/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.util.structure;

import com.liferay.layout.util.structure.LayoutStructureItemUtil;
import com.liferay.petra.lang.HashUtil;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;

public abstract class LayoutStructureItem {
    private List<String> _childrenItemIds;
    private String _itemId;
    private String _parentItemId;

    public static LayoutStructureItem of(JSONObject jsonObject) {
        String parentId = jsonObject.getString("parentId");
        String type = jsonObject.getString("type");
        LayoutStructureItem layoutStructureItem = LayoutStructureItemUtil.create(type, parentId);
        if (layoutStructureItem == null) {
            return null;
        }
        ArrayList<String> childrenItemIds = new ArrayList<String>();
        JSONUtil.addToStringCollection(childrenItemIds, (JSONArray)jsonObject.getJSONArray("children"));
        layoutStructureItem.setChildrenItemIds(childrenItemIds);
        layoutStructureItem.setItemId(jsonObject.getString("itemId"));
        layoutStructureItem.setParentItemId(parentId);
        layoutStructureItem.updateItemConfig(jsonObject.getJSONObject("config"));
        return layoutStructureItem;
    }

    public LayoutStructureItem() {
        this._childrenItemIds = new ArrayList<String>();
    }

    public LayoutStructureItem(String parentItemId) {
        this._parentItemId = parentItemId;
        this._itemId = String.valueOf(UUID.randomUUID());
        this._childrenItemIds = new ArrayList<String>();
    }

    public void addChildrenItem(int position, String itemId) {
        this._childrenItemIds.add(position, itemId);
    }

    public void addChildrenItem(String itemId) {
        this._childrenItemIds.add(itemId);
    }

    public void deleteChildrenItem(String itemId) {
        this._childrenItemIds.remove(itemId);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof LayoutStructureItem)) {
            return false;
        }
        LayoutStructureItem layoutStructureItem = (LayoutStructureItem)object;
        return Objects.equals(this._childrenItemIds, layoutStructureItem._childrenItemIds) && Objects.equals(this._itemId, layoutStructureItem._itemId) && Objects.equals(this._parentItemId, layoutStructureItem._parentItemId);
    }

    public List<String> getChildrenItemIds() {
        return this._childrenItemIds;
    }

    public abstract JSONObject getItemConfigJSONObject();

    public String getItemId() {
        return this._itemId;
    }

    public abstract String getItemType();

    public String getParentItemId() {
        return this._parentItemId;
    }

    public int hashCode() {
        return HashUtil.hash((int)0, (Object)this.getItemId());
    }

    public void setChildrenItemIds(List<String> childrenItemIds) {
        this._childrenItemIds = childrenItemIds;
    }

    public void setItemId(String itemId) {
        this._itemId = itemId;
    }

    public void setParentItemId(String parentItemId) {
        this._parentItemId = parentItemId;
    }

    public JSONObject toJSONObject() {
        return JSONUtil.put((String)"children", (Object)JSONFactoryUtil.createJSONArray(this.getChildrenItemIds())).put("config", this.getItemConfigJSONObject()).put("itemId", this.getItemId()).put("parentId", this.getParentItemId()).put("type", this.getItemType());
    }

    public String toString() {
        JSONObject jsonObject = this.toJSONObject();
        return jsonObject.toJSONString();
    }

    public abstract void updateItemConfig(JSONObject var1);
}

