/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.util.structure;

import com.liferay.fragment.model.FragmentEntry;
import com.liferay.fragment.model.FragmentEntryLink;
import com.liferay.fragment.service.FragmentEntryLocalServiceUtil;
import com.liferay.layout.util.structure.LayoutStructureItem;
import com.liferay.layout.util.structure.StyledLayoutStructureItem;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.PortletIdCodec;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;

public class LayoutStructureItemCSSUtil {
    private static final String _LAYOUT_STRUCTURE_ITEM_CSS_CLASS_PREFIX = "lfr-layout-structure-item-";
    private static final Log _log = LogFactoryUtil.getLog(LayoutStructureItemCSSUtil.class);

    public static String getFragmentEntryLinkCssClass(FragmentEntryLink fragmentEntryLink) {
        return LayoutStructureItemCSSUtil._normalizeCssClass(_LAYOUT_STRUCTURE_ITEM_CSS_CLASS_PREFIX + LayoutStructureItemCSSUtil._getFragmentEntryLinkIdentifier(fragmentEntryLink));
    }

    public static String getLayoutStructureItemCssClass(LayoutStructureItem layoutStructureItem) {
        return _LAYOUT_STRUCTURE_ITEM_CSS_CLASS_PREFIX + layoutStructureItem.getItemType();
    }

    public static String getLayoutStructureItemUniqueCssClass(LayoutStructureItem layoutStructureItem) {
        return _LAYOUT_STRUCTURE_ITEM_CSS_CLASS_PREFIX + layoutStructureItem.getItemId();
    }

    public static String getStyledLayoutStructureItemCssClasses(StyledLayoutStructureItem styledLayoutStructureItem) {
        return StringUtil.merge(styledLayoutStructureItem.getCssClasses(), (String)" ");
    }

    private static JSONObject _createJSONObject(String value) {
        try {
            return JSONFactoryUtil.createJSONObject((String)value);
        }
        catch (Exception exception) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)exception);
            }
            return JSONFactoryUtil.createJSONObject();
        }
    }

    private static String _getFragmentEntryLinkIdentifier(FragmentEntryLink fragmentEntryLink) {
        String rendererKey = fragmentEntryLink.getRendererKey();
        if (Validator.isNotNull((String)rendererKey)) {
            return rendererKey;
        }
        JSONObject jsonObject = LayoutStructureItemCSSUtil._createJSONObject(fragmentEntryLink.getEditableValues());
        String portletId = jsonObject.getString("portletId");
        if (Validator.isNotNull((String)portletId)) {
            return PortletIdCodec.decodePortletName((String)portletId);
        }
        FragmentEntry fragmentEntry = FragmentEntryLocalServiceUtil.fetchFragmentEntry((long)fragmentEntryLink.getFragmentEntryId());
        if (fragmentEntry != null) {
            return fragmentEntry.getFragmentEntryKey();
        }
        return "";
    }

    private static String _normalizeCssClass(String cssClass) {
        cssClass = StringUtil.toLowerCase((String)cssClass);
        return cssClass.replaceAll("[^A-Za-z0-9-]", "-");
    }
}

