Liferay.Loader.define("layout-admin-web@4.0.54/js/miller_columns/MillerColumnsItem", ['module', 'exports', 'require', '@frontend-taglib-clay$clayui/button', '@frontend-taglib-clay$clayui/drop-down', '@frontend-taglib-clay$clayui/form', '@frontend-taglib-clay$clayui/icon', '@frontend-taglib-clay$clayui/label', '@frontend-taglib-clay$clayui/layout', '@frontend-taglib-clay$clayui/link', 'frontend-js-react-web$classnames', 'frontend-js-react-web$react', 'frontend-js-react-web$react-dnd', 'frontend-js-react-web$react-dnd-html5-backend', './constants'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    function _typeof(obj) {
      "@babel/helpers - typeof";
      if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
        _typeof = function _typeof(obj) {
          return typeof obj;
        };
      } else {
        _typeof = function _typeof(obj) {
          return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
        };
      }return _typeof(obj);
    }

    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports["default"] = void 0;

    var _button = require("@frontend-taglib-clay$clayui/button");

    var _dropDown = _interopRequireDefault(require("@frontend-taglib-clay$clayui/drop-down"));

    var _form = require("@frontend-taglib-clay$clayui/form");

    var _icon = _interopRequireDefault(require("@frontend-taglib-clay$clayui/icon"));

    var _label = _interopRequireDefault(require("@frontend-taglib-clay$clayui/label"));

    var _layout = _interopRequireDefault(require("@frontend-taglib-clay$clayui/layout"));

    var _link = _interopRequireDefault(require("@frontend-taglib-clay$clayui/link"));

    var _classnames = _interopRequireDefault(require("frontend-js-react-web$classnames"));

    var _react = _interopRequireWildcard(require("frontend-js-react-web$react"));

    var _reactDnd = require("frontend-js-react-web$react-dnd");

    var _reactDndHtml5Backend = require("frontend-js-react-web$react-dnd-html5-backend");

    var _constants = require("./constants");

    function _getRequireWildcardCache() {
      if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
        return cache;
      };return cache;
    }

    function _interopRequireWildcard(obj) {
      if (obj && obj.__esModule) {
        return obj;
      }if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") {
        return { "default": obj };
      }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
        return cache.get(obj);
      }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
        if (Object.prototype.hasOwnProperty.call(obj, key)) {
          var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
            Object.defineProperty(newObj, key, desc);
          } else {
            newObj[key] = obj[key];
          }
        }
      }newObj["default"] = obj;if (cache) {
        cache.set(obj, newObj);
      }return newObj;
    }

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { "default": obj };
    }

    function ownKeys(object, enumerableOnly) {
      var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {
        var symbols = Object.getOwnPropertySymbols(object);if (enumerableOnly) symbols = symbols.filter(function (sym) {
          return Object.getOwnPropertyDescriptor(object, sym).enumerable;
        });keys.push.apply(keys, symbols);
      }return keys;
    }

    function _objectSpread(target) {
      for (var i = 1; i < arguments.length; i++) {
        var source = arguments[i] != null ? arguments[i] : {};if (i % 2) {
          ownKeys(Object(source), true).forEach(function (key) {
            _defineProperty(target, key, source[key]);
          });
        } else if (Object.getOwnPropertyDescriptors) {
          Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
        } else {
          ownKeys(Object(source)).forEach(function (key) {
            Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
          });
        }
      }return target;
    }

    function _defineProperty(obj, key, value) {
      if (key in obj) {
        Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
      } else {
        obj[key] = value;
      }return obj;
    }

    function _slicedToArray(arr, i) {
      return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest();
    }

    function _nonIterableRest() {
      throw new TypeError("Invalid attempt to destructure non-iterable instance");
    }

    function _iterableToArrayLimit(arr, i) {
      if (!(Symbol.iterator in Object(arr) || Object.prototype.toString.call(arr) === "[object Arguments]")) {
        return;
      }var _arr = [];var _n = true;var _d = false;var _e = undefined;try {
        for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
          _arr.push(_s.value);if (i && _arr.length === i) break;
        }
      } catch (err) {
        _d = true;_e = err;
      } finally {
        try {
          if (!_n && _i["return"] != null) _i["return"]();
        } finally {
          if (_d) throw _e;
        }
      }return _arr;
    }

    function _arrayWithHoles(arr) {
      if (Array.isArray(arr)) return arr;
    }

    var DROP_ZONES = {
      BOTTOM: 'BOTTOM',
      ELEMENT: 'ELEMENT',
      TOP: 'TOP'
    };
    var ITEM_HOVER_TIMEOUT = 500;
    var ITEM_STATES_COLORS = {
      'conversion-draft': 'info',
      draft: 'secondary',
      pending: 'info'
    };

    var isValidTarget = function isValidTarget(sources, target, dropZone) {
      if (sources.some(function (item) {
        return item.id === target.id;
      })) {
        return false;
      }

      if (sources.some(function (source) {
        return !(target.parentId && target.columnIndex <= source.columnIndex || target.columnIndex > source.columnIndex && !source.active);
      })) {
        return false;
      }

      if (dropZone === DROP_ZONES.TOP) {
        return !sources.some(function (source) {
          return !(target.columnIndex !== source.columnIndex || target.itemIndex < source.itemIndex || target.itemIndex > source.itemIndex + 1);
        });
      } else if (dropZone === DROP_ZONES.BOTTOM) {
        return !sources.some(function (source) {
          return !(target.columnIndex !== source.columnIndex || target.itemIndex > source.itemIndex || target.itemIndex < source.itemIndex - 1);
        });
      } else if (dropZone === DROP_ZONES.ELEMENT) {
        return !sources.some(function (source) {
          return !(target.id !== source.parentId && target.parentable);
        });
      }
    };

    var getDropZone = function getDropZone(ref, monitor) {
      if (!ref.current) {
        return;
      }

      var clientOffset = monitor.getClientOffset();
      var dropItemBoundingRect = ref.current.getBoundingClientRect();
      var hoverTopLimit = _constants.ITEM_HOVER_BORDER_LIMIT;
      var hoverBottomLimit = dropItemBoundingRect.height - _constants.ITEM_HOVER_BORDER_LIMIT;
      var hoverClientY = clientOffset.y - dropItemBoundingRect.top;
      var dropZone = DROP_ZONES.ELEMENT;

      if (hoverClientY < hoverTopLimit) {
        dropZone = DROP_ZONES.TOP;
      } else if (hoverClientY > hoverBottomLimit) {
        dropZone = DROP_ZONES.BOTTOM;
      }

      return dropZone;
    };

    var getItemIndex = function getItemIndex() {
      var item = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
      var items = arguments.length > 1 ? arguments[1] : undefined;
      var siblings = Array.from(items.values()).filter(function (_item) {
        return _item.columnIndex === item.columnIndex;
      });
      return siblings.indexOf(item);
    };

    var noop = function noop() {};

    var MillerColumnsItem = function MillerColumnsItem(_ref) {
      var _ref$item = _ref.item,
          _ref$item$actions = _ref$item.actions,
          actions = _ref$item$actions === void 0 ? [] : _ref$item$actions,
          active = _ref$item.active,
          _ref$item$bulkActions = _ref$item.bulkActions,
          bulkActions = _ref$item$bulkActions === void 0 ? [] : _ref$item$bulkActions,
          checked = _ref$item.checked,
          columnIndex = _ref$item.columnIndex,
          description = _ref$item.description,
          draggable = _ref$item.draggable,
          hasChild = _ref$item.hasChild,
          itemId = _ref$item.id,
          itemIndex = _ref$item.itemIndex,
          parentId = _ref$item.parentId,
          parentable = _ref$item.parentable,
          selectable = _ref$item.selectable,
          _ref$item$states = _ref$item.states,
          states = _ref$item$states === void 0 ? [] : _ref$item$states,
          title = _ref$item.title,
          url = _ref$item.url,
          viewUrl = _ref$item.viewUrl,
          items = _ref.items,
          _ref$actionHandlers = _ref.actionHandlers,
          actionHandlers = _ref$actionHandlers === void 0 ? {} : _ref$actionHandlers,
          namespace = _ref.namespace,
          _ref$onItemDrop = _ref.onItemDrop,
          onItemDrop = _ref$onItemDrop === void 0 ? noop : _ref$onItemDrop,
          _ref$onItemStayHover = _ref.onItemStayHover,
          onItemStayHover = _ref$onItemStayHover === void 0 ? noop : _ref$onItemStayHover,
          rtl = _ref.rtl;
      var ref = (0, _react.useRef)();
      var timeoutRef = (0, _react.useRef)();

      var _useState = (0, _react.useState)(),
          _useState2 = _slicedToArray(_useState, 2),
          dropdownActionsActive = _useState2[0],
          setDropdownActionsActive = _useState2[1];

      var _useState3 = (0, _react.useState)(),
          _useState4 = _slicedToArray(_useState3, 2),
          dropZone = _useState4[0],
          setDropZone = _useState4[1];

      var _useState5 = (0, _react.useState)(),
          _useState6 = _slicedToArray(_useState5, 2),
          layoutActionsActive = _useState6[0],
          setLayoutActionsActive = _useState6[1];

      var dropdownActions = (0, _react.useMemo)(function () {
        var dropdownActions = [];
        actions.forEach(function (action) {
          if (!action.quickAction && !action.layoutAction) {
            var onClick = action.handler || actionHandlers[action.id];
            dropdownActions.push(_objectSpread({}, action, {
              handler: function handler() {
                return onClick && onClick({
                  actionURL: action.url,
                  namespace: namespace
                });
              },
              href: onClick ? null : action.url
            }));
          }
        });
        return dropdownActions;
      }, [actions, actionHandlers, namespace]);
      var layoutActions = (0, _react.useMemo)(function () {
        return actions.filter(function (action) {
          return action.layoutAction && action.url;
        });
      }, [actions]);
      var quickActions = (0, _react.useMemo)(function () {
        var quickActions = [];
        actions.forEach(function (action) {
          if (action.quickAction && action.url) {
            quickActions.push(_objectSpread({}, action, {
              handler: action.handler || actionHandlers[action.id] || noop
            }));
          }
        });
        return quickActions;
      }, [actions, actionHandlers]);

      var _useDrag = (0, _reactDnd.useDrag)({
        collect: function collect(monitor) {
          return {
            isDragging: !!monitor.isDragging()
          };
        },
        isDragging: function isDragging(monitor) {
          var movedItems = monitor.getItem().items;
          return movedItems.some(function (item) {
            return item.checked;
          }) && checked || movedItems.some(function (item) {
            return item.id === itemId;
          });
        },
        item: {
          items: checked ? Array.from(items.values()).filter(function (item) {
            return item.checked;
          }).map(function (item) {
            return _objectSpread({}, item, {
              itemIndex: getItemIndex(item, items)
            });
          }) : [_objectSpread({}, items.get(itemId), {
            itemIndex: getItemIndex(items.get(itemId), items)
          })],
          type: _constants.ACCEPTING_TYPES.ITEM
        }
      }),
          _useDrag2 = _slicedToArray(_useDrag, 3),
          isDragging = _useDrag2[0].isDragging,
          drag = _useDrag2[1],
          previewRef = _useDrag2[2];

      var _useDrop = (0, _reactDnd.useDrop)({
        accept: _constants.ACCEPTING_TYPES.ITEM,
        canDrop: function canDrop(source, monitor) {
          var dropZone = getDropZone(ref, monitor);
          return isValidTarget(source.items, {
            columnIndex: columnIndex,
            id: itemId,
            itemIndex: itemIndex,
            parentId: parentId,
            parentable: parentable
          }, dropZone);
        },
        collect: function collect(monitor) {
          return {
            isOver: !!monitor.isOver()
          };
        },
        drop: function drop(source, monitor) {
          if (monitor.canDrop()) {
            if (dropZone === DROP_ZONES.ELEMENT) {
              var newIndex = Array.from(items.values()).filter(function (item) {
                return item.parentId === itemId;
              }).length;
              onItemDrop(source.items, itemId, newIndex);
            } else {
              var _newIndex = itemIndex;

              if (dropZone === DROP_ZONES.BOTTOM) {
                _newIndex = itemIndex + 1;
              }

              onItemDrop(source.items, parentId, _newIndex);
            }
          }
        },
        hover: function hover(source, monitor) {
          var dropZone;

          if (isOver && monitor.canDrop()) {
            dropZone = getDropZone(ref, monitor);
          }

          setDropZone(dropZone);
        }
      }),
          _useDrop2 = _slicedToArray(_useDrop, 2),
          isOver = _useDrop2[0].isOver,
          drop = _useDrop2[1];

      (0, _react.useEffect)(function () {
        drag(drop(ref));
      }, [drag, drop]);
      (0, _react.useEffect)(function () {
        previewRef((0, _reactDndHtml5Backend.getEmptyImage)(), {
          captureDraggingState: true
        });
      }, [previewRef]);
      (0, _react.useEffect)(function () {
        if (!active && dropZone === DROP_ZONES.ELEMENT && !timeoutRef.current) {
          timeoutRef.current = setTimeout(function () {
            if (isOver) {
              onItemStayHover(itemId);
            }
          }, ITEM_HOVER_TIMEOUT);
        } else if (!isOver || dropZone !== DROP_ZONES.ELEMENT && timeoutRef.current) {
          clearTimeout(timeoutRef.current);
          timeoutRef.current = null;
        }
      }, [active, dropZone, isOver, itemId, onItemStayHover]);
      return _react["default"].createElement(_layout["default"].ContentRow, {
        className: (0, _classnames["default"])('list-group-item-flex miller-columns-item', {
          dragging: isDragging,
          'drop-bottom': isOver && dropZone === DROP_ZONES.BOTTOM,
          'drop-element': isOver && dropZone === DROP_ZONES.ELEMENT,
          'drop-top': isOver && dropZone === DROP_ZONES.TOP,
          'miller-columns-item--active': active
        }),
        containerElement: "li",
        "data-actions": bulkActions,
        ref: ref,
        verticalAlign: "center"
      }, _react["default"].createElement("a", {
        className: "miller-columns-item-mask",
        href: url
      }, _react["default"].createElement("span", {
        className: "c-inner sr-only"
      }, "".concat(Liferay.Language.get('select'), " ").concat(title))), draggable && _react["default"].createElement(_layout["default"].ContentCol, {
        className: "miller-columns-item-drag-handler pl-0"
      }, _react["default"].createElement(_icon["default"], {
        symbol: "drag"
      })), selectable && _react["default"].createElement(_layout["default"].ContentCol, null, _react["default"].createElement(_form.ClayCheckbox, {
        defaultChecked: checked,
        name: "".concat(namespace, "rowIds"),
        value: itemId
      })), _react["default"].createElement(_layout["default"].ContentCol, {
        expand: true
      }, _react["default"].createElement("h4", {
        className: "list-group-title text-truncate-inline"
      }, viewUrl ? _react["default"].createElement(_link["default"], {
        className: "text-truncate",
        href: viewUrl
      }, title) : _react["default"].createElement("span", {
        className: "text-truncate"
      }, title)), description && _react["default"].createElement("h5", {
        className: "d-flex list-group-subtitle small"
      }, _react["default"].createElement("span", {
        className: "text-truncate"
      }, description), states.map(function (state) {
        return _react["default"].createElement(_label["default"], {
          className: "inline-item-after text-truncate",
          displayType: ITEM_STATES_COLORS[state.id],
          key: state.id
        }, state.label);
      }))), layoutActions.length > 0 && _react["default"].createElement(_layout["default"].ContentCol, {
        className: "miller-columns-item-actions"
      }, _react["default"].createElement(_dropDown["default"], {
        active: layoutActionsActive,
        onActiveChange: setLayoutActionsActive,
        trigger: _react["default"].createElement(_button.ClayButtonWithIcon, {
          borderless: true,
          displayType: "secondary",
          small: true,
          symbol: "plus"
        })
      }, _react["default"].createElement(_dropDown["default"].ItemList, null, layoutActions.map(function (action) {
        return _react["default"].createElement(_dropDown["default"].Item, {
          disabled: !action.url,
          href: action.url,
          id: action.id,
          key: action.id,
          onClick: action.handler
        }, action.label);
      })))), quickActions.map(function (action) {
        return _react["default"].createElement(_layout["default"].ContentCol, {
          className: "miller-columns-item-quick-action",
          key: action.id
        }, _react["default"].createElement(_link["default"], {
          borderless: true,
          displayType: "secondary",
          href: action.url,
          monospaced: true,
          outline: true
        }, _react["default"].createElement(_icon["default"], {
          symbol: action.icon
        })));
      }), dropdownActions.length > 0 && _react["default"].createElement(_layout["default"].ContentCol, {
        className: "miller-columns-item-actions"
      }, _react["default"].createElement(_dropDown["default"], {
        active: dropdownActionsActive,
        onActiveChange: setDropdownActionsActive,
        trigger: _react["default"].createElement(_button.ClayButtonWithIcon, {
          borderless: true,
          displayType: "secondary",
          small: true,
          symbol: "ellipsis-v"
        })
      }, _react["default"].createElement(_dropDown["default"].ItemList, null, dropdownActions.map(function (action) {
        return _react["default"].createElement(_dropDown["default"].Item, {
          disabled: !action.url,
          href: action.href,
          id: action.id,
          key: action.id,
          onClick: action.handler
        }, action.label);
      })))), hasChild && _react["default"].createElement(_layout["default"].ContentCol, {
        className: "miller-columns-item-child-indicator"
      }, _react["default"].createElement(_icon["default"], {
        symbol: rtl ? 'caret-left' : 'caret-right'
      })));
    };

    var _default = MillerColumnsItem;
    exports["default"] = _default;
    //# sourceMappingURL=MillerColumnsItem.js.map
  }
});
//# sourceMappingURL=MillerColumnsItem.js.map