Liferay.Loader.define("layout-admin-web@4.0.24/js/miller_columns/MillerColumns", ['module', 'exports', 'require', 'frontend-js-react-web', 'frontend-js-react-web$react', 'frontend-js-react-web$react-dnd', 'frontend-js-react-web$react-dnd-html5-backend', './MillerColumnsColumn'], function (module, exports, require) {
  var define = undefined;
  function _typeof(obj) {
    "@babel/helpers - typeof";
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }return _typeof(obj);
  }

  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = void 0;

  var _frontendJsReactWeb = require("frontend-js-react-web");

  var _react = _interopRequireWildcard(require("frontend-js-react-web$react"));

  var _reactDnd = require("frontend-js-react-web$react-dnd");

  var _reactDndHtml5Backend = _interopRequireDefault(require("frontend-js-react-web$react-dnd-html5-backend"));

  var _MillerColumnsColumn = _interopRequireDefault(require("./MillerColumnsColumn"));

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { "default": obj };
  }

  function _getRequireWildcardCache() {
    if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
      return cache;
    };return cache;
  }

  function _interopRequireWildcard(obj) {
    if (obj && obj.__esModule) {
      return obj;
    }if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") {
      return { "default": obj };
    }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
      return cache.get(obj);
    }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
      if (Object.prototype.hasOwnProperty.call(obj, key)) {
        var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
          Object.defineProperty(newObj, key, desc);
        } else {
          newObj[key] = obj[key];
        }
      }
    }newObj["default"] = obj;if (cache) {
      cache.set(obj, newObj);
    }return newObj;
  }

  function _slicedToArray(arr, i) {
    return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest();
  }

  function _nonIterableRest() {
    throw new TypeError("Invalid attempt to destructure non-iterable instance");
  }

  function _iterableToArrayLimit(arr, i) {
    if (!(Symbol.iterator in Object(arr) || Object.prototype.toString.call(arr) === "[object Arguments]")) {
      return;
    }var _arr = [];var _n = true;var _d = false;var _e = undefined;try {
      for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
        _arr.push(_s.value);if (i && _arr.length === i) break;
      }
    } catch (err) {
      _d = true;_e = err;
    } finally {
      try {
        if (!_n && _i["return"] != null) _i["return"]();
      } finally {
        if (_d) throw _e;
      }
    }return _arr;
  }

  function _arrayWithHoles(arr) {
    if (Array.isArray(arr)) return arr;
  }

  function ownKeys(object, enumerableOnly) {
    var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {
      var symbols = Object.getOwnPropertySymbols(object);if (enumerableOnly) symbols = symbols.filter(function (sym) {
        return Object.getOwnPropertyDescriptor(object, sym).enumerable;
      });keys.push.apply(keys, symbols);
    }return keys;
  }

  function _objectSpread(target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i] != null ? arguments[i] : {};if (i % 2) {
        ownKeys(Object(source), true).forEach(function (key) {
          _defineProperty(target, key, source[key]);
        });
      } else if (Object.getOwnPropertyDescriptors) {
        Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
      } else {
        ownKeys(Object(source)).forEach(function (key) {
          Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
        });
      }
    }return target;
  }

  function _defineProperty(obj, key, value) {
    if (key in obj) {
      Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
    } else {
      obj[key] = value;
    }return obj;
  }

  var getItemsMap = function getItemsMap(columns) {
    var map = new Map();
    var parentId, parentKey;
    columns.forEach(function (column, columnIndex) {
      var childrenCount = 0;
      var newParentId, newParentKey;
      column.forEach(function (item) {
        childrenCount++;
        map.set(item.key, _objectSpread({}, item, {
          columnIndex: columnIndex,
          parentId: parentId,
          parentKey: parentKey
        }));

        if (item.active && item.hasChild) {
          newParentId = item.id;
          newParentKey = item.key;
        }
      });

      if (parentKey) {
        map.set(parentKey, _objectSpread({}, map.get(parentKey), {
          childrenCount: childrenCount
        }));
      }

      parentId = newParentId;
      parentKey = newParentKey;
    });
    return map;
  };

  var noop = function noop() {};

  var MillerColumns = function MillerColumns(_ref) {
    var actionHandlers = _ref.actionHandlers,
        _ref$initialColumns = _ref.initialColumns,
        initialColumns = _ref$initialColumns === void 0 ? [] : _ref$initialColumns,
        namespace = _ref.namespace,
        _ref$onColumnsChange = _ref.onColumnsChange,
        onColumnsChange = _ref$onColumnsChange === void 0 ? noop : _ref$onColumnsChange,
        _ref$onItemMove = _ref.onItemMove,
        onItemMove = _ref$onItemMove === void 0 ? noop : _ref$onItemMove,
        onItemStayHover = _ref.onItemStayHover;
    var ref = (0, _react.useRef)();

    var _useState = (0, _react.useState)(function () {
      return getItemsMap(initialColumns);
    }),
        _useState2 = _slicedToArray(_useState, 2),
        items = _useState2[0],
        setItems = _useState2[1]; // Transform items map into a columns-like array.


    var columns = (0, _react.useMemo)(function () {
      var columns = []; // eslint-disable-next-line no-for-of-loops/no-for-of-loops

      var _iteratorNormalCompletion = true;
      var _didIteratorError = false;
      var _iteratorError = undefined;

      try {
        for (var _iterator = items.values()[Symbol.iterator](), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {
          var item = _step.value;

          if (!columns[item.columnIndex]) {
            columns[item.columnIndex] = {
              items: [],
              parent: items.get(item.parentId)
            };
          }

          var column = columns[item.columnIndex];
          column.items.push(item);
        } // Add empty column in the end if last column has an active item
      } catch (err) {
        _didIteratorError = true;
        _iteratorError = err;
      } finally {
        try {
          if (!_iteratorNormalCompletion && _iterator["return"] != null) {
            _iterator["return"]();
          }
        } finally {
          if (_didIteratorError) {
            throw _iteratorError;
          }
        }
      }

      var lastColumnActiveItem = columns[columns.length - 1].items.find(function (item) {
        return item.active;
      });

      if (lastColumnActiveItem && !lastColumnActiveItem.hasChild) {
        columns.push({
          items: [],
          parent: lastColumnActiveItem
        });
      }

      return columns;
    }, [items]);
    var previousColumnsValue = (0, _frontendJsReactWeb.usePrevious)(columns);
    var previousInitialColumnsValue = (0, _frontendJsReactWeb.usePrevious)(initialColumns);
    (0, _react.useEffect)(function () {
      if (previousInitialColumnsValue !== initialColumns) {
        setItems(getItemsMap(initialColumns));
      }
    }, [initialColumns, previousInitialColumnsValue]);
    (0, _react.useEffect)(function () {
      if (previousColumnsValue !== columns) {
        onColumnsChange(columns);
      }
    }, [columns, onColumnsChange, previousColumnsValue]);
    (0, _react.useEffect)(function () {
      if (ref.current) {
        ref.current.scrollLeft = ref.current.scrollWidth;
      }
    }, []);

    var onItemDrop = function onItemDrop(sourceId, newParentId, newIndex) {
      var newItems = new Map();
      var itemsArray = Array.from(items.values());
      var source = itemsArray.find(function (item) {
        return item.id === sourceId;
      });
      var parent = itemsArray.find(function (item) {
        return item.id === newParentId;
      }); // If no newIndex is provided set it as the last of the siblings.

      if (typeof newIndex !== 'number') {
        newIndex = parent.childrenCount || 0;
      }

      var newSource = _objectSpread({}, source, {
        active: newParentId === source.parentId && source.active,
        columnIndex: parent.columnIndex + 1,
        parentId: newParentId
      });

      var prevColumnIndex;
      var itemIndex = 0; // eslint-disable-next-line no-for-of-loops/no-for-of-loops

      var _iteratorNormalCompletion2 = true;
      var _didIteratorError2 = false;
      var _iteratorError2 = undefined;

      try {
        for (var _iterator2 = items.values()[Symbol.iterator](), _step2; !(_iteratorNormalCompletion2 = (_step2 = _iterator2.next()).done); _iteratorNormalCompletion2 = true) {
          var item = _step2.value;
          var columnIndex = item.columnIndex;

          if (item.columnIndex > prevColumnIndex) {
            // Exit if source was active but not anymore and we are on the
            // next column to where source used to live to avoid saving its
            // children (which must not be shown anymore)
            if (source.active && !newSource.active && columnIndex > newSource.columnIndex + 1) {
              break;
            } // Reset itemIndex counter on each column


            itemIndex = 0;
          } // Skip the source item iteration


          if (item.id === sourceId) {
            itemIndex++;
            prevColumnIndex = item.columnIndex;
            continue;
          }

          if (item.id === newParentId) {
            var newChildrenCount = item.childrenCount;

            if (newParentId !== source.parentId) {
              newChildrenCount++;
            }

            item = _objectSpread({}, item, {
              childrenCount: newChildrenCount,
              hasChild: true
            });
          } else if (item.id === source.parentId) {
            var _newChildrenCount = item.childrenCount - 1;

            item = _objectSpread({}, item, {
              childrenCount: _newChildrenCount,
              hasChild: _newChildrenCount > 0
            });
          }

          if (itemIndex === newIndex && columnIndex === newSource.columnIndex && parent.active) {
            newItems.set(newSource.key, newSource);
          }

          newItems.set(item.key, _objectSpread({}, item));
          itemIndex++;
          prevColumnIndex = item.columnIndex;
        } // If source parent is active (children are visible) set (again or not)
        // the newSource in the map in case it's being placed as the last
        // element (so won't reach that position in the loop).
      } catch (err) {
        _didIteratorError2 = true;
        _iteratorError2 = err;
      } finally {
        try {
          if (!_iteratorNormalCompletion2 && _iterator2["return"] != null) {
            _iterator2["return"]();
          }
        } finally {
          if (_didIteratorError2) {
            throw _iteratorError2;
          }
        }
      }

      if (parent.active) {
        newItems.set(newSource.id, newSource);
      }

      setItems(newItems);
      onItemMove(sourceId, newParentId, newIndex);
    };

    return _react["default"].createElement(_reactDnd.DndProvider, {
      backend: _reactDndHtml5Backend["default"]
    }, _react["default"].createElement("div", {
      className: "bg-white miller-columns-row",
      ref: ref
    }, columns.map(function (column, index) {
      return _react["default"].createElement(_MillerColumnsColumn["default"], {
        actionHandlers: actionHandlers,
        items: column.items,
        key: index,
        namespace: namespace,
        onItemDrop: onItemDrop,
        onItemStayHover: onItemStayHover,
        parent: column.parent
      });
    })));
  };

  var _default = MillerColumns;
  exports["default"] = _default;
  //# sourceMappingURL=MillerColumns.js.map
});
//# sourceMappingURL=MillerColumns.js.map