Liferay.Loader.define("layout-admin-web@4.0.24/js/layout/actionHandlers", ['module', 'exports', 'require'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = void 0;

  /**
   * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
   *
   * This library is free software; you can redistribute it and/or modify it under
   * the terms of the GNU Lesser General Public License as published by the Free
   * Software Foundation; either version 2.1 of the License, or (at your option)
   * any later version.
   *
   * This library is distributed in the hope that it will be useful, but WITHOUT
   * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
   * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
   * details.
   */
  var actionHandlers = {
    copyLayout: function copyLayout(_ref) {
      var actionURL = _ref.actionURL,
          namespace = _ref.namespace;
      Liferay.Util.openWindow({
        dialog: {
          destroyOnHide: true,
          height: 480,
          resizable: false,
          width: 640
        },
        dialogIframe: {
          bodyCssClass: 'dialog-with-footer'
        },
        id: "".concat(namespace, "addLayoutDialog"),
        title: Liferay.Language.get('copy-page'),
        uri: actionURL
      });
    },
    "delete": function _delete(_ref2) {
      var actionURL = _ref2.actionURL;
      var deleteMessage = Liferay.Language.get('are-you-sure-you-want-to-delete-this');

      if (confirm(deleteMessage)) {
        Liferay.Util.navigate(actionURL);
      }
    },
    permissions: function permissions(_ref3) {
      var actionURL = _ref3.actionURL;
      Liferay.Util.openWindow({
        dialog: {
          destroyOnHide: true,
          modal: true
        },
        dialogIframe: {
          bodyCssClass: 'dialog-with-footer'
        },
        title: Liferay.Language.get('permissions'),
        uri: actionURL
      });
    }
  };
  var _default = actionHandlers;
  exports["default"] = _default;
  //# sourceMappingURL=actionHandlers.js.map
});
//# sourceMappingURL=actionHandlers.js.map