Liferay.Loader.define("layout-admin-web@4.0.24/js/friendly_url_history/FriendlyURLHistoryModal", ['module', 'exports', 'require', '@frontend-taglib-clay$clayui/list', '@frontend-taglib-clay$clayui/loading-indicator', '@frontend-taglib-clay$clayui/modal', 'frontend-js-react-web', 'frontend-js-web', 'frontend-js-react-web$prop-types', 'frontend-js-react-web$react', './LanguageSelector'], function (module, exports, require) {
  var define = undefined;
  function _typeof(obj) {
    "@babel/helpers - typeof";
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }return _typeof(obj);
  }

  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = void 0;

  var _list = _interopRequireDefault(require("@frontend-taglib-clay$clayui/list"));

  var _loadingIndicator = _interopRequireDefault(require("@frontend-taglib-clay$clayui/loading-indicator"));

  var _modal = _interopRequireDefault(require("@frontend-taglib-clay$clayui/modal"));

  var _frontendJsReactWeb = require("frontend-js-react-web");

  var _frontendJsWeb = require("frontend-js-web");

  var _propTypes = _interopRequireDefault(require("frontend-js-react-web$prop-types"));

  var _react = _interopRequireWildcard(require("frontend-js-react-web$react"));

  var _LanguageSelector = _interopRequireDefault(require("./LanguageSelector"));

  function _getRequireWildcardCache() {
    if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
      return cache;
    };return cache;
  }

  function _interopRequireWildcard(obj) {
    if (obj && obj.__esModule) {
      return obj;
    }if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") {
      return { "default": obj };
    }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
      return cache.get(obj);
    }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
      if (Object.prototype.hasOwnProperty.call(obj, key)) {
        var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
          Object.defineProperty(newObj, key, desc);
        } else {
          newObj[key] = obj[key];
        }
      }
    }newObj["default"] = obj;if (cache) {
      cache.set(obj, newObj);
    }return newObj;
  }

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { "default": obj };
  }

  function ownKeys(object, enumerableOnly) {
    var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {
      var symbols = Object.getOwnPropertySymbols(object);if (enumerableOnly) symbols = symbols.filter(function (sym) {
        return Object.getOwnPropertyDescriptor(object, sym).enumerable;
      });keys.push.apply(keys, symbols);
    }return keys;
  }

  function _objectSpread(target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i] != null ? arguments[i] : {};if (i % 2) {
        ownKeys(Object(source), true).forEach(function (key) {
          _defineProperty(target, key, source[key]);
        });
      } else if (Object.getOwnPropertyDescriptors) {
        Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
      } else {
        ownKeys(Object(source)).forEach(function (key) {
          Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
        });
      }
    }return target;
  }

  function _defineProperty(obj, key, value) {
    if (key in obj) {
      Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
    } else {
      obj[key] = value;
    }return obj;
  }

  function _slicedToArray(arr, i) {
    return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest();
  }

  function _nonIterableRest() {
    throw new TypeError("Invalid attempt to destructure non-iterable instance");
  }

  function _iterableToArrayLimit(arr, i) {
    if (!(Symbol.iterator in Object(arr) || Object.prototype.toString.call(arr) === "[object Arguments]")) {
      return;
    }var _arr = [];var _n = true;var _d = false;var _e = undefined;try {
      for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
        _arr.push(_s.value);if (i && _arr.length === i) break;
      }
    } catch (err) {
      _d = true;_e = err;
    } finally {
      try {
        if (!_n && _i["return"] != null) _i["return"]();
      } finally {
        if (_d) throw _e;
      }
    }return _arr;
  }

  function _arrayWithHoles(arr) {
    if (Array.isArray(arr)) return arr;
  }

  var FriendlyURLHistoryModal = function FriendlyURLHistoryModal(_ref) {
    var defaultLanguageId = _ref.defaultLanguageId,
        deleteFriendlyURLEntryLocalizationURL = _ref.deleteFriendlyURLEntryLocalizationURL,
        friendlyURLEntryLocalizationsURL = _ref.friendlyURLEntryLocalizationsURL,
        initialLanguageId = _ref.initialLanguageId,
        observer = _ref.observer,
        portletNamespace = _ref.portletNamespace;

    var _useState = (0, _react.useState)(),
        _useState2 = _slicedToArray(_useState, 2),
        languageId = _useState2[0],
        setLanguageId = _useState2[1];

    var _useState3 = (0, _react.useState)(true),
        _useState4 = _slicedToArray(_useState3, 2),
        loading = _useState4[0],
        setLoading = _useState4[1];

    var _useState5 = (0, _react.useState)({}),
        _useState6 = _slicedToArray(_useState5, 2),
        friendlyURLEntryLocalizations = _useState6[0],
        setFriendlyURLEntryLocalizations = _useState6[1];

    var _useState7 = (0, _react.useState)([]),
        _useState8 = _slicedToArray(_useState7, 2),
        availableLanguages = _useState8[0],
        setAvailableLanguages = _useState8[1];

    var isMounted = (0, _frontendJsReactWeb.useIsMounted)();
    (0, _react.useEffect)(function () {
      (0, _frontendJsWeb.fetch)(friendlyURLEntryLocalizationsURL).then(function (response) {
        return response.json();
      }).then(function (response) {
        if (isMounted()) {
          setAvailableLanguages(Object.keys(response));
          setFriendlyURLEntryLocalizations(response);
        }
      })["catch"](function (error) {});
    }, [friendlyURLEntryLocalizationsURL, isMounted]);
    (0, _react.useEffect)(function () {
      if (loading) {
        var selectedLanguageId;

        if (friendlyURLEntryLocalizations[initialLanguageId]) {
          selectedLanguageId = initialLanguageId;
        } else if (friendlyURLEntryLocalizations[defaultLanguageId]) {
          selectedLanguageId = defaultLanguageId;
        } else {
          selectedLanguageId = availableLanguages[0];
        }

        setLanguageId(selectedLanguageId);
      }
    }, [availableLanguages, defaultLanguageId, friendlyURLEntryLocalizations, initialLanguageId, loading]);
    (0, _react.useEffect)(function () {
      if (loading && friendlyURLEntryLocalizations && languageId && friendlyURLEntryLocalizations[languageId]) {
        setLoading(false);
      }
    }, [friendlyURLEntryLocalizations, loading, languageId]);

    var handleDeleteFriendlyUrl = function handleDeleteFriendlyUrl(deleteFriendlyURLEntryId) {
      var formData = new FormData();
      formData.append("".concat(portletNamespace, "friendlyURLEntryId"), deleteFriendlyURLEntryId);
      formData.append("".concat(portletNamespace, "languageId"), languageId);
      (0, _frontendJsWeb.fetch)(deleteFriendlyURLEntryLocalizationURL, {
        body: formData,
        method: 'POST'
      }).then(function (response) {
        return response.json();
      }).then(function (response) {
        if (response.success) {
          setFriendlyURLEntryLocalizations(function (friendlyURLEntryLocalizations) {
            friendlyURLEntryLocalizations[languageId].history = friendlyURLEntryLocalizations[languageId].history.filter(function (_ref2) {
              var friendlyURLEntryId = _ref2.friendlyURLEntryId;
              return friendlyURLEntryId != deleteFriendlyURLEntryId;
            });
            return _objectSpread({}, friendlyURLEntryLocalizations);
          });
        } else {
          showToastError();
        }
      })["catch"](function (error) {

        showToastError();
      });
    };

    var showToastError = function showToastError() {
      (0, _frontendJsWeb.openToast)({
        message: Liferay.Language.get('an-unexpected-error-occurred'),
        title: Liferay.Language.get('error'),
        type: 'danger'
      });
    };

    return _react["default"].createElement(_modal["default"], {
      className: "portlet-layouts-admin-url-history-modal",
      observer: observer,
      size: "md"
    }, _react["default"].createElement(_modal["default"].Header, null, Liferay.Language.get('history')), _react["default"].createElement(_modal["default"].Body, null, loading ? _react["default"].createElement(_loadingIndicator["default"], null) : _react["default"].createElement(_react["default"].Fragment, null, _react["default"].createElement("div", {
      className: "language-selector-container"
    }, _react["default"].createElement(_LanguageSelector["default"], {
      defaultLanguageId: defaultLanguageId,
      languageIds: availableLanguages,
      onChange: function onChange(value) {
        setLanguageId(value);
      },
      selectedLanguageId: languageId
    })), _react["default"].createElement("div", {
      className: "active-url"
    }, _react["default"].createElement("div", {
      className: "active-url-tite"
    }, Liferay.Language.get('active-url')), _react["default"].createElement("p", {
      className: "active-url-text"
    }, friendlyURLEntryLocalizations[languageId].current.urlTitle)), _react["default"].createElement(_list["default"], {
      className: "show-quick-actions-one-line",
      showQuickActionsOnHover: true
    }, friendlyURLEntryLocalizations[languageId].history.length > 0 && _react["default"].createElement(_react["default"].Fragment, null, _react["default"].createElement(_list["default"].Header, null, Liferay.Language.get('old-friendly-urls')), friendlyURLEntryLocalizations[languageId].history.map(function (_ref3) {
      var friendlyURLEntryId = _ref3.friendlyURLEntryId,
          urlTitle = _ref3.urlTitle;
      return _react["default"].createElement(_list["default"].Item, {
        flex: true,
        key: friendlyURLEntryId
      }, _react["default"].createElement(_list["default"].ItemField, {
        expand: true
      }, _react["default"].createElement(_list["default"].ItemText, {
        className: "text-truncate"
      }, urlTitle)), _react["default"].createElement(_list["default"].ItemField, null, _react["default"].createElement(_list["default"].QuickActionMenu, null, _react["default"].createElement(_list["default"].QuickActionMenu.Item, {
        className: "d-none",
        symbol: "reload"
      }), _react["default"].createElement(_list["default"].QuickActionMenu.Item, {
        className: "lfr-portal-tooltip",
        "data-title": Liferay.Language.get('forget-url'),
        onClick: function onClick() {
          handleDeleteFriendlyUrl(friendlyURLEntryId);
        },
        symbol: "times-circle"
      }))));
    }))))));
  };

  var _default = FriendlyURLHistoryModal;
  exports["default"] = _default;
  //# sourceMappingURL=FriendlyURLHistoryModal.js.map
});
//# sourceMappingURL=FriendlyURLHistoryModal.js.map