"use strict";

Liferay.Loader.define("layout-admin-web@3.0.23/js/utils/utils.es", ['module', 'exports', 'require'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.setIn = setIn;

  function _toConsumableArray(arr) {
    return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _nonIterableSpread();
  }

  function _nonIterableSpread() {
    throw new TypeError("Invalid attempt to spread non-iterable instance");
  }

  function _iterableToArray(iter) {
    if (Symbol.iterator in Object(iter) || Object.prototype.toString.call(iter) === "[object Arguments]") return Array.from(iter);
  }

  function _arrayWithoutHoles(arr) {
    if (Array.isArray(arr)) {
      for (var i = 0, arr2 = new Array(arr.length); i < arr.length; i++) {
        arr2[i] = arr[i];
      }return arr2;
    }
  }

  /**
   * Recursively inserts a value inside an object creating
   * a copy of the original target. It the object (or any in the path),
   * it's an Array, it will generate new Arrays, preserving the same structure.
   *
   * @param {!Array|!Object} Original object that will be copied
   * @param {!string[]} Array of strings used for reaching the deep property
   * @param {*} value Value to be inserted
   * @return {!Array|!Object} Copy of the original object with the new value
   * @review
   */
  function setIn(object, keyPath, value) {
    var nextKey = keyPath[0];
    var target = object instanceof Array ? _toConsumableArray(object) : Object.assign({}, object);
    var nextValue = value;

    if (keyPath.length > 1) {
      nextValue = setIn(object[nextKey] || {}, keyPath.slice(1), value);
    }

    target[nextKey] = nextValue;
    return target;
  }
  //# sourceMappingURL=utils.es.js.map
});
//# sourceMappingURL=utils.es.js.map