/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.admin.web.internal.servlet.taglib.util;

import com.liferay.frontend.taglib.clay.servlet.taglib.util.DropdownItem;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.DropdownItemList;
import com.liferay.petra.function.UnsafeConsumer;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.LayoutPrototype;
import com.liferay.portal.kernel.portlet.LiferayWindowState;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.permission.GroupPermissionUtil;
import com.liferay.portal.kernel.service.permission.LayoutPrototypePermissionUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.taglib.security.PermissionsURLTag;
import java.util.List;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.servlet.http.HttpServletRequest;

public class LayoutPrototypeActionDropdownItemsProvider {
    private final HttpServletRequest _httpServletRequest;
    private final LayoutPrototype _layoutPrototype;
    private final RenderResponse _renderResponse;
    private final ThemeDisplay _themeDisplay;

    public LayoutPrototypeActionDropdownItemsProvider(LayoutPrototype layoutPrototype, RenderRequest renderRequest, RenderResponse renderResponse) {
        this._layoutPrototype = layoutPrototype;
        this._renderResponse = renderResponse;
        this._httpServletRequest = PortalUtil.getHttpServletRequest((PortletRequest)renderRequest);
        this._themeDisplay = (ThemeDisplay)this._httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
    }

    public List<DropdownItem> getActionDropdownItems() throws Exception {
        return new DropdownItemList(){
            {
                if (LayoutPrototypePermissionUtil.contains((PermissionChecker)LayoutPrototypeActionDropdownItemsProvider.this._themeDisplay.getPermissionChecker(), (long)LayoutPrototypeActionDropdownItemsProvider.this._layoutPrototype.getLayoutPrototypeId(), (String)"UPDATE")) {
                    this.add(LayoutPrototypeActionDropdownItemsProvider.this._getEditLayoutPrototypeActionUnsafeConsumer());
                    this.add(LayoutPrototypeActionDropdownItemsProvider.this._getConfigureLayoutPrototypeActionUnsafeConsumer());
                }
                if (LayoutPrototypePermissionUtil.contains((PermissionChecker)LayoutPrototypeActionDropdownItemsProvider.this._themeDisplay.getPermissionChecker(), (long)LayoutPrototypeActionDropdownItemsProvider.this._layoutPrototype.getLayoutPrototypeId(), (String)"PERMISSIONS")) {
                    this.add(LayoutPrototypeActionDropdownItemsProvider.this._getPermissionsLayoutPrototypeActionUnsafeConsumer());
                }
                if (GroupPermissionUtil.contains((PermissionChecker)LayoutPrototypeActionDropdownItemsProvider.this._themeDisplay.getPermissionChecker(), (Group)LayoutPrototypeActionDropdownItemsProvider.this._layoutPrototype.getGroup(), (String)"EXPORT_IMPORT_LAYOUTS")) {
                    this.add(LayoutPrototypeActionDropdownItemsProvider.this._getExportLayoutPrototypeActionUnsafeConsumer());
                    this.add(LayoutPrototypeActionDropdownItemsProvider.this._getImportLayoutPrototypeActionUnsafeConsumer());
                }
                if (LayoutPrototypePermissionUtil.contains((PermissionChecker)LayoutPrototypeActionDropdownItemsProvider.this._themeDisplay.getPermissionChecker(), (long)LayoutPrototypeActionDropdownItemsProvider.this._layoutPrototype.getLayoutPrototypeId(), (String)"DELETE")) {
                    this.add(LayoutPrototypeActionDropdownItemsProvider.this._getDeleteLayoutPrototypeActionUnsafeConsumer());
                }
            }
        };
    }

    private UnsafeConsumer<DropdownItem, Exception> _getConfigureLayoutPrototypeActionUnsafeConsumer() {
        return dropdownItem -> {
            dropdownItem.setHref(this._renderResponse.createRenderURL(), new Object[]{"mvcPath", "/edit_layout_prototype.jsp", "layoutPrototypeId", this._layoutPrototype.getLayoutPrototypeId()});
            dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)this._httpServletRequest, (String)"configure"));
        };
    }

    private UnsafeConsumer<DropdownItem, Exception> _getDeleteLayoutPrototypeActionUnsafeConsumer() {
        PortletURL deleteLayoutPrototypeURL = this._renderResponse.createActionURL();
        deleteLayoutPrototypeURL.setParameter("javax.portlet.action", "/layout_prototype/delete_layout_prototype");
        deleteLayoutPrototypeURL.setParameter("redirect", this._themeDisplay.getURLCurrent());
        deleteLayoutPrototypeURL.setParameter("layoutPrototypeId", String.valueOf(this._layoutPrototype.getLayoutPrototypeId()));
        return dropdownItem -> {
            dropdownItem.putData("action", "deleteLayoutPrototype");
            dropdownItem.putData("deleteLayoutPrototypeURL", deleteLayoutPrototypeURL.toString());
            dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)this._httpServletRequest, (String)"delete"));
        };
    }

    private UnsafeConsumer<DropdownItem, Exception> _getEditLayoutPrototypeActionUnsafeConsumer() throws PortalException {
        Group layoutPrototypeGroup = this._layoutPrototype.getGroup();
        return dropdownItem -> {
            dropdownItem.setHref((Object)layoutPrototypeGroup.getDisplayURL(this._themeDisplay, true));
            dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)this._httpServletRequest, (String)"edit"));
        };
    }

    private UnsafeConsumer<DropdownItem, Exception> _getExportLayoutPrototypeActionUnsafeConsumer() throws Exception {
        PortletURL exportLayoutPrototypeURL = PortalUtil.getControlPanelPortletURL((HttpServletRequest)this._httpServletRequest, (String)"com_liferay_exportimport_web_portlet_ExportPortlet", (String)"RENDER_PHASE");
        exportLayoutPrototypeURL.setParameter("mvcRenderCommandName", "exportLayouts");
        exportLayoutPrototypeURL.setParameter("cmd", "export");
        exportLayoutPrototypeURL.setParameter("groupId", String.valueOf(this._layoutPrototype.getGroupId()));
        exportLayoutPrototypeURL.setParameter("privateLayout", Boolean.TRUE.toString());
        exportLayoutPrototypeURL.setParameter("rootNodeName", this._layoutPrototype.getName(this._themeDisplay.getLocale()));
        exportLayoutPrototypeURL.setParameter("showHeader", Boolean.FALSE.toString());
        exportLayoutPrototypeURL.setWindowState(LiferayWindowState.POP_UP);
        return dropdownItem -> {
            dropdownItem.putData("action", "exportLayoutPrototype");
            dropdownItem.putData("exportLayoutPrototypeURL", exportLayoutPrototypeURL.toString());
            dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)this._httpServletRequest, (String)"export"));
        };
    }

    private UnsafeConsumer<DropdownItem, Exception> _getImportLayoutPrototypeActionUnsafeConsumer() throws Exception {
        PortletURL importLayoutPrototypeURL = PortalUtil.getControlPanelPortletURL((HttpServletRequest)this._httpServletRequest, (String)"com_liferay_exportimport_web_portlet_ImportPortlet", (String)"RENDER_PHASE");
        importLayoutPrototypeURL.setParameter("mvcRenderCommandName", "importLayouts");
        importLayoutPrototypeURL.setParameter("cmd", "import");
        importLayoutPrototypeURL.setParameter("groupId", String.valueOf(this._layoutPrototype.getGroupId()));
        importLayoutPrototypeURL.setParameter("privateLayout", Boolean.TRUE.toString());
        importLayoutPrototypeURL.setParameter("rootNodeName", this._layoutPrototype.getName(this._themeDisplay.getLocale()));
        importLayoutPrototypeURL.setParameter("showHeader", Boolean.FALSE.toString());
        importLayoutPrototypeURL.setWindowState(LiferayWindowState.POP_UP);
        return dropdownItem -> {
            dropdownItem.putData("action", "importLayoutPrototype");
            dropdownItem.putData("importLayoutPrototypeURL", importLayoutPrototypeURL.toString());
            dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)this._httpServletRequest, (String)"import"));
        };
    }

    private UnsafeConsumer<DropdownItem, Exception> _getPermissionsLayoutPrototypeActionUnsafeConsumer() throws Exception {
        String permissionsLayoutPrototypeURL = PermissionsURLTag.doTag((String)"", (String)LayoutPrototype.class.getName(), (String)this._layoutPrototype.getName(this._themeDisplay.getLocale()), null, (String)String.valueOf(this._layoutPrototype.getLayoutPrototypeId()), (String)LiferayWindowState.POP_UP.toString(), null, (HttpServletRequest)this._httpServletRequest);
        return dropdownItem -> {
            dropdownItem.putData("action", "permissionsLayoutPrototype");
            dropdownItem.putData("permissionsLayoutPrototypeURL", permissionsLayoutPrototypeURL);
            dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)this._httpServletRequest, (String)"permissions"));
        };
    }
}

