/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.admin.web.internal.servlet.taglib.util;

import com.liferay.frontend.taglib.clay.servlet.taglib.util.DropdownItem;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.DropdownItemList;
import com.liferay.item.selector.ItemSelector;
import com.liferay.item.selector.ItemSelectorCriterion;
import com.liferay.item.selector.ItemSelectorReturnType;
import com.liferay.item.selector.criteria.FileEntryItemSelectorReturnType;
import com.liferay.item.selector.criteria.upload.criterion.UploadItemSelectorCriterion;
import com.liferay.layout.admin.web.internal.configuration.LayoutAdminWebConfiguration;
import com.liferay.layout.admin.web.internal.security.permission.resource.LayoutPageTemplateEntryPermission;
import com.liferay.layout.page.template.model.LayoutPageTemplateEntry;
import com.liferay.petra.function.UnsafeConsumer;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.model.LayoutPrototype;
import com.liferay.portal.kernel.portlet.LiferayWindowState;
import com.liferay.portal.kernel.portlet.RequestBackedPortletURLFactoryUtil;
import com.liferay.portal.kernel.service.LayoutPrototypeServiceUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.upload.UploadServletRequestConfigurationHelperUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.taglib.security.PermissionsURLTag;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.servlet.http.HttpServletRequest;

public class LayoutPageTemplateEntryActionDropdownItemsProvider {
    private final HttpServletRequest _httpServletRequest;
    private final ItemSelector _itemSelector;
    private final LayoutAdminWebConfiguration _layoutAdminWebConfiguration;
    private final LayoutPageTemplateEntry _layoutPageTemplateEntry;
    private final RenderResponse _renderResponse;
    private final ThemeDisplay _themeDisplay;

    public LayoutPageTemplateEntryActionDropdownItemsProvider(LayoutPageTemplateEntry layoutPageTemplateEntry, RenderRequest renderRequest, RenderResponse renderResponse) {
        this._layoutPageTemplateEntry = layoutPageTemplateEntry;
        this._renderResponse = renderResponse;
        this._httpServletRequest = PortalUtil.getHttpServletRequest((PortletRequest)renderRequest);
        this._itemSelector = (ItemSelector)this._httpServletRequest.getAttribute("ITEM_SELECTOR");
        this._layoutAdminWebConfiguration = (LayoutAdminWebConfiguration)this._httpServletRequest.getAttribute(LayoutAdminWebConfiguration.class.getName());
        this._themeDisplay = (ThemeDisplay)this._httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
    }

    public List<DropdownItem> getActionDropdownItems() throws Exception {
        return new DropdownItemList(){
            {
                if (LayoutPageTemplateEntryPermission.contains(LayoutPageTemplateEntryActionDropdownItemsProvider.this._themeDisplay.getPermissionChecker(), LayoutPageTemplateEntryActionDropdownItemsProvider.this._layoutPageTemplateEntry, "UPDATE")) {
                    this.add(LayoutPageTemplateEntryActionDropdownItemsProvider.this._getUpdateLayoutPageTemplateEntryPreviewActionUnsafeConsumer());
                    if (LayoutPageTemplateEntryActionDropdownItemsProvider.this._layoutPageTemplateEntry.getPreviewFileEntryId() > 0L) {
                        this.add(LayoutPageTemplateEntryActionDropdownItemsProvider.this._getDeleteLayoutPageTemplateEntryPreviewActionUnsafeConsumer());
                    }
                    this.add(LayoutPageTemplateEntryActionDropdownItemsProvider.this._getRenameLayoutPageTemplateEntryActionUnsafeConsumer());
                    this.add(LayoutPageTemplateEntryActionDropdownItemsProvider.this._getConfigureLayoutPageTemplateEntryActionUnsafeConsumer());
                }
                if (LayoutPageTemplateEntryPermission.contains(LayoutPageTemplateEntryActionDropdownItemsProvider.this._themeDisplay.getPermissionChecker(), LayoutPageTemplateEntryActionDropdownItemsProvider.this._layoutPageTemplateEntry, "PERMISSIONS")) {
                    this.add(LayoutPageTemplateEntryActionDropdownItemsProvider.this._getPermissionsLayoutPageTemplateEntryActionUnsafeConsumer());
                }
                if (LayoutPageTemplateEntryPermission.contains(LayoutPageTemplateEntryActionDropdownItemsProvider.this._themeDisplay.getPermissionChecker(), LayoutPageTemplateEntryActionDropdownItemsProvider.this._layoutPageTemplateEntry, "DELETE")) {
                    this.add(LayoutPageTemplateEntryActionDropdownItemsProvider.this._getDeleteLayoutPageTemplateEntryActionUnsafeConsumer());
                }
            }
        };
    }

    private UnsafeConsumer<DropdownItem, Exception> _getConfigureLayoutPageTemplateEntryActionUnsafeConsumer() {
        return dropdownItem -> {
            dropdownItem.setHref(this._renderResponse.createRenderURL(), new Object[]{"mvcRenderCommandName", "/layout/edit_layout", "redirect", this._themeDisplay.getURLCurrent(), "backURL", this._themeDisplay.getURLCurrent(), "selPlid", this._layoutPageTemplateEntry.getPlid()});
            dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)this._httpServletRequest, (String)"configure"));
        };
    }

    private UnsafeConsumer<DropdownItem, Exception> _getDeleteLayoutPageTemplateEntryActionUnsafeConsumer() {
        PortletURL deleteLayoutPageTemplateEntryURL = this._renderResponse.createActionURL();
        deleteLayoutPageTemplateEntryURL.setParameter("javax.portlet.action", "/layout/delete_layout_page_template_entry");
        deleteLayoutPageTemplateEntryURL.setParameter("redirect", this._themeDisplay.getURLCurrent());
        deleteLayoutPageTemplateEntryURL.setParameter("layoutPageTemplateEntryId", String.valueOf(this._layoutPageTemplateEntry.getLayoutPageTemplateEntryId()));
        return dropdownItem -> {
            dropdownItem.putData("action", "deleteLayoutPageTemplateEntry");
            dropdownItem.putData("deleteLayoutPageTemplateEntryURL", deleteLayoutPageTemplateEntryURL.toString());
            dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)this._httpServletRequest, (String)"delete"));
        };
    }

    private UnsafeConsumer<DropdownItem, Exception> _getDeleteLayoutPageTemplateEntryPreviewActionUnsafeConsumer() {
        PortletURL deleteLayoutPageTemplateEntryPreviewURL = this._renderResponse.createActionURL();
        deleteLayoutPageTemplateEntryPreviewURL.setParameter("javax.portlet.action", "/layout/delete_layout_page_template_entry_preview");
        deleteLayoutPageTemplateEntryPreviewURL.setParameter("redirect", this._themeDisplay.getURLCurrent());
        deleteLayoutPageTemplateEntryPreviewURL.setParameter("layoutPageTemplateEntryId", String.valueOf(this._layoutPageTemplateEntry.getLayoutPageTemplateEntryId()));
        return dropdownItem -> {
            dropdownItem.putData("action", "deleteLayoutPageTemplateEntryPreview");
            dropdownItem.putData("deleteLayoutPageTemplateEntryPreviewURL", deleteLayoutPageTemplateEntryPreviewURL.toString());
            dropdownItem.putData("layoutPageTemplateEntryId", String.valueOf(this._layoutPageTemplateEntry.getLayoutPageTemplateEntryId()));
            dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)this._httpServletRequest, (String)"remove-thumbnail"));
        };
    }

    private String _getItemSelectorURL() {
        PortletURL uploadURL = this._renderResponse.createActionURL();
        uploadURL.setParameter("javax.portlet.action", "/layout/upload_layout_page_template_entry_preview");
        uploadURL.setParameter("layoutPageTemplateEntryId", String.valueOf(this._layoutPageTemplateEntry.getLayoutPageTemplateEntryId()));
        UploadItemSelectorCriterion itemSelectorCriterion = new UploadItemSelectorCriterion("com_liferay_layout_admin_web_portlet_GroupPagesPortlet", uploadURL.toString(), LanguageUtil.get((Locale)this._themeDisplay.getLocale(), (String)"page-template"), UploadServletRequestConfigurationHelperUtil.getMaxSize(), this._layoutAdminWebConfiguration.thumbnailExtensions());
        itemSelectorCriterion.setDesiredItemSelectorReturnTypes(new ItemSelectorReturnType[]{new FileEntryItemSelectorReturnType()});
        PortletURL itemSelectorURL = this._itemSelector.getItemSelectorURL(RequestBackedPortletURLFactoryUtil.create((HttpServletRequest)this._httpServletRequest), this._renderResponse.getNamespace() + "changePreview", new ItemSelectorCriterion[]{itemSelectorCriterion});
        return itemSelectorURL.toString();
    }

    private UnsafeConsumer<DropdownItem, Exception> _getPermissionsLayoutPageTemplateEntryActionUnsafeConsumer() throws Exception {
        String permissionsLayoutPageTemplateEntryURL = PermissionsURLTag.doTag((String)"", (String)LayoutPageTemplateEntry.class.getName(), (String)this._layoutPageTemplateEntry.getName(), null, (String)String.valueOf(this._layoutPageTemplateEntry.getLayoutPageTemplateEntryId()), (String)LiferayWindowState.POP_UP.toString(), null, (HttpServletRequest)this._httpServletRequest);
        return dropdownItem -> {
            dropdownItem.putData("action", "permissionsLayoutPageTemplateEntry");
            dropdownItem.putData("permissionsLayoutPageTemplateEntryURL", permissionsLayoutPageTemplateEntryURL);
            dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)this._httpServletRequest, (String)"permissions"));
        };
    }

    private UnsafeConsumer<DropdownItem, Exception> _getRenameLayoutPageTemplateEntryActionUnsafeConsumer() throws PortalException {
        if (Objects.equals(this._layoutPageTemplateEntry.getType(), 2)) {
            LayoutPrototype layoutPrototype = LayoutPrototypeServiceUtil.fetchLayoutPrototype((long)this._layoutPageTemplateEntry.getLayoutPrototypeId());
            return dropdownItem -> {
                dropdownItem.putData("action", "renameLayoutPageTemplateEntry");
                dropdownItem.putData("idFieldName", "layoutPrototypeId");
                dropdownItem.putData("idFieldValue", String.valueOf(layoutPrototype.getLayoutPrototypeId()));
                dropdownItem.putData("layoutPageTemplateEntryName", this._layoutPageTemplateEntry.getName());
                dropdownItem.putData("updateLayoutPageTemplateEntryURL", this._getUpdateLayoutPrototypeURL(layoutPrototype));
                dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)this._httpServletRequest, (String)"rename"));
            };
        }
        return dropdownItem -> {
            dropdownItem.putData("action", "renameLayoutPageTemplateEntry");
            dropdownItem.putData("idFieldName", "layoutPageTemplateEntryId");
            dropdownItem.putData("idFieldValue", String.valueOf(this._layoutPageTemplateEntry.getLayoutPageTemplateEntryId()));
            dropdownItem.putData("layoutPageTemplateEntryName", this._layoutPageTemplateEntry.getName());
            dropdownItem.putData("updateLayoutPageTemplateEntryURL", this._getUpdateLayoutPageTemplateEntryURL());
            dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)this._httpServletRequest, (String)"rename"));
        };
    }

    private UnsafeConsumer<DropdownItem, Exception> _getUpdateLayoutPageTemplateEntryPreviewActionUnsafeConsumer() {
        return dropdownItem -> {
            dropdownItem.putData("action", "updateLayoutPageTemplateEntryPreview");
            dropdownItem.putData("itemSelectorURL", this._getItemSelectorURL());
            dropdownItem.putData("layoutPageTemplateEntryId", String.valueOf(this._layoutPageTemplateEntry.getLayoutPageTemplateEntryId()));
            dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)this._httpServletRequest, (String)"change-thumbnail"));
        };
    }

    private String _getUpdateLayoutPageTemplateEntryURL() {
        PortletURL updateLayoutPageTemplateEntryURL = this._renderResponse.createActionURL();
        updateLayoutPageTemplateEntryURL.setParameter("javax.portlet.action", "/layout/update_layout_page_template_entry");
        updateLayoutPageTemplateEntryURL.setParameter("redirect", this._themeDisplay.getURLCurrent());
        updateLayoutPageTemplateEntryURL.setParameter("layoutPageTemplateCollectionId", String.valueOf(this._layoutPageTemplateEntry.getLayoutPageTemplateCollectionId()));
        updateLayoutPageTemplateEntryURL.setParameter("layoutPageTemplateEntryId", String.valueOf(this._layoutPageTemplateEntry.getLayoutPageTemplateEntryId()));
        return updateLayoutPageTemplateEntryURL.toString();
    }

    private String _getUpdateLayoutPrototypeURL(LayoutPrototype layoutPrototype) {
        PortletURL updateLayoutPrototypeURL = this._renderResponse.createActionURL();
        updateLayoutPrototypeURL.setParameter("javax.portlet.action", "/layout_prototype/update_layout_prototype");
        updateLayoutPrototypeURL.setParameter("redirect", this._themeDisplay.getURLCurrent());
        updateLayoutPrototypeURL.setParameter("layoutPrototypeId", String.valueOf(layoutPrototype.getLayoutPrototypeId()));
        return updateLayoutPrototypeURL.toString();
    }
}

