/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.admin.web.internal.servlet.taglib.util;

import com.liferay.frontend.taglib.clay.servlet.taglib.util.DropdownItem;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.DropdownItemList;
import com.liferay.layout.admin.web.internal.security.permission.resource.LayoutPageTemplateEntryPermission;
import com.liferay.layout.page.template.model.LayoutPageTemplateEntry;
import com.liferay.layout.page.template.service.LayoutPageTemplateEntryServiceUtil;
import com.liferay.petra.function.UnsafeConsumer;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutPrototype;
import com.liferay.portal.kernel.portlet.LiferayWindowState;
import com.liferay.portal.kernel.service.LayoutLocalServiceUtil;
import com.liferay.portal.kernel.service.LayoutPrototypeLocalServiceUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.taglib.security.PermissionsURLTag;
import java.util.List;
import java.util.Objects;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.servlet.http.HttpServletRequest;

public class DisplayPageActionDropdownItemsProvider {
    private final HttpServletRequest _httpServletRequest;
    private final LayoutPageTemplateEntry _layoutPageTemplateEntry;
    private final RenderResponse _renderResponse;
    private final ThemeDisplay _themeDisplay;

    public DisplayPageActionDropdownItemsProvider(LayoutPageTemplateEntry layoutPageTemplateEntry, RenderRequest renderRequest, RenderResponse renderResponse) {
        this._layoutPageTemplateEntry = layoutPageTemplateEntry;
        this._renderResponse = renderResponse;
        this._httpServletRequest = PortalUtil.getHttpServletRequest((PortletRequest)renderRequest);
        this._themeDisplay = (ThemeDisplay)this._httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
    }

    public List<DropdownItem> getActionDropdownItems() throws Exception {
        return new DropdownItemList(){
            {
                if (LayoutPageTemplateEntryPermission.contains(DisplayPageActionDropdownItemsProvider.this._themeDisplay.getPermissionChecker(), DisplayPageActionDropdownItemsProvider.this._layoutPageTemplateEntry, "UPDATE")) {
                    this.add(DisplayPageActionDropdownItemsProvider.this._getEditDisplayPageActionUnsafeConsumer());
                    this.add(DisplayPageActionDropdownItemsProvider.this._getConfigureDisplayPageActionUnsafeConsumer());
                    this.add(DisplayPageActionDropdownItemsProvider.this._getRenameDisplayPageActionUnsafeConsumer());
                }
                if (LayoutPageTemplateEntryPermission.contains(DisplayPageActionDropdownItemsProvider.this._themeDisplay.getPermissionChecker(), DisplayPageActionDropdownItemsProvider.this._layoutPageTemplateEntry, "PERMISSIONS")) {
                    this.add(DisplayPageActionDropdownItemsProvider.this._getPermissionsDisplayPageActionUnsafeConsumer());
                }
                if (DisplayPageActionDropdownItemsProvider.this._layoutPageTemplateEntry.isApproved() && Objects.equals(DisplayPageActionDropdownItemsProvider.this._layoutPageTemplateEntry.getType(), 1) && DisplayPageActionDropdownItemsProvider.this._layoutPageTemplateEntry.getClassNameId() > 0L && LayoutPageTemplateEntryPermission.contains(DisplayPageActionDropdownItemsProvider.this._themeDisplay.getPermissionChecker(), DisplayPageActionDropdownItemsProvider.this._layoutPageTemplateEntry, "UPDATE")) {
                    this.add(DisplayPageActionDropdownItemsProvider.this._getMarkAsDefaultDisplayPageActionUnsafeConsumer());
                }
                if (LayoutPageTemplateEntryPermission.contains(DisplayPageActionDropdownItemsProvider.this._themeDisplay.getPermissionChecker(), DisplayPageActionDropdownItemsProvider.this._layoutPageTemplateEntry, "DELETE")) {
                    this.add(DisplayPageActionDropdownItemsProvider.this._getDeleteLayoutPrototypeActionUnsafeConsumer());
                }
            }
        };
    }

    private UnsafeConsumer<DropdownItem, Exception> _getConfigureDisplayPageActionUnsafeConsumer() {
        return dropdownItem -> {
            dropdownItem.setHref(this._renderResponse.createRenderURL(), new Object[]{"mvcRenderCommandName", "/layout/edit_layout", "redirect", this._themeDisplay.getURLCurrent(), "backURL", this._themeDisplay.getURLCurrent(), "selPlid", this._layoutPageTemplateEntry.getPlid()});
            dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)this._httpServletRequest, (String)"configure"));
        };
    }

    private UnsafeConsumer<DropdownItem, Exception> _getDeleteLayoutPrototypeActionUnsafeConsumer() {
        PortletURL deleteDisplayPageURL = this._renderResponse.createActionURL();
        deleteDisplayPageURL.setParameter("javax.portlet.action", "/layout/delete_layout_page_template_entry");
        deleteDisplayPageURL.setParameter("redirect", this._themeDisplay.getURLCurrent());
        deleteDisplayPageURL.setParameter("layoutPageTemplateEntryId", String.valueOf(this._layoutPageTemplateEntry.getLayoutPageTemplateEntryId()));
        return dropdownItem -> {
            dropdownItem.putData("action", "deleteDisplayPage");
            dropdownItem.putData("deleteDisplayPageURL", deleteDisplayPageURL.toString());
            dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)this._httpServletRequest, (String)"delete"));
        };
    }

    private UnsafeConsumer<DropdownItem, Exception> _getEditDisplayPageActionUnsafeConsumer() throws Exception {
        if (Objects.equals(this._layoutPageTemplateEntry.getType(), 2)) {
            LayoutPrototype layoutPrototype = LayoutPrototypeLocalServiceUtil.fetchLayoutPrototype((long)this._layoutPageTemplateEntry.getLayoutPrototypeId());
            if (layoutPrototype == null) {
                return null;
            }
            Group layoutPrototypeGroup = layoutPrototype.getGroup();
            return dropdownItem -> {
                String layoutFullURL = layoutPrototypeGroup.getDisplayURL(this._themeDisplay, true);
                layoutFullURL = HttpUtil.setParameter((String)layoutFullURL, (String)"p_l_back_url", (String)this._themeDisplay.getURLCurrent());
                dropdownItem.setHref((Object)layoutFullURL);
                dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)this._httpServletRequest, (String)"edit"));
            };
        }
        Layout layout = LayoutLocalServiceUtil.fetchLayout((long)this._layoutPageTemplateEntry.getPlid());
        Layout draftLayout = LayoutLocalServiceUtil.fetchLayout((long)PortalUtil.getClassNameId(Layout.class), (long)layout.getPlid());
        return dropdownItem -> {
            String layoutFullURL = PortalUtil.getLayoutFullURL((Layout)draftLayout, (ThemeDisplay)this._themeDisplay);
            layoutFullURL = HttpUtil.setParameter((String)layoutFullURL, (String)"p_l_back_url", (String)this._themeDisplay.getURLCurrent());
            layoutFullURL = HttpUtil.setParameter((String)layoutFullURL, (String)"p_l_mode", (String)"edit");
            dropdownItem.setHref((Object)layoutFullURL);
            dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)this._httpServletRequest, (String)"edit"));
        };
    }

    private UnsafeConsumer<DropdownItem, Exception> _getMarkAsDefaultDisplayPageActionUnsafeConsumer() {
        PortletURL markAsDefaultDisplayPageURL = this._renderResponse.createActionURL();
        markAsDefaultDisplayPageURL.setParameter("javax.portlet.action", "/layout/edit_layout_page_template_settings");
        markAsDefaultDisplayPageURL.setParameter("redirect", this._themeDisplay.getURLCurrent());
        markAsDefaultDisplayPageURL.setParameter("layoutPageTemplateEntryId", String.valueOf(this._layoutPageTemplateEntry.getLayoutPageTemplateEntryId()));
        markAsDefaultDisplayPageURL.setParameter("defaultTemplate", String.valueOf(!this._layoutPageTemplateEntry.isDefaultTemplate()));
        return dropdownItem -> {
            dropdownItem.putData("action", "markAsDefaultDisplayPage");
            dropdownItem.putData("markAsDefaultDisplayPageURL", markAsDefaultDisplayPageURL.toString());
            String message = "";
            LayoutPageTemplateEntry defaultLayoutPageTemplateEntry = LayoutPageTemplateEntryServiceUtil.fetchDefaultLayoutPageTemplateEntry((long)this._layoutPageTemplateEntry.getGroupId(), (long)this._layoutPageTemplateEntry.getClassNameId(), (long)this._layoutPageTemplateEntry.getClassTypeId());
            if (defaultLayoutPageTemplateEntry != null && defaultLayoutPageTemplateEntry.getLayoutPageTemplateEntryId() != this._layoutPageTemplateEntry.getLayoutPageTemplateEntryId()) {
                message = LanguageUtil.format((HttpServletRequest)this._httpServletRequest, (String)"do-you-want-to-replace-x-for-x-as-the-default-display-page-template", (Object[])new String[]{this._layoutPageTemplateEntry.getName(), defaultLayoutPageTemplateEntry.getName()});
            } else if (this._layoutPageTemplateEntry.isDefaultTemplate()) {
                message = LanguageUtil.get((HttpServletRequest)this._httpServletRequest, (String)"unmark-default-confirmation");
            }
            dropdownItem.putData("message", message);
            String label = "mark-as-default";
            if (this._layoutPageTemplateEntry.isDefaultTemplate()) {
                label = "unmark-as-default";
            }
            dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)this._httpServletRequest, (String)label));
        };
    }

    private UnsafeConsumer<DropdownItem, Exception> _getPermissionsDisplayPageActionUnsafeConsumer() throws Exception {
        String permissionsDisplayPageURL = PermissionsURLTag.doTag((String)"", (String)LayoutPageTemplateEntry.class.getName(), (String)this._layoutPageTemplateEntry.getName(), null, (String)String.valueOf(this._layoutPageTemplateEntry.getLayoutPageTemplateEntryId()), (String)LiferayWindowState.POP_UP.toString(), null, (HttpServletRequest)this._httpServletRequest);
        return dropdownItem -> {
            dropdownItem.putData("action", "permissionsDisplayPage");
            dropdownItem.putData("permissionsDisplayPageURL", permissionsDisplayPageURL);
            dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)this._httpServletRequest, (String)"permissions"));
        };
    }

    private UnsafeConsumer<DropdownItem, Exception> _getRenameDisplayPageActionUnsafeConsumer() {
        PortletURL updateDisplayPageURL = this._renderResponse.createActionURL();
        updateDisplayPageURL.setParameter("javax.portlet.action", "/layout/update_layout_page_template_entry");
        updateDisplayPageURL.setParameter("redirect", this._themeDisplay.getURLCurrent());
        updateDisplayPageURL.setParameter("layoutPageTemplateCollectionId", String.valueOf(this._layoutPageTemplateEntry.getLayoutPageTemplateCollectionId()));
        updateDisplayPageURL.setParameter("layoutPageTemplateEntryId", String.valueOf(this._layoutPageTemplateEntry.getLayoutPageTemplateEntryId()));
        return dropdownItem -> {
            dropdownItem.putData("action", "renameDisplayPage");
            dropdownItem.putData("layoutPageTemplateEntryId", String.valueOf(this._layoutPageTemplateEntry.getLayoutPageTemplateEntryId()));
            dropdownItem.putData("layoutPageTemplateEntryName", this._layoutPageTemplateEntry.getName());
            dropdownItem.putData("updateDisplayPageURL", updateDisplayPageURL.toString());
            dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)this._httpServletRequest, (String)"rename"));
        };
    }
}

