/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.admin.web.internal.servlet.taglib.clay;

import com.liferay.frontend.taglib.clay.servlet.taglib.soy.BaseBaseClayCard;
import com.liferay.frontend.taglib.clay.servlet.taglib.soy.VerticalCard;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.DropdownItem;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.LabelItem;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.LabelItemList;
import com.liferay.layout.admin.web.internal.servlet.taglib.util.LayoutPrototypeActionDropdownItemsProvider;
import com.liferay.portal.kernel.dao.search.RowChecker;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.LayoutPrototype;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import java.util.Date;
import java.util.List;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.servlet.http.HttpServletRequest;

public class LayoutPrototypeVerticalCard
extends BaseBaseClayCard
implements VerticalCard {
    private final HttpServletRequest _httpServletRequest;
    private final LayoutPrototype _layoutPrototype;
    private final RenderRequest _renderRequest;
    private final RenderResponse _renderResponse;
    private final ThemeDisplay _themeDisplay;

    public LayoutPrototypeVerticalCard(BaseModel<?> baseModel, RenderRequest renderRequest, RenderResponse renderResponse, RowChecker rowChecker) {
        super(baseModel, rowChecker);
        this._renderRequest = renderRequest;
        this._renderResponse = renderResponse;
        this._layoutPrototype = (LayoutPrototype)baseModel;
        this._themeDisplay = (ThemeDisplay)renderRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        this._httpServletRequest = PortalUtil.getHttpServletRequest((PortletRequest)renderRequest);
    }

    public List<DropdownItem> getActionDropdownItems() {
        try {
            LayoutPrototypeActionDropdownItemsProvider layoutPrototypeActionDropdownItemsProvider = new LayoutPrototypeActionDropdownItemsProvider(this._layoutPrototype, this._renderRequest, this._renderResponse);
            return layoutPrototypeActionDropdownItemsProvider.getActionDropdownItems();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String getDefaultEventHandler() {
        return "LAYOUT_PROTOTYPE_DROPDOWN_DEFAULT_EVENT_HANDLER";
    }

    public String getHref() {
        if (this._layoutPrototype == null) {
            return null;
        }
        try {
            Group layoutPrototypeGroup = this._layoutPrototype.getGroup();
            String layoutFullURL = layoutPrototypeGroup.getDisplayURL(this._themeDisplay, true);
            return HttpUtil.setParameter((String)layoutFullURL, (String)"p_l_back_url", (String)this._themeDisplay.getURLCurrent());
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String getIcon() {
        return "page-template";
    }

    public List<LabelItem> getLabels() {
        return new LabelItemList(){
            {
                this.add(labelItem -> {
                    String label = "not-active";
                    if (LayoutPrototypeVerticalCard.this._layoutPrototype.isActive()) {
                        label = "active";
                    }
                    labelItem.setLabel(LanguageUtil.get((HttpServletRequest)LayoutPrototypeVerticalCard.this._httpServletRequest, (String)label));
                    String style = "warning";
                    if (LayoutPrototypeVerticalCard.this._layoutPrototype.isActive()) {
                        style = "success";
                    }
                    labelItem.setStyle(style);
                });
            }
        };
    }

    public String getSubtitle() {
        Date createDate = this._layoutPrototype.getModifiedDate();
        String createdDateDescription = LanguageUtil.getTimeDescription((HttpServletRequest)this._httpServletRequest, (long)(System.currentTimeMillis() - createDate.getTime()), (boolean)true);
        return LanguageUtil.format((HttpServletRequest)this._httpServletRequest, (String)"created-x-ago", (Object)createdDateDescription);
    }

    public String getTitle() {
        if (this._layoutPrototype != null) {
            return HtmlUtil.escape((String)this._layoutPrototype.getName(this._themeDisplay.getLocale()));
        }
        return null;
    }
}

