/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.admin.web.internal.servlet.taglib.clay;

import com.liferay.asset.kernel.AssetRendererFactoryRegistryUtil;
import com.liferay.asset.kernel.model.AssetRendererFactory;
import com.liferay.asset.kernel.model.ClassType;
import com.liferay.asset.kernel.model.ClassTypeReader;
import com.liferay.frontend.taglib.clay.servlet.taglib.soy.BaseBaseClayCard;
import com.liferay.frontend.taglib.clay.servlet.taglib.soy.VerticalCard;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.DropdownItem;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.LabelItem;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.LabelItemList;
import com.liferay.info.display.contributor.InfoDisplayContributor;
import com.liferay.info.display.contributor.InfoDisplayContributorTracker;
import com.liferay.layout.admin.web.internal.servlet.taglib.util.DisplayPageActionDropdownItemsProvider;
import com.liferay.layout.page.template.model.LayoutPageTemplateEntry;
import com.liferay.portal.kernel.dao.search.RowChecker;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutPrototype;
import com.liferay.portal.kernel.service.LayoutLocalServiceUtil;
import com.liferay.portal.kernel.service.LayoutPrototypeLocalServiceUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.List;
import java.util.Objects;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;

public class DisplayPageVerticalCard
extends BaseBaseClayCard
implements VerticalCard {
    private final InfoDisplayContributorTracker _infoDisplayContributorTracker;
    private final LayoutPageTemplateEntry _layoutPageTemplateEntry;
    private final RenderRequest _renderRequest;
    private final RenderResponse _renderResponse;
    private final ThemeDisplay _themeDisplay;

    public DisplayPageVerticalCard(BaseModel<?> baseModel, RenderRequest renderRequest, RenderResponse renderResponse, RowChecker rowChecker) {
        super(baseModel, rowChecker);
        this._renderRequest = renderRequest;
        this._renderResponse = renderResponse;
        this._infoDisplayContributorTracker = (InfoDisplayContributorTracker)renderRequest.getAttribute("INFO_DISPLAY_CONTRIBUTOR_TRACKER");
        this._layoutPageTemplateEntry = (LayoutPageTemplateEntry)baseModel;
        this._themeDisplay = (ThemeDisplay)renderRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
    }

    public List<DropdownItem> getActionDropdownItems() {
        try {
            DisplayPageActionDropdownItemsProvider displayPageActionDropdownItemsProvider = new DisplayPageActionDropdownItemsProvider(this._layoutPageTemplateEntry, this._renderRequest, this._renderResponse);
            return displayPageActionDropdownItemsProvider.getActionDropdownItems();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String getDefaultEventHandler() {
        return "DISPLAY_PAGE_DROPDOWN_DEFAULT_EVENT_HANDLER";
    }

    public String getHref() {
        try {
            if (Objects.equals(this._layoutPageTemplateEntry.getType(), 2)) {
                LayoutPrototype layoutPrototype = LayoutPrototypeLocalServiceUtil.fetchLayoutPrototype((long)this._layoutPageTemplateEntry.getLayoutPrototypeId());
                if (layoutPrototype == null) {
                    return null;
                }
                Group layoutPrototypeGroup = layoutPrototype.getGroup();
                String layoutFullURL = layoutPrototypeGroup.getDisplayURL(this._themeDisplay, true);
                return HttpUtil.setParameter((String)layoutFullURL, (String)"p_l_back_url", (String)this._themeDisplay.getURLCurrent());
            }
            Layout layout = LayoutLocalServiceUtil.fetchLayout((long)this._layoutPageTemplateEntry.getPlid());
            Layout draftLayout = LayoutLocalServiceUtil.fetchLayout((long)PortalUtil.getClassNameId(Layout.class), (long)layout.getPlid());
            String layoutFullURL = PortalUtil.getLayoutFullURL((Layout)draftLayout, (ThemeDisplay)this._themeDisplay);
            layoutFullURL = HttpUtil.setParameter((String)layoutFullURL, (String)"p_l_mode", (String)"edit");
            return HttpUtil.setParameter((String)layoutFullURL, (String)"p_l_back_url", (String)this._themeDisplay.getURLCurrent());
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String getIcon() {
        return "page";
    }

    public String getImageSrc() {
        return this._layoutPageTemplateEntry.getImagePreviewURL(this._themeDisplay);
    }

    public List<LabelItem> getLabels() {
        return new LabelItemList(){
            {
                this.add(labelItem -> labelItem.setStatus(DisplayPageVerticalCard.this._layoutPageTemplateEntry.getStatus()));
            }
        };
    }

    public String getStickerIcon() {
        if (this._layoutPageTemplateEntry.getDefaultTemplate()) {
            return "check-circle";
        }
        return null;
    }

    public String getStickerStyle() {
        return "primary";
    }

    public String getSubtitle() {
        String typeLabel = this._getTypeLabel();
        if (Validator.isNull((String)typeLabel)) {
            return "-";
        }
        String subtypeLabel = "";
        try {
            subtypeLabel = this._getSubtypeLabel();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (Validator.isNull((String)subtypeLabel)) {
            return typeLabel;
        }
        return typeLabel + " - " + subtypeLabel;
    }

    public String getTitle() {
        return HtmlUtil.escape((String)this._layoutPageTemplateEntry.getName());
    }

    private String _getSubtypeLabel() throws PortalException {
        AssetRendererFactory assetRendererFactory = AssetRendererFactoryRegistryUtil.getAssetRendererFactoryByClassName((String)this._layoutPageTemplateEntry.getClassName());
        if (assetRendererFactory == null || this._layoutPageTemplateEntry.getClassTypeId() <= 0L) {
            return "";
        }
        ClassTypeReader classTypeReader = assetRendererFactory.getClassTypeReader();
        ClassType classType = classTypeReader.getClassType(this._layoutPageTemplateEntry.getClassTypeId(), this._themeDisplay.getLocale());
        return classType.getName();
    }

    private String _getTypeLabel() {
        InfoDisplayContributor infoDisplayContributor = this._infoDisplayContributorTracker.getInfoDisplayContributor(this._layoutPageTemplateEntry.getClassName());
        if (infoDisplayContributor == null) {
            return "";
        }
        return infoDisplayContributor.getLabel(this._themeDisplay.getLocale());
    }
}

