/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.admin.web.internal.product.navigation.control.menu;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutSet;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.permission.LayoutPermissionUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.product.navigation.control.menu.BaseJSPProductNavigationControlMenuEntry;
import com.liferay.product.navigation.control.menu.ProductNavigationControlMenuEntry;
import com.liferay.sites.kernel.util.SitesUtil;
import java.io.IOException;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"product.navigation.control.menu.category.key=tools", "product.navigation.control.menu.entry.order:Integer=300"}, service={ProductNavigationControlMenuEntry.class})
public class InformationMessagesProductNavigationControlMenuEntry
extends BaseJSPProductNavigationControlMenuEntry
implements ProductNavigationControlMenuEntry {
    public static final String INFORMATION_MESSAGES_LINKED_LAYOUT = "INFORMATION_MESSAGES_LINKED_LAYOUT";
    public static final String INFORMATION_MESSAGES_MODIFIED_LAYOUT = "INFORMATION_MESSAGES_MODIFIED_LAYOUT";
    private static final Log _log = LogFactoryUtil.getLog(InformationMessagesProductNavigationControlMenuEntry.class);

    public String getIconJspPath() {
        return "/control/menu/information_messages.jsp";
    }

    public boolean hasUpdateLayoutPermission(ThemeDisplay themeDisplay) throws PortalException {
        return LayoutPermissionUtil.contains((PermissionChecker)themeDisplay.getPermissionChecker(), (Layout)themeDisplay.getLayout(), (String)"UPDATE");
    }

    public boolean includeIcon(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        try {
            httpServletRequest.setAttribute(INFORMATION_MESSAGES_LINKED_LAYOUT, (Object)this.isLinkedLayout(themeDisplay));
            httpServletRequest.setAttribute(INFORMATION_MESSAGES_MODIFIED_LAYOUT, (Object)this.isModifiedLayout(themeDisplay));
        }
        catch (PortalException pe) {
            _log.error((Object)pe, (Throwable)pe);
        }
        return super.includeIcon(httpServletRequest, httpServletResponse);
    }

    public boolean isShow(HttpServletRequest httpServletRequest) throws PortalException {
        ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        Layout layout = themeDisplay.getLayout();
        if (layout.isTypeControlPanel()) {
            return false;
        }
        if (!this.isLinkedLayout(themeDisplay) && !this.isModifiedLayout(themeDisplay)) {
            return false;
        }
        return super.isShow(httpServletRequest);
    }

    @Reference(target="(osgi.web.symbolicname=com.liferay.layout.admin.web)", unbind="-")
    public void setServletContext(ServletContext servletContext) {
        super.setServletContext(servletContext);
    }

    protected boolean isLinkedLayout(ThemeDisplay themeDisplay) throws PortalException {
        Layout layout = themeDisplay.getLayout();
        Group group = layout.getGroup();
        if (!SitesUtil.isLayoutUpdateable((Layout)layout) || layout.isLayoutPrototypeLinkActive() && !group.hasStagingGroup()) {
            return LayoutPermissionUtil.containsWithoutViewableGroup((PermissionChecker)themeDisplay.getPermissionChecker(), (Layout)layout, (boolean)false, (String)"UPDATE");
        }
        return false;
    }

    protected boolean isModifiedLayout(ThemeDisplay themeDisplay) throws PortalException {
        Layout layout = themeDisplay.getLayout();
        LayoutSet layoutSet = layout.getLayoutSet();
        if (!layoutSet.isLayoutSetPrototypeLinkActive() || !SitesUtil.isLayoutModifiedSinceLastMerge((Layout)layout)) {
            return false;
        }
        return this.hasUpdateLayoutPermission(themeDisplay);
    }
}

