/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.admin.web.internal.portlet.action;

import com.liferay.document.library.kernel.service.DLAppLocalService;
import com.liferay.layout.admin.web.internal.portlet.action.ActionUtil;
import com.liferay.portal.events.EventsProcessorUtil;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutTypePortlet;
import com.liferay.portal.kernel.portlet.bridges.mvc.BaseMVCActionCommand;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCActionCommand;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.service.LayoutService;
import com.liferay.portal.kernel.service.PortletPreferencesLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextFactory;
import com.liferay.portal.kernel.servlet.MultiSessionMessages;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.upload.UploadPortletRequest;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.PropertiesParamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.PropsValues;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"javax.portlet.name=com_liferay_layout_admin_web_portlet_GroupPagesPortlet", "mvc.command.name=/layout/edit_layout"}, service={MVCActionCommand.class})
public class EditLayoutMVCActionCommand
extends BaseMVCActionCommand {
    @Reference
    private ActionUtil _actionUtil;
    @Reference
    private DLAppLocalService _dlAppLocalService;
    @Reference
    private LayoutLocalService _layoutLocalService;
    @Reference
    private LayoutService _layoutService;
    @Reference
    private Portal _portal;
    @Reference
    private PortletPreferencesLocalService _portletPreferencesLocalService;

    protected void doProcessAction(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        String currentType;
        UploadPortletRequest uploadPortletRequest = this._portal.getUploadPortletRequest((PortletRequest)actionRequest);
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        long groupId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"groupId");
        long liveGroupId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"liveGroupId");
        long stagingGroupId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"stagingGroupId");
        boolean privateLayout = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"privateLayout");
        long layoutId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"layoutId");
        Map nameMap = LocalizationUtil.getLocalizationMap((PortletRequest)actionRequest, (String)"name");
        Map titleMap = LocalizationUtil.getLocalizationMap((PortletRequest)actionRequest, (String)"title");
        Map descriptionMap = LocalizationUtil.getLocalizationMap((PortletRequest)actionRequest, (String)"description");
        Map keywordsMap = LocalizationUtil.getLocalizationMap((PortletRequest)actionRequest, (String)"keywords");
        Map robotsMap = LocalizationUtil.getLocalizationMap((PortletRequest)actionRequest, (String)"robots");
        String type = ParamUtil.getString((HttpServletRequest)uploadPortletRequest, (String)"type");
        boolean hidden = ParamUtil.getBoolean((HttpServletRequest)uploadPortletRequest, (String)"hidden");
        Map friendlyURLMap = LocalizationUtil.getLocalizationMap((PortletRequest)actionRequest, (String)"friendlyURL");
        boolean deleteLogo = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"deleteLogo");
        byte[] iconBytes = null;
        long fileEntryId = ParamUtil.getLong((HttpServletRequest)uploadPortletRequest, (String)"fileEntryId");
        if (fileEntryId > 0L) {
            FileEntry fileEntry = this._dlAppLocalService.getFileEntry(fileEntryId);
            iconBytes = FileUtil.getBytes((InputStream)fileEntry.getContentStream());
        }
        ServiceContext serviceContext = ServiceContextFactory.getInstance((String)Layout.class.getName(), (PortletRequest)actionRequest);
        Layout layout = this._layoutLocalService.getLayout(groupId, privateLayout, layoutId);
        String oldFriendlyURL = layout.getFriendlyURL();
        Collection values = friendlyURLMap.values();
        values.removeIf(value -> Validator.isNull((String)value));
        if (friendlyURLMap.isEmpty()) {
            friendlyURLMap = layout.getFriendlyURLMap();
        }
        if (StringUtil.equals((String)(currentType = layout.getType()), (String)"asset_display")) {
            serviceContext.setAttribute("layout.instanceable.allowed", (Serializable)Boolean.TRUE);
        }
        layout = this._layoutService.updateLayout(groupId, privateLayout, layoutId, layout.getParentLayoutId(), nameMap, titleMap, descriptionMap, keywordsMap, robotsMap, type, hidden, friendlyURLMap, !deleteLogo, iconBytes, serviceContext);
        Layout draftLayout = this._layoutLocalService.fetchLayout(this._portal.getClassNameId(Layout.class), layout.getPlid());
        if (draftLayout != null) {
            this._layoutService.updateLayout(groupId, privateLayout, draftLayout.getLayoutId(), draftLayout.getParentLayoutId(), nameMap, titleMap, descriptionMap, keywordsMap, robotsMap, type, draftLayout.isHidden(), draftLayout.getFriendlyURLMap(), !deleteLogo, iconBytes, serviceContext);
        }
        themeDisplay.clearLayoutFriendlyURL(layout);
        UnicodeProperties layoutTypeSettingsProperties = layout.getTypeSettingsProperties();
        UnicodeProperties formTypeSettingsProperties = PropertiesParamUtil.getProperties((PortletRequest)actionRequest, (String)"TypeSettingsProperties--");
        String linkToLayoutUuid = ParamUtil.getString((PortletRequest)actionRequest, (String)"linkToLayoutUuid");
        if (Validator.isNotNull((String)linkToLayoutUuid)) {
            Layout linkToLayout = this._layoutService.getLayoutByUuidAndGroupId(linkToLayoutUuid, groupId, privateLayout);
            formTypeSettingsProperties.put("linkToLayoutId", String.valueOf(linkToLayout.getLayoutId()));
        }
        LayoutTypePortlet layoutTypePortlet = (LayoutTypePortlet)layout.getLayoutType();
        if (type.equals("portlet")) {
            String layoutTemplateId = ParamUtil.getString((HttpServletRequest)uploadPortletRequest, (String)"layoutTemplateId", (String)PropsValues.DEFAULT_LAYOUT_TEMPLATE_ID);
            layoutTypePortlet.setLayoutTemplateId(themeDisplay.getUserId(), layoutTemplateId);
            layoutTypeSettingsProperties.putAll((Map)formTypeSettingsProperties);
            boolean layoutCustomizable = GetterUtil.getBoolean((String)((String)layoutTypeSettingsProperties.get((Object)"CUSTOMIZABLE_LAYOUT")));
            if (!layoutCustomizable) {
                layoutTypePortlet.removeCustomization(layoutTypeSettingsProperties);
            }
            layout = this._layoutService.updateLayout(groupId, privateLayout, layoutId, layoutTypeSettingsProperties.toString());
            if (!currentType.equals("portlet")) {
                this._portletPreferencesLocalService.deletePortletPreferences(0L, 3, layout.getPlid());
            }
        } else {
            layoutTypeSettingsProperties.putAll((Map)formTypeSettingsProperties);
            layoutTypeSettingsProperties.putAll((Map)layout.getTypeSettingsProperties());
            layout = this._layoutService.updateLayout(groupId, privateLayout, layoutId, layoutTypeSettingsProperties.toString());
        }
        HttpServletResponse httpServletResponse = this._portal.getHttpServletResponse((PortletResponse)actionResponse);
        EventsProcessorUtil.process((String)"layout.configuration.action.update", (String[])layoutTypePortlet.getConfigurationActionUpdate(), (HttpServletRequest)uploadPortletRequest, (HttpServletResponse)httpServletResponse);
        this._actionUtil.updateLookAndFeel(actionRequest, themeDisplay.getCompanyId(), liveGroupId, stagingGroupId, privateLayout, layout.getLayoutId(), layout.getTypeSettingsProperties());
        String redirect = ParamUtil.getString((PortletRequest)actionRequest, (String)"redirect");
        if (Validator.isNull((String)redirect) || redirect.endsWith(oldFriendlyURL)) {
            redirect = this._portal.getLayoutFullURL(layout, themeDisplay);
        }
        String portletResource = ParamUtil.getString((PortletRequest)actionRequest, (String)"portletResource");
        MultiSessionMessages.add((PortletRequest)actionRequest, (String)(portletResource + "layoutUpdated"), (Object)layout);
        actionRequest.setAttribute("REDIRECT", (Object)redirect);
    }
}

