/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.admin.web.internal.portlet.action;

import com.liferay.layout.util.LayoutCopyHelper;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.portlet.JSONPortletResponseUtil;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.portlet.bridges.mvc.BaseMVCActionCommand;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCActionCommand;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.service.LayoutService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextFactory;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.upload.UploadPortletRequest;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.PropertiesParamUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletURL;
import javax.servlet.http.HttpServletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"javax.portlet.name=com_liferay_layout_admin_web_portlet_GroupPagesPortlet", "mvc.command.name=/layout/copy_layout"}, service={MVCActionCommand.class})
public class CopyLayoutMVCActionCommand
extends BaseMVCActionCommand {
    private static final Log _log = LogFactoryUtil.getLog(CopyLayoutMVCActionCommand.class);
    @Reference
    private LayoutCopyHelper _layoutCopyHelper;
    @Reference
    private LayoutLocalService _layoutLocalService;
    @Reference
    private LayoutService _layoutService;
    @Reference
    private Portal _portal;

    protected void doProcessAction(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        UploadPortletRequest uploadPortletRequest = this._portal.getUploadPortletRequest((PortletRequest)actionRequest);
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        long sourcePlid = ParamUtil.getLong((HttpServletRequest)uploadPortletRequest, (String)"sourcePlid");
        long groupId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"groupId");
        boolean privateLayout = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"privateLayout");
        String name = ParamUtil.getString((PortletRequest)actionRequest, (String)"name");
        HashMap<Locale, String> nameMap = new HashMap<Locale, String>();
        nameMap.put(themeDisplay.getLocale(), name);
        if (!Objects.equals(themeDisplay.getLocale(), LocaleUtil.getSiteDefault())) {
            nameMap.put(LocaleUtil.getSiteDefault(), name);
        }
        ServiceContext serviceContext = ServiceContextFactory.getInstance((String)Layout.class.getName(), (PortletRequest)actionRequest);
        UnicodeProperties typeSettingsProperties = PropertiesParamUtil.getProperties((PortletRequest)actionRequest, (String)"TypeSettingsProperties--");
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
        try {
            Layout sourceLayout = this._layoutLocalService.fetchLayout(sourcePlid);
            UnicodeProperties sourceTypeSettingsProperties = sourceLayout.getTypeSettingsProperties();
            sourceTypeSettingsProperties.putAll((Map)typeSettingsProperties);
            Layout targetLayout = this._layoutService.addLayout(groupId, privateLayout, sourceLayout.getParentLayoutId(), 0L, 0L, nameMap, new HashMap(), new HashMap(), sourceLayout.getKeywordsMap(), sourceLayout.getRobotsMap(), sourceLayout.getType(), sourceTypeSettingsProperties.toString(), false, false, new HashMap(), serviceContext);
            Layout draftLayout = this._layoutLocalService.fetchLayout(this._portal.getClassNameId(Layout.class), targetLayout.getPlid());
            if (draftLayout != null) {
                targetLayout = draftLayout;
            }
            targetLayout = this._layoutCopyHelper.copyLayout(sourceLayout, targetLayout);
            targetLayout.setNameMap(nameMap);
            this._layoutLocalService.updateLayout(targetLayout);
            LiferayPortletResponse liferayPortletResponse = this._portal.getLiferayPortletResponse((PortletResponse)actionResponse);
            PortletURL redirectURL = liferayPortletResponse.createRenderURL();
            redirectURL.setParameter("navigation", privateLayout ? "private-pages" : "public-pages");
            redirectURL.setParameter("selPlid", String.valueOf(sourceLayout.getParentPlid()));
            redirectURL.setParameter("privateLayout", String.valueOf(privateLayout));
            jsonObject.put("redirectURL", redirectURL.toString());
            JSONPortletResponseUtil.writeJSON((PortletRequest)actionRequest, (PortletResponse)actionResponse, (Object)jsonObject);
        }
        catch (PortalException pe) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)pe, (Throwable)pe);
            }
            jsonObject.put("error", LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"an-unexpected-error-occurred"));
            JSONPortletResponseUtil.writeJSON((PortletRequest)actionRequest, (PortletResponse)actionResponse, (Object)jsonObject);
        }
    }
}

