/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.admin.web.internal.portlet.action;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.portlet.bridges.mvc.BaseMVCActionCommand;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.Validator;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletURL;
import javax.portlet.WindowState;
import org.osgi.service.component.annotations.Reference;

public abstract class BaseAddLayoutMVCActionCommand
extends BaseMVCActionCommand {
    @Reference
    protected LayoutLocalService layoutLocalService;
    @Reference
    protected Portal portal;

    protected String getContentRedirectURL(ActionRequest actionRequest, Layout layout) throws PortalException {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        String layoutFullURL = this.portal.getLayoutFullURL(layout, themeDisplay);
        Layout draftLayout = this.layoutLocalService.fetchLayout(this.portal.getClassNameId(Layout.class), layout.getPlid());
        if (draftLayout != null) {
            layoutFullURL = this.portal.getLayoutFullURL(draftLayout, themeDisplay);
        }
        layoutFullURL = HttpUtil.setParameter((String)layoutFullURL, (String)"p_l_mode", (String)"edit");
        String backURL = ParamUtil.getString((PortletRequest)actionRequest, (String)"backURL");
        if (Validator.isNotNull((String)backURL)) {
            layoutFullURL = HttpUtil.setParameter((String)layoutFullURL, (String)"p_l_back_url", (String)backURL);
        }
        return layoutFullURL;
    }

    protected String getRedirectURL(ActionRequest actionRequest, ActionResponse actionResponse, Layout layout) {
        LiferayPortletResponse liferayPortletResponse = this.portal.getLiferayPortletResponse((PortletResponse)actionResponse);
        PortletURL configureLayoutURL = liferayPortletResponse.createRenderURL();
        configureLayoutURL.setParameter("mvcRenderCommandName", "/layout/edit_layout");
        String backURL = ParamUtil.getString((PortletRequest)actionRequest, (String)"backURL");
        if (Validator.isNull((String)backURL)) {
            PortletURL redirectURL = liferayPortletResponse.createRenderURL();
            backURL = HttpUtil.setParameter((String)redirectURL.toString(), (String)"p_p_state", (String)WindowState.NORMAL.toString());
        }
        configureLayoutURL.setParameter("redirect", backURL);
        String portletResource = ParamUtil.getString((PortletRequest)actionRequest, (String)"portletResource");
        configureLayoutURL.setParameter("portletResource", portletResource);
        configureLayoutURL.setParameter("groupId", String.valueOf(layout.getGroupId()));
        configureLayoutURL.setParameter("selPlid", String.valueOf(layout.getPlid()));
        configureLayoutURL.setParameter("privateLayout", String.valueOf(layout.isPrivateLayout()));
        return configureLayoutURL.toString();
    }
}

