/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.admin.web.internal.portlet.action;

import com.liferay.layout.admin.web.internal.handler.LayoutPageTemplateEntryExceptionRequestHandler;
import com.liferay.layout.page.template.model.LayoutPageTemplateEntry;
import com.liferay.layout.page.template.service.LayoutPageTemplateEntryService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.portlet.JSONPortletResponseUtil;
import com.liferay.portal.kernel.portlet.bridges.mvc.BaseMVCActionCommand;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCActionCommand;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextFactory;
import com.liferay.portal.kernel.servlet.MultiSessionMessages;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.Http;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.Validator;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"javax.portlet.name=com_liferay_layout_admin_web_portlet_GroupPagesPortlet", "mvc.command.name=/layout/add_layout_page_template_entry"}, service={MVCActionCommand.class})
public class AddLayoutPageTemplateEntryMVCActionCommand
extends BaseMVCActionCommand {
    @Reference
    private Http _http;
    @Reference
    private LayoutLocalService _layoutLocalService;
    @Reference
    private LayoutPageTemplateEntryExceptionRequestHandler _layoutPageTemplateEntryExceptionRequestHandler;
    @Reference
    private LayoutPageTemplateEntryService _layoutPageTemplateEntryService;
    @Reference
    private Portal _portal;

    protected void doProcessAction(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        long layoutPageTemplateCollectionId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"layoutPageTemplateCollectionId");
        String name = ParamUtil.getString((PortletRequest)actionRequest, (String)"name");
        int type = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"type", (int)0);
        try {
            ServiceContext serviceContext = ServiceContextFactory.getInstance((PortletRequest)actionRequest);
            LayoutPageTemplateEntry layoutPageTemplateEntry = this._layoutPageTemplateEntryService.addLayoutPageTemplateEntry(serviceContext.getScopeGroupId(), layoutPageTemplateCollectionId, name, type, 2, serviceContext);
            if (SessionErrors.contains((PortletRequest)actionRequest, (String)"layoutPageTemplateEntryNameInvalid")) {
                this.addSuccessMessage(actionRequest, actionResponse);
            }
            JSONObject jsonObject = JSONUtil.put((String)"redirectURL", (Object)this.getRedirectURL(actionRequest, layoutPageTemplateEntry));
            JSONPortletResponseUtil.writeJSON((PortletRequest)actionRequest, (PortletResponse)actionResponse, (Object)jsonObject);
            if (type == 1) {
                MultiSessionMessages.add((PortletRequest)actionRequest, (String)"displayPageAdded");
            } else if (type == 0) {
                MultiSessionMessages.add((PortletRequest)actionRequest, (String)"layoutPageTemplateAdded");
            }
        }
        catch (PortalException pe) {
            SessionErrors.add((PortletRequest)actionRequest, (String)"layoutPageTemplateEntryNameInvalid");
            this.hideDefaultErrorMessage((PortletRequest)actionRequest);
            this._layoutPageTemplateEntryExceptionRequestHandler.handlePortalException(actionRequest, actionResponse, pe);
        }
    }

    protected String getRedirectURL(ActionRequest actionRequest, LayoutPageTemplateEntry layoutPageTemplateEntry) throws PortalException {
        Layout layout = this._layoutLocalService.getLayout(layoutPageTemplateEntry.getPlid());
        Layout draftLayout = this._layoutLocalService.fetchLayout(this._portal.getClassNameId(Layout.class), layout.getPlid());
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        String layoutFullURL = this._portal.getLayoutFullURL(draftLayout, themeDisplay);
        layoutFullURL = this._http.setParameter(layoutFullURL, "p_l_mode", "edit");
        String backURL = ParamUtil.getString((PortletRequest)actionRequest, (String)"backURL");
        if (Validator.isNotNull((String)backURL)) {
            layoutFullURL = this._http.setParameter(layoutFullURL, "p_l_back_url", backURL);
        }
        return layoutFullURL;
    }
}

