/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.admin.web.internal.display.context;

import com.liferay.exportimport.kernel.staging.LayoutStagingUtil;
import com.liferay.exportimport.kernel.staging.StagingUtil;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.DropdownItem;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.DropdownItemList;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.NavigationItem;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.NavigationItemList;
import com.liferay.layout.admin.web.internal.display.context.OrphanPortletsDisplayContext;
import com.liferay.layout.page.template.model.LayoutPageTemplateCollection;
import com.liferay.layout.page.template.model.LayoutPageTemplateEntry;
import com.liferay.layout.page.template.service.LayoutPageTemplateCollectionLocalServiceUtil;
import com.liferay.layout.page.template.service.LayoutPageTemplateEntryLocalServiceUtil;
import com.liferay.layout.page.template.service.LayoutPageTemplateEntryServiceUtil;
import com.liferay.layout.page.template.util.comparator.LayoutPageTemplateCollectionNameComparator;
import com.liferay.layout.util.LayoutCopyHelper;
import com.liferay.layout.util.comparator.LayoutCreateDateComparator;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.search.EmptyOnClickRowChecker;
import com.liferay.portal.kernel.dao.search.RowChecker;
import com.liferay.portal.kernel.dao.search.SearchContainer;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutRevision;
import com.liferay.portal.kernel.model.LayoutSet;
import com.liferay.portal.kernel.model.LayoutSetBranch;
import com.liferay.portal.kernel.model.LayoutType;
import com.liferay.portal.kernel.model.LayoutTypeController;
import com.liferay.portal.kernel.portlet.LiferayPortletRequest;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.portlet.LiferayWindowState;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.LayoutLocalServiceUtil;
import com.liferay.portal.kernel.service.LayoutSetBranchLocalServiceUtil;
import com.liferay.portal.kernel.service.LayoutSetLocalServiceUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextFactory;
import com.liferay.portal.kernel.service.permission.GroupPermissionUtil;
import com.liferay.portal.kernel.service.permission.LayoutPermissionUtil;
import com.liferay.portal.kernel.servlet.taglib.ui.BreadcrumbEntry;
import com.liferay.portal.kernel.theme.PortletDisplay;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.Accessor;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.LayoutDescription;
import com.liferay.portal.util.LayoutListUtil;
import com.liferay.portal.util.LayoutTypeControllerTracker;
import com.liferay.portlet.layoutsadmin.display.context.GroupDisplayContextHelper;
import com.liferay.site.navigation.model.SiteNavigationMenu;
import com.liferay.site.navigation.service.SiteNavigationMenuLocalServiceUtil;
import com.liferay.staging.StagingGroupHelper;
import com.liferay.staging.StagingGroupHelperUtil;
import com.liferay.taglib.security.PermissionsURLTag;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.ResourceBundle;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletURL;
import javax.servlet.http.HttpServletRequest;

public class LayoutsAdminDisplayContext {
    private Long _activeLayoutSetBranchId;
    private String _backURL;
    private String _displayStyle;
    private Boolean _firstColumn;
    private final GroupDisplayContextHelper _groupDisplayContextHelper;
    private final HttpServletRequest _httpServletRequest;
    private String _keywords;
    private final LayoutCopyHelper _layoutCopyHelper;
    private List<LayoutDescription> _layoutDescriptions;
    private Long _layoutId;
    private SearchContainer _layoutsSearchContainer;
    private final LiferayPortletRequest _liferayPortletRequest;
    private final LiferayPortletResponse _liferayPortletResponse;
    private String _orderByCol;
    private String _orderByType;
    private Long _parentLayoutId;
    private Boolean _privateLayout;
    private String _redirect;
    private String _rootNodeName;
    private Layout _selLayout;
    private LayoutSet _selLayoutSet;
    private Long _selPlid;
    private String _tabs1;
    private final ThemeDisplay _themeDisplay;

    public LayoutsAdminDisplayContext(LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse) {
        this._liferayPortletRequest = liferayPortletRequest;
        this._liferayPortletResponse = liferayPortletResponse;
        this._themeDisplay = (ThemeDisplay)liferayPortletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        this._httpServletRequest = PortalUtil.getHttpServletRequest((PortletRequest)this._liferayPortletRequest);
        this._groupDisplayContextHelper = new GroupDisplayContextHelper(this._httpServletRequest);
        this._layoutCopyHelper = (LayoutCopyHelper)this._liferayPortletRequest.getAttribute("LAYOUT_COPY_HELPER");
    }

    public List<DropdownItem> getAddLayoutDropdownItems() {
        return new DropdownItemList(){
            {
                if (LayoutsAdminDisplayContext.this.isShowPublicPages()) {
                    this.add(dropdownItem -> {
                        dropdownItem.setHref((Object)LayoutsAdminDisplayContext.this.getSelectLayoutPageTemplateEntryURL(false));
                        dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)LayoutsAdminDisplayContext.this._httpServletRequest, (String)"public-page"));
                    });
                }
                this.add(dropdownItem -> {
                    dropdownItem.setHref((Object)LayoutsAdminDisplayContext.this.getSelectLayoutPageTemplateEntryURL(true));
                    dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)LayoutsAdminDisplayContext.this._httpServletRequest, (String)"private-page"));
                });
            }
        };
    }

    public String getAddLayoutURL() {
        PortletURL portletURL = this._liferayPortletResponse.createActionURL();
        portletURL.setParameter("mvcPath", "/select_layout_page_template_entry.jsp");
        portletURL.setParameter("backURL", this._getBackURL());
        portletURL.setParameter("portletResource", this.getPortletResource());
        portletURL.setParameter("groupId", String.valueOf(this.getGroupId()));
        portletURL.setParameter("liveGroupId", String.valueOf(this.getLiveGroupId()));
        portletURL.setParameter("stagingGroupId", String.valueOf(this.getStagingGroupId()));
        portletURL.setParameter("parentLayoutId", String.valueOf(this.getParentLayoutId()));
        portletURL.setParameter("privateLayout", String.valueOf(this.isPrivateLayout()));
        portletURL.setParameter("explicitCreation", Boolean.TRUE.toString());
        String type = ParamUtil.getString((HttpServletRequest)this._httpServletRequest, (String)"type");
        if (Validator.isNotNull((String)type)) {
            portletURL.setParameter("type", type);
        }
        long layoutPageTemplateEntryId = ParamUtil.getLong((HttpServletRequest)this._httpServletRequest, (String)"layoutPageTemplateEntryId");
        portletURL.setParameter("layoutPageTemplateEntryId", String.valueOf(layoutPageTemplateEntryId));
        if (layoutPageTemplateEntryId > 0L) {
            portletURL.setParameter("javax.portlet.action", "/layout/add_content_layout");
        } else {
            portletURL.setParameter("javax.portlet.action", "/layout/add_simple_layout");
        }
        return portletURL.toString();
    }

    public String getAutoSiteNavigationMenuNames() {
        List siteNavigationMenus = SiteNavigationMenuLocalServiceUtil.getAutoSiteNavigationMenus((long)this._themeDisplay.getScopeGroupId());
        return ListUtil.toString((List)siteNavigationMenus, (Accessor)SiteNavigationMenu.NAME_ACCESSOR, (String)", ");
    }

    public List<SiteNavigationMenu> getAutoSiteNavigationMenus() {
        return SiteNavigationMenuLocalServiceUtil.getAutoSiteNavigationMenus((long)this._themeDisplay.getScopeGroupId());
    }

    public JSONArray getBreadcrumbEntriesJSONArray() throws PortalException {
        boolean privatePages = this.isPrivateLayout();
        Layout selLayout = this.getSelLayout();
        if (selLayout != null) {
            privatePages = selLayout.isPrivateLayout();
        }
        JSONObject breadcrumbEntryJSONObject = JSONUtil.put((String)"title", (Object)LanguageUtil.get((HttpServletRequest)this._httpServletRequest, (String)"pages"));
        PortletURL portletURL = this._liferayPortletResponse.createRenderURL();
        portletURL.setParameter("tabs1", this.getTabs1());
        portletURL.setParameter("selPlid", String.valueOf(0L));
        String displayStyle = this.getDisplayStyle();
        if (Validator.isNotNull((String)displayStyle)) {
            portletURL.setParameter("displayStyle", displayStyle);
        }
        portletURL.setParameter("firstColumn", Boolean.TRUE.toString());
        breadcrumbEntryJSONObject.put("url", portletURL.toString());
        JSONArray breadcrumbEntriesJSONArray = JSONUtil.put((Object)breadcrumbEntryJSONObject);
        if (this.isFirstColumn()) {
            return breadcrumbEntriesJSONArray;
        }
        breadcrumbEntriesJSONArray.put(this._getBreadcrumbEntryJSONObject(0L, privatePages, this.getTitle(privatePages)));
        if (this.getSelPlid() == 0L || selLayout == null) {
            return breadcrumbEntriesJSONArray;
        }
        List layouts = selLayout.getAncestors();
        Collections.reverse(layouts);
        for (Layout layout : layouts) {
            breadcrumbEntriesJSONArray.put(this._getBreadcrumbEntryJSONObject(layout.getPlid(), layout.isPrivateLayout(), layout.getName(this._themeDisplay.getLocale())));
        }
        breadcrumbEntriesJSONArray.put(this._getBreadcrumbEntryJSONObject(selLayout.getPlid(), selLayout.isPrivateLayout(), selLayout.getName(this._themeDisplay.getLocale())));
        return breadcrumbEntriesJSONArray;
    }

    public String getConfigureLayoutURL(Layout layout) {
        PortletURL configureLayoutURL = this._liferayPortletResponse.createRenderURL();
        configureLayoutURL.setParameter("mvcRenderCommandName", "/layout/edit_layout");
        configureLayoutURL.setParameter("redirect", this._themeDisplay.getURLCurrent());
        configureLayoutURL.setParameter("backURL", this._themeDisplay.getURLCurrent());
        PortletDisplay portletDisplay = this._themeDisplay.getPortletDisplay();
        configureLayoutURL.setParameter("portletResource", portletDisplay.getId());
        configureLayoutURL.setParameter("groupId", String.valueOf(layout.getGroupId()));
        configureLayoutURL.setParameter("selPlid", String.valueOf(layout.getPlid()));
        configureLayoutURL.setParameter("privateLayout", String.valueOf(layout.isPrivateLayout()));
        return configureLayoutURL.toString();
    }

    public String getCopyLayoutRenderURL(Layout layout) throws Exception {
        PortletURL copyLayoutRenderURL = this._liferayPortletResponse.createActionURL();
        copyLayoutRenderURL.setParameter("mvcRenderCommandName", "/layout/add_layout");
        copyLayoutRenderURL.setParameter("sourcePlid", String.valueOf(layout.getPlid()));
        copyLayoutRenderURL.setWindowState(LiferayWindowState.POP_UP);
        return copyLayoutRenderURL.toString();
    }

    public String getCopyLayoutURL(long sourcePlid) {
        PortletURL copyLayoutURL = this._liferayPortletResponse.createActionURL();
        copyLayoutURL.setParameter("javax.portlet.action", "/layout/copy_layout");
        copyLayoutURL.setParameter("sourcePlid", String.valueOf(sourcePlid));
        copyLayoutURL.setParameter("groupId", String.valueOf(this.getGroupId()));
        copyLayoutURL.setParameter("liveGroupId", String.valueOf(this.getLiveGroupId()));
        copyLayoutURL.setParameter("stagingGroupId", String.valueOf(this.getStagingGroupId()));
        copyLayoutURL.setParameter("privateLayout", String.valueOf(this.isPrivateLayout()));
        return copyLayoutURL.toString();
    }

    public String getDeleteLayoutURL(Layout layout) throws PortalException {
        PortletURL deleteLayoutURL = this._liferayPortletResponse.createActionURL();
        deleteLayoutURL.setParameter("javax.portlet.action", "/layout/delete_layout");
        PortletURL redirectURL = this._liferayPortletResponse.createRenderURL();
        redirectURL.setParameter("selPlid", String.valueOf(layout.getParentPlid()));
        redirectURL.setParameter("layoutSetBranchId", String.valueOf(this._getActiveLayoutSetBranchId()));
        deleteLayoutURL.setParameter("redirect", redirectURL.toString());
        deleteLayoutURL.setParameter("selPlid", String.valueOf(layout.getPlid()));
        deleteLayoutURL.setParameter("layoutSetBranchId", String.valueOf(this._getActiveLayoutSetBranchId()));
        return deleteLayoutURL.toString();
    }

    public String getDisplayStyle() {
        if (Validator.isNotNull((String)this._displayStyle)) {
            return this._displayStyle;
        }
        this._displayStyle = ParamUtil.getString((HttpServletRequest)this._httpServletRequest, (String)"displayStyle", (String)"miller-columns");
        return this._displayStyle;
    }

    public String getEditLayoutURL(Layout layout) throws Exception {
        if (!Objects.equals(layout.getType(), "content")) {
            return "";
        }
        Layout draftLayout = LayoutLocalServiceUtil.fetchLayout((long)PortalUtil.getClassNameId(Layout.class), (long)layout.getPlid());
        if (draftLayout == null) {
            ServiceContext serviceContext = ServiceContextFactory.getInstance((HttpServletRequest)this._httpServletRequest);
            draftLayout = LayoutLocalServiceUtil.addLayout((long)layout.getUserId(), (long)layout.getGroupId(), (boolean)layout.isPrivateLayout(), (long)layout.getParentLayoutId(), (long)PortalUtil.getClassNameId(Layout.class), (long)layout.getPlid(), (Map)layout.getNameMap(), (Map)layout.getTitleMap(), (Map)layout.getDescriptionMap(), (Map)layout.getKeywordsMap(), (Map)layout.getRobotsMap(), (String)layout.getType(), (String)layout.getTypeSettings(), (boolean)true, (boolean)true, Collections.emptyMap(), (ServiceContext)serviceContext);
            this._layoutCopyHelper.copyLayout(layout, draftLayout);
        }
        String layoutFullURL = PortalUtil.getLayoutFullURL((Layout)draftLayout, (ThemeDisplay)this._themeDisplay);
        layoutFullURL = HttpUtil.setParameter((String)layoutFullURL, (String)"p_l_mode", (String)"edit");
        return HttpUtil.setParameter((String)layoutFullURL, (String)"p_l_back_url", (String)this._themeDisplay.getURLCurrent());
    }

    public String getFirstColumnConfigureLayoutURL(boolean privatePages) {
        PortletURL editLayoutSetURL = this._liferayPortletResponse.createRenderURL();
        editLayoutSetURL.setParameter("mvcRenderCommandName", "/layout/edit_layout_set");
        editLayoutSetURL.setParameter("redirect", this._themeDisplay.getURLCurrent());
        editLayoutSetURL.setParameter("backURL", this._themeDisplay.getURLCurrent());
        editLayoutSetURL.setParameter("groupId", String.valueOf(this._themeDisplay.getScopeGroupId()));
        editLayoutSetURL.setParameter("privateLayout", String.valueOf(privatePages));
        return editLayoutSetURL.toString();
    }

    public SearchContainer getFirstColumnLayoutsSearchContainer() {
        if (this._layoutsSearchContainer != null) {
            return this._layoutsSearchContainer;
        }
        SearchContainer layoutsSearchContainer = new SearchContainer((PortletRequest)this._liferayPortletRequest, this.getPortletURL(), null, "");
        ArrayList<String> results = new ArrayList<String>();
        if (this.isShowPublicPages()) {
            results.add("public-pages");
        }
        results.add("private-pages");
        layoutsSearchContainer.setTotal(results.size());
        layoutsSearchContainer.setResults(results);
        this._layoutsSearchContainer = layoutsSearchContainer;
        return this._layoutsSearchContainer;
    }

    public long getFirstLayoutPageTemplateCollectionId() {
        LayoutPageTemplateCollectionNameComparator layoutPageTemplateCollectionNameComparator = new LayoutPageTemplateCollectionNameComparator(true);
        List layoutPageTemplateCollections = LayoutPageTemplateCollectionLocalServiceUtil.getLayoutPageTemplateCollections((long)this.getGroupId(), (int)-1, (int)-1, (OrderByComparator)layoutPageTemplateCollectionNameComparator);
        if (layoutPageTemplateCollections.isEmpty()) {
            return 0L;
        }
        for (LayoutPageTemplateCollection layoutPageTemplateCollection : layoutPageTemplateCollections) {
            int layoutPageTemplateEntriesCount = LayoutPageTemplateEntryServiceUtil.getLayoutPageTemplateEntriesCount((long)this._themeDisplay.getScopeGroupId(), (long)layoutPageTemplateCollection.getLayoutPageTemplateCollectionId(), (int)0);
            if (layoutPageTemplateEntriesCount <= 0) continue;
            return layoutPageTemplateCollection.getLayoutPageTemplateCollectionId();
        }
        return 0L;
    }

    public Group getGroup() {
        return this._groupDisplayContextHelper.getGroup();
    }

    public Long getGroupId() {
        return this._groupDisplayContextHelper.getGroupId();
    }

    public UnicodeProperties getGroupTypeSettings() {
        return this._groupDisplayContextHelper.getGroupTypeSettings();
    }

    public String getKeywords() {
        if (this._keywords != null) {
            return this._keywords;
        }
        this._keywords = ParamUtil.getString((HttpServletRequest)this._httpServletRequest, (String)"keywords");
        return this._keywords;
    }

    public String getLayoutChildrenURL() {
        PortletURL itemChildrenURL = this._liferayPortletResponse.createActionURL();
        itemChildrenURL.setParameter("javax.portlet.action", "/layout/get_layout_children");
        return itemChildrenURL.toString();
    }

    public JSONArray getLayoutColumnsJSONArray() throws Exception {
        JSONArray layoutColumnsJSONArray = this._getLayoutColumnsJSONArray();
        while (layoutColumnsJSONArray.length() < 3) {
            layoutColumnsJSONArray.put(JSONFactoryUtil.createJSONArray());
        }
        return layoutColumnsJSONArray;
    }

    public List<LayoutDescription> getLayoutDescriptions() {
        if (this._layoutDescriptions != null) {
            return this._layoutDescriptions;
        }
        this._layoutDescriptions = LayoutListUtil.getLayoutDescriptions((long)this.getGroupId(), (boolean)this.isPrivateLayout(), (String)this.getRootNodeName(), (Locale)this._themeDisplay.getLocale());
        return this._layoutDescriptions;
    }

    public Long getLayoutId() {
        if (this._layoutId != null) {
            return this._layoutId;
        }
        this._layoutId = 0L;
        Layout selLayout = this.getSelLayout();
        if (selLayout != null) {
            this._layoutId = selLayout.getLayoutId();
        }
        return this._layoutId;
    }

    public JSONArray getLayoutsJSONArray(long parentLayoutId, boolean privateLayout) throws Exception {
        JSONArray layoutsJSONArray = JSONFactoryUtil.createJSONArray();
        List layouts = LayoutLocalServiceUtil.getLayouts((long)this.getSelGroupId(), (boolean)privateLayout, (long)parentLayoutId, (boolean)true, (int)-1, (int)-1, null);
        for (Layout layout : layouts) {
            LayoutRevision layoutRevision;
            if (this._getActiveLayoutSetBranchId() > 0L && (layoutRevision = LayoutStagingUtil.getLayoutRevision((Layout)layout)).isIncomplete()) continue;
            JSONObject layoutJSONObject = JSONUtil.put((String)"actions", (Object)this._getAvailableActions(layout)).put("actionURLs", this._getActionURLsJSONObject(layout)).put("active", this._isActive(layout.getPlid()));
            LayoutTypeController layoutTypeController = LayoutTypeControllerTracker.getLayoutTypeController((String)layout.getType());
            ResourceBundle layoutTypeResourceBundle = ResourceBundleUtil.getBundle((String)"content.Language", (Locale)this._themeDisplay.getLocale(), layoutTypeController.getClass());
            layoutJSONObject.put("description", LanguageUtil.get((HttpServletRequest)this._httpServletRequest, (ResourceBundle)layoutTypeResourceBundle, (String)("layout.types." + layout.getType())));
            if (Objects.equals(layout.getType(), "content")) {
                Layout draftLayout = LayoutLocalServiceUtil.fetchLayout((long)PortalUtil.getClassNameId(Layout.class), (long)layout.getPlid());
                Date modifiedDate = draftLayout.getModifiedDate();
                Date publishDate = layout.getPublishDate();
                if (publishDate == null) {
                    publishDate = modifiedDate;
                }
                layoutJSONObject.put("draft", modifiedDate.getTime() > publishDate.getTime());
            } else {
                layoutJSONObject.put("draft", false);
            }
            int childLayoutsCount = LayoutLocalServiceUtil.getLayoutsCount((Group)this.getSelGroup(), (boolean)layout.isPrivateLayout(), (long)layout.getLayoutId());
            layoutJSONObject.put("hasChild", childLayoutsCount > 0);
            LayoutType layoutType = layout.getLayoutType();
            layoutJSONObject.put("parentable", layoutType.isParentable()).put("plid", layout.getPlid());
            PortletURL portletURL = this.getPortletURL();
            portletURL.setParameter("selPlid", String.valueOf(layout.getPlid()));
            portletURL.setParameter("layoutSetBranchId", String.valueOf(this._getActiveLayoutSetBranchId()));
            portletURL.setParameter("privateLayout", String.valueOf(layout.isPrivateLayout()));
            layoutJSONObject.put("title", layout.getName(this._themeDisplay.getLocale())).put("url", portletURL.toString());
            layoutsJSONArray.put(layoutJSONObject);
        }
        return layoutsJSONArray;
    }

    public SearchContainer getLayoutsSearchContainer() throws PortalException {
        if (this._layoutsSearchContainer != null) {
            return this._layoutsSearchContainer;
        }
        String emptyResultMessage = "there-are-no-public-pages";
        if (this.isPrivateLayout()) {
            emptyResultMessage = "there-are-no-private-pages";
        }
        SearchContainer layoutsSearchContainer = new SearchContainer((PortletRequest)this._liferayPortletRequest, this.getPortletURL(), null, emptyResultMessage);
        layoutsSearchContainer.setOrderByCol(this._getOrderByCol());
        String orderByType = this._getOrderByType();
        boolean orderByAsc = false;
        if (orderByType.equals("asc")) {
            orderByAsc = true;
        }
        LayoutCreateDateComparator orderByComparator = null;
        if (Objects.equals(this._getOrderByCol(), "create-date")) {
            orderByComparator = new LayoutCreateDateComparator(orderByAsc);
        }
        layoutsSearchContainer.setOrderByComparator(orderByComparator);
        layoutsSearchContainer.setOrderByType(this._getOrderByType());
        EmptyOnClickRowChecker emptyOnClickRowChecker = new EmptyOnClickRowChecker((PortletResponse)this._liferayPortletResponse);
        layoutsSearchContainer.setRowChecker((RowChecker)emptyOnClickRowChecker);
        int layoutsCount = LayoutLocalServiceUtil.getLayoutsCount((Group)this.getSelGroup(), (boolean)this.isPrivateLayout(), (String)this.getKeywords(), (String[])new String[]{"content", "embedded", "link_to_layout", "full_page_application", "panel", "portlet", "url"});
        List layouts = LayoutLocalServiceUtil.getLayouts((long)this.getSelGroupId(), (boolean)this.isPrivateLayout(), (String)this.getKeywords(), (String[])new String[]{"content", "embedded", "link_to_layout", "full_page_application", "panel", "portlet", "url"}, (int)layoutsSearchContainer.getStart(), (int)layoutsSearchContainer.getEnd(), (OrderByComparator)layoutsSearchContainer.getOrderByComparator());
        layoutsSearchContainer.setTotal(layoutsCount);
        layoutsSearchContainer.setResults(layouts);
        this._layoutsSearchContainer = layoutsSearchContainer;
        return this._layoutsSearchContainer;
    }

    public Group getLiveGroup() {
        return this._groupDisplayContextHelper.getLiveGroup();
    }

    public Long getLiveGroupId() {
        return this._groupDisplayContextHelper.getLiveGroupId();
    }

    public String getMoveLayoutColumnItemURL() {
        PortletURL deleteLayoutURL = this._liferayPortletResponse.createActionURL();
        deleteLayoutURL.setParameter("javax.portlet.action", "/layout/move_layout");
        deleteLayoutURL.setParameter("redirect", this._themeDisplay.getURLCurrent());
        return deleteLayoutURL.toString();
    }

    public List<NavigationItem> getNavigationItems() {
        final Group group = this._themeDisplay.getScopeGroup();
        final StagingGroupHelper stagingGroupHelper = StagingGroupHelperUtil.getStagingGroupHelper();
        return new NavigationItemList(){
            {
                if (!group.isCompany()) {
                    this.add(navigationItem -> {
                        navigationItem.setActive(Objects.equals(LayoutsAdminDisplayContext.this.getTabs1(), "pages"));
                        navigationItem.setHref(LayoutsAdminDisplayContext.this.getPortletURL(), new Object[]{"tabs1", "pages"});
                        navigationItem.setLabel(LanguageUtil.get((HttpServletRequest)LayoutsAdminDisplayContext.this._httpServletRequest, (String)"pages"));
                    });
                }
                if (!stagingGroupHelper.isLocalLiveGroup(group) && !stagingGroupHelper.isRemoteLiveGroup(group)) {
                    this.add(navigationItem -> {
                        navigationItem.setActive(Objects.equals(LayoutsAdminDisplayContext.this.getTabs1(), "page-templates"));
                        navigationItem.setHref(LayoutsAdminDisplayContext.this.getPortletURL(), new Object[]{"tabs1", "page-templates"});
                        navigationItem.setLabel(LanguageUtil.get((HttpServletRequest)LayoutsAdminDisplayContext.this._httpServletRequest, (String)"page-templates"));
                    });
                }
                if (!(group.isCompany() || stagingGroupHelper.isLocalLiveGroup(group) || stagingGroupHelper.isRemoteLiveGroup(group))) {
                    this.add(navigationItem -> {
                        navigationItem.setActive(Objects.equals(LayoutsAdminDisplayContext.this.getTabs1(), "display-page-templates"));
                        navigationItem.setHref(LayoutsAdminDisplayContext.this.getPortletURL(), new Object[]{"tabs1", "display-page-templates"});
                        navigationItem.setLabel(LanguageUtil.get((HttpServletRequest)LayoutsAdminDisplayContext.this._httpServletRequest, (String)"display-page-templates"));
                    });
                }
            }
        };
    }

    public String getOrphanPortletsURL(Layout layout) {
        PortletURL orphanPortletsURL = this._liferayPortletResponse.createRenderURL();
        orphanPortletsURL.setParameter("mvcPath", "/orphan_portlets.jsp");
        orphanPortletsURL.setParameter("backURL", this._themeDisplay.getURLCurrent());
        orphanPortletsURL.setParameter("selPlid", String.valueOf(layout.getPlid()));
        return orphanPortletsURL.toString();
    }

    public long getParentLayoutId() {
        if (this._parentLayoutId != null) {
            return this._parentLayoutId;
        }
        this._parentLayoutId = 0L;
        Layout layout = this.getSelLayout();
        if (layout != null) {
            this._parentLayoutId = layout.getLayoutId();
        }
        return this._parentLayoutId;
    }

    public String getPath(Layout layout, Locale locale) throws PortalException {
        List layouts = layout.getAncestors();
        StringBundler sb = new StringBundler(layouts.size() * 4);
        for (Layout curLayout : layouts) {
            sb.append(curLayout.getName(locale));
            sb.append(" ");
            sb.append(">");
            sb.append(" ");
        }
        return sb.toString();
    }

    public String getPermissionsURL(Layout layout) throws Exception {
        return PermissionsURLTag.doTag((String)"", (String)Layout.class.getName(), (String)HtmlUtil.escape((String)layout.getName(this._themeDisplay.getLocale())), null, (String)String.valueOf(layout.getPlid()), (String)LiferayWindowState.POP_UP.toString(), null, (HttpServletRequest)this._themeDisplay.getRequest());
    }

    public List<BreadcrumbEntry> getPortletBreadcrumbEntries() throws PortalException {
        ArrayList<BreadcrumbEntry> breadcrumbEntries = new ArrayList<BreadcrumbEntry>();
        JSONArray breadcrumbEntriesJSONArray = this.getBreadcrumbEntriesJSONArray();
        for (int i = 0; i < breadcrumbEntriesJSONArray.length(); ++i) {
            JSONObject breadcrumbEntryJSONObject = breadcrumbEntriesJSONArray.getJSONObject(i);
            BreadcrumbEntry breadcrumbEntry = new BreadcrumbEntry();
            breadcrumbEntry.setTitle(breadcrumbEntryJSONObject.getString("title"));
            breadcrumbEntry.setURL(breadcrumbEntryJSONObject.getString("url"));
            breadcrumbEntries.add(breadcrumbEntry);
        }
        return breadcrumbEntries;
    }

    public String getPortletResource() {
        String portletResource = ParamUtil.getString((HttpServletRequest)this._httpServletRequest, (String)"portletResource");
        if (Validator.isNull((String)portletResource)) {
            PortletDisplay portletDisplay = this._themeDisplay.getPortletDisplay();
            portletResource = portletDisplay.getPortletName();
        }
        return portletResource;
    }

    public PortletURL getPortletURL() {
        PortletURL portletURL = this._liferayPortletResponse.createRenderURL();
        portletURL.setParameter("tabs1", this.getTabs1());
        portletURL.setParameter("privateLayout", String.valueOf(this.isPrivateLayout()));
        String displayStyle = this.getDisplayStyle();
        if (Validator.isNotNull((String)displayStyle)) {
            portletURL.setParameter("displayStyle", displayStyle);
        }
        return portletURL;
    }

    public String getRedirect() {
        if (this._redirect != null) {
            return this._redirect;
        }
        this._redirect = ParamUtil.getString((PortletRequest)this._liferayPortletRequest, (String)"redirect", (String)this._themeDisplay.getURLCurrent());
        return this._redirect;
    }

    public PortletURL getRedirectURL() {
        PortletURL portletURL = this._liferayPortletResponse.createRenderURL();
        portletURL.setParameter("redirect", this.getRedirect());
        portletURL.setParameter("groupId", String.valueOf(this.getSelGroupId()));
        return portletURL;
    }

    public List<BreadcrumbEntry> getRelativeBreadcrumbEntries(Layout layout) throws PortalException {
        ArrayList<BreadcrumbEntry> breadcrumbEntries = new ArrayList<BreadcrumbEntry>();
        List curLayouts = layout.getAncestors();
        Collections.reverse(curLayouts);
        boolean showLayoutPath = false;
        if (this.getSelPlid() <= 0L) {
            showLayoutPath = true;
        }
        for (Layout curLayout : curLayouts) {
            if (showLayoutPath) {
                BreadcrumbEntry breadcrumbEntry = new BreadcrumbEntry();
                breadcrumbEntry.setTitle(curLayout.getName(this._themeDisplay.getLocale()));
                breadcrumbEntries.add(breadcrumbEntry);
            }
            if (curLayout.getPlid() != this.getSelPlid().longValue()) continue;
            showLayoutPath = true;
        }
        BreadcrumbEntry breadcrumbEntry = new BreadcrumbEntry();
        breadcrumbEntry.setTitle(layout.getName(this._themeDisplay.getLocale()));
        breadcrumbEntries.add(breadcrumbEntry);
        return breadcrumbEntries;
    }

    public String getRootNodeName() {
        if (this._rootNodeName != null) {
            return this._rootNodeName;
        }
        this._rootNodeName = this.getRootNodeName(this.isPrivateLayout());
        return this._rootNodeName;
    }

    public String getRootNodeName(boolean privateLayout) {
        Group liveGroup = this.getLiveGroup();
        return liveGroup.getLayoutRootNodeName(privateLayout, this._themeDisplay.getLocale());
    }

    public String getSelectLayoutPageTemplateEntryURL(boolean privateLayout) throws PortalException {
        return this.getSelectLayoutPageTemplateEntryURL(this.getFirstLayoutPageTemplateCollectionId(), privateLayout);
    }

    public String getSelectLayoutPageTemplateEntryURL(long layoutPageTemplateCollectionId, boolean privateLayout) {
        return this.getSelectLayoutPageTemplateEntryURL(layoutPageTemplateCollectionId, 0L, privateLayout);
    }

    public String getSelectLayoutPageTemplateEntryURL(long layoutPageTemplateCollectionId, long selPlid, boolean privateLayout) {
        return this.getSelectLayoutPageTemplateEntryURL(layoutPageTemplateCollectionId, selPlid, "basic-pages", privateLayout);
    }

    public String getSelectLayoutPageTemplateEntryURL(long layoutPageTemplateCollectionId, long selPlid, String selectedTab, boolean privateLayout) {
        PortletURL selectLayoutPageTemplateEntryURL = this._liferayPortletResponse.createRenderURL();
        selectLayoutPageTemplateEntryURL.setParameter("mvcPath", "/select_layout_page_template_entry.jsp");
        selectLayoutPageTemplateEntryURL.setParameter("redirect", this.getRedirect());
        selectLayoutPageTemplateEntryURL.setParameter("backURL", this._themeDisplay.getURLCurrent());
        selectLayoutPageTemplateEntryURL.setParameter("groupId", String.valueOf(this.getSelGroupId()));
        selectLayoutPageTemplateEntryURL.setParameter("selPlid", String.valueOf(selPlid));
        selectLayoutPageTemplateEntryURL.setParameter("privateLayout", String.valueOf(privateLayout));
        if (layoutPageTemplateCollectionId > 0L) {
            selectLayoutPageTemplateEntryURL.setParameter("layoutPageTemplateCollectionId", String.valueOf(layoutPageTemplateCollectionId));
        } else if (Validator.isNotNull((String)selectedTab)) {
            selectLayoutPageTemplateEntryURL.setParameter("selectedTab", selectedTab);
        }
        return selectLayoutPageTemplateEntryURL.toString();
    }

    public Group getSelGroup() {
        return this._groupDisplayContextHelper.getSelGroup();
    }

    public long getSelGroupId() {
        Group selGroup = this.getSelGroup();
        if (selGroup != null) {
            return selGroup.getGroupId();
        }
        return 0L;
    }

    public Layout getSelLayout() {
        if (this._selLayout != null) {
            return this._selLayout;
        }
        if (this.getSelPlid() != 0L) {
            this._selLayout = LayoutLocalServiceUtil.fetchLayout((long)this.getSelPlid());
        }
        return this._selLayout;
    }

    public LayoutSet getSelLayoutSet() throws PortalException {
        if (this._selLayoutSet != null) {
            return this._selLayoutSet;
        }
        Group group = this.getStagingGroup();
        if (group == null) {
            group = this.getLiveGroup();
        }
        this._selLayoutSet = LayoutSetLocalServiceUtil.getLayoutSet((long)group.getGroupId(), (boolean)this.isPrivateLayout());
        return this._selLayoutSet;
    }

    public Long getSelPlid() {
        if (this._selPlid != null) {
            return this._selPlid;
        }
        this._selPlid = ParamUtil.getLong((PortletRequest)this._liferayPortletRequest, (String)"selPlid", (long)0L);
        return this._selPlid;
    }

    public Group getStagingGroup() {
        return this._groupDisplayContextHelper.getStagingGroup();
    }

    public Long getStagingGroupId() {
        return this._groupDisplayContextHelper.getStagingGroupId();
    }

    public String getTabs1() {
        if (this._tabs1 != null) {
            return this._tabs1;
        }
        Group group = this.getGroup();
        this._tabs1 = ParamUtil.getString((PortletRequest)this._liferayPortletRequest, (String)"tabs1", (String)(group.isCompany() ? "page-templates" : "pages"));
        return this._tabs1;
    }

    public String getTitle(boolean privatePages) {
        String title = "pages";
        if (this.isShowPublicPages()) {
            title = privatePages ? "private-pages" : "public-pages";
        }
        return LanguageUtil.get((HttpServletRequest)this._httpServletRequest, (String)title);
    }

    public int getTotalItems() throws Exception {
        return LayoutLocalServiceUtil.getLayoutsCount((Group)this.getSelGroup(), (boolean)this.isPrivateLayout());
    }

    public String getViewLayoutURL(Layout layout) throws PortalException {
        String layoutFullURL = PortalUtil.getLayoutFullURL((Layout)layout, (ThemeDisplay)this._themeDisplay);
        layoutFullURL = HttpUtil.setParameter((String)layoutFullURL, (String)"p_l_back_url", (String)this._themeDisplay.getURLCurrent());
        return layoutFullURL;
    }

    public boolean hasLayouts() {
        int publicPagesCount;
        int privatePagesCount = LayoutLocalServiceUtil.getLayoutsCount((Group)this.getSelGroup(), (boolean)true, (long)0L);
        return privatePagesCount + (publicPagesCount = LayoutLocalServiceUtil.getLayoutsCount((Group)this.getSelGroup(), (boolean)false, (long)0L)) > 0;
    }

    public boolean isDraft() {
        Layout layout = this.getSelLayout();
        return layout.isSystem() && layout.getClassPK() > 0L && layout.getClassNameId() == PortalUtil.getClassNameId(Layout.class);
    }

    public boolean isFirstColumn() {
        if (this._firstColumn != null) {
            return this._firstColumn;
        }
        this._firstColumn = ParamUtil.getBoolean((HttpServletRequest)this._httpServletRequest, (String)"firstColumn", (boolean)false);
        return this._firstColumn;
    }

    public boolean isLayoutPageTemplateEntry() {
        Layout layout = this.getSelLayout();
        LayoutPageTemplateEntry layoutPageTemplateEntry = LayoutPageTemplateEntryLocalServiceUtil.fetchLayoutPageTemplateEntryByPlid((long)layout.getClassPK());
        return StringUtil.equals((String)layout.getType(), (String)"asset_display") || layoutPageTemplateEntry != null && layout.isSystem();
    }

    public boolean isPagesTab() {
        return Objects.equals(this.getTabs1(), "pages");
    }

    public boolean isPrivateLayout() {
        if (this._privateLayout != null) {
            return this._privateLayout;
        }
        Group selGroup = this.getSelGroup();
        if (selGroup.isLayoutSetPrototype()) {
            this._privateLayout = true;
            return this._privateLayout;
        }
        Layout selLayout = this.getSelLayout();
        if (this.getSelLayout() != null) {
            this._privateLayout = selLayout.isPrivateLayout();
            return this._privateLayout;
        }
        Layout layout = this._themeDisplay.getLayout();
        if (!layout.isTypeControlPanel()) {
            this._privateLayout = layout.isPrivateLayout();
            return this._privateLayout;
        }
        this._privateLayout = ParamUtil.getBoolean((PortletRequest)this._liferayPortletRequest, (String)"privateLayout");
        return this._privateLayout;
    }

    public boolean isSearch() {
        return Validator.isNotNull((String)this.getKeywords());
    }

    public boolean isShowAddChildPageAction(Layout layout) throws PortalException {
        return LayoutPermissionUtil.contains((PermissionChecker)this._themeDisplay.getPermissionChecker(), (Layout)layout, (String)"ADD_LAYOUT");
    }

    public boolean isShowAddRootLayoutButton() throws PortalException {
        return GroupPermissionUtil.contains((PermissionChecker)this._themeDisplay.getPermissionChecker(), (Group)this.getSelGroup(), (String)"ADD_LAYOUT");
    }

    public boolean isShowConfigureAction(Layout layout) throws PortalException {
        return LayoutPermissionUtil.contains((PermissionChecker)this._themeDisplay.getPermissionChecker(), (Layout)layout, (String)"UPDATE");
    }

    public boolean isShowCopyLayoutAction(Layout layout) throws PortalException {
        if (!this.isShowAddRootLayoutButton()) {
            return false;
        }
        return layout.isTypePortlet();
    }

    public boolean isShowDeleteAction(Layout layout) throws PortalException {
        if (StagingUtil.isIncomplete((Layout)layout)) {
            return false;
        }
        if (!LayoutPermissionUtil.contains((PermissionChecker)this._themeDisplay.getPermissionChecker(), (Layout)layout, (String)"DELETE")) {
            return false;
        }
        Group group = layout.getGroup();
        int layoutsCount = LayoutLocalServiceUtil.getLayoutsCount((Group)group, (boolean)false, (long)0L);
        return !group.isGuest() || layout.isPrivateLayout() || !layout.isRootLayout() || layoutsCount != 1;
    }

    public boolean isShowFirstColumnConfigureAction() throws PortalException {
        return GroupPermissionUtil.contains((PermissionChecker)this._themeDisplay.getPermissionChecker(), (long)this.getSelGroupId(), (String)"MANAGE_LAYOUTS");
    }

    public boolean isShowOrphanPortletsAction(Layout layout) throws PortalException {
        if (StagingUtil.isIncomplete((Layout)layout)) {
            return false;
        }
        if (!layout.isSupportsEmbeddedPortlets()) {
            return false;
        }
        if (!this.isShowAddRootLayoutButton()) {
            return false;
        }
        OrphanPortletsDisplayContext orphanPortletsDisplayContext = new OrphanPortletsDisplayContext(this._httpServletRequest, this._liferayPortletRequest, this._liferayPortletResponse);
        return !ListUtil.isEmpty(orphanPortletsDisplayContext.getOrphanPortlets(layout));
    }

    public boolean isShowPermissionsAction(Layout layout) throws PortalException {
        if (StagingUtil.isIncomplete((Layout)layout)) {
            return false;
        }
        Group selGroup = this.getSelGroup();
        if (selGroup.isLayoutPrototype()) {
            return false;
        }
        return LayoutPermissionUtil.contains((PermissionChecker)this._themeDisplay.getPermissionChecker(), (Layout)layout, (String)"PERMISSIONS");
    }

    public boolean isShowPublicPages() {
        Group selGroup = this.getSelGroup();
        return !selGroup.isLayoutSetPrototype() && !selGroup.isLayoutPrototype();
    }

    private JSONObject _getActionURLsJSONObject(Layout layout) throws Exception {
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
        if (this.isShowAddChildPageAction(layout)) {
            jsonObject.put("addURL", this.getSelectLayoutPageTemplateEntryURL(this.getFirstLayoutPageTemplateCollectionId(), layout.getPlid(), layout.isPrivateLayout()));
        }
        if (this.isShowConfigureAction(layout)) {
            jsonObject.put("configureURL", this.getConfigureLayoutURL(layout));
        }
        if (this.isShowCopyLayoutAction(layout)) {
            jsonObject.put("copyLayoutURL", this.getCopyLayoutRenderURL(layout));
        }
        if (this.isShowDeleteAction(layout)) {
            jsonObject.put("deleteURL", this.getDeleteLayoutURL(layout));
        }
        if (this.isShowConfigureAction(layout)) {
            jsonObject.put("editLayoutURL", this.getEditLayoutURL(layout));
        }
        if (this.isShowOrphanPortletsAction(layout)) {
            jsonObject.put("orphanPortletsURL", this.getOrphanPortletsURL(layout));
        }
        if (this.isShowPermissionsAction(layout)) {
            jsonObject.put("permissionsURL", this.getPermissionsURL(layout));
        }
        jsonObject.put("viewLayoutURL", this.getViewLayoutURL(layout));
        return jsonObject;
    }

    private long _getActiveLayoutSetBranchId() throws PortalException {
        LayoutRevision layoutRevision;
        if (this._activeLayoutSetBranchId != null) {
            return this._activeLayoutSetBranchId;
        }
        this._activeLayoutSetBranchId = ParamUtil.getLong((HttpServletRequest)this._httpServletRequest, (String)"layoutSetBranchId");
        Layout layout = this.getSelLayout();
        if (layout != null && (layoutRevision = LayoutStagingUtil.getLayoutRevision((Layout)layout)) != null) {
            this._activeLayoutSetBranchId = layoutRevision.getLayoutSetBranchId();
        }
        List layoutSetBranches = LayoutSetBranchLocalServiceUtil.getLayoutSetBranches((long)this._themeDisplay.getScopeGroupId(), (boolean)this.isPrivateLayout());
        if (this._activeLayoutSetBranchId == 0L && !layoutSetBranches.isEmpty()) {
            LayoutSetBranch currentUserLayoutSetBranch = LayoutSetBranchLocalServiceUtil.getUserLayoutSetBranch((long)this._themeDisplay.getUserId(), (long)this._themeDisplay.getScopeGroupId(), (boolean)this.isPrivateLayout(), (long)0L, (long)0L);
            this._activeLayoutSetBranchId = currentUserLayoutSetBranch.getLayoutSetBranchId();
        }
        if (this._activeLayoutSetBranchId == 0L && !layoutSetBranches.isEmpty()) {
            LayoutSetBranch layoutSetBranch = LayoutSetBranchLocalServiceUtil.getMasterLayoutSetBranch((long)this._themeDisplay.getScopeGroupId(), (boolean)this.isPrivateLayout());
            this._activeLayoutSetBranchId = layoutSetBranch.getLayoutSetBranchId();
        }
        return this._activeLayoutSetBranchId;
    }

    private String _getAvailableActions(Layout layout) throws PortalException {
        ThemeDisplay themeDisplay = (ThemeDisplay)this._httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        if (LayoutPermissionUtil.contains((PermissionChecker)themeDisplay.getPermissionChecker(), (Layout)layout, (String)"DELETE")) {
            return "deleteSelectedPages";
        }
        return "";
    }

    private String _getBackURL() {
        if (this._backURL != null) {
            return this._backURL;
        }
        this._backURL = ParamUtil.getString((PortletRequest)this._liferayPortletRequest, (String)"backURL");
        return this._backURL;
    }

    private JSONObject _getBreadcrumbEntryJSONObject(long plid, boolean privateLayout, String title) {
        JSONObject breadcrumbEntryJSONObject = JSONUtil.put((String)"title", (Object)title);
        PortletURL portletURL = this.getPortletURL();
        portletURL.setParameter("selPlid", String.valueOf(plid));
        portletURL.setParameter("privateLayout", String.valueOf(privateLayout));
        breadcrumbEntryJSONObject.put("url", portletURL.toString());
        return breadcrumbEntryJSONObject;
    }

    private JSONObject _getFirstColumn(boolean privatePages, boolean active) throws PortalException {
        JSONObject pagesJSONObject = JSONUtil.put((String)"actionURLs", (Object)this._getFirstColumnActionURLsJSONObject(privatePages)).put("active", active).put("hasChild", true).put("plid", 0L).put("title", this.getTitle(privatePages));
        PortletURL pagesURL = this.getPortletURL();
        pagesURL.setParameter("selPlid", String.valueOf(0L));
        pagesURL.setParameter("privateLayout", String.valueOf(privatePages));
        pagesJSONObject.put("url", pagesURL.toString());
        return pagesJSONObject;
    }

    private JSONObject _getFirstColumnActionURLsJSONObject(boolean privatePages) throws PortalException {
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
        if (this.isShowFirstColumnConfigureAction()) {
            jsonObject.put("configureURL", this.getFirstColumnConfigureLayoutURL(privatePages));
        }
        if (this.isShowAddRootLayoutButton()) {
            jsonObject.put("addURL", this.getSelectLayoutPageTemplateEntryURL(privatePages));
        }
        return jsonObject;
    }

    private JSONArray _getLayoutColumnsJSONArray() throws Exception {
        boolean active;
        JSONArray firstColumnJSONArray = JSONFactoryUtil.createJSONArray();
        Layout selLayout = this.getSelLayout();
        if (LayoutLocalServiceUtil.hasLayouts((Group)this.getSelGroup(), (boolean)false) && this.isShowPublicPages()) {
            boolean bl = active = !this.isPrivateLayout();
            if (selLayout != null) {
                active = selLayout.isPublicLayout();
            }
            if (this.isFirstColumn()) {
                active = false;
            }
            firstColumnJSONArray.put(this._getFirstColumn(false, active));
        }
        if (LayoutLocalServiceUtil.hasLayouts((Group)this.getSelGroup(), (boolean)true)) {
            active = this.isPrivateLayout();
            if (selLayout != null) {
                active = selLayout.isPrivateLayout();
            }
            if (this.isFirstColumn()) {
                active = false;
            }
            firstColumnJSONArray.put(this._getFirstColumn(true, active));
        }
        JSONArray layoutColumnsJSONArray = JSONUtil.put((Object)firstColumnJSONArray);
        if (this.isFirstColumn()) {
            return layoutColumnsJSONArray;
        }
        JSONArray layoutSetBranchesJSONArray = this._getLayoutSetBranchesJSONArray();
        if (layoutSetBranchesJSONArray.length() > 0) {
            layoutColumnsJSONArray.put(layoutSetBranchesJSONArray);
        }
        if (selLayout == null) {
            layoutColumnsJSONArray.put(this.getLayoutsJSONArray(0L, this.isPrivateLayout()));
            return layoutColumnsJSONArray;
        }
        List layouts = ListUtil.copy((List)selLayout.getAncestors());
        Collections.reverse(layouts);
        layouts.add(selLayout);
        for (Layout layout : layouts) {
            layoutColumnsJSONArray.put(this.getLayoutsJSONArray(layout.getParentLayoutId(), selLayout.isPrivateLayout()));
        }
        layoutColumnsJSONArray.put(this.getLayoutsJSONArray(selLayout.getLayoutId(), selLayout.isPrivateLayout()));
        return layoutColumnsJSONArray;
    }

    private JSONArray _getLayoutSetBranchesJSONArray() throws PortalException {
        JSONArray jsonArray = JSONFactoryUtil.createJSONArray();
        List layoutSetBranches = LayoutSetBranchLocalServiceUtil.getLayoutSetBranches((long)this._themeDisplay.getScopeGroupId(), (boolean)this.isPrivateLayout());
        for (LayoutSetBranch layoutSetBranch : layoutSetBranches) {
            JSONObject jsonObject = JSONUtil.put((String)"active", (Object)(layoutSetBranch.getLayoutSetBranchId() == this._getActiveLayoutSetBranchId() ? 1 : 0)).put("hasChild", true).put("plid", 0L).put("title", LanguageUtil.get((HttpServletRequest)this._httpServletRequest, (String)layoutSetBranch.getName()));
            PortletURL portletURL = this.getPortletURL();
            portletURL.setParameter("layoutSetBranchId", String.valueOf(layoutSetBranch.getLayoutSetBranchId()));
            portletURL.setParameter("privateLayout", String.valueOf(layoutSetBranch.isPrivateLayout()));
            jsonObject.put("url", portletURL.toString());
            jsonArray.put(jsonObject);
        }
        return jsonArray;
    }

    private String _getOrderByCol() {
        if (Validator.isNotNull((String)this._orderByCol)) {
            return this._orderByCol;
        }
        this._orderByCol = ParamUtil.getString((PortletRequest)this._liferayPortletRequest, (String)"orderByCol", (String)"path");
        if (this.isSearch()) {
            this._orderByCol = "create-date";
        }
        return this._orderByCol;
    }

    private String _getOrderByType() {
        if (Validator.isNotNull((String)this._orderByType)) {
            return this._orderByType;
        }
        this._orderByType = ParamUtil.getString((PortletRequest)this._liferayPortletRequest, (String)"orderByType", (String)"asc");
        return this._orderByType;
    }

    private boolean _isActive(long plid) throws PortalException {
        if (plid == this.getSelPlid()) {
            return true;
        }
        Layout selLayout = this.getSelLayout();
        if (selLayout == null) {
            return false;
        }
        for (Layout layout : selLayout.getAncestors()) {
            if (plid != layout.getPlid()) continue;
            return true;
        }
        return false;
    }
}

