/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.admin.web.internal.display.context;

import com.liferay.frontend.taglib.clay.servlet.taglib.display.context.SearchContainerManagementToolbarDisplayContext;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.CreationMenu;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.DropdownItem;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.DropdownItemList;
import com.liferay.layout.admin.web.internal.display.context.DisplayPageDisplayContext;
import com.liferay.layout.admin.web.internal.security.permission.resource.LayoutPageTemplateEntryPermission;
import com.liferay.layout.admin.web.internal.security.permission.resource.LayoutPageTemplatePermission;
import com.liferay.layout.page.template.model.LayoutPageTemplateEntry;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.portlet.LiferayPortletRequest;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import java.util.List;
import javax.portlet.PortletURL;
import javax.servlet.http.HttpServletRequest;

public class DisplayPageManagementToolbarDisplayContext
extends SearchContainerManagementToolbarDisplayContext {
    private final ThemeDisplay _themeDisplay;

    public DisplayPageManagementToolbarDisplayContext(LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse, HttpServletRequest httpServletRequest, DisplayPageDisplayContext displayPageDisplayContext) {
        super(liferayPortletRequest, liferayPortletResponse, httpServletRequest, displayPageDisplayContext.getDisplayPagesSearchContainer());
        this._themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
    }

    public List<DropdownItem> getActionDropdownItems() {
        return new DropdownItemList(){
            {
                this.add(dropdownItem -> {
                    dropdownItem.putData("action", "deleteSelectedDisplayPages");
                    dropdownItem.setIcon("times-circle");
                    dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)DisplayPageManagementToolbarDisplayContext.this.request, (String)"delete"));
                    dropdownItem.setQuickAction(true);
                });
            }
        };
    }

    public String getAvailableActions(LayoutPageTemplateEntry layoutPageTemplateEntry) throws PortalException {
        if (LayoutPageTemplateEntryPermission.contains(this._themeDisplay.getPermissionChecker(), layoutPageTemplateEntry, "DELETE")) {
            return "deleteSelectedDisplayPages";
        }
        return "";
    }

    public String getClearResultsURL() {
        PortletURL clearResultsURL = this.getPortletURL();
        clearResultsURL.setParameter("keywords", "");
        return clearResultsURL.toString();
    }

    public String getComponentId() {
        return "displayPagesManagementToolbar";
    }

    public CreationMenu getCreationMenu() {
        final PortletURL addDisplayPageURL = this.liferayPortletResponse.createActionURL();
        addDisplayPageURL.setParameter("javax.portlet.action", "/layout/add_layout_page_template_entry");
        addDisplayPageURL.setParameter("mvcRenderCommandName", "/layout/edit_layout_page_template_entry");
        addDisplayPageURL.setParameter("backURL", this._themeDisplay.getURLCurrent());
        addDisplayPageURL.setParameter("type", String.valueOf(1));
        return new CreationMenu(){
            {
                this.addDropdownItem(dropdownItem -> {
                    dropdownItem.putData("action", "addDisplayPage");
                    dropdownItem.putData("addDisplayPageURL", addDisplayPageURL.toString());
                    dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)DisplayPageManagementToolbarDisplayContext.this.request, (String)"add"));
                });
            }
        };
    }

    public String getDefaultEventHandler() {
        return "DISPLAY_PAGE_MANAGEMENT_TOOLBAR_DEFAULT_EVENT_HANDLER";
    }

    public String getSearchActionURL() {
        PortletURL searchActionURL = this.getPortletURL();
        return searchActionURL.toString();
    }

    public String getSearchContainerId() {
        return "displayPages";
    }

    public Boolean isShowCreationMenu() {
        if (LayoutPageTemplatePermission.contains(this._themeDisplay.getPermissionChecker(), this._themeDisplay.getSiteGroupId(), "ADD_LAYOUT_PAGE_TEMPLATE_ENTRY")) {
            return true;
        }
        return false;
    }

    protected String[] getNavigationKeys() {
        return new String[]{"all"};
    }

    protected String[] getOrderByKeys() {
        return new String[]{"create-date", "name"};
    }
}

