/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.admin.web.internal.asset.model;

import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.model.AssetRenderer;
import com.liferay.asset.kernel.model.AssetRendererFactory;
import com.liferay.asset.kernel.model.BaseAssetRendererFactory;
import com.liferay.asset.kernel.service.AssetEntryLocalService;
import com.liferay.layout.admin.web.internal.asset.model.LayoutRevisionAssetRenderer;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.LayoutRevision;
import com.liferay.portal.kernel.model.LayoutSetBranch;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.LayoutRevisionLocalService;
import com.liferay.portal.kernel.service.LayoutSetBranchLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.Portal;
import javax.servlet.ServletContext;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"javax.portlet.name=com_liferay_layout_admin_web_portlet_GroupPagesPortlet"}, service={AssetRendererFactory.class})
public class LayoutRevisionAssetRendererFactory
extends BaseAssetRendererFactory<LayoutRevision> {
    public static final String TYPE = "layout_revision";
    private AssetEntryLocalService _assetEntryLocalService;
    private LayoutRevisionLocalService _layoutRevisionLocalService;
    private LayoutSetBranchLocalService _layoutSetBranchLocalService;
    @Reference
    private Portal _portal;
    private ServletContext _servletContext;
    private UserLocalService _userLocalService;

    public LayoutRevisionAssetRendererFactory() {
        this.setClassName(LayoutRevision.class.getName());
        this.setCategorizable(false);
        this.setPortletId("com_liferay_layout_admin_web_portlet_GroupPagesPortlet");
        this.setSelectable(false);
    }

    public AssetEntry getAssetEntry(long assetEntryId) throws PortalException {
        return this.getAssetEntry(this.getClassName(), assetEntryId);
    }

    public AssetEntry getAssetEntry(String className, long classPK) throws PortalException {
        LayoutRevision layoutRevision = this._layoutRevisionLocalService.getLayoutRevision(classPK);
        LayoutSetBranch layoutSetBranch = this._layoutSetBranchLocalService.getLayoutSetBranch(layoutRevision.getLayoutSetBranchId());
        User user = this._userLocalService.getUserById(layoutRevision.getUserId());
        AssetEntry assetEntry = this._assetEntryLocalService.createAssetEntry(classPK);
        assetEntry.setGroupId(layoutRevision.getGroupId());
        assetEntry.setCompanyId(user.getCompanyId());
        assetEntry.setUserId(user.getUserId());
        assetEntry.setUserName(user.getFullName());
        assetEntry.setCreateDate(layoutRevision.getCreateDate());
        assetEntry.setClassNameId(this._portal.getClassNameId(LayoutRevision.class.getName()));
        assetEntry.setClassPK(layoutRevision.getLayoutRevisionId());
        StringBundler sb = new StringBundler(4);
        sb.append(layoutRevision.getHTMLTitle(LocaleUtil.getSiteDefault()));
        sb.append(" [");
        sb.append(layoutSetBranch.getName());
        sb.append("]");
        assetEntry.setTitle(sb.toString());
        return assetEntry;
    }

    public AssetRenderer<LayoutRevision> getAssetRenderer(long layoutRevisionId, int type) throws PortalException {
        LayoutRevision layoutRevision = this._layoutRevisionLocalService.getLayoutRevision(layoutRevisionId);
        LayoutRevisionAssetRenderer layoutRevisionAssetRenderer = new LayoutRevisionAssetRenderer(layoutRevision);
        layoutRevisionAssetRenderer.setAssetRendererType(type);
        layoutRevisionAssetRenderer.setServletContext(this._servletContext);
        return layoutRevisionAssetRenderer;
    }

    public String getClassName() {
        return LayoutRevision.class.getName();
    }

    public String getIconCssClass() {
        return "edit-layout";
    }

    public String getType() {
        return TYPE;
    }

    @Reference(target="(osgi.web.symbolicname=com.liferay.layout.admin.web)", unbind="-")
    public void setServletContext(ServletContext servletContext) {
        this._servletContext = servletContext;
    }

    @Reference(unbind="-")
    protected void setAssetEntryLocalService(AssetEntryLocalService assetEntryLocalService) {
        this._assetEntryLocalService = assetEntryLocalService;
    }

    @Reference(unbind="-")
    protected void setLayoutRevisionLocalService(LayoutRevisionLocalService layoutRevisionLocalService) {
        this._layoutRevisionLocalService = layoutRevisionLocalService;
    }

    @Reference(unbind="-")
    protected void setLayoutSetBranchLocalService(LayoutSetBranchLocalService layoutSetBranchLocalService) {
        this._layoutSetBranchLocalService = layoutSetBranchLocalService;
    }

    @Reference(unbind="-")
    protected void setUserLocalService(UserLocalService userLocalService) {
        this._userLocalService = userLocalService;
    }
}

