Liferay.Loader.define("layout-admin-web@3.0.159/js/miller_columns/utils/LayoutUpdateUtils.es", ['module', 'exports', 'require', '../../utils/utils.es', './LayoutDragDrop.es', './LayoutGetUtils.es'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.appendItemToColumn = appendItemToColumn;
  exports.clearFollowingColumns = clearFollowingColumns;
  exports.clearPath = clearPath;
  exports.deleteEmptyColumns = deleteEmptyColumns;
  exports.moveItemInside = moveItemInside;
  exports.removeItem = removeItem;
  exports.setActiveItem = setActiveItem;

  var _utils = require("../../utils/utils.es");

  var _LayoutDragDrop = require("./LayoutDragDrop.es");

  var _LayoutGetUtils = require("./LayoutGetUtils.es");

  function _toConsumableArray(arr) {
    return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _nonIterableSpread();
  }

  function _nonIterableSpread() {
    throw new TypeError("Invalid attempt to spread non-iterable instance");
  }

  function _iterableToArray(iter) {
    if (Symbol.iterator in Object(iter) || Object.prototype.toString.call(iter) === "[object Arguments]") return Array.from(iter);
  }

  function _arrayWithoutHoles(arr) {
    if (Array.isArray(arr)) {
      for (var i = 0, arr2 = new Array(arr.length); i < arr.length; i++) {
        arr2[i] = arr[i];
      }return arr2;
    }
  }

  /**
   * Append an item to a column and returns a new array of columns
   * @param {object} sourceItem
   * @param {object[]} layoutColumns
   * @param {number} targetColumnIndex
   * @return {object[]}
   * @review
   */
  function appendItemToColumn(sourceItem, layoutColumns, targetColumnIndex) {
    var nextLayoutColumns = layoutColumns;

    if (sourceItem) {
      nextLayoutColumns = removeItem(sourceItem.plid, nextLayoutColumns);

      var nextTargetColumn = _toConsumableArray(nextLayoutColumns[targetColumnIndex]);

      nextTargetColumn.splice(nextTargetColumn.length, 0, sourceItem);
      nextLayoutColumns[targetColumnIndex] = nextTargetColumn;
    }

    return nextLayoutColumns;
  }
  /**
   * Removes following columns starting at position indicated
   * by startColumnIndex and returns a new array of columns
   * @param {object} layoutColumns
   * @param {number} startColumnIndex
   * @return {object}
   * @review
   */

  function clearFollowingColumns(layoutColumns, startColumnIndex) {
    var nextLayoutColumns = layoutColumns.map(function (layoutColumn) {
      return _toConsumableArray(layoutColumn);
    });

    for (var i = startColumnIndex + 1; i < nextLayoutColumns.length; i++) {
      nextLayoutColumns[i] = [];
    }

    return nextLayoutColumns;
  }
  /**
   * Clears path if an active item is moved to another column
   * @param {object} layoutColumns
   * @param {object} sourceItem
   * @param {number} sourceItemColumnIndex
   * @param {string} targetItemPlid
   * @return {object}
   * @review
   */

  function clearPath(layoutColumns, sourceItem, sourceItemColumnIndex, targetId, targetType) {
    var nextLayoutColumns = layoutColumns.map(function (layoutColumn) {
      return _toConsumableArray(layoutColumn);
    });
    var targetColumnIndex = targetId;

    if (targetType === _LayoutDragDrop.DROP_TARGET_ITEM_TYPES.item) {
      targetColumnIndex = (0, _LayoutGetUtils.getItemColumnIndex)(nextLayoutColumns, targetId);
    }

    if (sourceItem && sourceItem.active && sourceItemColumnIndex !== targetColumnIndex) {
      sourceItem.active = false;
      nextLayoutColumns = clearFollowingColumns(nextLayoutColumns, sourceItemColumnIndex);
      nextLayoutColumns = deleteEmptyColumns(nextLayoutColumns);
    }

    return nextLayoutColumns;
  }
  /**
   * Removes extra empty columns when there are more than three and returns
   * a new Array with the columns removed.
   * @param {object} layoutColumns
   * @private
   * @return {object}
   * @review
   */

  function deleteEmptyColumns(layoutColumns) {
    var nextLayoutColumns = _toConsumableArray(layoutColumns);

    for (var i = 3; i < nextLayoutColumns.length && nextLayoutColumns[i].length === 0; i++) {
      nextLayoutColumns.splice(i, 1);
    }

    return nextLayoutColumns;
  }
  /**
   * Insert an item inside another item's children
   * and returns a new array of columns
   * @param {object} layoutColumns
   * @param {boolean} pathUpdated
   * @param {object} sourceItem
   * @param {number} sourceItemColumnIndex
   * @param {object} targetItem
   * @return {object}
   * @review
   */

  function moveItemInside(layoutColumns, pathUpdated, sourceItem, sourceItemColumnIndex, targetItem) {
    var nextLayoutColumns = removeItem(sourceItem.plid, layoutColumns);
    var targetColumn = (0, _LayoutGetUtils.getItemColumn)(nextLayoutColumns, targetItem.plid);
    var targetColumnIndex = (0, _LayoutGetUtils.getItemColumnIndex)(nextLayoutColumns, targetItem.plid);

    if (targetItem.active) {
      var nextColumn = nextLayoutColumns[targetColumnIndex + 1];

      if (nextColumn) {
        nextLayoutColumns = (0, _utils.setIn)(nextLayoutColumns, [targetColumnIndex + 1, nextColumn.length], sourceItem);
      } else {
        nextLayoutColumns = (0, _utils.setIn)(nextLayoutColumns, [targetColumnIndex + 1], []);
        nextLayoutColumns = (0, _utils.setIn)(nextLayoutColumns, [targetColumnIndex + 1, 0], sourceItem);
      }
    }

    if (sourceItem.active && !pathUpdated) {
      nextLayoutColumns = clearFollowingColumns(nextLayoutColumns, sourceItemColumnIndex);
      nextLayoutColumns = deleteEmptyColumns(nextLayoutColumns);
    }

    return (0, _utils.setIn)(nextLayoutColumns, [targetColumnIndex, targetColumn.indexOf(targetItem), 'hasChild'], true);
  }
  /**
   * Removes an item, if any, from a column and returns a new array of columns
   * @param {string} itemPlid
   * @param {object[]} layoutColumns
   * @param {string} targetItemPlid
   * @return {object[]} new column array
   * @review
   */

  function removeItem(itemPlid, layoutColumns) {
    var item = (0, _LayoutGetUtils.getItem)(layoutColumns, itemPlid);
    var nextLayoutColumns = layoutColumns;

    if (item) {
      nextLayoutColumns = _toConsumableArray(layoutColumns);
      var itemColumn = (0, _LayoutGetUtils.getItemColumn)(nextLayoutColumns, itemPlid);

      if (itemColumn) {
        var itemIndex = itemColumn.findIndex(function (_item) {
          return _item.plid === itemPlid;
        });

        var nextItemColumn = _toConsumableArray(itemColumn);

        var nextItemColumnIndex = (0, _LayoutGetUtils.getItemColumnIndex)(nextLayoutColumns, itemPlid);
        nextItemColumn.splice(itemIndex, 1);
        nextLayoutColumns[nextItemColumnIndex] = nextItemColumn;
      }
    }

    return nextLayoutColumns;
  }
  /**
   * Set the item with the given plid as the active item of its column
   * and returns a new layoutColumns
   * @param {object} layoutColumns
   * @param {string} itemPlid
   * @return {object}
   * @review
   */

  function setActiveItem(layoutColumns, itemPlid) {
    var columnIndex = (0, _LayoutGetUtils.getItemColumnIndex)(layoutColumns, itemPlid);
    var column = layoutColumns[columnIndex];
    var currentActiveItemIndex = column.indexOf((0, _LayoutGetUtils.getColumnActiveItem)(layoutColumns, columnIndex));
    var newActiveItemIndex = column.indexOf((0, _LayoutGetUtils.getItem)(layoutColumns, itemPlid));
    var nextLayoutColumns = (0, _utils.setIn)(layoutColumns, [columnIndex, currentActiveItemIndex, 'active'], false);
    nextLayoutColumns = (0, _utils.setIn)(nextLayoutColumns, [columnIndex, newActiveItemIndex, 'active'], true);
    return nextLayoutColumns;
  }
  //# sourceMappingURL=LayoutUpdateUtils.es.js.map
});
//# sourceMappingURL=LayoutUpdateUtils.es.js.map