Liferay.Loader.define("layout-admin-web@3.0.139/js/miller_columns/Layout.es", ['module', 'exports', 'require', 'frontend-js-web', 'frontend-js-metal-web$metal-component', 'frontend-js-metal-web$metal-soy', 'frontend-js-metal-web$metal-state', './LayoutBreadcrumbs.es', './LayoutColumn.es', '../utils/utils.es', './Layout.soy', './utils/LayoutDragDrop.es', './utils/LayoutDropUtils.es', './utils/LayoutGetUtils.es', './utils/LayoutUpdateUtils.es'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = exports.Layout = void 0;

  var _frontendJsWeb = require("frontend-js-web");

  var _metalComponent = _interopRequireDefault(require("frontend-js-metal-web$metal-component"));

  var _metalSoy = _interopRequireDefault(require("frontend-js-metal-web$metal-soy"));

  var _metalState = require("frontend-js-metal-web$metal-state");

  require("./LayoutBreadcrumbs.es");

  require("./LayoutColumn.es");

  var _utils = require("../utils/utils.es");

  var _Layout = _interopRequireDefault(require("./Layout.soy"));

  var _LayoutDragDrop = require("./utils/LayoutDragDrop.es");

  var _LayoutDropUtils = require("./utils/LayoutDropUtils.es");

  var _LayoutGetUtils = require("./utils/LayoutGetUtils.es");

  var _LayoutUpdateUtils = require("./utils/LayoutUpdateUtils.es");

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { "default": obj };
  }

  function _typeof(obj) {
    "@babel/helpers - typeof";
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }return _typeof(obj);
  }

  function _toConsumableArray(arr) {
    return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _nonIterableSpread();
  }

  function _nonIterableSpread() {
    throw new TypeError("Invalid attempt to spread non-iterable instance");
  }

  function _iterableToArray(iter) {
    if (Symbol.iterator in Object(iter) || Object.prototype.toString.call(iter) === "[object Arguments]") return Array.from(iter);
  }

  function _arrayWithoutHoles(arr) {
    if (Array.isArray(arr)) {
      for (var i = 0, arr2 = new Array(arr.length); i < arr.length; i++) {
        arr2[i] = arr[i];
      }return arr2;
    }
  }

  function _classCallCheck(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _defineProperties(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
    }
  }

  function _createClass(Constructor, protoProps, staticProps) {
    if (protoProps) _defineProperties(Constructor.prototype, protoProps);if (staticProps) _defineProperties(Constructor, staticProps);return Constructor;
  }

  function _possibleConstructorReturn(self, call) {
    if (call && (_typeof(call) === "object" || typeof call === "function")) {
      return call;
    }return _assertThisInitialized(self);
  }

  function _assertThisInitialized(self) {
    if (self === void 0) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }return self;
  }

  function _getPrototypeOf(o) {
    _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
      return o.__proto__ || Object.getPrototypeOf(o);
    };return _getPrototypeOf(o);
  }

  function _inherits(subClass, superClass) {
    if (typeof superClass !== "function" && superClass !== null) {
      throw new TypeError("Super expression must either be null or a function");
    }subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } });if (superClass) _setPrototypeOf(subClass, superClass);
  }

  function _setPrototypeOf(o, p) {
    _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
      o.__proto__ = p;return o;
    };return _setPrototypeOf(o, p);
  }

  /**
   * Metal drag
   * @param {number}
   */
  var DRAG_SPEED = 20;
  var UPDATE_PATH_TIMEOUT = 500;
  /**
   * Component that allows to show layouts tree in form of three dependent
   * columns. It integrates three <LayoutColumn /> components for N-th, N-th + 2
   * and N-th + 3 levels of layouts tree.
   * @review
   */

  var Layout = /*#__PURE__*/function (_Component) {
    _inherits(Layout, _Component);

    function Layout() {
      _classCallCheck(this, Layout);

      return _possibleConstructorReturn(this, _getPrototypeOf(Layout).apply(this, arguments));
    }

    _createClass(Layout, [{
      key: "attached",

      /**
       * @inheritDoc
       */
      value: function attached() {
        var _this = this;

        this._handleLayoutColumnsScroll = this._handleLayoutColumnsScroll.bind(this);
        var A = new AUI();
        A.use('liferay-search-container', 'liferay-search-container-select', function (A) {
          var plugins = [];
          plugins.push({
            cfg: {
              rowSelector: '.layout-item'
            },
            fn: A.Plugin.SearchContainerSelect
          });
          var searchContainer = new Liferay.SearchContainer({
            contentBox: A.one(_this.refs.layout),
            id: _this.getInitialConfig().portletNamespace + _this.getInitialConfig().searchContainerId,
            plugins: plugins
          });
          _this.searchContainer_ = searchContainer;
        });
      }
      /**
       * @inheritDoc
       * @review
       */

    }, {
      key: "disposed",
      value: function disposed() {
        this._layoutDragDrop.dispose();

        this._removeLayoutColumnsScrollListener();
      }
      /**
       * @inheritDoc
       */

    }, {
      key: "rendered",
      value: function rendered(firstRendered) {
        var _this2 = this;

        requestAnimationFrame(function () {
          var layoutColumns = _this2.refs.layoutColumns;

          if (typeof _this2._layoutColumnsScrollLeft === 'number') {
            layoutColumns.scrollLeft = _this2._layoutColumnsScrollLeft;
          } else {
            layoutColumns.scrollLeft = layoutColumns.scrollWidth;
          }

          if (_this2._newPathItems) {
            _this2._addLayoutDragDropTargets(_this2._newPathItems);

            _this2._newPathItems = null;
          }
        });

        if (firstRendered) {
          this._initializeLayoutDragDrop();
        }
      }
      /**
       * Adds scroll listener to layout columns.
       * @private
       * @review
       */

    }, {
      key: "_addLayoutColumnsScrollListener",
      value: function _addLayoutColumnsScrollListener() {
        var layoutColumns = this.refs.layoutColumns;

        if (layoutColumns) {
          this._layoutColumnsScrollLeft = layoutColumns.scrollLeft;
          layoutColumns.addEventListener('scroll', this._handleLayoutColumnsScroll);
        }
      }
      /**
       * Receives an array of items and add them as drag drop targets
       * @param {!Array} items
       * @private
       * @review
       */

    }, {
      key: "_addLayoutDragDropTargets",
      value: function _addLayoutDragDropTargets(items) {
        var _this3 = this;

        var element = null;
        var query = null;
        items.forEach(function (item) {
          query = "[data-layout-column-item-plid=\"".concat(item.plid, "\"]");
          element = document.querySelector(query);

          _this3._layoutDragDrop.addTarget(element);
        });
      }
      /**
       * @param {string} plid
       * @private
       * @return {Promise<object>}
       * @review
       */

    }, {
      key: "_getItemChildren",
      value: function _getItemChildren(plid) {
        var formData = new FormData();
        formData.append("".concat(this.portletNamespace, "plid"), plid);
        return (0, _frontendJsWeb.fetch)(this.getItemChildrenURL, {
          body: formData,
          method: 'POST'
        }).then(function (response) {
          return response.json();
        });
      }
      /**
       * Handle dragLayoutColumnItem event
       * @param {!object} eventData
       * @param {!string} eventData.position
       * @param {!string} eventData.sourceItemPlid
       * @param {!string} eventData.targetId
       * @param {!string} eventData.targetType
       * @private
       * @review
       */

    }, {
      key: "_handleDragLayoutColumnItem",
      value: function _handleDragLayoutColumnItem(eventData) {
        var _this4 = this;

        clearTimeout(this._updatePathTimeout);
        var position = eventData.position,
            sourceItemPlid = eventData.sourceItemPlid,
            targetId = eventData.targetId,
            targetType = eventData.targetType;

        if (targetType === _LayoutDragDrop.DROP_TARGET_ITEM_TYPES.column) {
          this._setColumnHoveredData(sourceItemPlid, targetId);
        } else if (targetType === _LayoutDragDrop.DROP_TARGET_ITEM_TYPES.item) {
          this._setItemHoveredData(position, sourceItemPlid, targetId);

          if (this._draggingItemPosition === _LayoutDragDrop.DROP_TARGET_BORDERS.inside && this._currentPathItemPlid !== targetId) {
            var draggingItem = this._draggingItem;
            this._updatePathTimeout = setTimeout(function () {
              _this4._updatePath(targetId, draggingItem);
            }, UPDATE_PATH_TIMEOUT);
          }
        }
      }
      /**
       * @param {!object} eventData
       * @param {!string} eventData.targetId
       * @param {!string} eventData.targetType
       * @private
       * @review
       */

    }, {
      key: "_handleDropLayoutColumnItem",
      value: function _handleDropLayoutColumnItem(eventData) {
        var _this5 = this;

        this._removeLayoutColumnsScrollListener();

        this._resetDragDropClasses();

        var layoutColumns = this.layoutColumns.map(function (layoutColumn) {
          return _toConsumableArray(layoutColumn);
        });
        var sourceItemPlid = eventData.sourceItemPlid,
            targetId = eventData.targetId,
            targetType = eventData.targetType;
        var itemDropIsValid = (0, _LayoutDropUtils.dropIsValid)(layoutColumns, this._draggingItem, this._draggingItemColumnIndex, targetId, targetType);

        if (itemDropIsValid) {
          var parentPlid = null;
          var priority = null;

          if (targetType === _LayoutDragDrop.DROP_TARGET_ITEM_TYPES.column) {
            layoutColumns = (0, _LayoutUpdateUtils.clearPath)(layoutColumns, this._draggingItem, this._draggingItemColumnIndex, targetId, targetType);
            var dropData = (0, _LayoutDropUtils.dropItemInsideColumn)(layoutColumns, this._draggingItem, targetId);
            layoutColumns = dropData.layoutColumns;
            parentPlid = dropData.newParentPlid;
            priority = dropData.priority;
          } else if (targetType === _LayoutDragDrop.DROP_TARGET_ITEM_TYPES.item) {
            var targetItem = (0, _LayoutGetUtils.getItem)(layoutColumns, targetId);
            layoutColumns = (0, _LayoutUpdateUtils.clearPath)(layoutColumns, this._draggingItem, this._draggingItemColumnIndex, targetId, targetType);

            if (this._draggingItemPosition === _LayoutDragDrop.DROP_TARGET_BORDERS.inside) {
              var pathUpdated = !!this._currentPathItemPlid;

              var _dropData = (0, _LayoutDropUtils.dropItemInsideItem)(layoutColumns, this._draggingItem, this._draggingItemColumnIndex, pathUpdated, targetItem);

              layoutColumns = _dropData.layoutColumns;
              parentPlid = _dropData.newParentPlid;
              priority = _dropData.priority;
            } else {
              var _dropData2 = (0, _LayoutDropUtils.dropItemNextToItem)(layoutColumns, this._draggingItem, this._draggingItemPosition, targetItem);

              layoutColumns = _dropData2.layoutColumns;
              parentPlid = _dropData2.newParentPlid;
              priority = _dropData2.priority;
            }
          }

          var droppedItemParentPlid = this._draggingItemParentPlid;

          this._moveLayoutColumnItemOnServer(parentPlid, sourceItemPlid, priority, droppedItemParentPlid).then(function (response) {
            if (droppedItemParentPlid && droppedItemParentPlid !== '0' && response.children && response.children.length === 0) {
              layoutColumns = _this5._removeHasChildArrow(layoutColumns, droppedItemParentPlid);
            }

            return response;
          }).then(function () {
            _this5.layoutColumns = layoutColumns;
            clearTimeout(_this5._updatePathTimeout);

            if (_this5._draggingItem == null) {
              requestAnimationFrame(function () {
                _this5._initializeLayoutDragDrop();
              });
            }
          });
        }

        this._resetHoveredData();

        this._currentPathItemPlid = null;
        this._draggingItem = null;
        this._draggingItemColumnIndex = null;
      }
      /**
       * Handle layout column item check event
       * @param {!object} event
       * @param {string} event.delegateTarget.value
       * @private
       * @review
       */

    }, {
      key: "_handleLayoutColumnItemCheck",
      value: function _handleLayoutColumnItemCheck(event) {
        this._setLayoutColumnItemChecked(event.delegateTarget.value, event.delegateTarget.checked);
      }
      /**
       * Handle click event on layout column item checkbox
       * @param {!object} event
       * @private
       * @review
       */

    }, {
      key: "_handleLayoutColumnItemCheckboxClick",
      value: function _handleLayoutColumnItemCheckboxClick(event) {
        event.stopPropagation();
      }
      /**
       * Handle layout column item click event
       * @param {!object} event
       * @param {string} event.delegateTarget.dataset.layoutColumnItemPlid
       * @param {object} event.target.classList
       * @param {string} event.target.type
       * @private
       * @review
       */

    }, {
      key: "_handleLayoutColumnItemClick",
      value: function _handleLayoutColumnItemClick(event) {
        var itemUrl = event.delegateTarget.dataset.layoutColumnItemUrl;

        if (itemUrl) {
          (0, _frontendJsWeb.navigate)(itemUrl);
        } else {
          var itemPlid = event.delegateTarget.dataset.layoutColumnItemPlid;
          var item = (0, _LayoutGetUtils.getItem)(this.layoutColumns, itemPlid);
          this.layoutColumns = (0, _LayoutUpdateUtils.setActiveItem)(this.layoutColumns, itemPlid);
          (0, _frontendJsWeb.navigate)(item.url);
        }
      }
      /**
       * Stores scroll distances when they are below DRAG_SPEED and
       * a drag and drop is being done.
       * @private
       * @review
       * @see DRAG_SPEED
       */

    }, {
      key: "_handleLayoutColumnsScroll",
      value: function _handleLayoutColumnsScroll() {
        var layoutColumns = this.refs.layoutColumns;

        if (layoutColumns) {
          var delta = Math.abs(this._layoutColumnsScrollLeft - layoutColumns.scrollLeft);

          if (delta <= DRAG_SPEED) {
            this._layoutColumnsScrollLeft = layoutColumns.scrollLeft;
          }
        }
      }
      /**
       * @private
       * @review
       */

    }, {
      key: "_handleLeaveLayoutColumnItem",
      value: function _handleLeaveLayoutColumnItem() {
        this._resetDragDropClasses();

        this._resetHoveredData();
      }
      /**
       * @param {!object} eventData
       * @param {!string} eventData.sourceItemPlid
       * @private
       * @review
       */

    }, {
      key: "_handleStartMovingLayoutColumnItem",
      value: function _handleStartMovingLayoutColumnItem(eventData) {
        this._addLayoutColumnsScrollListener();

        var sourceItemColumn = (0, _LayoutGetUtils.getItemColumn)(this.layoutColumns, eventData.sourceItemPlid);
        var sourceItemColumnIndex = this.layoutColumns.indexOf(sourceItemColumn);
        this._draggingItem = (0, _LayoutGetUtils.getItem)(this.layoutColumns, eventData.sourceItemPlid);
        this._draggingItemColumnIndex = sourceItemColumnIndex;
        this._draggingItemParentPlid = (0, _LayoutGetUtils.getColumnActiveItem)(this.layoutColumns, sourceItemColumnIndex - 1).plid;
      }
      /**
       * @param {!object} event
       * @private
       * @review
       */

    }, {
      key: "_handleTooltipHovered",
      value: function _handleTooltipHovered(event) {
        var element = event.delegateTarget;
        var tooltip = Liferay.Util.escape(element.dataset.tooltip);

        if (tooltip && element.offsetWidth < element.scrollWidth) {
          element.setAttribute('title', tooltip);
          element.classList.add('lfr-portal-tooltip');
        } else {
          element.removeAttribute('title');
          element.classList.remove('lfr-portal-tooltip');
        }
      }
      /**
       * @private
       * @review
       */

    }, {
      key: "_initializeLayoutDragDrop",
      value: function _initializeLayoutDragDrop() {
        if (this._layoutDragDrop) {
          this._layoutDragDrop.dispose();
        }

        this._layoutDragDrop = new _LayoutDragDrop.LayoutDragDrop();

        this._layoutDragDrop.on('dragLayoutColumnItem', this._handleDragLayoutColumnItem.bind(this));

        this._layoutDragDrop.on('leaveLayoutColumnItem', this._handleLeaveLayoutColumnItem.bind(this));

        this._layoutDragDrop.on('dropLayoutColumnItem', this._handleDropLayoutColumnItem.bind(this));

        this._layoutDragDrop.on('startMovingLayoutColumnItem', this._handleStartMovingLayoutColumnItem.bind(this));
      }
      /**
       * Sends the movement of an item to the server.
       * @param {string} parentPlid
       * @param {string} plid
       * @param {string} priority
       * @param {string} checkPlid
       * @private
       * @return {Promise<object>}
       * @review
       */

    }, {
      key: "_moveLayoutColumnItemOnServer",
      value: function _moveLayoutColumnItemOnServer(parentPlid, plid, priority, checkPlid) {
        var _this6 = this;

        var formData = new FormData();
        formData.append("".concat(this.portletNamespace, "plid"), plid);
        formData.append("".concat(this.portletNamespace, "parentPlid"), parentPlid);
        formData.append("".concat(this.portletNamespace, "checkPlid"), checkPlid);

        if (priority) {
          formData.append("".concat(this.portletNamespace, "priority"), priority);
        }

        return (0, _frontendJsWeb.fetch)(this.moveLayoutColumnItemURL, {
          body: formData,
          method: 'POST'
        }).then(function (response) {
          return response.json();
        })["catch"](function () {
          _this6._resetHoveredData();
        });
      }
      /**
       * Remove arrow if the item has no children
       * @param {Array} layoutColumns
       * @param {string} itemPlid
       * @private
       * @return {Array}
       * @review
       */

    }, {
      key: "_removeHasChildArrow",
      value: function _removeHasChildArrow(layoutColumns, itemPlid) {
        var nextLayoutColumns = layoutColumns;
        var column = (0, _LayoutGetUtils.getItemColumn)(layoutColumns, itemPlid);
        var item = (0, _LayoutGetUtils.getItem)(nextLayoutColumns, itemPlid);
        nextLayoutColumns = (0, _utils.setIn)(nextLayoutColumns, [nextLayoutColumns.indexOf(column), column.indexOf(item), 'hasChild'], false);
        this._draggingItemParentPlid = null;
        return nextLayoutColumns;
      }
      /**
       * Removes scroll listener from layout columns.
       * @private
       * @review
       */

    }, {
      key: "_removeLayoutColumnsScrollListener",
      value: function _removeLayoutColumnsScrollListener() {
        var layoutColumns = this.refs.layoutColumns;

        if (layoutColumns) {
          layoutColumns.removeEventListener('scroll', this._handleLayoutColumnsScroll);
        }

        this._layoutColumnsScrollLeft = null;
      }
      /**
       * Removes all drag-drop related classes from all items.
       * @private
       * @review
       */

    }, {
      key: "_resetDragDropClasses",
      value: function _resetDragDropClasses() {
        this.element.querySelectorAll("\n\t\t\t\t.layout-column-item-drag-bottom,\n\t\t\t\t.layout-column-item-drag-inside,\n\t\t\t\t.layout-column-item-drag-top\n\t\t\t").forEach(function (item) {
          item.classList.remove('layout-column-item-drag-bottom', 'layout-column-item-drag-inside', 'layout-column-item-drag-top');
        });
      }
      /**
       * Resets dragging information to null
       * @private
       */

    }, {
      key: "_resetHoveredData",
      value: function _resetHoveredData() {
        this._draggingItemPosition = null;
        this._hoveredLayoutColumnItemPlid = null;
      }
      /**
       * Set hovered data with the last item of a column
       * @param {string} draggingItemPlid
       * @param {number} targetColumnIndex Index of the column whose last item
       * will be stored inside hoveredLayoutColumnItemPlid
       * @private
       * @review
       */

    }, {
      key: "_setColumnHoveredData",
      value: function _setColumnHoveredData(draggingItemPlid, targetColumnIndex) {
        var targetColumnIsChild = (0, _LayoutGetUtils.columnIsItemChild)(targetColumnIndex, this._draggingItem, this._draggingItemColumnIndex);
        var targetColumnLastItem = (0, _LayoutGetUtils.getColumnLastItem)(this.layoutColumns, targetColumnIndex);
        var targetEqualsSource = targetColumnLastItem && draggingItemPlid === targetColumnLastItem.plid;

        if (targetColumnLastItem && !targetColumnIsChild && !targetEqualsSource) {
          this._draggingItemPosition = _LayoutDragDrop.DROP_TARGET_BORDERS.bottom;
          this._hoveredLayoutColumnItemPlid = targetColumnLastItem.plid;

          this._resetDragDropClasses();

          this._setElementDragDropCssClass(targetColumnLastItem.plid, _LayoutDragDrop.DROP_TARGET_BORDERS.bottom);
        }
      }
      /**
       * Adds the given CSS class to the given itemPlid if it is found inside
       * the document.
       * @param {string} itemPlid
       * @param {string} cssClass
       * @private
       * @review
       */

    }, {
      key: "_setElementDragDropCssClass",
      value: function _setElementDragDropCssClass(itemPlid, cssClass) {
        var itemElement = this.element.querySelector("li[data-layout-column-item-plid=\"".concat(itemPlid, "\"]"));

        if (itemElement) {
          itemElement.classList.add(cssClass);
        }
      }
      /**
       * Set hovered data with an item
       * @param {string} position Position where item is being dragged
       * @param {string} sourceItemPlid
       * @param {string} targetItemPlid
       * @private
       * @review
       * @see DROP_TARGET_BORDERS
       */

    }, {
      key: "_setItemHoveredData",
      value: function _setItemHoveredData(position, sourceItemPlid, targetItemPlid) {
        var targetColumnIndex = (0, _LayoutGetUtils.getItemColumnIndex)(this.layoutColumns, targetItemPlid);
        var targetIsChild = (0, _LayoutGetUtils.columnIsItemChild)(targetColumnIndex, this._draggingItem, this._draggingItemColumnIndex);

        var draggingInsideParent = position === _LayoutDragDrop.DROP_TARGET_BORDERS.inside && (0, _LayoutGetUtils.itemIsParent)(this.layoutColumns, sourceItemPlid, targetItemPlid);

        if (!(sourceItemPlid === targetItemPlid) && !targetIsChild && !draggingInsideParent) {
          this._draggingItemPosition = position;
          this._hoveredLayoutColumnItemPlid = targetItemPlid;

          this._resetDragDropClasses();

          this._setElementDragDropCssClass(targetItemPlid, position);
        }
      }
      /**
       * Set an item active property to true
       * @param {!string} plid
       * @param {!boolean} checked
       * @private
       * @review
       */

    }, {
      key: "_setLayoutColumnItemChecked",
      value: function _setLayoutColumnItemChecked(plid, checked) {
        var column = (0, _LayoutGetUtils.getItemColumn)(this.layoutColumns, plid);
        var columnIndex = this.layoutColumns.indexOf(column);
        var item = (0, _LayoutGetUtils.getItem)(this.layoutColumns, plid);
        this.layoutColumns = (0, _utils.setIn)(this.layoutColumns, [columnIndex, column.indexOf(item), 'checked'], checked);
      }
      /**
       * @param {string} targetItemPlid
       * @private
       * @review
       */

    }, {
      key: "_updatePath",
      value: function _updatePath(targetItemPlid, draggingItem) {
        var _this7 = this;

        var nextLayoutColumns = this.layoutColumns;
        var targetColumn = (0, _LayoutGetUtils.getItemColumn)(nextLayoutColumns, targetItemPlid);
        var targetColumnIndex = nextLayoutColumns.indexOf(targetColumn);
        nextLayoutColumns = (0, _LayoutUpdateUtils.clearFollowingColumns)(nextLayoutColumns, targetColumnIndex);
        nextLayoutColumns = (0, _LayoutUpdateUtils.setActiveItem)(nextLayoutColumns, targetItemPlid);
        draggingItem.active = false;
        this._currentPathItemPlid = targetItemPlid;
        nextLayoutColumns = (0, _LayoutUpdateUtils.deleteEmptyColumns)(nextLayoutColumns);

        this._getItemChildren(targetItemPlid).then(function (response) {
          var children = response.children;
          var lastColumnIndex = nextLayoutColumns.length - 1;

          if (nextLayoutColumns[lastColumnIndex].length === 0) {
            nextLayoutColumns = (0, _utils.setIn)(nextLayoutColumns, [lastColumnIndex], children);
          } else {
            nextLayoutColumns = (0, _utils.setIn)(nextLayoutColumns, [nextLayoutColumns.length], children);
          }

          _this7._newPathItems = children;
          _this7.layoutColumns = nextLayoutColumns;
        });
      }
    }]);

    return Layout;
  }(_metalComponent["default"]);
  /**
   * State definition.
   * @review
   * @static
   * @type {!Object}
   */

  exports.Layout = Layout;
  Layout.STATE = {
    /**
     * Wether the path is refreshing or not
     * @default null
     * @instance
     * @review
     * @type {!string}
     */
    _currentPathItemPlid: _metalState.Config.string().internal().value(null),

    /**
     * Item that is being dragged.
     * @default undefined
     * @instance
     * @review
     * @type {!object}
     */
    _draggingItem: _metalState.Config.internal(),

    /**
     * Index of the dragging item column in layoutColumns array.
     * @default undefined
     * @instance
     * @review
     * @type {!number}
     */
    _draggingItemColumnIndex: _metalState.Config.number().internal(),

    /**
     * Plid of the dragging item parent
     * @default undefined
     * @instance
     * @review
     * @type {!string}
     */
    _draggingItemParentPlid: _metalState.Config.string().internal(),

    /**
     * Nearest border of the hovered layout column item when dragging.
     * @default undefined
     * @instance
     * @review
     * @type {!string}
     */
    _draggingItemPosition: _metalState.Config.string().internal(),

    /**
     * Id of the hovered layout column item when dragging.
     * @default undefined
     * @instance
     * @review
     * @type {!string}
     */
    _hoveredLayoutColumnItemPlid: _metalState.Config.string().internal(),

    /**
     * Scroll left position stored while dragging elements
     * @default null
     * @instance
     * @memberOf Layout
     * @private
     * @review
     * @type {number}
     */
    _layoutColumnsScrollLeft: _metalState.Config.internal().value(null),

    /**
     * Internal LayoutDragDrop instance
     * @default null
     * @instance
     * @memberOf Layout
     * @review
     * @type {object|null}
     */
    _layoutDragDrop: _metalState.Config.internal().value(null),

    /**
     * Stores new items that are shown when path is updated
     * @default null
     * @instance
     * @memberOf Layout
     * @review
     * @type {Array}
     */
    _newPathItems: _metalState.Config.internal().value(null),

    /**
     * Id of the timeout to update the path
     * @default undefined
     * @instance
     * @memberOf Layout
     * @review
     * @type {number}
     */
    _updatePathTimeout: _metalState.Config.number().internal(),

    /**
     * Breadcrumb Entries
     * @instance
     * @memberof Layout
     * @type {!Array}
     */
    breadcrumbEntries: _metalState.Config.arrayOf(_metalState.Config.shapeOf({
      title: _metalState.Config.string().required(),
      url: _metalState.Config.string().required()
    })).required(),

    /**
     * URL for get the children of an item
     * @default undefined
     * @instance
     * @review
     * @type {!string}
     */
    getItemChildrenURL: _metalState.Config.string().required(),

    /**
     * Layout blocks
     * @instance
     * @memberof Layout
     * @type {!Array}
     */
    layoutColumns: _metalState.Config.arrayOf(_metalState.Config.arrayOf(_metalState.Config.shapeOf({
      actionURLs: _metalState.Config.object().required(),
      actions: _metalState.Config.string().required(),
      active: _metalState.Config.bool().required(),
      checked: _metalState.Config.bool().required(),
      hasChild: _metalState.Config.bool().required(),
      hasScopeGroup: _metalState.Config.bool().required(),
      parentable: _metalState.Config.bool().required(),
      plid: _metalState.Config.string().required(),
      title: _metalState.Config.string().required(),
      url: _metalState.Config.string().required()
    }))).required(),

    /**
     * URL for moving a layout column item through its column.
     * @default undefined
     * @instance
     * @review
     * @type {!string}
     */
    moveLayoutColumnItemURL: _metalState.Config.string().required(),

    /**
     * URL for using icons
     * @instance
     * @memberof Layout
     * @type {!string}
     */
    pathThemeImages: _metalState.Config.string().required(),

    /**
     * Namespace of portlet to prefix parameters names
     * @instance
     * @memberof Layout
     * @type {!string}
     */
    portletNamespace: _metalState.Config.string().required(),

    /**
     * Site navigation menu names, to add layouts by default
     * @instance
     * @memberof Layout
     * @type {!string}
     */
    siteNavigationMenuNames: _metalState.Config.string().required()
  };

  _metalSoy["default"].register(Layout, _Layout["default"]);

  var _default = Layout;
  exports["default"] = _default;
  //# sourceMappingURL=Layout.es.js.map
});
//# sourceMappingURL=Layout.es.js.map