Liferay.Loader.define("layout-admin-web@2.0.60/metal-soy-bundle/build/bundle", ['exports', 'metal-incremental-dom/src/all/incremental-dom'], function (exports) {
  'use strict';

  var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) {
    return typeof obj;
  } : function (obj) {
    return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
  };

  (function () {
    if (!this.goog) {
      this.CLOSURE_NO_DEPS = true;
      this.goog = this.goog || {};

      // Copyright 2006 The Closure Library Authors. All Rights Reserved.
      //
      // Licensed under the Apache License, Version 2.0 (the "License");
      // you may not use this file except in compliance with the License.
      // You may obtain a copy of the License at
      //
      //      http://www.apache.org/licenses/LICENSE-2.0
      //
      // Unless required by applicable law or agreed to in writing, software
      // distributed under the License is distributed on an "AS-IS" BASIS,
      // WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
      // See the License for the specific language governing permissions and
      // limitations under the License.

      /**
       * @fileoverview Bootstrap for the Google JS Library (Closure).
       *
       * In uncompiled mode base.js will write out Closure's deps file, unless the
       * global <code>CLOSURE_NO_DEPS</code> is set to true.  This allows projects to
       * include their own deps file(s) from different locations.
       *
       * @author arv@google.com (Erik Arvidsson)
       *
       * @provideGoog
       */

      /**
       * @define {boolean} Overridden to true by the compiler when
       *     --process_closure_primitives is specified.
       */
      var COMPILED = false;

      /**
       * Base namespace for the Closure library.  Checks to see goog is already
       * defined in the current scope before assigning to prevent clobbering if
       * base.js is loaded more than once.
       *
       * @const
       */
      var goog = this.goog || {};

      /**
       * Reference to the global context.  In most cases this will be 'window'.
       */
      goog.global = this;

      /**
       * A hook for overriding the define values in uncompiled mode.
       *
       * In uncompiled mode, {@code CLOSURE_UNCOMPILED_DEFINES} may be defined before
       * loading base.js.  If a key is defined in {@code CLOSURE_UNCOMPILED_DEFINES},
       * {@code goog.define} will use the value instead of the default value.  This
       * allows flags to be overwritten without compilation (this is normally
       * accomplished with the compiler's "define" flag).
       *
       * Example:
       * <pre>
       *   var CLOSURE_UNCOMPILED_DEFINES = {'goog.DEBUG': false};
       * </pre>
       *
       * @type {Object<string, (string|number|boolean)>|undefined}
       */
      goog.global.CLOSURE_UNCOMPILED_DEFINES;

      /**
       * A hook for overriding the define values in uncompiled or compiled mode,
       * like CLOSURE_UNCOMPILED_DEFINES but effective in compiled code.  In
       * uncompiled code CLOSURE_UNCOMPILED_DEFINES takes precedence.
       *
       * Also unlike CLOSURE_UNCOMPILED_DEFINES the values must be number, boolean or
       * string literals or the compiler will emit an error.
       *
       * While any @define value may be set, only those set with goog.define will be
       * effective for uncompiled code.
       *
       * Example:
       * <pre>
       *   var CLOSURE_DEFINES = {'goog.DEBUG': false} ;
       * </pre>
       *
       * @type {Object<string, (string|number|boolean)>|undefined}
       */
      goog.global.CLOSURE_DEFINES;

      /**
       * Returns true if the specified value is not undefined.
       * WARNING: Do not use this to test if an object has a property. Use the in
       * operator instead.
       *
       * @param {?} val Variable to test.
       * @return {boolean} Whether variable is defined.
       */
      goog.isDef = function (val) {
        // void 0 always evaluates to undefined and hence we do not need to depend on
        // the definition of the global variable named 'undefined'.
        return val !== void 0;
      };

      /**
       * Builds an object structure for the provided namespace path, ensuring that
       * names that already exist are not overwritten. For example:
       * "a.b.c" -> a = {};a.b={};a.b.c={};
       * Used by goog.provide and goog.exportSymbol.
       * @param {string} name name of the object that this file defines.
       * @param {*=} opt_object the object to expose at the end of the path.
       * @param {Object=} opt_objectToExportTo The object to add the path to; default
       *     is |goog.global|.
       * @private
       */
      goog.exportPath_ = function (name, opt_object, opt_objectToExportTo) {
        var parts = name.split('.');
        var cur = opt_objectToExportTo || goog.global;

        // Internet Explorer exhibits strange behavior when throwing errors from
        // methods externed in this manner.  See the testExportSymbolExceptions in
        // base_test.html for an example.
        if (!(parts[0] in cur) && cur.execScript) {
          cur.execScript('var ' + parts[0]);
        }

        // Certain browsers cannot parse code in the form for((a in b); c;);
        // This pattern is produced by the JSCompiler when it collapses the
        // statement above into the conditional loop below. To prevent this from
        // happening, use a for-loop and reserve the init logic as below.

        // Parentheses added to eliminate strict JS warning in Firefox.
        for (var part; parts.length && (part = parts.shift());) {
          if (!parts.length && goog.isDef(opt_object)) {
            // last part and we have an object; use it
            cur[part] = opt_object;
          } else if (cur[part]) {
            cur = cur[part];
          } else {
            cur = cur[part] = {};
          }
        }
      };

      /**
       * Defines a named value. In uncompiled mode, the value is retrieved from
       * CLOSURE_DEFINES or CLOSURE_UNCOMPILED_DEFINES if the object is defined and
       * has the property specified, and otherwise used the defined defaultValue.
       * When compiled the default can be overridden using the compiler
       * options or the value set in the CLOSURE_DEFINES object.
       *
       * @param {string} name The distinguished name to provide.
       * @param {string|number|boolean} defaultValue
       */
      goog.define = function (name, defaultValue) {
        var value = defaultValue;
        if (!COMPILED) {
          if (goog.global.CLOSURE_UNCOMPILED_DEFINES && Object.prototype.hasOwnProperty.call(goog.global.CLOSURE_UNCOMPILED_DEFINES, name)) {
            value = goog.global.CLOSURE_UNCOMPILED_DEFINES[name];
          } else if (goog.global.CLOSURE_DEFINES && Object.prototype.hasOwnProperty.call(goog.global.CLOSURE_DEFINES, name)) {
            value = goog.global.CLOSURE_DEFINES[name];
          }
        }
        goog.exportPath_(name, value);
      };

      /**
       * @define {boolean} DEBUG is provided as a convenience so that debugging code
       * that should not be included in a production js_binary can be easily stripped
       * by specifying --define goog.DEBUG=false to the JSCompiler. For example, most
       * toString() methods should be declared inside an "if (goog.DEBUG)" conditional
       * because they are generally used for debugging purposes and it is difficult
       * for the JSCompiler to statically determine whether they are used.
       */
      goog.define('goog.DEBUG', true);

      /**
       * @define {string} LOCALE defines the locale being used for compilation. It is
       * used to select locale specific data to be compiled in js binary. BUILD rule
       * can specify this value by "--define goog.LOCALE=<locale_name>" as JSCompiler
       * option.
       *
       * Take into account that the locale code format is important. You should use
       * the canonical Unicode format with hyphen as a delimiter. Language must be
       * lowercase, Language Script - Capitalized, Region - UPPERCASE.
       * There are few examples: pt-BR, en, en-US, sr-Latin-BO, zh-Hans-CN.
       *
       * See more info about locale codes here:
       * http://www.unicode.org/reports/tr35/#Unicode_Language_and_Locale_Identifiers
       *
       * For language codes you should use values defined by ISO 693-1. See it here
       * http://www.w3.org/WAI/ER/IG/ert/iso639.htm. There is only one exception from
       * this rule: the Hebrew language. For legacy reasons the old code (iw) should
       * be used instead of the new code (he), see http://wiki/Main/IIISynonyms.
       */
      goog.define('goog.LOCALE', 'en'); // default to en


      /**
       * @define {boolean} Whether this code is running on trusted sites.
       *
       * On untrusted sites, several native functions can be defined or overridden by
       * external libraries like Prototype, Datejs, and JQuery and setting this flag
       * to false forces closure to use its own implementations when possible.
       *
       * If your JavaScript can be loaded by a third party site and you are wary about
       * relying on non-standard implementations, specify
       * "--define goog.TRUSTED_SITE=false" to the JSCompiler.
       */
      goog.define('goog.TRUSTED_SITE', true);

      /**
       * @define {boolean} Whether a project is expected to be running in strict mode.
       *
       * This define can be used to trigger alternate implementations compatible with
       * running in EcmaScript Strict mode or warn about unavailable functionality.
       * @see https://goo.gl/g5EoHI
       *
       */
      goog.define('goog.STRICT_MODE_COMPATIBLE', false);

      /**
       * @define {boolean} Whether code that calls {@link goog.setTestOnly} should
       *     be disallowed in the compilation unit.
       */
      goog.define('goog.DISALLOW_TEST_ONLY_CODE', COMPILED && !goog.DEBUG);

      /**
       * @define {boolean} Whether to use a Chrome app CSP-compliant method for
       *     loading scripts via goog.require. @see appendScriptSrcNode_.
       */
      goog.define('goog.ENABLE_CHROME_APP_SAFE_SCRIPT_LOADING', false);

      /**
       * Defines a namespace in Closure.
       *
       * A namespace may only be defined once in a codebase. It may be defined using
       * goog.provide() or goog.module().
       *
       * The presence of one or more goog.provide() calls in a file indicates
       * that the file defines the given objects/namespaces.
       * Provided symbols must not be null or undefined.
       *
       * In addition, goog.provide() creates the object stubs for a namespace
       * (for example, goog.provide("goog.foo.bar") will create the object
       * goog.foo.bar if it does not already exist).
       *
       * Build tools also scan for provide/require/module statements
       * to discern dependencies, build dependency files (see deps.js), etc.
       *
       * @see goog.require
       * @see goog.module
       * @param {string} name Namespace provided by this file in the form
       *     "goog.package.part".
       */
      goog.provide = function (name) {
        if (!COMPILED) {
          // Ensure that the same namespace isn't provided twice.
          // A goog.module/goog.provide maps a goog.require to a specific file
          if (goog.isProvided_(name)) {
            throw Error('Namespace "' + name + '" already declared.');
          }
        }

        goog.constructNamespace_(name);
      };

      /**
       * @param {string} name Namespace provided by this file in the form
       *     "goog.package.part".
       * @param {Object=} opt_obj The object to embed in the namespace.
       * @private
       */
      goog.constructNamespace_ = function (name, opt_obj) {
        if (!COMPILED) {
          delete goog.implicitNamespaces_[name];

          var namespace = name;
          while (namespace = namespace.substring(0, namespace.lastIndexOf('.'))) {
            if (goog.getObjectByName(namespace)) {
              break;
            }
            goog.implicitNamespaces_[namespace] = true;
          }
        }

        goog.exportPath_(name, opt_obj);
      };

      /**
       * Module identifier validation regexp.
       * Note: This is a conservative check, it is very possible to be more lenient,
       *   the primary exclusion here is "/" and "\" and a leading ".", these
       *   restrictions are intended to leave the door open for using goog.require
       *   with relative file paths rather than module identifiers.
       * @private
       */
      goog.VALID_MODULE_RE_ = /^[a-zA-Z_$][a-zA-Z0-9._$]*$/;

      /**
       * Defines a module in Closure.
       *
       * Marks that this file must be loaded as a module and claims the namespace.
       *
       * A namespace may only be defined once in a codebase. It may be defined using
       * goog.provide() or goog.module().
       *
       * goog.module() has three requirements:
       * - goog.module may not be used in the same file as goog.provide.
       * - goog.module must be the first statement in the file.
       * - only one goog.module is allowed per file.
       *
       * When a goog.module annotated file is loaded, it is enclosed in
       * a strict function closure. This means that:
       * - any variables declared in a goog.module file are private to the file
       * (not global), though the compiler is expected to inline the module.
       * - The code must obey all the rules of "strict" JavaScript.
       * - the file will be marked as "use strict"
       *
       * NOTE: unlike goog.provide, goog.module does not declare any symbols by
       * itself. If declared symbols are desired, use
       * goog.module.declareLegacyNamespace().
       *
       *
       * See the public goog.module proposal: http://goo.gl/Va1hin
       *
       * @param {string} name Namespace provided by this file in the form
       *     "goog.package.part", is expected but not required.
       */
      goog.module = function (name) {
        if (!goog.isString(name) || !name || name.search(goog.VALID_MODULE_RE_) == -1) {
          throw Error('Invalid module identifier');
        }
        if (!goog.isInModuleLoader_()) {
          throw Error('Module ' + name + ' has been loaded incorrectly.');
        }
        if (goog.moduleLoaderState_.moduleName) {
          throw Error('goog.module may only be called once per module.');
        }

        // Store the module name for the loader.
        goog.moduleLoaderState_.moduleName = name;
        if (!COMPILED) {
          // Ensure that the same namespace isn't provided twice.
          // A goog.module/goog.provide maps a goog.require to a specific file
          if (goog.isProvided_(name)) {
            throw Error('Namespace "' + name + '" already declared.');
          }
          delete goog.implicitNamespaces_[name];
        }
      };

      /**
       * @param {string} name The module identifier.
       * @return {?} The module exports for an already loaded module or null.
       *
       * Note: This is not an alternative to goog.require, it does not
       * indicate a hard dependency, instead it is used to indicate
       * an optional dependency or to access the exports of a module
       * that has already been loaded.
       * @suppress {missingProvide}
       */
      goog.module.get = function (name) {
        return goog.module.getInternal_(name);
      };

      /**
       * @param {string} name The module identifier.
       * @return {?} The module exports for an already loaded module or null.
       * @private
       */
      goog.module.getInternal_ = function (name) {
        if (!COMPILED) {
          if (goog.isProvided_(name)) {
            // goog.require only return a value with-in goog.module files.
            return name in goog.loadedModules_ ? goog.loadedModules_[name] : goog.getObjectByName(name);
          } else {
            return null;
          }
        }
      };

      /**
       * @private {?{moduleName: (string|undefined), declareLegacyNamespace:boolean}}
       */
      goog.moduleLoaderState_ = null;

      /**
       * @private
       * @return {boolean} Whether a goog.module is currently being initialized.
       */
      goog.isInModuleLoader_ = function () {
        return goog.moduleLoaderState_ != null;
      };

      /**
       * Provide the module's exports as a globally accessible object under the
       * module's declared name.  This is intended to ease migration to goog.module
       * for files that have existing usages.
       * @suppress {missingProvide}
       */
      goog.module.declareLegacyNamespace = function () {
        if (!COMPILED && !goog.isInModuleLoader_()) {
          throw new Error('goog.module.declareLegacyNamespace must be called from ' + 'within a goog.module');
        }
        if (!COMPILED && !goog.moduleLoaderState_.moduleName) {
          throw Error('goog.module must be called prior to ' + 'goog.module.declareLegacyNamespace.');
        }
        goog.moduleLoaderState_.declareLegacyNamespace = true;
      };

      /**
       * Marks that the current file should only be used for testing, and never for
       * live code in production.
       *
       * In the case of unit tests, the message may optionally be an exact namespace
       * for the test (e.g. 'goog.stringTest'). The linter will then ignore the extra
       * provide (if not explicitly defined in the code).
       *
       * @param {string=} opt_message Optional message to add to the error that's
       *     raised when used in production code.
       */
      goog.setTestOnly = function (opt_message) {
        if (goog.DISALLOW_TEST_ONLY_CODE) {
          opt_message = opt_message || '';
          throw Error('Importing test-only code into non-debug environment' + (opt_message ? ': ' + opt_message : '.'));
        }
      };

      if (!COMPILED) {
        /**
         * Check if the given name has been goog.provided. This will return false for
         * names that are available only as implicit namespaces.
         * @param {string} name name of the object to look for.
         * @return {boolean} Whether the name has been provided.
         * @private
         */
        goog.isProvided_ = function (name) {
          return name in goog.loadedModules_ || !goog.implicitNamespaces_[name] && goog.isDefAndNotNull(goog.getObjectByName(name));
        };

        /**
         * Namespaces implicitly defined by goog.provide. For example,
         * goog.provide('goog.events.Event') implicitly declares that 'goog' and
         * 'goog.events' must be namespaces.
         *
         * @type {!Object<string, (boolean|undefined)>}
         * @private
         */
        goog.implicitNamespaces_ = { 'goog.module': true };

        // NOTE: We add goog.module as an implicit namespace as goog.module is defined
        // here and because the existing module package has not been moved yet out of
        // the goog.module namespace. This satisifies both the debug loader and
        // ahead-of-time dependency management.
      }

      /**
       * Returns an object based on its fully qualified external name.  The object
       * is not found if null or undefined.  If you are using a compilation pass that
       * renames property names beware that using this function will not find renamed
       * properties.
       *
       * @param {string} name The fully qualified name.
       * @param {Object=} opt_obj The object within which to look; default is
       *     |goog.global|.
       * @return {?} The value (object or primitive) or, if not found, null.
       */
      goog.getObjectByName = function (name, opt_obj) {
        var parts = name.split('.');
        var cur = opt_obj || goog.global;
        for (var part; part = parts.shift();) {
          if (goog.isDefAndNotNull(cur[part])) {
            cur = cur[part];
          } else {
            return null;
          }
        }
        return cur;
      };

      /**
       * Globalizes a whole namespace, such as goog or goog.lang.
       *
       * @param {!Object} obj The namespace to globalize.
       * @param {Object=} opt_global The object to add the properties to.
       * @deprecated Properties may be explicitly exported to the global scope, but
       *     this should no longer be done in bulk.
       */
      goog.globalize = function (obj, opt_global) {
        var global = opt_global || goog.global;
        for (var x in obj) {
          global[x] = obj[x];
        }
      };

      /**
       * Adds a dependency from a file to the files it requires.
       * @param {string} relPath The path to the js file.
       * @param {!Array<string>} provides An array of strings with
       *     the names of the objects this file provides.
       * @param {!Array<string>} requires An array of strings with
       *     the names of the objects this file requires.
       * @param {boolean|!Object<string>=} opt_loadFlags Parameters indicating
       *     how the file must be loaded.  The boolean 'true' is equivalent
       *     to {'module': 'goog'} for backwards-compatibility.  Valid properties
       *     and values include {'module': 'goog'} and {'lang': 'es6'}.
       */
      goog.addDependency = function (relPath, provides, requires, opt_loadFlags) {
        if (goog.DEPENDENCIES_ENABLED) {
          var provide, require;
          var path = relPath.replace(/\\/g, '/');
          var deps = goog.dependencies_;
          if (!opt_loadFlags || typeof opt_loadFlags === 'boolean') {
            opt_loadFlags = opt_loadFlags ? { 'module': 'goog' } : {};
          }
          for (var i = 0; provide = provides[i]; i++) {
            deps.nameToPath[provide] = path;
            deps.pathIsModule[path] = opt_loadFlags['module'] == 'goog';
          }
          for (var j = 0; require = requires[j]; j++) {
            if (!(path in deps.requires)) {
              deps.requires[path] = {};
            }
            deps.requires[path][require] = true;
          }
        }
      };

      // NOTE(nnaze): The debug DOM loader was included in base.js as an original way
      // to do "debug-mode" development.  The dependency system can sometimes be
      // confusing, as can the debug DOM loader's asynchronous nature.
      //
      // With the DOM loader, a call to goog.require() is not blocking -- the script
      // will not load until some point after the current script.  If a namespace is
      // needed at runtime, it needs to be defined in a previous script, or loaded via
      // require() with its registered dependencies.
      //
      // User-defined namespaces may need their own deps file. For a reference on
      // creating a deps file, see:
      // Externally: https://developers.google.com/closure/library/docs/depswriter
      //
      // Because of legacy clients, the DOM loader can't be easily removed from
      // base.js.  Work is being done to make it disableable or replaceable for
      // different environments (DOM-less JavaScript interpreters like Rhino or V8,
      // for example). See bootstrap/ for more information.


      /**
       * @define {boolean} Whether to enable the debug loader.
       *
       * If enabled, a call to goog.require() will attempt to load the namespace by
       * appending a script tag to the DOM (if the namespace has been registered).
       *
       * If disabled, goog.require() will simply assert that the namespace has been
       * provided (and depend on the fact that some outside tool correctly ordered
       * the script).
       */
      goog.define('goog.ENABLE_DEBUG_LOADER', true);

      /**
       * @param {string} msg
       * @private
       */
      goog.logToConsole_ = function (msg) {
        if (goog.global.console) {
          goog.global.console['error'](msg);
        }
      };

      /**
       * Implements a system for the dynamic resolution of dependencies that works in
       * parallel with the BUILD system. Note that all calls to goog.require will be
       * stripped by the JSCompiler when the --process_closure_primitives option is
       * used.
       * @see goog.provide
       * @param {string} name Namespace to include (as was given in goog.provide()) in
       *     the form "goog.package.part".
       * @return {?} If called within a goog.module file, the associated namespace or
       *     module otherwise null.
       */
      goog.require = function (name) {
        // If the object already exists we do not need do do anything.
        if (!COMPILED) {
          if (goog.ENABLE_DEBUG_LOADER && goog.IS_OLD_IE_) {
            goog.maybeProcessDeferredDep_(name);
          }

          if (goog.isProvided_(name)) {
            if (goog.isInModuleLoader_()) {
              return goog.module.getInternal_(name);
            } else {
              return null;
            }
          }

          if (goog.ENABLE_DEBUG_LOADER) {
            var path = goog.getPathFromDeps_(name);
            if (path) {
              goog.writeScripts_(path);
              return null;
            }
          }

          var errorMessage = 'goog.require could not find: ' + name;
          goog.logToConsole_(errorMessage);

          throw Error(errorMessage);
        }
      };

      /**
       * Path for included scripts.
       * @type {string}
       */
      goog.basePath = '';

      /**
       * A hook for overriding the base path.
       * @type {string|undefined}
       */
      goog.global.CLOSURE_BASE_PATH;

      /**
       * Whether to write out Closure's deps file. By default, the deps are written.
       * @type {boolean|undefined}
       */
      goog.global.CLOSURE_NO_DEPS;

      /**
       * A function to import a single script. This is meant to be overridden when
       * Closure is being run in non-HTML contexts, such as web workers. It's defined
       * in the global scope so that it can be set before base.js is loaded, which
       * allows deps.js to be imported properly.
       *
       * The function is passed the script source, which is a relative URI. It should
       * return true if the script was imported, false otherwise.
       * @type {(function(string): boolean)|undefined}
       */
      goog.global.CLOSURE_IMPORT_SCRIPT;

      /**
       * Null function used for default values of callbacks, etc.
       * @return {void} Nothing.
       */
      goog.nullFunction = function () {};

      /**
       * When defining a class Foo with an abstract method bar(), you can do:
       * Foo.prototype.bar = goog.abstractMethod
       *
       * Now if a subclass of Foo fails to override bar(), an error will be thrown
       * when bar() is invoked.
       *
       * Note: This does not take the name of the function to override as an argument
       * because that would make it more difficult to obfuscate our JavaScript code.
       *
       * @type {!Function}
       * @throws {Error} when invoked to indicate the method should be overridden.
       */
      goog.abstractMethod = function () {
        throw Error('unimplemented abstract method');
      };

      /**
       * Adds a {@code getInstance} static method that always returns the same
       * instance object.
       * @param {!Function} ctor The constructor for the class to add the static
       *     method to.
       */
      goog.addSingletonGetter = function (ctor) {
        ctor.getInstance = function () {
          if (ctor.instance_) {
            return ctor.instance_;
          }
          if (goog.DEBUG) {
            // NOTE: JSCompiler can't optimize away Array#push.
            goog.instantiatedSingletons_[goog.instantiatedSingletons_.length] = ctor;
          }
          return ctor.instance_ = new ctor();
        };
      };

      /**
       * All singleton classes that have been instantiated, for testing. Don't read
       * it directly, use the {@code goog.testing.singleton} module. The compiler
       * removes this variable if unused.
       * @type {!Array<!Function>}
       * @private
       */
      goog.instantiatedSingletons_ = [];

      /**
       * @define {boolean} Whether to load goog.modules using {@code eval} when using
       * the debug loader.  This provides a better debugging experience as the
       * source is unmodified and can be edited using Chrome Workspaces or similar.
       * However in some environments the use of {@code eval} is banned
       * so we provide an alternative.
       */
      goog.define('goog.LOAD_MODULE_USING_EVAL', true);

      /**
       * @define {boolean} Whether the exports of goog.modules should be sealed when
       * possible.
       */
      goog.define('goog.SEAL_MODULE_EXPORTS', goog.DEBUG);

      /**
       * The registry of initialized modules:
       * the module identifier to module exports map.
       * @private @const {!Object<string, ?>}
       */
      goog.loadedModules_ = {};

      /**
       * True if goog.dependencies_ is available.
       * @const {boolean}
       */
      goog.DEPENDENCIES_ENABLED = !COMPILED && goog.ENABLE_DEBUG_LOADER;

      if (goog.DEPENDENCIES_ENABLED) {
        /**
         * This object is used to keep track of dependencies and other data that is
         * used for loading scripts.
         * @private
         * @type {{
         *   pathIsModule: !Object<string, boolean>,
         *   nameToPath: !Object<string, string>,
         *   requires: !Object<string, !Object<string, boolean>>,
         *   visited: !Object<string, boolean>,
         *   written: !Object<string, boolean>,
         *   deferred: !Object<string, string>
         * }}
         */
        goog.dependencies_ = {
          pathIsModule: {}, // 1 to 1

          nameToPath: {}, // 1 to 1

          requires: {}, // 1 to many

          // Used when resolving dependencies to prevent us from visiting file twice.
          visited: {},

          written: {}, // Used to keep track of script files we have written.

          deferred: {} // Used to track deferred module evaluations in old IEs
        };

        /**
         * Tries to detect whether is in the context of an HTML document.
         * @return {boolean} True if it looks like HTML document.
         * @private
         */
        goog.inHtmlDocument_ = function () {
          /** @type {Document} */
          var doc = goog.global.document;
          return doc != null && 'write' in doc; // XULDocument misses write.
        };

        /**
         * Tries to detect the base path of base.js script that bootstraps Closure.
         * @private
         */
        goog.findBasePath_ = function () {
          if (goog.isDef(goog.global.CLOSURE_BASE_PATH)) {
            goog.basePath = goog.global.CLOSURE_BASE_PATH;
            return;
          } else if (!goog.inHtmlDocument_()) {
            return;
          }
          /** @type {Document} */
          var doc = goog.global.document;
          var scripts = doc.getElementsByTagName('SCRIPT');
          // Search backwards since the current script is in almost all cases the one
          // that has base.js.
          for (var i = scripts.length - 1; i >= 0; --i) {
            var script = /** @type {!HTMLScriptElement} */scripts[i];
            var src = script.src;
            var qmark = src.lastIndexOf('?');
            var l = qmark == -1 ? src.length : qmark;
            if (src.substr(l - 7, 7) == 'base.js') {
              goog.basePath = src.substr(0, l - 7);
              return;
            }
          }
        };

        /**
         * Imports a script if, and only if, that script hasn't already been imported.
         * (Must be called at execution time)
         * @param {string} src Script source.
         * @param {string=} opt_sourceText The optionally source text to evaluate
         * @private
         */
        goog.importScript_ = function (src, opt_sourceText) {
          var importScript = goog.global.CLOSURE_IMPORT_SCRIPT || goog.writeScriptTag_;
          if (importScript(src, opt_sourceText)) {
            goog.dependencies_.written[src] = true;
          }
        };

        /** @const @private {boolean} */
        goog.IS_OLD_IE_ = !!(!goog.global.atob && goog.global.document && goog.global.document.all);

        /**
         * Given a URL initiate retrieval and execution of the module.
         * @param {string} src Script source URL.
         * @private
         */
        goog.importModule_ = function (src) {
          // In an attempt to keep browsers from timing out loading scripts using
          // synchronous XHRs, put each load in its own script block.
          var bootstrap = 'goog.retrieveAndExecModule_("' + src + '");';

          if (goog.importScript_('', bootstrap)) {
            goog.dependencies_.written[src] = true;
          }
        };

        /** @private {!Array<string>} */
        goog.queuedModules_ = [];

        /**
         * Return an appropriate module text. Suitable to insert into
         * a script tag (that is unescaped).
         * @param {string} srcUrl
         * @param {string} scriptText
         * @return {string}
         * @private
         */
        goog.wrapModule_ = function (srcUrl, scriptText) {
          if (!goog.LOAD_MODULE_USING_EVAL || !goog.isDef(goog.global.JSON)) {
            return '' + 'goog.loadModule(function(exports) {' + '"use strict";' + scriptText + '\n' + // terminate any trailing single line comment.
            ';return exports' + '});' + '\n//# sourceURL=' + srcUrl + '\n';
          } else {
            return '' + 'goog.loadModule(' + goog.global.JSON.stringify(scriptText + '\n//# sourceURL=' + srcUrl + '\n') + ');';
          }
        };

        // On IE9 and earlier, it is necessary to handle
        // deferred module loads. In later browsers, the
        // code to be evaluated is simply inserted as a script
        // block in the correct order. To eval deferred
        // code at the right time, we piggy back on goog.require to call
        // goog.maybeProcessDeferredDep_.
        //
        // The goog.requires are used both to bootstrap
        // the loading process (when no deps are available) and
        // declare that they should be available.
        //
        // Here we eval the sources, if all the deps are available
        // either already eval'd or goog.require'd.  This will
        // be the case when all the dependencies have already
        // been loaded, and the dependent module is loaded.
        //
        // But this alone isn't sufficient because it is also
        // necessary to handle the case where there is no root
        // that is not deferred.  For that there we register for an event
        // and trigger goog.loadQueuedModules_ handle any remaining deferred
        // evaluations.

        /**
         * Handle any remaining deferred goog.module evals.
         * @private
         */
        goog.loadQueuedModules_ = function () {
          var count = goog.queuedModules_.length;
          if (count > 0) {
            var queue = goog.queuedModules_;
            goog.queuedModules_ = [];
            for (var i = 0; i < count; i++) {
              var path = queue[i];
              goog.maybeProcessDeferredPath_(path);
            }
          }
        };

        /**
         * Eval the named module if its dependencies are
         * available.
         * @param {string} name The module to load.
         * @private
         */
        goog.maybeProcessDeferredDep_ = function (name) {
          if (goog.isDeferredModule_(name) && goog.allDepsAreAvailable_(name)) {
            var path = goog.getPathFromDeps_(name);
            goog.maybeProcessDeferredPath_(goog.basePath + path);
          }
        };

        /**
         * @param {string} name The module to check.
         * @return {boolean} Whether the name represents a
         *     module whose evaluation has been deferred.
         * @private
         */
        goog.isDeferredModule_ = function (name) {
          var path = goog.getPathFromDeps_(name);
          if (path && goog.dependencies_.pathIsModule[path]) {
            var abspath = goog.basePath + path;
            return abspath in goog.dependencies_.deferred;
          }
          return false;
        };

        /**
         * @param {string} name The module to check.
         * @return {boolean} Whether the name represents a
         *     module whose declared dependencies have all been loaded
         *     (eval'd or a deferred module load)
         * @private
         */
        goog.allDepsAreAvailable_ = function (name) {
          var path = goog.getPathFromDeps_(name);
          if (path && path in goog.dependencies_.requires) {
            for (var requireName in goog.dependencies_.requires[path]) {
              if (!goog.isProvided_(requireName) && !goog.isDeferredModule_(requireName)) {
                return false;
              }
            }
          }
          return true;
        };

        /**
         * @param {string} abspath
         * @private
         */
        goog.maybeProcessDeferredPath_ = function (abspath) {
          if (abspath in goog.dependencies_.deferred) {
            var src = goog.dependencies_.deferred[abspath];
            delete goog.dependencies_.deferred[abspath];
            goog.globalEval(src);
          }
        };

        /**
         * Load a goog.module from the provided URL.  This is not a general purpose
         * code loader and does not support late loading code, that is it should only
         * be used during page load. This method exists to support unit tests and
         * "debug" loaders that would otherwise have inserted script tags. Under the
         * hood this needs to use a synchronous XHR and is not recommeneded for
         * production code.
         *
         * The module's goog.requires must have already been satisified; an exception
         * will be thrown if this is not the case. This assumption is that no
         * "deps.js" file exists, so there is no way to discover and locate the
         * module-to-be-loaded's dependencies and no attempt is made to do so.
         *
         * There should only be one attempt to load a module.  If
         * "goog.loadModuleFromUrl" is called for an already loaded module, an
         * exception will be throw.
         *
         * @param {string} url The URL from which to attempt to load the goog.module.
         */
        goog.loadModuleFromUrl = function (url) {
          // Because this executes synchronously, we don't need to do any additional
          // bookkeeping. When "goog.loadModule" the namespace will be marked as
          // having been provided which is sufficient.
          goog.retrieveAndExecModule_(url);
        };

        /**
         * @param {function(?):?|string} moduleDef The module definition.
         */
        goog.loadModule = function (moduleDef) {
          // NOTE: we allow function definitions to be either in the from
          // of a string to eval (which keeps the original source intact) or
          // in a eval forbidden environment (CSP) we allow a function definition
          // which in its body must call {@code goog.module}, and return the exports
          // of the module.
          var previousState = goog.moduleLoaderState_;
          try {
            goog.moduleLoaderState_ = {
              moduleName: undefined,
              declareLegacyNamespace: false
            };
            var exports;
            if (goog.isFunction(moduleDef)) {
              exports = moduleDef.call(goog.global, {});
            } else if (goog.isString(moduleDef)) {
              exports = goog.loadModuleFromSource_.call(goog.global, moduleDef);
            } else {
              throw Error('Invalid module definition');
            }

            var moduleName = goog.moduleLoaderState_.moduleName;
            if (!goog.isString(moduleName) || !moduleName) {
              throw Error('Invalid module name \"' + moduleName + '\"');
            }

            // Don't seal legacy namespaces as they may be uses as a parent of
            // another namespace
            if (goog.moduleLoaderState_.declareLegacyNamespace) {
              goog.constructNamespace_(moduleName, exports);
            } else if (goog.SEAL_MODULE_EXPORTS && Object.seal) {
              Object.seal(exports);
            }

            goog.loadedModules_[moduleName] = exports;
          } finally {
            goog.moduleLoaderState_ = previousState;
          }
        };

        /**
         * @private @const {function(string):?}
         *
         * The new type inference warns because this function has no formal
         * parameters, but its jsdoc says that it takes one argument.
         * (The argument is used via arguments[0], but NTI does not detect this.)
         * @suppress {newCheckTypes}
         */
        goog.loadModuleFromSource_ = function () {
          // NOTE: we avoid declaring parameters or local variables here to avoid
          // masking globals or leaking values into the module definition.
          'use strict';

          var exports = {};
          eval(arguments[0]);
          return exports;
        };

        /**
         * Writes a new script pointing to {@code src} directly into the DOM.
         *
         * NOTE: This method is not CSP-compliant. @see goog.appendScriptSrcNode_ for
         * the fallback mechanism.
         *
         * @param {string} src The script URL.
         * @private
         */
        goog.writeScriptSrcNode_ = function (src) {
          goog.global.document.write('<script type="text/javascript" src="' + src + '"></' + 'script>');
        };

        /**
         * Appends a new script node to the DOM using a CSP-compliant mechanism. This
         * method exists as a fallback for document.write (which is not allowed in a
         * strict CSP context, e.g., Chrome apps).
         *
         * NOTE: This method is not analogous to using document.write to insert a
         * <script> tag; specifically, the user agent will execute a script added by
         * document.write immediately after the current script block finishes
         * executing, whereas the DOM-appended script node will not be executed until
         * the entire document is parsed and executed. That is to say, this script is
         * added to the end of the script execution queue.
         *
         * The page must not attempt to call goog.required entities until after the
         * document has loaded, e.g., in or after the window.onload callback.
         *
         * @param {string} src The script URL.
         * @private
         */
        goog.appendScriptSrcNode_ = function (src) {
          /** @type {Document} */
          var doc = goog.global.document;
          var scriptEl =
          /** @type {HTMLScriptElement} */doc.createElement('script');
          scriptEl.type = 'text/javascript';
          scriptEl.src = src;
          scriptEl.defer = false;
          scriptEl.async = false;
          doc.head.appendChild(scriptEl);
        };

        /**
         * The default implementation of the import function. Writes a script tag to
         * import the script.
         *
         * @param {string} src The script url.
         * @param {string=} opt_sourceText The optionally source text to evaluate
         * @return {boolean} True if the script was imported, false otherwise.
         * @private
         */
        goog.writeScriptTag_ = function (src, opt_sourceText) {
          if (goog.inHtmlDocument_()) {
            /** @type {!HTMLDocument} */
            var doc = goog.global.document;

            // If the user tries to require a new symbol after document load,
            // something has gone terribly wrong. Doing a document.write would
            // wipe out the page. This does not apply to the CSP-compliant method
            // of writing script tags.
            if (!goog.ENABLE_CHROME_APP_SAFE_SCRIPT_LOADING && doc.readyState == 'complete') {
              // Certain test frameworks load base.js multiple times, which tries
              // to write deps.js each time. If that happens, just fail silently.
              // These frameworks wipe the page between each load of base.js, so this
              // is OK.
              var isDeps = /\bdeps.js$/.test(src);
              if (isDeps) {
                return false;
              } else {
                throw Error('Cannot write "' + src + '" after document load');
              }
            }

            var isOldIE = goog.IS_OLD_IE_;

            if (opt_sourceText === undefined) {
              if (!isOldIE) {
                if (goog.ENABLE_CHROME_APP_SAFE_SCRIPT_LOADING) {
                  goog.appendScriptSrcNode_(src);
                } else {
                  goog.writeScriptSrcNode_(src);
                }
              } else {
                var state = " onreadystatechange='goog.onScriptLoad_(this, " + ++goog.lastNonModuleScriptIndex_ + ")' ";
                doc.write('<script type="text/javascript" src="' + src + '"' + state + '></' + 'script>');
              }
            } else {
              doc.write('<script type="text/javascript">' + opt_sourceText + '</' + 'script>');
            }
            return true;
          } else {
            return false;
          }
        };

        /** @private {number} */
        goog.lastNonModuleScriptIndex_ = 0;

        /**
         * A readystatechange handler for legacy IE
         * @param {!HTMLScriptElement} script
         * @param {number} scriptIndex
         * @return {boolean}
         * @private
         */
        goog.onScriptLoad_ = function (script, scriptIndex) {
          // for now load the modules when we reach the last script,
          // later allow more inter-mingling.
          if (script.readyState == 'complete' && goog.lastNonModuleScriptIndex_ == scriptIndex) {
            goog.loadQueuedModules_();
          }
          return true;
        };

        /**
         * Resolves dependencies based on the dependencies added using addDependency
         * and calls importScript_ in the correct order.
         * @param {string} pathToLoad The path from which to start discovering
         *     dependencies.
         * @private
         */
        goog.writeScripts_ = function (pathToLoad) {
          /** @type {!Array<string>} The scripts we need to write this time. */
          var scripts = [];
          var seenScript = {};
          var deps = goog.dependencies_;

          /** @param {string} path */
          function visitNode(path) {
            if (path in deps.written) {
              return;
            }

            // We have already visited this one. We can get here if we have cyclic
            // dependencies.
            if (path in deps.visited) {
              return;
            }

            deps.visited[path] = true;

            if (path in deps.requires) {
              for (var requireName in deps.requires[path]) {
                // If the required name is defined, we assume that it was already
                // bootstrapped by other means.
                if (!goog.isProvided_(requireName)) {
                  if (requireName in deps.nameToPath) {
                    visitNode(deps.nameToPath[requireName]);
                  } else {
                    throw Error('Undefined nameToPath for ' + requireName);
                  }
                }
              }
            }

            if (!(path in seenScript)) {
              seenScript[path] = true;
              scripts.push(path);
            }
          }

          visitNode(pathToLoad);

          // record that we are going to load all these scripts.
          for (var i = 0; i < scripts.length; i++) {
            var path = scripts[i];
            goog.dependencies_.written[path] = true;
          }

          // If a module is loaded synchronously then we need to
          // clear the current inModuleLoader value, and restore it when we are
          // done loading the current "requires".
          var moduleState = goog.moduleLoaderState_;
          goog.moduleLoaderState_ = null;

          for (var i = 0; i < scripts.length; i++) {
            var path = scripts[i];
            if (path) {
              if (!deps.pathIsModule[path]) {
                goog.importScript_(goog.basePath + path);
              } else {
                goog.importModule_(goog.basePath + path);
              }
            } else {
              goog.moduleLoaderState_ = moduleState;
              throw Error('Undefined script input');
            }
          }

          // restore the current "module loading state"
          goog.moduleLoaderState_ = moduleState;
        };

        /**
         * Looks at the dependency rules and tries to determine the script file that
         * fulfills a particular rule.
         * @param {string} rule In the form goog.namespace.Class or project.script.
         * @return {?string} Url corresponding to the rule, or null.
         * @private
         */
        goog.getPathFromDeps_ = function (rule) {
          if (rule in goog.dependencies_.nameToPath) {
            return goog.dependencies_.nameToPath[rule];
          } else {
            return null;
          }
        };

        goog.findBasePath_();

        // Allow projects to manage the deps files themselves.
        if (!goog.global.CLOSURE_NO_DEPS) {
          goog.importScript_(goog.basePath + 'deps.js');
        }
      }

      /**
       * Normalize a file path by removing redundant ".." and extraneous "." file
       * path components.
       * @param {string} path
       * @return {string}
       * @private
       */
      goog.normalizePath_ = function (path) {
        var components = path.split('/');
        var i = 0;
        while (i < components.length) {
          if (components[i] == '.') {
            components.splice(i, 1);
          } else if (i && components[i] == '..' && components[i - 1] && components[i - 1] != '..') {
            components.splice(--i, 2);
          } else {
            i++;
          }
        }
        return components.join('/');
      };

      /**
       * Loads file by synchronous XHR. Should not be used in production environments.
       * @param {string} src Source URL.
       * @return {string} File contents.
       * @private
       */
      goog.loadFileSync_ = function (src) {
        if (goog.global.CLOSURE_LOAD_FILE_SYNC) {
          return goog.global.CLOSURE_LOAD_FILE_SYNC(src);
        } else {
          /** @type {XMLHttpRequest} */
          var xhr = new goog.global['XMLHttpRequest']();
          xhr.open('get', src, false);
          xhr.send();
          return xhr.responseText;
        }
      };

      /**
       * Retrieve and execute a module.
       * @param {string} src Script source URL.
       * @private
       */
      goog.retrieveAndExecModule_ = function (src) {
        if (!COMPILED) {
          // The full but non-canonicalized URL for later use.
          var originalPath = src;
          // Canonicalize the path, removing any /./ or /../ since Chrome's debugging
          // console doesn't auto-canonicalize XHR loads as it does <script> srcs.
          src = goog.normalizePath_(src);

          var importScript = goog.global.CLOSURE_IMPORT_SCRIPT || goog.writeScriptTag_;

          var scriptText = goog.loadFileSync_(src);

          if (scriptText != null) {
            var execModuleScript = goog.wrapModule_(src, scriptText);
            var isOldIE = goog.IS_OLD_IE_;
            if (isOldIE) {
              goog.dependencies_.deferred[originalPath] = execModuleScript;
              goog.queuedModules_.push(originalPath);
            } else {
              importScript(src, execModuleScript);
            }
          } else {
            throw new Error('load of ' + src + 'failed');
          }
        }
      };

      //==============================================================================
      // Language Enhancements
      //==============================================================================


      /**
       * This is a "fixed" version of the typeof operator.  It differs from the typeof
       * operator in such a way that null returns 'null' and arrays return 'array'.
       * @param {?} value The value to get the type of.
       * @return {string} The name of the type.
       */
      goog.typeOf = function (value) {
        var s = typeof value === 'undefined' ? 'undefined' : _typeof(value);
        if (s == 'object') {
          if (value) {
            // Check these first, so we can avoid calling Object.prototype.toString if
            // possible.
            //
            // IE improperly marshals typeof across execution contexts, but a
            // cross-context object will still return false for "instanceof Object".
            if (value instanceof Array) {
              return 'array';
            } else if (value instanceof Object) {
              return s;
            }

            // HACK: In order to use an Object prototype method on the arbitrary
            //   value, the compiler requires the value be cast to type Object,
            //   even though the ECMA spec explicitly allows it.
            var className = Object.prototype.toString.call(
            /** @type {!Object} */value);
            // In Firefox 3.6, attempting to access iframe window objects' length
            // property throws an NS_ERROR_FAILURE, so we need to special-case it
            // here.
            if (className == '[object Window]') {
              return 'object';
            }

            // We cannot always use constructor == Array or instanceof Array because
            // different frames have different Array objects. In IE6, if the iframe
            // where the array was created is destroyed, the array loses its
            // prototype. Then dereferencing val.splice here throws an exception, so
            // we can't use goog.isFunction. Calling typeof directly returns 'unknown'
            // so that will work. In this case, this function will return false and
            // most array functions will still work because the array is still
            // array-like (supports length and []) even though it has lost its
            // prototype.
            // Mark Miller noticed that Object.prototype.toString
            // allows access to the unforgeable [[Class]] property.
            //  15.2.4.2 Object.prototype.toString ( )
            //  When the toString method is called, the following steps are taken:
            //      1. Get the [[Class]] property of this object.
            //      2. Compute a string value by concatenating the three strings
            //         "[object ", Result(1), and "]".
            //      3. Return Result(2).
            // and this behavior survives the destruction of the execution context.
            if (className == '[object Array]' ||
            // In IE all non value types are wrapped as objects across window
            // boundaries (not iframe though) so we have to do object detection
            // for this edge case.
            typeof value.length == 'number' && typeof value.splice != 'undefined' && typeof value.propertyIsEnumerable != 'undefined' && !value.propertyIsEnumerable('splice')) {
              return 'array';
            }
            // HACK: There is still an array case that fails.
            //     function ArrayImpostor() {}
            //     ArrayImpostor.prototype = [];
            //     var impostor = new ArrayImpostor;
            // this can be fixed by getting rid of the fast path
            // (value instanceof Array) and solely relying on
            // (value && Object.prototype.toString.vall(value) === '[object Array]')
            // but that would require many more function calls and is not warranted
            // unless closure code is receiving objects from untrusted sources.

            // IE in cross-window calls does not correctly marshal the function type
            // (it appears just as an object) so we cannot use just typeof val ==
            // 'function'. However, if the object has a call property, it is a
            // function.
            if (className == '[object Function]' || typeof value.call != 'undefined' && typeof value.propertyIsEnumerable != 'undefined' && !value.propertyIsEnumerable('call')) {
              return 'function';
            }
          } else {
            return 'null';
          }
        } else if (s == 'function' && typeof value.call == 'undefined') {
          // In Safari typeof nodeList returns 'function', and on Firefox typeof
          // behaves similarly for HTML{Applet,Embed,Object}, Elements and RegExps. We
          // would like to return object for those and we can detect an invalid
          // function by making sure that the function object has a call method.
          return 'object';
        }
        return s;
      };

      /**
       * Returns true if the specified value is null.
       * @param {?} val Variable to test.
       * @return {boolean} Whether variable is null.
       */
      goog.isNull = function (val) {
        return val === null;
      };

      /**
       * Returns true if the specified value is defined and not null.
       * @param {?} val Variable to test.
       * @return {boolean} Whether variable is defined and not null.
       */
      goog.isDefAndNotNull = function (val) {
        // Note that undefined == null.
        return val != null;
      };

      /**
       * Returns true if the specified value is an array.
       * @param {?} val Variable to test.
       * @return {boolean} Whether variable is an array.
       */
      goog.isArray = function (val) {
        return goog.typeOf(val) == 'array';
      };

      /**
       * Returns true if the object looks like an array. To qualify as array like
       * the value needs to be either a NodeList or an object with a Number length
       * property. As a special case, a function value is not array like, because its
       * length property is fixed to correspond to the number of expected arguments.
       * @param {?} val Variable to test.
       * @return {boolean} Whether variable is an array.
       */
      goog.isArrayLike = function (val) {
        var type = goog.typeOf(val);
        // We do not use goog.isObject here in order to exclude function values.
        return type == 'array' || type == 'object' && typeof val.length == 'number';
      };

      /**
       * Returns true if the object looks like a Date. To qualify as Date-like the
       * value needs to be an object and have a getFullYear() function.
       * @param {?} val Variable to test.
       * @return {boolean} Whether variable is a like a Date.
       */
      goog.isDateLike = function (val) {
        return goog.isObject(val) && typeof val.getFullYear == 'function';
      };

      /**
       * Returns true if the specified value is a string.
       * @param {?} val Variable to test.
       * @return {boolean} Whether variable is a string.
       */
      goog.isString = function (val) {
        return typeof val == 'string';
      };

      /**
       * Returns true if the specified value is a boolean.
       * @param {?} val Variable to test.
       * @return {boolean} Whether variable is boolean.
       */
      goog.isBoolean = function (val) {
        return typeof val == 'boolean';
      };

      /**
       * Returns true if the specified value is a number.
       * @param {?} val Variable to test.
       * @return {boolean} Whether variable is a number.
       */
      goog.isNumber = function (val) {
        return typeof val == 'number';
      };

      /**
       * Returns true if the specified value is a function.
       * @param {?} val Variable to test.
       * @return {boolean} Whether variable is a function.
       */
      goog.isFunction = function (val) {
        return goog.typeOf(val) == 'function';
      };

      /**
       * Returns true if the specified value is an object.  This includes arrays and
       * functions.
       * @param {?} val Variable to test.
       * @return {boolean} Whether variable is an object.
       */
      goog.isObject = function (val) {
        var type = typeof val === 'undefined' ? 'undefined' : _typeof(val);
        return type == 'object' && val != null || type == 'function';
        // return Object(val) === val also works, but is slower, especially if val is
        // not an object.
      };

      /**
       * Gets a unique ID for an object. This mutates the object so that further calls
       * with the same object as a parameter returns the same value. The unique ID is
       * guaranteed to be unique across the current session amongst objects that are
       * passed into {@code getUid}. There is no guarantee that the ID is unique or
       * consistent across sessions. It is unsafe to generate unique ID for function
       * prototypes.
       *
       * @param {Object} obj The object to get the unique ID for.
       * @return {number} The unique ID for the object.
       */
      goog.getUid = function (obj) {
        // TODO(arv): Make the type stricter, do not accept null.

        // In Opera window.hasOwnProperty exists but always returns false so we avoid
        // using it. As a consequence the unique ID generated for BaseClass.prototype
        // and SubClass.prototype will be the same.
        return obj[goog.UID_PROPERTY_] || (obj[goog.UID_PROPERTY_] = ++goog.uidCounter_);
      };

      /**
       * Whether the given object is already assigned a unique ID.
       *
       * This does not modify the object.
       *
       * @param {!Object} obj The object to check.
       * @return {boolean} Whether there is an assigned unique id for the object.
       */
      goog.hasUid = function (obj) {
        return !!obj[goog.UID_PROPERTY_];
      };

      /**
       * Removes the unique ID from an object. This is useful if the object was
       * previously mutated using {@code goog.getUid} in which case the mutation is
       * undone.
       * @param {Object} obj The object to remove the unique ID field from.
       */
      goog.removeUid = function (obj) {
        // TODO(arv): Make the type stricter, do not accept null.

        // In IE, DOM nodes are not instances of Object and throw an exception if we
        // try to delete.  Instead we try to use removeAttribute.
        if (obj !== null && 'removeAttribute' in obj) {
          obj.removeAttribute(goog.UID_PROPERTY_);
        }
        /** @preserveTry */
        try {
          delete obj[goog.UID_PROPERTY_];
        } catch (ex) {}
      };

      /**
       * Name for unique ID property. Initialized in a way to help avoid collisions
       * with other closure JavaScript on the same page.
       * @type {string}
       * @private
       */
      goog.UID_PROPERTY_ = 'closure_uid_' + (Math.random() * 1e9 >>> 0);

      /**
       * Counter for UID.
       * @type {number}
       * @private
       */
      goog.uidCounter_ = 0;

      /**
       * Adds a hash code field to an object. The hash code is unique for the
       * given object.
       * @param {Object} obj The object to get the hash code for.
       * @return {number} The hash code for the object.
       * @deprecated Use goog.getUid instead.
       */
      goog.getHashCode = goog.getUid;

      /**
       * Removes the hash code field from an object.
       * @param {Object} obj The object to remove the field from.
       * @deprecated Use goog.removeUid instead.
       */
      goog.removeHashCode = goog.removeUid;

      /**
       * Clones a value. The input may be an Object, Array, or basic type. Objects and
       * arrays will be cloned recursively.
       *
       * WARNINGS:
       * <code>goog.cloneObject</code> does not detect reference loops. Objects that
       * refer to themselves will cause infinite recursion.
       *
       * <code>goog.cloneObject</code> is unaware of unique identifiers, and copies
       * UIDs created by <code>getUid</code> into cloned results.
       *
       * @param {*} obj The value to clone.
       * @return {*} A clone of the input value.
       * @deprecated goog.cloneObject is unsafe. Prefer the goog.object methods.
       */
      goog.cloneObject = function (obj) {
        var type = goog.typeOf(obj);
        if (type == 'object' || type == 'array') {
          if (obj.clone) {
            return obj.clone();
          }
          var clone = type == 'array' ? [] : {};
          for (var key in obj) {
            clone[key] = goog.cloneObject(obj[key]);
          }
          return clone;
        }

        return obj;
      };

      /**
       * A native implementation of goog.bind.
       * @param {Function} fn A function to partially apply.
       * @param {Object|undefined} selfObj Specifies the object which this should
       *     point to when the function is run.
       * @param {...*} var_args Additional arguments that are partially applied to the
       *     function.
       * @return {!Function} A partially-applied form of the function bind() was
       *     invoked as a method of.
       * @private
       * @suppress {deprecated} The compiler thinks that Function.prototype.bind is
       *     deprecated because some people have declared a pure-JS version.
       *     Only the pure-JS version is truly deprecated.
       */
      goog.bindNative_ = function (fn, selfObj, var_args) {
        return (/** @type {!Function} */fn.call.apply(fn.bind, arguments)
        );
      };

      /**
       * A pure-JS implementation of goog.bind.
       * @param {Function} fn A function to partially apply.
       * @param {Object|undefined} selfObj Specifies the object which this should
       *     point to when the function is run.
       * @param {...*} var_args Additional arguments that are partially applied to the
       *     function.
       * @return {!Function} A partially-applied form of the function bind() was
       *     invoked as a method of.
       * @private
       */
      goog.bindJs_ = function (fn, selfObj, var_args) {
        if (!fn) {
          throw new Error();
        }

        if (arguments.length > 2) {
          var boundArgs = Array.prototype.slice.call(arguments, 2);
          return function () {
            // Prepend the bound arguments to the current arguments.
            var newArgs = Array.prototype.slice.call(arguments);
            Array.prototype.unshift.apply(newArgs, boundArgs);
            return fn.apply(selfObj, newArgs);
          };
        } else {
          return function () {
            return fn.apply(selfObj, arguments);
          };
        }
      };

      /**
       * Partially applies this function to a particular 'this object' and zero or
       * more arguments. The result is a new function with some arguments of the first
       * function pre-filled and the value of this 'pre-specified'.
       *
       * Remaining arguments specified at call-time are appended to the pre-specified
       * ones.
       *
       * Also see: {@link #partial}.
       *
       * Usage:
       * <pre>var barMethBound = goog.bind(myFunction, myObj, 'arg1', 'arg2');
       * barMethBound('arg3', 'arg4');</pre>
       *
       * @param {?function(this:T, ...)} fn A function to partially apply.
       * @param {T} selfObj Specifies the object which this should point to when the
       *     function is run.
       * @param {...*} var_args Additional arguments that are partially applied to the
       *     function.
       * @return {!Function} A partially-applied form of the function goog.bind() was
       *     invoked as a method of.
       * @template T
       * @suppress {deprecated} See above.
       */
      goog.bind = function (fn, selfObj, var_args) {
        // TODO(nicksantos): narrow the type signature.
        if (Function.prototype.bind &&
        // NOTE(nicksantos): Somebody pulled base.js into the default Chrome
        // extension environment. This means that for Chrome extensions, they get
        // the implementation of Function.prototype.bind that calls goog.bind
        // instead of the native one. Even worse, we don't want to introduce a
        // circular dependency between goog.bind and Function.prototype.bind, so
        // we have to hack this to make sure it works correctly.
        Function.prototype.bind.toString().indexOf('native code') != -1) {
          goog.bind = goog.bindNative_;
        } else {
          goog.bind = goog.bindJs_;
        }
        return goog.bind.apply(null, arguments);
      };

      /**
       * Like goog.bind(), except that a 'this object' is not required. Useful when
       * the target function is already bound.
       *
       * Usage:
       * var g = goog.partial(f, arg1, arg2);
       * g(arg3, arg4);
       *
       * @param {Function} fn A function to partially apply.
       * @param {...*} var_args Additional arguments that are partially applied to fn.
       * @return {!Function} A partially-applied form of the function goog.partial()
       *     was invoked as a method of.
       */
      goog.partial = function (fn, var_args) {
        var args = Array.prototype.slice.call(arguments, 1);
        return function () {
          // Clone the array (with slice()) and append additional arguments
          // to the existing arguments.
          var newArgs = args.slice();
          newArgs.push.apply(newArgs, arguments);
          return fn.apply(this, newArgs);
        };
      };

      /**
       * Copies all the members of a source object to a target object. This method
       * does not work on all browsers for all objects that contain keys such as
       * toString or hasOwnProperty. Use goog.object.extend for this purpose.
       * @param {Object} target Target.
       * @param {Object} source Source.
       */
      goog.mixin = function (target, source) {
        for (var x in source) {
          target[x] = source[x];
        }

        // For IE7 or lower, the for-in-loop does not contain any properties that are
        // not enumerable on the prototype object (for example, isPrototypeOf from
        // Object.prototype) but also it will not include 'replace' on objects that
        // extend String and change 'replace' (not that it is common for anyone to
        // extend anything except Object).
      };

      /**
       * @return {number} An integer value representing the number of milliseconds
       *     between midnight, January 1, 1970 and the current time.
       */
      goog.now = goog.TRUSTED_SITE && Date.now || function () {
        // Unary plus operator converts its operand to a number which in
        // the case of
        // a date is done by calling getTime().
        return +new Date();
      };

      /**
       * Evals JavaScript in the global scope.  In IE this uses execScript, other
       * browsers use goog.global.eval. If goog.global.eval does not evaluate in the
       * global scope (for example, in Safari), appends a script tag instead.
       * Throws an exception if neither execScript or eval is defined.
       * @param {string} script JavaScript string.
       */
      goog.globalEval = function (script) {
        if (goog.global.execScript) {
          goog.global.execScript(script, 'JavaScript');
        } else if (goog.global.eval) {
          // Test to see if eval works
          if (goog.evalWorksForGlobals_ == null) {
            goog.global.eval('var _evalTest_ = 1;');
            if (typeof goog.global['_evalTest_'] != 'undefined') {
              try {
                delete goog.global['_evalTest_'];
              } catch (ignore) {
                // Microsoft edge fails the deletion above in strict mode.
              }
              goog.evalWorksForGlobals_ = true;
            } else {
              goog.evalWorksForGlobals_ = false;
            }
          }

          if (goog.evalWorksForGlobals_) {
            goog.global.eval(script);
          } else {
            /** @type {Document} */
            var doc = goog.global.document;
            var scriptElt =
            /** @type {!HTMLScriptElement} */doc.createElement('SCRIPT');
            scriptElt.type = 'text/javascript';
            scriptElt.defer = false;
            // Note(user): can't use .innerHTML since "t('<test>')" will fail and
            // .text doesn't work in Safari 2.  Therefore we append a text node.
            scriptElt.appendChild(doc.createTextNode(script));
            doc.body.appendChild(scriptElt);
            doc.body.removeChild(scriptElt);
          }
        } else {
          throw Error('goog.globalEval not available');
        }
      };

      /**
       * Indicates whether or not we can call 'eval' directly to eval code in the
       * global scope. Set to a Boolean by the first call to goog.globalEval (which
       * empirically tests whether eval works for globals). @see goog.globalEval
       * @type {?boolean}
       * @private
       */
      goog.evalWorksForGlobals_ = null;

      /**
       * Optional map of CSS class names to obfuscated names used with
       * goog.getCssName().
       * @private {!Object<string, string>|undefined}
       * @see goog.setCssNameMapping
       */
      goog.cssNameMapping_;

      /**
       * Optional obfuscation style for CSS class names. Should be set to either
       * 'BY_WHOLE' or 'BY_PART' if defined.
       * @type {string|undefined}
       * @private
       * @see goog.setCssNameMapping
       */
      goog.cssNameMappingStyle_;

      /**
       * Handles strings that are intended to be used as CSS class names.
       *
       * This function works in tandem with @see goog.setCssNameMapping.
       *
       * Without any mapping set, the arguments are simple joined with a hyphen and
       * passed through unaltered.
       *
       * When there is a mapping, there are two possible styles in which these
       * mappings are used. In the BY_PART style, each part (i.e. in between hyphens)
       * of the passed in css name is rewritten according to the map. In the BY_WHOLE
       * style, the full css name is looked up in the map directly. If a rewrite is
       * not specified by the map, the compiler will output a warning.
       *
       * When the mapping is passed to the compiler, it will replace calls to
       * goog.getCssName with the strings from the mapping, e.g.
       *     var x = goog.getCssName('foo');
       *     var y = goog.getCssName(this.baseClass, 'active');
       *  becomes:
       *     var x = 'foo';
       *     var y = this.baseClass + '-active';
       *
       * If one argument is passed it will be processed, if two are passed only the
       * modifier will be processed, as it is assumed the first argument was generated
       * as a result of calling goog.getCssName.
       *
       * @param {string} className The class name.
       * @param {string=} opt_modifier A modifier to be appended to the class name.
       * @return {string} The class name or the concatenation of the class name and
       *     the modifier.
       */
      goog.getCssName = function (className, opt_modifier) {
        var getMapping = function getMapping(cssName) {
          return goog.cssNameMapping_[cssName] || cssName;
        };

        var renameByParts = function renameByParts(cssName) {
          // Remap all the parts individually.
          var parts = cssName.split('-');
          var mapped = [];
          for (var i = 0; i < parts.length; i++) {
            mapped.push(getMapping(parts[i]));
          }
          return mapped.join('-');
        };

        var rename;
        if (goog.cssNameMapping_) {
          rename = goog.cssNameMappingStyle_ == 'BY_WHOLE' ? getMapping : renameByParts;
        } else {
          rename = function rename(a) {
            return a;
          };
        }

        if (opt_modifier) {
          return className + '-' + rename(opt_modifier);
        } else {
          return rename(className);
        }
      };

      /**
       * Sets the map to check when returning a value from goog.getCssName(). Example:
       * <pre>
       * goog.setCssNameMapping({
       *   "goog": "a",
       *   "disabled": "b",
       * });
       *
       * var x = goog.getCssName('goog');
       * // The following evaluates to: "a a-b".
       * goog.getCssName('goog') + ' ' + goog.getCssName(x, 'disabled')
       * </pre>
       * When declared as a map of string literals to string literals, the JSCompiler
       * will replace all calls to goog.getCssName() using the supplied map if the
       * --process_closure_primitives flag is set.
       *
       * @param {!Object} mapping A map of strings to strings where keys are possible
       *     arguments to goog.getCssName() and values are the corresponding values
       *     that should be returned.
       * @param {string=} opt_style The style of css name mapping. There are two valid
       *     options: 'BY_PART', and 'BY_WHOLE'.
       * @see goog.getCssName for a description.
       */
      goog.setCssNameMapping = function (mapping, opt_style) {
        goog.cssNameMapping_ = mapping;
        goog.cssNameMappingStyle_ = opt_style;
      };

      /**
       * To use CSS renaming in compiled mode, one of the input files should have a
       * call to goog.setCssNameMapping() with an object literal that the JSCompiler
       * can extract and use to replace all calls to goog.getCssName(). In uncompiled
       * mode, JavaScript code should be loaded before this base.js file that declares
       * a global variable, CLOSURE_CSS_NAME_MAPPING, which is used below. This is
       * to ensure that the mapping is loaded before any calls to goog.getCssName()
       * are made in uncompiled mode.
       *
       * A hook for overriding the CSS name mapping.
       * @type {!Object<string, string>|undefined}
       */
      goog.global.CLOSURE_CSS_NAME_MAPPING;

      if (!COMPILED && goog.global.CLOSURE_CSS_NAME_MAPPING) {
        // This does not call goog.setCssNameMapping() because the JSCompiler
        // requires that goog.setCssNameMapping() be called with an object literal.
        goog.cssNameMapping_ = goog.global.CLOSURE_CSS_NAME_MAPPING;
      }

      /**
       * Gets a localized message.
       *
       * This function is a compiler primitive. If you give the compiler a localized
       * message bundle, it will replace the string at compile-time with a localized
       * version, and expand goog.getMsg call to a concatenated string.
       *
       * Messages must be initialized in the form:
       * <code>
       * var MSG_NAME = goog.getMsg('Hello {$placeholder}', {'placeholder': 'world'});
       * </code>
       *
       * @param {string} str Translatable string, places holders in the form {$foo}.
       * @param {Object<string, string>=} opt_values Maps place holder name to value.
       * @return {string} message with placeholders filled.
       */
      goog.getMsg = function (str, opt_values) {
        if (opt_values) {
          str = str.replace(/\{\$([^}]+)}/g, function (match, key) {
            return opt_values != null && key in opt_values ? opt_values[key] : match;
          });
        }
        return str;
      };

      /**
       * Gets a localized message. If the message does not have a translation, gives a
       * fallback message.
       *
       * This is useful when introducing a new message that has not yet been
       * translated into all languages.
       *
       * This function is a compiler primitive. Must be used in the form:
       * <code>var x = goog.getMsgWithFallback(MSG_A, MSG_B);</code>
       * where MSG_A and MSG_B were initialized with goog.getMsg.
       *
       * @param {string} a The preferred message.
       * @param {string} b The fallback message.
       * @return {string} The best translated message.
       */
      goog.getMsgWithFallback = function (a, b) {
        return a;
      };

      /**
       * Exposes an unobfuscated global namespace path for the given object.
       * Note that fields of the exported object *will* be obfuscated, unless they are
       * exported in turn via this function or goog.exportProperty.
       *
       * Also handy for making public items that are defined in anonymous closures.
       *
       * ex. goog.exportSymbol('public.path.Foo', Foo);
       *
       * ex. goog.exportSymbol('public.path.Foo.staticFunction', Foo.staticFunction);
       *     public.path.Foo.staticFunction();
       *
       * ex. goog.exportSymbol('public.path.Foo.prototype.myMethod',
       *                       Foo.prototype.myMethod);
       *     new public.path.Foo().myMethod();
       *
       * @param {string} publicPath Unobfuscated name to export.
       * @param {*} object Object the name should point to.
       * @param {Object=} opt_objectToExportTo The object to add the path to; default
       *     is goog.global.
       */
      goog.exportSymbol = function (publicPath, object, opt_objectToExportTo) {
        goog.exportPath_(publicPath, object, opt_objectToExportTo);
      };

      /**
       * Exports a property unobfuscated into the object's namespace.
       * ex. goog.exportProperty(Foo, 'staticFunction', Foo.staticFunction);
       * ex. goog.exportProperty(Foo.prototype, 'myMethod', Foo.prototype.myMethod);
       * @param {Object} object Object whose static property is being exported.
       * @param {string} publicName Unobfuscated name to export.
       * @param {*} symbol Object the name should point to.
       */
      goog.exportProperty = function (object, publicName, symbol) {
        object[publicName] = symbol;
      };

      /**
       * Inherit the prototype methods from one constructor into another.
       *
       * Usage:
       * <pre>
       * function ParentClass(a, b) { }
       * ParentClass.prototype.foo = function(a) { };
       *
       * function ChildClass(a, b, c) {
       *   ChildClass.base(this, 'constructor', a, b);
       * }
       * goog.inherits(ChildClass, ParentClass);
       *
       * var child = new ChildClass('a', 'b', 'see');
       * child.foo(); // This works.
       * </pre>
       *
       * @param {!Function} childCtor Child class.
       * @param {!Function} parentCtor Parent class.
       */
      goog.inherits = function (childCtor, parentCtor) {
        /** @constructor */
        function tempCtor() {}
        tempCtor.prototype = parentCtor.prototype;
        childCtor.superClass_ = parentCtor.prototype;
        childCtor.prototype = new tempCtor();
        /** @override */
        childCtor.prototype.constructor = childCtor;

        /**
         * Calls superclass constructor/method.
         *
         * This function is only available if you use goog.inherits to
         * express inheritance relationships between classes.
         *
         * NOTE: This is a replacement for goog.base and for superClass_
         * property defined in childCtor.
         *
         * @param {!Object} me Should always be "this".
         * @param {string} methodName The method name to call. Calling
         *     superclass constructor can be done with the special string
         *     'constructor'.
         * @param {...*} var_args The arguments to pass to superclass
         *     method/constructor.
         * @return {*} The return value of the superclass method/constructor.
         */
        childCtor.base = function (me, methodName, var_args) {
          // Copying using loop to avoid deop due to passing arguments object to
          // function. This is faster in many JS engines as of late 2014.
          var args = new Array(arguments.length - 2);
          for (var i = 2; i < arguments.length; i++) {
            args[i - 2] = arguments[i];
          }
          return parentCtor.prototype[methodName].apply(me, args);
        };
      };

      /**
       * Call up to the superclass.
       *
       * If this is called from a constructor, then this calls the superclass
       * constructor with arguments 1-N.
       *
       * If this is called from a prototype method, then you must pass the name of the
       * method as the second argument to this function. If you do not, you will get a
       * runtime error. This calls the superclass' method with arguments 2-N.
       *
       * This function only works if you use goog.inherits to express inheritance
       * relationships between your classes.
       *
       * This function is a compiler primitive. At compile-time, the compiler will do
       * macro expansion to remove a lot of the extra overhead that this function
       * introduces. The compiler will also enforce a lot of the assumptions that this
       * function makes, and treat it as a compiler error if you break them.
       *
       * @param {!Object} me Should always be "this".
       * @param {*=} opt_methodName The method name if calling a super method.
       * @param {...*} var_args The rest of the arguments.
       * @return {*} The return value of the superclass method.
       * @suppress {es5Strict} This method can not be used in strict mode, but
       *     all Closure Library consumers must depend on this file.
       */
      goog.base = function (me, opt_methodName, var_args) {
        var caller = arguments.callee.caller;

        if (goog.STRICT_MODE_COMPATIBLE || goog.DEBUG && !caller) {
          throw Error('arguments.caller not defined.  goog.base() cannot be used ' + 'with strict mode code. See ' + 'http://www.ecma-international.org/ecma-262/5.1/#sec-C');
        }

        if (caller.superClass_) {
          // Copying using loop to avoid deop due to passing arguments object to
          // function. This is faster in many JS engines as of late 2014.
          var ctorArgs = new Array(arguments.length - 1);
          for (var i = 1; i < arguments.length; i++) {
            ctorArgs[i - 1] = arguments[i];
          }
          // This is a constructor. Call the superclass constructor.
          return caller.superClass_.constructor.apply(me, ctorArgs);
        }

        // Copying using loop to avoid deop due to passing arguments object to
        // function. This is faster in many JS engines as of late 2014.
        var args = new Array(arguments.length - 2);
        for (var i = 2; i < arguments.length; i++) {
          args[i - 2] = arguments[i];
        }
        var foundCaller = false;
        for (var ctor = me.constructor; ctor; ctor = ctor.superClass_ && ctor.superClass_.constructor) {
          if (ctor.prototype[opt_methodName] === caller) {
            foundCaller = true;
          } else if (foundCaller) {
            return ctor.prototype[opt_methodName].apply(me, args);
          }
        }

        // If we did not find the caller in the prototype chain, then one of two
        // things happened:
        // 1) The caller is an instance method.
        // 2) This method was not called by the right caller.
        if (me[opt_methodName] === caller) {
          return me.constructor.prototype[opt_methodName].apply(me, args);
        } else {
          throw Error('goog.base called from a method of one name ' + 'to a method of a different name');
        }
      };

      /**
       * Allow for aliasing within scope functions.  This function exists for
       * uncompiled code - in compiled code the calls will be inlined and the aliases
       * applied.  In uncompiled code the function is simply run since the aliases as
       * written are valid JavaScript.
       *
       *
       * @param {function()} fn Function to call.  This function can contain aliases
       *     to namespaces (e.g. "var dom = goog.dom") or classes
       *     (e.g. "var Timer = goog.Timer").
       */
      goog.scope = function (fn) {
        fn.call(goog.global);
      };

      /*
       * To support uncompiled, strict mode bundles that use eval to divide source
       * like so:
       *    eval('someSource;//# sourceUrl sourcefile.js');
       * We need to export the globally defined symbols "goog" and "COMPILED".
       * Exporting "goog" breaks the compiler optimizations, so we required that
       * be defined externally.
       * NOTE: We don't use goog.exportSymbol here because we don't want to trigger
       * extern generation when that compiler option is enabled.
       */
      if (!COMPILED) {
        goog.global['COMPILED'] = COMPILED;
      }

      goog.provide('goog.string');

      /**
       * Does simple python-style string substitution.
       * subs("foo%s hot%s", "bar", "dog") becomes "foobar hotdog".
       * @param {string} str The string containing the pattern.
       * @param {...*} var_args The items to substitute into the pattern.
       * @return {string} A copy of {@code str} in which each occurrence of
       *     {@code %s} has been replaced an argument from {@code var_args}.
       */
      goog.string.subs = function (str, var_args) {
        var splitParts = str.split('%s');
        var returnString = '';

        var subsArguments = Array.prototype.slice.call(arguments, 1);
        while (subsArguments.length &&
        // Replace up to the last split part. We are inserting in the
        // positions between split parts.
        splitParts.length > 1) {
          returnString += splitParts.shift() + subsArguments.shift();
        }

        return returnString + splitParts.join('%s'); // Join unused '%s'
      };

      /**
       * Regular expression that matches an ampersand, for use in escaping.
       * @const {!RegExp}
       * @private
       */
      goog.string.AMP_RE_ = /&/g;

      /**
       * Regular expression that matches a less than sign, for use in escaping.
       * @const {!RegExp}
       * @private
       */
      goog.string.LT_RE_ = /</g;

      /**
       * Regular expression that matches a greater than sign, for use in escaping.
       * @const {!RegExp}
       * @private
       */
      goog.string.GT_RE_ = />/g;

      /**
       * Regular expression that matches a double quote, for use in escaping.
       * @const {!RegExp}
       * @private
       */
      goog.string.QUOT_RE_ = /"/g;

      /**
       * Regular expression that matches a single quote, for use in escaping.
       * @const {!RegExp}
       * @private
       */
      goog.string.SINGLE_QUOTE_RE_ = /'/g;

      /**
       * Regular expression that matches null character, for use in escaping.
       * @const {!RegExp}
       * @private
       */
      goog.string.NULL_RE_ = /\x00/g;

      /**
       * Regular expression that matches a lowercase letter "e", for use in escaping.
       * @const {!RegExp}
       * @private
       */
      goog.string.E_RE_ = /e/g;

      /**
       * Regular expression that matches any character that needs to be escaped.
       * @const {!RegExp}
       * @private
       */
      goog.string.ALL_RE_ = goog.string.DETECT_DOUBLE_ESCAPING ? /[\x00&<>"'e]/ : /[\x00&<>"']/;

      /**
       * Unescapes an HTML string.
       *
       * @param {string} str The string to unescape.
       * @return {string} An unescaped copy of {@code str}.
       */
      goog.string.unescapeEntities = function (str) {
        if (goog.string.contains(str, '&')) {
          // We are careful not to use a DOM if we do not have one or we explicitly
          // requested non-DOM html unescaping.
          if (!goog.string.FORCE_NON_DOM_HTML_UNESCAPING && 'document' in goog.global) {
            return goog.string.unescapeEntitiesUsingDom_(str);
          } else {
            // Fall back on pure XML entities
            return goog.string.unescapePureXmlEntities_(str);
          }
        }
        return str;
      };

      /**
       * Unescapes an HTML string using a DOM to resolve non-XML, non-numeric
       * entities. This function is XSS-safe and whitespace-preserving.
       * @private
       * @param {string} str The string to unescape.
       * @param {Document=} opt_document An optional document to use for creating
       *     elements. If this is not specified then the default window.document
       *     will be used.
       * @return {string} The unescaped {@code str} string.
       */
      goog.string.unescapeEntitiesUsingDom_ = function (str, opt_document) {
        /** @type {!Object<string, string>} */
        var seen = { '&amp;': '&', '&lt;': '<', '&gt;': '>', '&quot;': '"' };
        var div;
        if (opt_document) {
          div = opt_document.createElement('div');
        } else {
          div = goog.global.document.createElement('div');
        }
        // Match as many valid entity characters as possible. If the actual entity
        // happens to be shorter, it will still work as innerHTML will return the
        // trailing characters unchanged. Since the entity characters do not include
        // open angle bracket, there is no chance of XSS from the innerHTML use.
        // Since no whitespace is passed to innerHTML, whitespace is preserved.
        return str.replace(goog.string.HTML_ENTITY_PATTERN_, function (s, entity) {
          // Check for cached entity.
          var value = seen[s];
          if (value) {
            return value;
          }
          // Check for numeric entity.
          if (entity.charAt(0) == '#') {
            // Prefix with 0 so that hex entities (e.g. &#x10) parse as hex numbers.
            var n = Number('0' + entity.substr(1));
            if (!isNaN(n)) {
              value = String.fromCharCode(n);
            }
          }
          // Fall back to innerHTML otherwise.
          if (!value) {
            // Append a non-entity character to avoid a bug in Webkit that parses
            // an invalid entity at the end of innerHTML text as the empty string.
            div.innerHTML = s + ' ';
            // Then remove the trailing character from the result.
            value = div.firstChild.nodeValue.slice(0, -1);
          }
          // Cache and return.
          return seen[s] = value;
        });
      };

      /**
       * Unescapes XML entities.
       * @private
       * @param {string} str The string to unescape.
       * @return {string} An unescaped copy of {@code str}.
       */
      goog.string.unescapePureXmlEntities_ = function (str) {
        return str.replace(/&([^;]+);/g, function (s, entity) {
          switch (entity) {
            case 'amp':
              return '&';
            case 'lt':
              return '<';
            case 'gt':
              return '>';
            case 'quot':
              return '"';
            default:
              if (entity.charAt(0) == '#') {
                // Prefix with 0 so that hex entities (e.g. &#x10) parse as hex.
                var n = Number('0' + entity.substr(1));
                if (!isNaN(n)) {
                  return String.fromCharCode(n);
                }
              }
              // For invalid entities we just return the entity
              return s;
          }
        });
      };

      /**
       * Regular expression that matches an HTML entity.
       * See also HTML5: Tokenization / Tokenizing character references.
       * @private
       * @type {!RegExp}
       */
      goog.string.HTML_ENTITY_PATTERN_ = /&([^;\s<&]+);?/g;

      /**
       * Determines whether a string contains a substring.
       * @param {string} str The string to search.
       * @param {string} subString The substring to search for.
       * @return {boolean} Whether {@code str} contains {@code subString}.
       */
      goog.string.contains = function (str, subString) {
        return str.indexOf(subString) != -1;
      };

      /**
       * Escapes double quote '"' and single quote '\'' characters in addition to
       * '&', '<', and '>' so that a string can be included in an HTML tag attribute
       * value within double or single quotes.
       *
       * It should be noted that > doesn't need to be escaped for the HTML or XML to
       * be valid, but it has been decided to escape it for consistency with other
       * implementations.
       *
       * With goog.string.DETECT_DOUBLE_ESCAPING, this function escapes also the
       * lowercase letter "e".
       *
       * NOTE(user):
       * HtmlEscape is often called during the generation of large blocks of HTML.
       * Using statics for the regular expressions and strings is an optimization
       * that can more than half the amount of time IE spends in this function for
       * large apps, since strings and regexes both contribute to GC allocations.
       *
       * Testing for the presence of a character before escaping increases the number
       * of function calls, but actually provides a speed increase for the average
       * case -- since the average case often doesn't require the escaping of all 4
       * characters and indexOf() is much cheaper than replace().
       * The worst case does suffer slightly from the additional calls, therefore the
       * opt_isLikelyToContainHtmlChars option has been included for situations
       * where all 4 HTML entities are very likely to be present and need escaping.
       *
       * Some benchmarks (times tended to fluctuate +-0.05ms):
       *                                     FireFox                     IE6
       * (no chars / average (mix of cases) / all 4 chars)
       * no checks                     0.13 / 0.22 / 0.22         0.23 / 0.53 / 0.80
       * indexOf                       0.08 / 0.17 / 0.26         0.22 / 0.54 / 0.84
       * indexOf + re test             0.07 / 0.17 / 0.28         0.19 / 0.50 / 0.85
       *
       * An additional advantage of checking if replace actually needs to be called
       * is a reduction in the number of object allocations, so as the size of the
       * application grows the difference between the various methods would increase.
       *
       * @param {string} str string to be escaped.
       * @param {boolean=} opt_isLikelyToContainHtmlChars Don't perform a check to see
       *     if the character needs replacing - use this option if you expect each of
       *     the characters to appear often. Leave false if you expect few html
       *     characters to occur in your strings, such as if you are escaping HTML.
       * @return {string} An escaped copy of {@code str}.
       */
      goog.string.htmlEscape = function (str, opt_isLikelyToContainHtmlChars) {

        if (opt_isLikelyToContainHtmlChars) {
          str = str.replace(goog.string.AMP_RE_, '&amp;').replace(goog.string.LT_RE_, '&lt;').replace(goog.string.GT_RE_, '&gt;').replace(goog.string.QUOT_RE_, '&quot;').replace(goog.string.SINGLE_QUOTE_RE_, '&#39;').replace(goog.string.NULL_RE_, '&#0;');
          if (goog.string.DETECT_DOUBLE_ESCAPING) {
            str = str.replace(goog.string.E_RE_, '&#101;');
          }
          return str;
        } else {
          // quick test helps in the case when there are no chars to replace, in
          // worst case this makes barely a difference to the time taken
          if (!goog.string.ALL_RE_.test(str)) return str;

          // str.indexOf is faster than regex.test in this case
          if (str.indexOf('&') != -1) {
            str = str.replace(goog.string.AMP_RE_, '&amp;');
          }
          if (str.indexOf('<') != -1) {
            str = str.replace(goog.string.LT_RE_, '&lt;');
          }
          if (str.indexOf('>') != -1) {
            str = str.replace(goog.string.GT_RE_, '&gt;');
          }
          if (str.indexOf('"') != -1) {
            str = str.replace(goog.string.QUOT_RE_, '&quot;');
          }
          if (str.indexOf('\'') != -1) {
            str = str.replace(goog.string.SINGLE_QUOTE_RE_, '&#39;');
          }
          if (str.indexOf('\x00') != -1) {
            str = str.replace(goog.string.NULL_RE_, '&#0;');
          }
          if (goog.string.DETECT_DOUBLE_ESCAPING && str.indexOf('e') != -1) {
            str = str.replace(goog.string.E_RE_, '&#101;');
          }
          return str;
        }
      };

      goog.debug = {};

      /**
       * Returns the type of a value. If a constructor is passed, and a suitable
       * string cannot be found, 'unknown type name' will be returned.
       *
       * <p>Forked rather than moved from {@link goog.asserts.getType_}
       * to avoid adding a dependency to goog.asserts.
       * @param {*} value A constructor, object, or primitive.
       * @return {string} The best display name for the value, or 'unknown type name'.
       */
      goog.debug.runtimeType = function (value) {
        if (value instanceof Function) {
          return value.displayName || value.name || 'unknown type name';
        } else if (value instanceof Object) {
          return value.constructor.displayName || value.constructor.name || Object.prototype.toString.call(value);
        } else {
          return value === null ? 'null' : typeof value === 'undefined' ? 'undefined' : _typeof(value);
        }
      };

      // Copyright 2009 The Closure Library Authors. All Rights Reserved.
      //
      // Licensed under the Apache License, Version 2.0 (the "License");
      // you may not use this file except in compliance with the License.
      // You may obtain a copy of the License at
      //
      //      http://www.apache.org/licenses/LICENSE-2.0
      //
      // Unless required by applicable law or agreed to in writing, software
      // distributed under the License is distributed on an "AS-IS" BASIS,
      // WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
      // See the License for the specific language governing permissions and
      // limitations under the License.

      /**
       * @fileoverview Provides a base class for custom Error objects such that the
       * stack is correctly maintained.
       *
       * You should never need to throw goog.debug.Error(msg) directly, Error(msg) is
       * sufficient.
       *
       */

      /**
       * Base class for custom error objects.
       * @param {*=} opt_msg The message associated with the error.
       * @constructor
       * @extends {Error}
       */
      goog.debug.Error = function (opt_msg) {

        // Attempt to ensure there is a stack trace.
        if (Error.captureStackTrace) {
          Error.captureStackTrace(this, goog.debug.Error);
        } else {
          var stack = new Error().stack;
          if (stack) {
            this.stack = stack;
          }
        }

        if (opt_msg) {
          this.message = String(opt_msg);
        }

        /**
         * Whether to report this error to the server. Setting this to false will
         * cause the error reporter to not report the error back to the server,
         * which can be useful if the client knows that the error has already been
         * logged on the server.
         * @type {boolean}
         */
        this.reportErrorToServer = true;
      };
      goog.inherits(goog.debug.Error, Error);

      /** @override */
      goog.debug.Error.prototype.name = 'CustomError';

      /**
       * @fileoverview Definition of goog.dom.NodeType.
       */

      goog.dom = {};

      /**
       * Constants for the nodeType attribute in the Node interface.
       *
       * These constants match those specified in the Node interface. These are
       * usually present on the Node object in recent browsers, but not in older
       * browsers (specifically, early IEs) and thus are given here.
       *
       * In some browsers (early IEs), these are not defined on the Node object,
       * so they are provided here.
       *
       * See http://www.w3.org/TR/DOM-Level-2-Core/core.html#ID-1950641247
       * @enum {number}
       */
      goog.dom.NodeType = {
        ELEMENT: 1,
        ATTRIBUTE: 2,
        TEXT: 3,
        CDATA_SECTION: 4,
        ENTITY_REFERENCE: 5,
        ENTITY: 6,
        PROCESSING_INSTRUCTION: 7,
        COMMENT: 8,
        DOCUMENT: 9,
        DOCUMENT_TYPE: 10,
        DOCUMENT_FRAGMENT: 11,
        NOTATION: 12
      };

      // Copyright 2007 The Closure Library Authors. All Rights Reserved.
      //
      // Licensed under the Apache License, Version 2.0 (the "License");
      // you may not use this file except in compliance with the License.
      // You may obtain a copy of the License at
      //
      //      http://www.apache.org/licenses/LICENSE-2.0
      //
      // Unless required by applicable law or agreed to in writing, software
      // distributed under the License is distributed on an "AS-IS" BASIS,
      // WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
      // See the License for the specific language governing permissions and
      // limitations under the License.

      /**
       * @fileoverview Utility functions for supporting Bidi issues.
       */

      /**
       * Namespace for bidi supporting functions.
       */
      goog.provide('goog.i18n.bidi');
      goog.provide('goog.i18n.bidi.Dir');
      goog.provide('goog.i18n.bidi.DirectionalString');
      goog.provide('goog.i18n.bidi.Format');

      /**
       * @define {boolean} FORCE_RTL forces the {@link goog.i18n.bidi.IS_RTL} constant
       * to say that the current locale is a RTL locale.  This should only be used
       * if you want to override the default behavior for deciding whether the
       * current locale is RTL or not.
       *
       * {@see goog.i18n.bidi.IS_RTL}
       */
      goog.define('goog.i18n.bidi.FORCE_RTL', false);

      /**
       * Constant that defines whether or not the current locale is a RTL locale.
       * If {@link goog.i18n.bidi.FORCE_RTL} is not true, this constant will default
       * to check that {@link goog.LOCALE} is one of a few major RTL locales.
       *
       * <p>This is designed to be a maximally efficient compile-time constant. For
       * example, for the default goog.LOCALE, compiling
       * "if (goog.i18n.bidi.IS_RTL) alert('rtl') else {}" should produce no code. It
       * is this design consideration that limits the implementation to only
       * supporting a few major RTL locales, as opposed to the broader repertoire of
       * something like goog.i18n.bidi.isRtlLanguage.
       *
       * <p>Since this constant refers to the directionality of the locale, it is up
       * to the caller to determine if this constant should also be used for the
       * direction of the UI.
       *
       * {@see goog.LOCALE}
       *
       * @type {boolean}
       *
       * TODO(user): write a test that checks that this is a compile-time constant.
       */
      goog.i18n.bidi.IS_RTL = goog.i18n.bidi.FORCE_RTL || (goog.LOCALE.substring(0, 2).toLowerCase() == 'ar' || goog.LOCALE.substring(0, 2).toLowerCase() == 'fa' || goog.LOCALE.substring(0, 2).toLowerCase() == 'he' || goog.LOCALE.substring(0, 2).toLowerCase() == 'iw' || goog.LOCALE.substring(0, 2).toLowerCase() == 'ps' || goog.LOCALE.substring(0, 2).toLowerCase() == 'sd' || goog.LOCALE.substring(0, 2).toLowerCase() == 'ug' || goog.LOCALE.substring(0, 2).toLowerCase() == 'ur' || goog.LOCALE.substring(0, 2).toLowerCase() == 'yi') && (goog.LOCALE.length == 2 || goog.LOCALE.substring(2, 3) == '-' || goog.LOCALE.substring(2, 3) == '_') || goog.LOCALE.length >= 3 && goog.LOCALE.substring(0, 3).toLowerCase() == 'ckb' && (goog.LOCALE.length == 3 || goog.LOCALE.substring(3, 4) == '-' || goog.LOCALE.substring(3, 4) == '_');

      /**
       * Unicode formatting characters and directionality string constants.
       * @enum {string}
       */
      goog.i18n.bidi.Format = {
        /** Unicode "Left-To-Right Embedding" (LRE) character. */
        LRE: '\u202A',
        /** Unicode "Right-To-Left Embedding" (RLE) character. */
        RLE: '\u202B',
        /** Unicode "Pop Directional Formatting" (PDF) character. */
        PDF: '\u202C',
        /** Unicode "Left-To-Right Mark" (LRM) character. */
        LRM: '\u200E',
        /** Unicode "Right-To-Left Mark" (RLM) character. */
        RLM: '\u200F'
      };

      /**
       * Directionality enum.
       * @enum {number}
       */
      goog.i18n.bidi.Dir = {
        /**
         * Left-to-right.
         */
        LTR: 1,

        /**
         * Right-to-left.
         */
        RTL: -1,

        /**
         * Neither left-to-right nor right-to-left.
         */
        NEUTRAL: 0
      };

      /**
       * 'right' string constant.
       * @type {string}
       */
      goog.i18n.bidi.RIGHT = 'right';

      /**
       * 'left' string constant.
       * @type {string}
       */
      goog.i18n.bidi.LEFT = 'left';

      /**
       * 'left' if locale is RTL, 'right' if not.
       * @type {string}
       */
      goog.i18n.bidi.I18N_RIGHT = goog.i18n.bidi.IS_RTL ? goog.i18n.bidi.LEFT : goog.i18n.bidi.RIGHT;

      /**
       * 'right' if locale is RTL, 'left' if not.
       * @type {string}
       */
      goog.i18n.bidi.I18N_LEFT = goog.i18n.bidi.IS_RTL ? goog.i18n.bidi.RIGHT : goog.i18n.bidi.LEFT;

      /**
       * Convert a directionality given in various formats to a goog.i18n.bidi.Dir
       * constant. Useful for interaction with different standards of directionality
       * representation.
       *
       * @param {goog.i18n.bidi.Dir|number|boolean|null} givenDir Directionality given
       *     in one of the following formats:
       *     1. A goog.i18n.bidi.Dir constant.
       *     2. A number (positive = LTR, negative = RTL, 0 = neutral).
       *     3. A boolean (true = RTL, false = LTR).
       *     4. A null for unknown directionality.
       * @param {boolean=} opt_noNeutral Whether a givenDir of zero or
       *     goog.i18n.bidi.Dir.NEUTRAL should be treated as null, i.e. unknown, in
       *     order to preserve legacy behavior.
       * @return {?goog.i18n.bidi.Dir} A goog.i18n.bidi.Dir constant matching the
       *     given directionality. If given null, returns null (i.e. unknown).
       */
      goog.i18n.bidi.toDir = function (givenDir, opt_noNeutral) {
        if (typeof givenDir == 'number') {
          // This includes the non-null goog.i18n.bidi.Dir case.
          return givenDir > 0 ? goog.i18n.bidi.Dir.LTR : givenDir < 0 ? goog.i18n.bidi.Dir.RTL : opt_noNeutral ? null : goog.i18n.bidi.Dir.NEUTRAL;
        } else if (givenDir == null) {
          return null;
        } else {
          // Must be typeof givenDir == 'boolean'.
          return givenDir ? goog.i18n.bidi.Dir.RTL : goog.i18n.bidi.Dir.LTR;
        }
      };

      /**
       * A practical pattern to identify strong LTR characters. This pattern is not
       * theoretically correct according to the Unicode standard. It is simplified for
       * performance and small code size.
       * @type {string}
       * @private
       */
      goog.i18n.bidi.ltrChars_ = 'A-Za-z\xC0-\xD6\xD8-\xF6\xF8-\u02B8\u0300-\u0590\u0800-\u1FFF' + '\u200E\u2C00-\uFB1C\uFE00-\uFE6F\uFEFD-\uFFFF';

      /**
       * A practical pattern to identify strong RTL character. This pattern is not
       * theoretically correct according to the Unicode standard. It is simplified
       * for performance and small code size.
       * @type {string}
       * @private
       */
      goog.i18n.bidi.rtlChars_ = '\u0591-\u06EF\u06FA-\u07FF\u200F\uFB1D-\uFDFF\uFE70-\uFEFC';

      /**
       * Simplified regular expression for an HTML tag (opening or closing) or an HTML
       * escape. We might want to skip over such expressions when estimating the text
       * directionality.
       * @type {RegExp}
       * @private
       */
      goog.i18n.bidi.htmlSkipReg_ = /<[^>]*>|&[^;]+;/g;

      /**
       * Returns the input text with spaces instead of HTML tags or HTML escapes, if
       * opt_isStripNeeded is true. Else returns the input as is.
       * Useful for text directionality estimation.
       * Note: the function should not be used in other contexts; it is not 100%
       * correct, but rather a good-enough implementation for directionality
       * estimation purposes.
       * @param {string} str The given string.
       * @param {boolean=} opt_isStripNeeded Whether to perform the stripping.
       *     Default: false (to retain consistency with calling functions).
       * @return {string} The given string cleaned of HTML tags / escapes.
       * @private
       */
      goog.i18n.bidi.stripHtmlIfNeeded_ = function (str, opt_isStripNeeded) {
        return opt_isStripNeeded ? str.replace(goog.i18n.bidi.htmlSkipReg_, '') : str;
      };

      /**
       * Regular expression to check for RTL characters.
       * @type {RegExp}
       * @private
       */
      goog.i18n.bidi.rtlCharReg_ = new RegExp('[' + goog.i18n.bidi.rtlChars_ + ']');

      /**
       * Regular expression to check for LTR characters.
       * @type {RegExp}
       * @private
       */
      goog.i18n.bidi.ltrCharReg_ = new RegExp('[' + goog.i18n.bidi.ltrChars_ + ']');

      /**
       * Test whether the given string has any RTL characters in it.
       * @param {string} str The given string that need to be tested.
       * @param {boolean=} opt_isHtml Whether str is HTML / HTML-escaped.
       *     Default: false.
       * @return {boolean} Whether the string contains RTL characters.
       */
      goog.i18n.bidi.hasAnyRtl = function (str, opt_isHtml) {
        return goog.i18n.bidi.rtlCharReg_.test(goog.i18n.bidi.stripHtmlIfNeeded_(str, opt_isHtml));
      };

      /**
       * Test whether the given string has any RTL characters in it.
       * @param {string} str The given string that need to be tested.
       * @return {boolean} Whether the string contains RTL characters.
       * @deprecated Use hasAnyRtl.
       */
      goog.i18n.bidi.hasRtlChar = goog.i18n.bidi.hasAnyRtl;

      /**
       * Test whether the given string has any LTR characters in it.
       * @param {string} str The given string that need to be tested.
       * @param {boolean=} opt_isHtml Whether str is HTML / HTML-escaped.
       *     Default: false.
       * @return {boolean} Whether the string contains LTR characters.
       */
      goog.i18n.bidi.hasAnyLtr = function (str, opt_isHtml) {
        return goog.i18n.bidi.ltrCharReg_.test(goog.i18n.bidi.stripHtmlIfNeeded_(str, opt_isHtml));
      };

      /**
       * Regular expression pattern to check if the first character in the string
       * is LTR.
       * @type {RegExp}
       * @private
       */
      goog.i18n.bidi.ltrRe_ = new RegExp('^[' + goog.i18n.bidi.ltrChars_ + ']');

      /**
       * Regular expression pattern to check if the first character in the string
       * is RTL.
       * @type {RegExp}
       * @private
       */
      goog.i18n.bidi.rtlRe_ = new RegExp('^[' + goog.i18n.bidi.rtlChars_ + ']');

      /**
       * Check if the first character in the string is RTL or not.
       * @param {string} str The given string that need to be tested.
       * @return {boolean} Whether the first character in str is an RTL char.
       */
      goog.i18n.bidi.isRtlChar = function (str) {
        return goog.i18n.bidi.rtlRe_.test(str);
      };

      /**
       * Check if the first character in the string is LTR or not.
       * @param {string} str The given string that need to be tested.
       * @return {boolean} Whether the first character in str is an LTR char.
       */
      goog.i18n.bidi.isLtrChar = function (str) {
        return goog.i18n.bidi.ltrRe_.test(str);
      };

      /**
       * Check if the first character in the string is neutral or not.
       * @param {string} str The given string that need to be tested.
       * @return {boolean} Whether the first character in str is a neutral char.
       */
      goog.i18n.bidi.isNeutralChar = function (str) {
        return !goog.i18n.bidi.isLtrChar(str) && !goog.i18n.bidi.isRtlChar(str);
      };

      /**
       * Regular expressions to check if a piece of text is of LTR directionality
       * on first character with strong directionality.
       * @type {RegExp}
       * @private
       */
      goog.i18n.bidi.ltrDirCheckRe_ = new RegExp('^[^' + goog.i18n.bidi.rtlChars_ + ']*[' + goog.i18n.bidi.ltrChars_ + ']');

      /**
       * Regular expressions to check if a piece of text is of RTL directionality
       * on first character with strong directionality.
       * @type {RegExp}
       * @private
       */
      goog.i18n.bidi.rtlDirCheckRe_ = new RegExp('^[^' + goog.i18n.bidi.ltrChars_ + ']*[' + goog.i18n.bidi.rtlChars_ + ']');

      /**
       * Check whether the first strongly directional character (if any) is RTL.
       * @param {string} str String being checked.
       * @param {boolean=} opt_isHtml Whether str is HTML / HTML-escaped.
       *     Default: false.
       * @return {boolean} Whether RTL directionality is detected using the first
       *     strongly-directional character method.
       */
      goog.i18n.bidi.startsWithRtl = function (str, opt_isHtml) {
        return goog.i18n.bidi.rtlDirCheckRe_.test(goog.i18n.bidi.stripHtmlIfNeeded_(str, opt_isHtml));
      };

      /**
       * Check whether the first strongly directional character (if any) is RTL.
       * @param {string} str String being checked.
       * @param {boolean=} opt_isHtml Whether str is HTML / HTML-escaped.
       *     Default: false.
       * @return {boolean} Whether RTL directionality is detected using the first
       *     strongly-directional character method.
       * @deprecated Use startsWithRtl.
       */
      goog.i18n.bidi.isRtlText = goog.i18n.bidi.startsWithRtl;

      /**
       * Check whether the first strongly directional character (if any) is LTR.
       * @param {string} str String being checked.
       * @param {boolean=} opt_isHtml Whether str is HTML / HTML-escaped.
       *     Default: false.
       * @return {boolean} Whether LTR directionality is detected using the first
       *     strongly-directional character method.
       */
      goog.i18n.bidi.startsWithLtr = function (str, opt_isHtml) {
        return goog.i18n.bidi.ltrDirCheckRe_.test(goog.i18n.bidi.stripHtmlIfNeeded_(str, opt_isHtml));
      };

      /**
       * Check whether the first strongly directional character (if any) is LTR.
       * @param {string} str String being checked.
       * @param {boolean=} opt_isHtml Whether str is HTML / HTML-escaped.
       *     Default: false.
       * @return {boolean} Whether LTR directionality is detected using the first
       *     strongly-directional character method.
       * @deprecated Use startsWithLtr.
       */
      goog.i18n.bidi.isLtrText = goog.i18n.bidi.startsWithLtr;

      /**
       * Regular expression to check if a string looks like something that must
       * always be LTR even in RTL text, e.g. a URL. When estimating the
       * directionality of text containing these, we treat these as weakly LTR,
       * like numbers.
       * @type {RegExp}
       * @private
       */
      goog.i18n.bidi.isRequiredLtrRe_ = /^http:\/\/.*/;

      /**
       * Check whether the input string either contains no strongly directional
       * characters or looks like a url.
       * @param {string} str String being checked.
       * @param {boolean=} opt_isHtml Whether str is HTML / HTML-escaped.
       *     Default: false.
       * @return {boolean} Whether neutral directionality is detected.
       */
      goog.i18n.bidi.isNeutralText = function (str, opt_isHtml) {
        str = goog.i18n.bidi.stripHtmlIfNeeded_(str, opt_isHtml);
        return goog.i18n.bidi.isRequiredLtrRe_.test(str) || !goog.i18n.bidi.hasAnyLtr(str) && !goog.i18n.bidi.hasAnyRtl(str);
      };

      /**
       * Regular expressions to check if the last strongly-directional character in a
       * piece of text is LTR.
       * @type {RegExp}
       * @private
       */
      goog.i18n.bidi.ltrExitDirCheckRe_ = new RegExp('[' + goog.i18n.bidi.ltrChars_ + '][^' + goog.i18n.bidi.rtlChars_ + ']*$');

      /**
       * Regular expressions to check if the last strongly-directional character in a
       * piece of text is RTL.
       * @type {RegExp}
       * @private
       */
      goog.i18n.bidi.rtlExitDirCheckRe_ = new RegExp('[' + goog.i18n.bidi.rtlChars_ + '][^' + goog.i18n.bidi.ltrChars_ + ']*$');

      /**
       * Check if the exit directionality a piece of text is LTR, i.e. if the last
       * strongly-directional character in the string is LTR.
       * @param {string} str String being checked.
       * @param {boolean=} opt_isHtml Whether str is HTML / HTML-escaped.
       *     Default: false.
       * @return {boolean} Whether LTR exit directionality was detected.
       */
      goog.i18n.bidi.endsWithLtr = function (str, opt_isHtml) {
        return goog.i18n.bidi.ltrExitDirCheckRe_.test(goog.i18n.bidi.stripHtmlIfNeeded_(str, opt_isHtml));
      };

      /**
       * Check if the exit directionality a piece of text is LTR, i.e. if the last
       * strongly-directional character in the string is LTR.
       * @param {string} str String being checked.
       * @param {boolean=} opt_isHtml Whether str is HTML / HTML-escaped.
       *     Default: false.
       * @return {boolean} Whether LTR exit directionality was detected.
       * @deprecated Use endsWithLtr.
       */
      goog.i18n.bidi.isLtrExitText = goog.i18n.bidi.endsWithLtr;

      /**
       * Check if the exit directionality a piece of text is RTL, i.e. if the last
       * strongly-directional character in the string is RTL.
       * @param {string} str String being checked.
       * @param {boolean=} opt_isHtml Whether str is HTML / HTML-escaped.
       *     Default: false.
       * @return {boolean} Whether RTL exit directionality was detected.
       */
      goog.i18n.bidi.endsWithRtl = function (str, opt_isHtml) {
        return goog.i18n.bidi.rtlExitDirCheckRe_.test(goog.i18n.bidi.stripHtmlIfNeeded_(str, opt_isHtml));
      };

      /**
       * Check if the exit directionality a piece of text is RTL, i.e. if the last
       * strongly-directional character in the string is RTL.
       * @param {string} str String being checked.
       * @param {boolean=} opt_isHtml Whether str is HTML / HTML-escaped.
       *     Default: false.
       * @return {boolean} Whether RTL exit directionality was detected.
       * @deprecated Use endsWithRtl.
       */
      goog.i18n.bidi.isRtlExitText = goog.i18n.bidi.endsWithRtl;

      /**
       * A regular expression for matching right-to-left language codes.
       * See {@link #isRtlLanguage} for the design.
       * @type {RegExp}
       * @private
       */
      goog.i18n.bidi.rtlLocalesRe_ = new RegExp('^(ar|ckb|dv|he|iw|fa|nqo|ps|sd|ug|ur|yi|' + '.*[-_](Arab|Hebr|Thaa|Nkoo|Tfng))' + '(?!.*[-_](Latn|Cyrl)($|-|_))($|-|_)', 'i');

      /**
       * Check if a BCP 47 / III language code indicates an RTL language, i.e. either:
       * - a language code explicitly specifying one of the right-to-left scripts,
       *   e.g. "az-Arab", or<p>
       * - a language code specifying one of the languages normally written in a
       *   right-to-left script, e.g. "fa" (Farsi), except ones explicitly specifying
       *   Latin or Cyrillic script (which are the usual LTR alternatives).<p>
       * The list of right-to-left scripts appears in the 100-199 range in
       * http://www.unicode.org/iso15924/iso15924-num.html, of which Arabic and
       * Hebrew are by far the most widely used. We also recognize Thaana, N'Ko, and
       * Tifinagh, which also have significant modern usage. The rest (Syriac,
       * Samaritan, Mandaic, etc.) seem to have extremely limited or no modern usage
       * and are not recognized to save on code size.
       * The languages usually written in a right-to-left script are taken as those
       * with Suppress-Script: Hebr|Arab|Thaa|Nkoo|Tfng  in
       * http://www.iana.org/assignments/language-subtag-registry,
       * as well as Central (or Sorani) Kurdish (ckb), Sindhi (sd) and Uyghur (ug).
       * Other subtags of the language code, e.g. regions like EG (Egypt), are
       * ignored.
       * @param {string} lang BCP 47 (a.k.a III) language code.
       * @return {boolean} Whether the language code is an RTL language.
       */
      goog.i18n.bidi.isRtlLanguage = function (lang) {
        return goog.i18n.bidi.rtlLocalesRe_.test(lang);
      };

      /**
       * Regular expression for bracket guard replacement in text.
       * @type {RegExp}
       * @private
       */
      goog.i18n.bidi.bracketGuardTextRe_ = /(\(.*?\)+)|(\[.*?\]+)|(\{.*?\}+)|(<.*?>+)/g;

      /**
       * Apply bracket guard using LRM and RLM. This is to address the problem of
       * messy bracket display frequently happens in RTL layout.
       * This function works for plain text, not for HTML. In HTML, the opening
       * bracket might be in a different context than the closing bracket (such as
       * an attribute value).
       * @param {string} s The string that need to be processed.
       * @param {boolean=} opt_isRtlContext specifies default direction (usually
       *     direction of the UI).
       * @return {string} The processed string, with all bracket guarded.
       */
      goog.i18n.bidi.guardBracketInText = function (s, opt_isRtlContext) {
        var useRtl = opt_isRtlContext === undefined ? goog.i18n.bidi.hasAnyRtl(s) : opt_isRtlContext;
        var mark = useRtl ? goog.i18n.bidi.Format.RLM : goog.i18n.bidi.Format.LRM;
        return s.replace(goog.i18n.bidi.bracketGuardTextRe_, mark + '$&' + mark);
      };

      /**
       * Enforce the html snippet in RTL directionality regardless overall context.
       * If the html piece was enclosed by tag, dir will be applied to existing
       * tag, otherwise a span tag will be added as wrapper. For this reason, if
       * html snippet start with with tag, this tag must enclose the whole piece. If
       * the tag already has a dir specified, this new one will override existing
       * one in behavior (tested on FF and IE).
       * @param {string} html The string that need to be processed.
       * @return {string} The processed string, with directionality enforced to RTL.
       */
      goog.i18n.bidi.enforceRtlInHtml = function (html) {
        if (html.charAt(0) == '<') {
          return html.replace(/<\w+/, '$& dir=rtl');
        }
        // '\n' is important for FF so that it won't incorrectly merge span groups
        return '\n<span dir=rtl>' + html + '</span>';
      };

      /**
       * Enforce RTL on both end of the given text piece using unicode BiDi formatting
       * characters RLE and PDF.
       * @param {string} text The piece of text that need to be wrapped.
       * @return {string} The wrapped string after process.
       */
      goog.i18n.bidi.enforceRtlInText = function (text) {
        return goog.i18n.bidi.Format.RLE + text + goog.i18n.bidi.Format.PDF;
      };

      /**
       * Enforce the html snippet in RTL directionality regardless overall context.
       * If the html piece was enclosed by tag, dir will be applied to existing
       * tag, otherwise a span tag will be added as wrapper. For this reason, if
       * html snippet start with with tag, this tag must enclose the whole piece. If
       * the tag already has a dir specified, this new one will override existing
       * one in behavior (tested on FF and IE).
       * @param {string} html The string that need to be processed.
       * @return {string} The processed string, with directionality enforced to RTL.
       */
      goog.i18n.bidi.enforceLtrInHtml = function (html) {
        if (html.charAt(0) == '<') {
          return html.replace(/<\w+/, '$& dir=ltr');
        }
        // '\n' is important for FF so that it won't incorrectly merge span groups
        return '\n<span dir=ltr>' + html + '</span>';
      };

      /**
       * Enforce LTR on both end of the given text piece using unicode BiDi formatting
       * characters LRE and PDF.
       * @param {string} text The piece of text that need to be wrapped.
       * @return {string} The wrapped string after process.
       */
      goog.i18n.bidi.enforceLtrInText = function (text) {
        return goog.i18n.bidi.Format.LRE + text + goog.i18n.bidi.Format.PDF;
      };

      /**
       * Regular expression to find dimensions such as "padding: .3 0.4ex 5px 6;"
       * @type {RegExp}
       * @private
       */
      goog.i18n.bidi.dimensionsRe_ = /:\s*([.\d][.\w]*)\s+([.\d][.\w]*)\s+([.\d][.\w]*)\s+([.\d][.\w]*)/g;

      /**
       * Regular expression for left.
       * @type {RegExp}
       * @private
       */
      goog.i18n.bidi.leftRe_ = /left/gi;

      /**
       * Regular expression for right.
       * @type {RegExp}
       * @private
       */
      goog.i18n.bidi.rightRe_ = /right/gi;

      /**
       * Placeholder regular expression for swapping.
       * @type {RegExp}
       * @private
       */
      goog.i18n.bidi.tempRe_ = /%%%%/g;

      /**
       * Swap location parameters and 'left'/'right' in CSS specification. The
       * processed string will be suited for RTL layout. Though this function can
       * cover most cases, there are always exceptions. It is suggested to put
       * those exceptions in separate group of CSS string.
       * @param {string} cssStr CSS spefication string.
       * @return {string} Processed CSS specification string.
       */
      goog.i18n.bidi.mirrorCSS = function (cssStr) {
        return cssStr.
        // reverse dimensions
        replace(goog.i18n.bidi.dimensionsRe_, ':$1 $4 $3 $2').replace(goog.i18n.bidi.leftRe_, '%%%%'). // swap left and right
        replace(goog.i18n.bidi.rightRe_, goog.i18n.bidi.LEFT).replace(goog.i18n.bidi.tempRe_, goog.i18n.bidi.RIGHT);
      };

      /**
       * Regular expression for hebrew double quote substitution, finding quote
       * directly after hebrew characters.
       * @type {RegExp}
       * @private
       */
      goog.i18n.bidi.doubleQuoteSubstituteRe_ = /([\u0591-\u05f2])"/g;

      /**
       * Regular expression for hebrew single quote substitution, finding quote
       * directly after hebrew characters.
       * @type {RegExp}
       * @private
       */
      goog.i18n.bidi.singleQuoteSubstituteRe_ = /([\u0591-\u05f2])'/g;

      /**
       * Replace the double and single quote directly after a Hebrew character with
       * GERESH and GERSHAYIM. In such case, most likely that's user intention.
       * @param {string} str String that need to be processed.
       * @return {string} Processed string with double/single quote replaced.
       */
      goog.i18n.bidi.normalizeHebrewQuote = function (str) {
        return str.replace(goog.i18n.bidi.doubleQuoteSubstituteRe_, '$1\u05F4').replace(goog.i18n.bidi.singleQuoteSubstituteRe_, '$1\u05F3');
      };

      /**
       * Regular expression to split a string into "words" for directionality
       * estimation based on relative word counts.
       * @type {RegExp}
       * @private
       */
      goog.i18n.bidi.wordSeparatorRe_ = /\s+/;

      /**
       * Regular expression to check if a string contains any numerals. Used to
       * differentiate between completely neutral strings and those containing
       * numbers, which are weakly LTR.
       *
       * Native Arabic digits (\u0660 - \u0669) are not included because although they
       * do flow left-to-right inside a number, this is the case even if the  overall
       * directionality is RTL, and a mathematical expression using these digits is
       * supposed to flow right-to-left overall, including unary plus and minus
       * appearing to the right of a number, and this does depend on the overall
       * directionality being RTL. The digits used in Farsi (\u06F0 - \u06F9), on the
       * other hand, are included, since Farsi math (including unary plus and minus)
       * does flow left-to-right.
       *
       * @type {RegExp}
       * @private
       */
      goog.i18n.bidi.hasNumeralsRe_ = /[\d\u06f0-\u06f9]/;

      /**
       * This constant controls threshold of RTL directionality.
       * @type {number}
       * @private
       */
      goog.i18n.bidi.rtlDetectionThreshold_ = 0.40;

      /**
       * Estimates the directionality of a string based on relative word counts.
       * If the number of RTL words is above a certain percentage of the total number
       * of strongly directional words, returns RTL.
       * Otherwise, if any words are strongly or weakly LTR, returns LTR.
       * Otherwise, returns UNKNOWN, which is used to mean "neutral".
       * Numbers are counted as weakly LTR.
       * @param {string} str The string to be checked.
       * @param {boolean=} opt_isHtml Whether str is HTML / HTML-escaped.
       *     Default: false.
       * @return {goog.i18n.bidi.Dir} Estimated overall directionality of {@code str}.
       */
      goog.i18n.bidi.estimateDirection = function (str, opt_isHtml) {
        var rtlCount = 0;
        var totalCount = 0;
        var hasWeaklyLtr = false;
        var tokens = goog.i18n.bidi.stripHtmlIfNeeded_(str, opt_isHtml).split(goog.i18n.bidi.wordSeparatorRe_);
        for (var i = 0; i < tokens.length; i++) {
          var token = tokens[i];
          if (goog.i18n.bidi.startsWithRtl(token)) {
            rtlCount++;
            totalCount++;
          } else if (goog.i18n.bidi.isRequiredLtrRe_.test(token)) {
            hasWeaklyLtr = true;
          } else if (goog.i18n.bidi.hasAnyLtr(token)) {
            totalCount++;
          } else if (goog.i18n.bidi.hasNumeralsRe_.test(token)) {
            hasWeaklyLtr = true;
          }
        }

        return totalCount == 0 ? hasWeaklyLtr ? goog.i18n.bidi.Dir.LTR : goog.i18n.bidi.Dir.NEUTRAL : rtlCount / totalCount > goog.i18n.bidi.rtlDetectionThreshold_ ? goog.i18n.bidi.Dir.RTL : goog.i18n.bidi.Dir.LTR;
      };

      /**
       * Check the directionality of a piece of text, return true if the piece of
       * text should be laid out in RTL direction.
       * @param {string} str The piece of text that need to be detected.
       * @param {boolean=} opt_isHtml Whether str is HTML / HTML-escaped.
       *     Default: false.
       * @return {boolean} Whether this piece of text should be laid out in RTL.
       */
      goog.i18n.bidi.detectRtlDirectionality = function (str, opt_isHtml) {
        return goog.i18n.bidi.estimateDirection(str, opt_isHtml) == goog.i18n.bidi.Dir.RTL;
      };

      /**
       * Sets text input element's directionality and text alignment based on a
       * given directionality. Does nothing if the given directionality is unknown or
       * neutral.
       * @param {Element} element Input field element to set directionality to.
       * @param {goog.i18n.bidi.Dir|number|boolean|null} dir Desired directionality,
       *     given in one of the following formats:
       *     1. A goog.i18n.bidi.Dir constant.
       *     2. A number (positive = LRT, negative = RTL, 0 = neutral).
       *     3. A boolean (true = RTL, false = LTR).
       *     4. A null for unknown directionality.
       */
      goog.i18n.bidi.setElementDirAndAlign = function (element, dir) {
        if (element) {
          dir = goog.i18n.bidi.toDir(dir);
          if (dir) {
            element.style.textAlign = dir == goog.i18n.bidi.Dir.RTL ? goog.i18n.bidi.RIGHT : goog.i18n.bidi.LEFT;
            element.dir = dir == goog.i18n.bidi.Dir.RTL ? 'rtl' : 'ltr';
          }
        }
      };

      /**
       * Sets element dir based on estimated directionality of the given text.
       * @param {!Element} element
       * @param {string} text
       */
      goog.i18n.bidi.setElementDirByTextDirectionality = function (element, text) {
        switch (goog.i18n.bidi.estimateDirection(text)) {
          case goog.i18n.bidi.Dir.LTR:
            element.dir = 'ltr';
            break;
          case goog.i18n.bidi.Dir.RTL:
            element.dir = 'rtl';
            break;
          default:
            // Default for no direction, inherit from document.
            element.removeAttribute('dir');
        }
      };

      /**
       * Strings that have an (optional) known direction.
       *
       * Implementations of this interface are string-like objects that carry an
       * attached direction, if known.
       * @interface
       */
      goog.i18n.bidi.DirectionalString = function () {};

      /**
       * Interface marker of the DirectionalString interface.
       *
       * This property can be used to determine at runtime whether or not an object
       * implements this interface.  All implementations of this interface set this
       * property to {@code true}.
       * @type {boolean}
       */
      goog.i18n.bidi.DirectionalString.prototype.implementsGoogI18nBidiDirectionalString;

      /**
       * Retrieves this object's known direction (if any).
       * @return {?goog.i18n.bidi.Dir} The known direction. Null if unknown.
       */
      goog.i18n.bidi.DirectionalString.prototype.getDirection;

      // Copyright 2008 The Closure Library Authors. All Rights Reserved.
      //
      // Licensed under the Apache License, Version 2.0 (the "License");
      // you may not use this file except in compliance with the License.
      // You may obtain a copy of the License at
      //
      //      http://www.apache.org/licenses/LICENSE-2.0
      //
      // Unless required by applicable law or agreed to in writing, software
      // distributed under the License is distributed on an "AS-IS" BASIS,
      // WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
      // See the License for the specific language governing permissions and
      // limitations under the License.

      /**
       * @fileoverview Utilities to check the preconditions, postconditions and
       * invariants runtime.
       *
       * Methods in this package should be given special treatment by the compiler
       * for type-inference. For example, <code>goog.asserts.assert(foo)</code>
       * will restrict <code>foo</code> to a truthy value.
       *
       * The compiler has an option to disable asserts. So code like:
       * <code>
       * var x = goog.asserts.assert(foo()); goog.asserts.assert(bar());
       * </code>
       * will be transformed into:
       * <code>
       * var x = foo();
       * </code>
       * The compiler will leave in foo() (because its return value is used),
       * but it will remove bar() because it assumes it does not have side-effects.
       *
       * @author agrieve@google.com (Andrew Grieve)
       */

      goog.provide('goog.asserts');

      /**
       * @define {boolean} Whether to strip out asserts or to leave them in.
       */
      goog.define('goog.asserts.ENABLE_ASSERTS', goog.DEBUG);

      /**
       * Error object for failed assertions.
       * @param {string} messagePattern The pattern that was used to form message.
       * @param {!Array<*>} messageArgs The items to substitute into the pattern.
       * @constructor
       * @extends {goog.debug.Error}
       * @final
       */
      goog.asserts.AssertionError = function (messagePattern, messageArgs) {
        messageArgs.unshift(messagePattern);
        goog.debug.Error.call(this, goog.string.subs.apply(null, messageArgs));
        // Remove the messagePattern afterwards to avoid permanently modifying the
        // passed in array.
        messageArgs.shift();

        /**
         * The message pattern used to format the error message. Error handlers can
         * use this to uniquely identify the assertion.
         * @type {string}
         */
        this.messagePattern = messagePattern;
      };
      goog.inherits(goog.asserts.AssertionError, goog.debug.Error);

      /** @override */
      goog.asserts.AssertionError.prototype.name = 'AssertionError';

      /**
       * The default error handler.
       * @param {!goog.asserts.AssertionError} e The exception to be handled.
       */
      goog.asserts.DEFAULT_ERROR_HANDLER = function (e) {
        throw e;
      };

      /**
       * The handler responsible for throwing or logging assertion errors.
       * @private {function(!goog.asserts.AssertionError)}
       */
      goog.asserts.errorHandler_ = goog.asserts.DEFAULT_ERROR_HANDLER;

      /**
       * Throws an exception with the given message and "Assertion failed" prefixed
       * onto it.
       * @param {string} defaultMessage The message to use if givenMessage is empty.
       * @param {Array<*>} defaultArgs The substitution arguments for defaultMessage.
       * @param {string|undefined} givenMessage Message supplied by the caller.
       * @param {Array<*>} givenArgs The substitution arguments for givenMessage.
       * @throws {goog.asserts.AssertionError} When the value is not a number.
       * @private
       */
      goog.asserts.doAssertFailure_ = function (defaultMessage, defaultArgs, givenMessage, givenArgs) {
        var message = 'Assertion failed';
        if (givenMessage) {
          message += ': ' + givenMessage;
          var args = givenArgs;
        } else if (defaultMessage) {
          message += ': ' + defaultMessage;
          args = defaultArgs;
        }
        // The '' + works around an Opera 10 bug in the unit tests. Without it,
        // a stack trace is added to var message above. With this, a stack trace is
        // not added until this line (it causes the extra garbage to be added after
        // the assertion message instead of in the middle of it).
        var e = new goog.asserts.AssertionError('' + message, args || []);
        goog.asserts.errorHandler_(e);
      };

      /**
       * Sets a custom error handler that can be used to customize the behavior of
       * assertion failures, for example by turning all assertion failures into log
       * messages.
       * @param {function(!goog.asserts.AssertionError)} errorHandler
       */
      goog.asserts.setErrorHandler = function (errorHandler) {
        if (goog.asserts.ENABLE_ASSERTS) {
          goog.asserts.errorHandler_ = errorHandler;
        }
      };

      /**
       * Checks if the condition evaluates to true if goog.asserts.ENABLE_ASSERTS is
       * true.
       * @template T
       * @param {T} condition The condition to check.
       * @param {string=} opt_message Error message in case of failure.
       * @param {...*} var_args The items to substitute into the failure message.
       * @return {T} The value of the condition.
       * @throws {goog.asserts.AssertionError} When the condition evaluates to false.
       */
      goog.asserts.assert = function (condition, opt_message, var_args) {
        if (goog.asserts.ENABLE_ASSERTS && !condition) {
          goog.asserts.doAssertFailure_('', null, opt_message, Array.prototype.slice.call(arguments, 2));
        }
        return condition;
      };

      /**
       * Fails if goog.asserts.ENABLE_ASSERTS is true. This function is useful in case
       * when we want to add a check in the unreachable area like switch-case
       * statement:
       *
       * <pre>
       *  switch(type) {
       *    case FOO: doSomething(); break;
       *    case BAR: doSomethingElse(); break;
       *    default: goog.assert.fail('Unrecognized type: ' + type);
       *      // We have only 2 types - "default:" section is unreachable code.
       *  }
       * </pre>
       *
       * @param {string=} opt_message Error message in case of failure.
       * @param {...*} var_args The items to substitute into the failure message.
       * @throws {goog.asserts.AssertionError} Failure.
       */
      goog.asserts.fail = function (opt_message, var_args) {
        if (goog.asserts.ENABLE_ASSERTS) {
          goog.asserts.errorHandler_(new goog.asserts.AssertionError('Failure' + (opt_message ? ': ' + opt_message : ''), Array.prototype.slice.call(arguments, 1)));
        }
      };

      /**
       * Checks if the value is a number if goog.asserts.ENABLE_ASSERTS is true.
       * @param {*} value The value to check.
       * @param {string=} opt_message Error message in case of failure.
       * @param {...*} var_args The items to substitute into the failure message.
       * @return {number} The value, guaranteed to be a number when asserts enabled.
       * @throws {goog.asserts.AssertionError} When the value is not a number.
       */
      goog.asserts.assertNumber = function (value, opt_message, var_args) {
        if (goog.asserts.ENABLE_ASSERTS && !goog.isNumber(value)) {
          goog.asserts.doAssertFailure_('Expected number but got %s: %s.', [goog.typeOf(value), value], opt_message, Array.prototype.slice.call(arguments, 2));
        }
        return (/** @type {number} */value
        );
      };

      /**
       * Checks if the value is a string if goog.asserts.ENABLE_ASSERTS is true.
       * @param {*} value The value to check.
       * @param {string=} opt_message Error message in case of failure.
       * @param {...*} var_args The items to substitute into the failure message.
       * @return {string} The value, guaranteed to be a string when asserts enabled.
       * @throws {goog.asserts.AssertionError} When the value is not a string.
       */
      goog.asserts.assertString = function (value, opt_message, var_args) {
        if (goog.asserts.ENABLE_ASSERTS && !goog.isString(value)) {
          goog.asserts.doAssertFailure_('Expected string but got %s: %s.', [goog.typeOf(value), value], opt_message, Array.prototype.slice.call(arguments, 2));
        }
        return (/** @type {string} */value
        );
      };

      /**
       * Checks if the value is a function if goog.asserts.ENABLE_ASSERTS is true.
       * @param {*} value The value to check.
       * @param {string=} opt_message Error message in case of failure.
       * @param {...*} var_args The items to substitute into the failure message.
       * @return {!Function} The value, guaranteed to be a function when asserts
       *     enabled.
       * @throws {goog.asserts.AssertionError} When the value is not a function.
       */
      goog.asserts.assertFunction = function (value, opt_message, var_args) {
        if (goog.asserts.ENABLE_ASSERTS && !goog.isFunction(value)) {
          goog.asserts.doAssertFailure_('Expected function but got %s: %s.', [goog.typeOf(value), value], opt_message, Array.prototype.slice.call(arguments, 2));
        }
        return (/** @type {!Function} */value
        );
      };

      /**
       * Checks if the value is an Object if goog.asserts.ENABLE_ASSERTS is true.
       * @param {*} value The value to check.
       * @param {string=} opt_message Error message in case of failure.
       * @param {...*} var_args The items to substitute into the failure message.
       * @return {!Object} The value, guaranteed to be a non-null object.
       * @throws {goog.asserts.AssertionError} When the value is not an object.
       */
      goog.asserts.assertObject = function (value, opt_message, var_args) {
        if (goog.asserts.ENABLE_ASSERTS && !goog.isObject(value)) {
          goog.asserts.doAssertFailure_('Expected object but got %s: %s.', [goog.typeOf(value), value], opt_message, Array.prototype.slice.call(arguments, 2));
        }
        return (/** @type {!Object} */value
        );
      };

      /**
       * Checks if the value is an Array if goog.asserts.ENABLE_ASSERTS is true.
       * @param {*} value The value to check.
       * @param {string=} opt_message Error message in case of failure.
       * @param {...*} var_args The items to substitute into the failure message.
       * @return {!Array<?>} The value, guaranteed to be a non-null array.
       * @throws {goog.asserts.AssertionError} When the value is not an array.
       */
      goog.asserts.assertArray = function (value, opt_message, var_args) {
        if (goog.asserts.ENABLE_ASSERTS && !goog.isArray(value)) {
          goog.asserts.doAssertFailure_('Expected array but got %s: %s.', [goog.typeOf(value), value], opt_message, Array.prototype.slice.call(arguments, 2));
        }
        return (/** @type {!Array<?>} */value
        );
      };

      /**
       * Checks if the value is a boolean if goog.asserts.ENABLE_ASSERTS is true.
       * @param {*} value The value to check.
       * @param {string=} opt_message Error message in case of failure.
       * @param {...*} var_args The items to substitute into the failure message.
       * @return {boolean} The value, guaranteed to be a boolean when asserts are
       *     enabled.
       * @throws {goog.asserts.AssertionError} When the value is not a boolean.
       */
      goog.asserts.assertBoolean = function (value, opt_message, var_args) {
        if (goog.asserts.ENABLE_ASSERTS && !goog.isBoolean(value)) {
          goog.asserts.doAssertFailure_('Expected boolean but got %s: %s.', [goog.typeOf(value), value], opt_message, Array.prototype.slice.call(arguments, 2));
        }
        return (/** @type {boolean} */value
        );
      };

      /**
       * Checks if the value is a DOM Element if goog.asserts.ENABLE_ASSERTS is true.
       * @param {*} value The value to check.
       * @param {string=} opt_message Error message in case of failure.
       * @param {...*} var_args The items to substitute into the failure message.
       * @return {!Element} The value, likely to be a DOM Element when asserts are
       *     enabled.
       * @throws {goog.asserts.AssertionError} When the value is not an Element.
       */
      goog.asserts.assertElement = function (value, opt_message, var_args) {
        if (goog.asserts.ENABLE_ASSERTS && (!goog.isObject(value) || value.nodeType != goog.dom.NodeType.ELEMENT)) {
          goog.asserts.doAssertFailure_('Expected Element but got %s: %s.', [goog.typeOf(value), value], opt_message, Array.prototype.slice.call(arguments, 2));
        }
        return (/** @type {!Element} */value
        );
      };

      /**
       * Checks if the value is an instance of the user-defined type if
       * goog.asserts.ENABLE_ASSERTS is true.
       *
       * The compiler may tighten the type returned by this function.
       *
       * @param {?} value The value to check.
       * @param {function(new: T, ...)} type A user-defined constructor.
       * @param {string=} opt_message Error message in case of failure.
       * @param {...*} var_args The items to substitute into the failure message.
       * @throws {goog.asserts.AssertionError} When the value is not an instance of
       *     type.
       * @return {T}
       * @template T
       */
      goog.asserts.assertInstanceof = function (value, type, opt_message, var_args) {
        if (goog.asserts.ENABLE_ASSERTS && !(value instanceof type)) {
          goog.asserts.doAssertFailure_('Expected instanceof %s but got %s.', [goog.asserts.getType_(type), goog.asserts.getType_(value)], opt_message, Array.prototype.slice.call(arguments, 3));
        }
        return value;
      };

      /**
       * Checks that no enumerable keys are present in Object.prototype. Such keys
       * would break most code that use {@code for (var ... in ...)} loops.
       */
      goog.asserts.assertObjectPrototypeIsIntact = function () {
        for (var key in Object.prototype) {
          goog.asserts.fail(key + ' should not be enumerable in Object.prototype.');
        }
      };

      /**
       * Returns the type of a value. If a constructor is passed, and a suitable
       * string cannot be found, 'unknown type name' will be returned.
       * @param {*} value A constructor, object, or primitive.
       * @return {string} The best display name for the value, or 'unknown type name'.
       * @private
       */
      goog.asserts.getType_ = function (value) {
        if (value instanceof Function) {
          return value.displayName || value.name || 'unknown type name';
        } else if (value instanceof Object) {
          return value.constructor.displayName || value.constructor.name || Object.prototype.toString.call(value);
        } else {
          return value === null ? 'null' : typeof value === 'undefined' ? 'undefined' : _typeof(value);
        }
      };

      /**
       * @fileoverview Utility for fast string concatenation.
       */

      /**
       * Utility class to facilitate string concatenation.
       *
       * @param {*=} opt_a1 Optional first initial item to append.
       * @param {...*} var_args Other initial items to
       *     append, e.g., new goog.string.StringBuffer('foo', 'bar').
       * @constructor
       */
      goog.string.StringBuffer = function (opt_a1, var_args) {
        if (opt_a1 != null) {
          this.append.apply(this, arguments);
        }
      };

      /**
       * Internal buffer for the string to be concatenated.
       * @type {string}
       * @private
       */
      goog.string.StringBuffer.prototype.buffer_ = '';

      /**
       * Sets the contents of the string buffer object, replacing what's currently
       * there.
       *
       * @param {*} s String to set.
       */
      goog.string.StringBuffer.prototype.set = function (s) {
        this.buffer_ = '' + s;
      };

      /**
       * Appends one or more items to the buffer.
       *
       * Calling this with null, undefined, or empty arguments is an error.
       *
       * @param {*} a1 Required first string.
       * @param {*=} opt_a2 Optional second string.
       * @param {...?} var_args Other items to append,
       *     e.g., sb.append('foo', 'bar', 'baz').
       * @return {!goog.string.StringBuffer} This same StringBuffer object.
       * @suppress {duplicate}
       */
      goog.string.StringBuffer.prototype.append = function (a1, opt_a2, var_args) {
        // Use a1 directly to avoid arguments instantiation for single-arg case.
        this.buffer_ += String(a1);
        if (opt_a2 != null) {
          // second argument is undefined (null == undefined)
          for (var i = 1; i < arguments.length; i++) {
            this.buffer_ += arguments[i];
          }
        }
        return this;
      };

      /**
       * Clears the internal buffer.
       */
      goog.string.StringBuffer.prototype.clear = function () {
        this.buffer_ = '';
      };

      /**
       * @return {number} the length of the current contents of the buffer.
       */
      goog.string.StringBuffer.prototype.getLength = function () {
        return this.buffer_.length;
      };

      /**
       * @return {string} The concatenated string.
       * @override
       */
      goog.string.StringBuffer.prototype.toString = function () {
        return this.buffer_;
      };

      // Copyright 2012 The Closure Library Authors. All Rights Reserved.
      //
      // Licensed under the Apache License, Version 2.0 (the "License");
      // you may not use this file except in compliance with the License.
      // You may obtain a copy of the License at
      //
      //      http://www.apache.org/licenses/LICENSE-2.0
      //
      // Unless required by applicable law or agreed to in writing, software
      // distributed under the License is distributed on an "AS-IS" BASIS,
      // WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
      // See the License for the specific language governing permissions and
      // limitations under the License.

      /**
       * @fileoverview Soy data primitives.
       *
       * The goal is to encompass data types used by Soy, especially to mark content
       * as known to be "safe".
       *
       * @author gboyer@google.com (Garrett Boyer)
       */

      goog.soy = {};
      goog.soy.data = {};

      /**
       * A type of textual content.
       *
       * This is an enum of type Object so that these values are unforgeable.
       *
       * @enum {!Object}
       */
      goog.soy.data.SanitizedContentKind = {

        /**
         * A snippet of HTML that does not start or end inside a tag, comment, entity,
         * or DOCTYPE; and that does not contain any executable code
         * (JS, {@code <object>}s, etc.) from a different trust domain.
         */
        HTML: goog.DEBUG ? { sanitizedContentKindHtml: true } : {},

        /**
         * Executable Javascript code or expression, safe for insertion in a
         * script-tag or event handler context, known to be free of any
         * attacker-controlled scripts. This can either be side-effect-free
         * Javascript (such as JSON) or Javascript that's entirely under Google's
         * control.
         */
        JS: goog.DEBUG ? { sanitizedContentJsChars: true } : {},

        /** A properly encoded portion of a URI. */
        URI: goog.DEBUG ? { sanitizedContentUri: true } : {},

        /** A resource URI not under attacker control. */
        TRUSTED_RESOURCE_URI: goog.DEBUG ? { sanitizedContentTrustedResourceUri: true } : {},

        /**
         * Repeated attribute names and values. For example,
         * {@code dir="ltr" foo="bar" onclick="trustedFunction()" checked}.
         */
        ATTRIBUTES: goog.DEBUG ? { sanitizedContentHtmlAttribute: true } : {},

        // TODO: Consider separating rules, declarations, and values into
        // separate types, but for simplicity, we'll treat explicitly blessed
        // SanitizedContent as allowed in all of these contexts.
        /**
         * A CSS3 declaration, property, value or group of semicolon separated
         * declarations.
         */
        STYLE: goog.DEBUG ? { sanitizedContentStyle: true } : {},

        /** A CSS3 style sheet (list of rules). */
        CSS: goog.DEBUG ? { sanitizedContentCss: true } : {},

        /**
         * Unsanitized plain-text content.
         *
         * This is effectively the "null" entry of this enum, and is sometimes used
         * to explicitly mark content that should never be used unescaped. Since any
         * string is safe to use as text, being of ContentKind.TEXT makes no
         * guarantees about its safety in any other context such as HTML.
         */
        TEXT: goog.DEBUG ? { sanitizedContentKindText: true } : {}
      };

      /**
       * A string-like object that carries a content-type and a content direction.
       *
       * IMPORTANT! Do not create these directly, nor instantiate the subclasses.
       * Instead, use a trusted, centrally reviewed library as endorsed by your team
       * to generate these objects. Otherwise, you risk accidentally creating
       * SanitizedContent that is attacker-controlled and gets evaluated unescaped in
       * templates.
       *
       * @constructor
       */
      goog.soy.data.SanitizedContent = function () {
        throw new Error('Do not instantiate directly');
      };

      /**
       * The context in which this content is safe from XSS attacks.
       * @type {goog.soy.data.SanitizedContentKind}
       */
      goog.soy.data.SanitizedContent.prototype.contentKind;

      /**
       * The content's direction; null if unknown and thus to be estimated when
       * necessary.
       * @type {?goog.i18n.bidi.Dir}
       */
      goog.soy.data.SanitizedContent.prototype.contentDir = null;

      /**
       * The already-safe content.
       * @protected {string}
       */
      goog.soy.data.SanitizedContent.prototype.content;

      /**
       * Gets the already-safe content.
       * @return {string}
       */
      goog.soy.data.SanitizedContent.prototype.getContent = function () {
        return this.content;
      };

      /** @override */
      goog.soy.data.SanitizedContent.prototype.toString = function () {
        return this.content;
      };

      /**
       * Converts sanitized content of kind TEXT or HTML into SafeHtml. HTML content
       * is converted without modification, while text content is HTML-escaped.
       * @return {!goog.html.SafeHtml}
       * @throws {Error} when the content kind is not TEXT or HTML.
       */
      goog.soy.data.SanitizedContent.prototype.toSafeHtml = function () {
        if (this.contentKind === goog.soy.data.SanitizedContentKind.TEXT) {
          return goog.html.SafeHtml.htmlEscape(this.toString());
        }
        if (this.contentKind !== goog.soy.data.SanitizedContentKind.HTML) {
          throw new Error('Sanitized content was not of kind TEXT or HTML.');
        }
        return goog.html.uncheckedconversions.safeHtmlFromStringKnownToSatisfyTypeContract(goog.string.Const.from('Soy SanitizedContent of kind HTML produces ' + 'SafeHtml-contract-compliant value.'), this.toString(), this.contentDir);
      };

      /**
       * Converts sanitized content of kind URI into SafeUrl without modification.
       * @return {!goog.html.SafeUrl}
       * @throws {Error} when the content kind is not URI.
       */
      goog.soy.data.SanitizedContent.prototype.toSafeUrl = function () {
        if (this.contentKind !== goog.soy.data.SanitizedContentKind.URI) {
          throw new Error('Sanitized content was not of kind URI.');
        }
        return goog.html.uncheckedconversions.safeUrlFromStringKnownToSatisfyTypeContract(goog.string.Const.from('Soy SanitizedContent of kind URI produces ' + 'SafeHtml-contract-compliant value.'), this.toString());
      };

      /**
       * Unsanitized plain text string.
       *
       * While all strings are effectively safe to use as a plain text, there are no
       * guarantees about safety in any other context such as HTML. This is
       * sometimes used to mark that should never be used unescaped.
       *
       * @param {*} content Plain text with no guarantees.
       * @param {?goog.i18n.bidi.Dir=} opt_contentDir The content direction; null if
       *     unknown and thus to be estimated when necessary. Default: null.
       * @extends {goog.soy.data.SanitizedContent}
       * @constructor
       */
      goog.soy.data.UnsanitizedText = function (content, opt_contentDir) {
        // Not calling the superclass constructor which just throws an exception.

        /** @override */
        this.content = String(content);
        this.contentDir = opt_contentDir != null ? opt_contentDir : null;
      };
      goog.inherits(goog.soy.data.UnsanitizedText, goog.soy.data.SanitizedContent);

      /** @override */
      goog.soy.data.UnsanitizedText.prototype.contentKind = goog.soy.data.SanitizedContentKind.TEXT;

      /**
       * Content of type {@link goog.soy.data.SanitizedContentKind.HTML}.
       *
       * The content is a string of HTML that can safely be embedded in a PCDATA
       * context in your app.  If you would be surprised to find that an HTML
       * sanitizer produced {@code s} (e.g.  it runs code or fetches bad URLs) and
       * you wouldn't write a template that produces {@code s} on security or privacy
       * grounds, then don't pass {@code s} here. The default content direction is
       * unknown, i.e. to be estimated when necessary.
       *
       * @extends {goog.soy.data.SanitizedContent}
       * @constructor
       */
      goog.soy.data.SanitizedHtml = function () {
        goog.soy.data.SanitizedHtml.base(this, 'constructor');
      };
      goog.inherits(goog.soy.data.SanitizedHtml, goog.soy.data.SanitizedContent);

      /** @override */
      goog.soy.data.SanitizedHtml.prototype.contentKind = goog.soy.data.SanitizedContentKind.HTML;

      /**
       * Checks if the value could be used as the Soy type {html}.
       * @param {*} value
       * @return {boolean}
       */
      goog.soy.data.SanitizedHtml.isCompatibleWith = function (value) {
        return goog.isString(value) || value instanceof goog.soy.data.SanitizedHtml || value instanceof goog.soy.data.UnsanitizedText || value instanceof goog.html.SafeHtml;
      };

      /**
       * Content of type {@link goog.soy.data.SanitizedContentKind.JS}.
       *
       * The content is JavaScript source that when evaluated does not execute any
       * attacker-controlled scripts. The content direction is LTR.
       *
       * @extends {goog.soy.data.SanitizedContent}
       * @constructor
       */
      goog.soy.data.SanitizedJs = function () {
        goog.soy.data.SanitizedJs.base(this, 'constructor');
      };
      goog.inherits(goog.soy.data.SanitizedJs, goog.soy.data.SanitizedContent);

      /** @override */
      goog.soy.data.SanitizedJs.prototype.contentKind = goog.soy.data.SanitizedContentKind.JS;

      /** @override */
      goog.soy.data.SanitizedJs.prototype.contentDir = goog.i18n.bidi.Dir.LTR;

      /**
       * Checks if the value could be used as the Soy type {js}.
       * @param {*} value
       * @return {boolean}
       */
      goog.soy.data.SanitizedJs.isCompatibleWith = function (value) {
        return goog.isString(value) || value instanceof goog.soy.data.SanitizedJs || value instanceof goog.soy.data.UnsanitizedText || value instanceof goog.html.SafeScript;
      };

      /**
       * Content of type {@link goog.soy.data.SanitizedContentKind.URI}.
       *
       * The content is a URI chunk that the caller knows is safe to emit in a
       * template. The content direction is LTR.
       *
       * @extends {goog.soy.data.SanitizedContent}
       * @constructor
       */
      goog.soy.data.SanitizedUri = function () {
        goog.soy.data.SanitizedUri.base(this, 'constructor');
      };
      goog.inherits(goog.soy.data.SanitizedUri, goog.soy.data.SanitizedContent);

      /** @override */
      goog.soy.data.SanitizedUri.prototype.contentKind = goog.soy.data.SanitizedContentKind.URI;

      /** @override */
      goog.soy.data.SanitizedUri.prototype.contentDir = goog.i18n.bidi.Dir.LTR;

      /**
       * Checks if the value could be used as the Soy type {uri}.
       * @param {*} value
       * @return {boolean}
       */
      goog.soy.data.SanitizedUri.isCompatibleWith = function (value) {
        return goog.isString(value) || value instanceof goog.soy.data.SanitizedUri || value instanceof goog.soy.data.UnsanitizedText || value instanceof goog.html.SafeUrl || value instanceof goog.html.TrustedResourceUrl || value instanceof goog.Uri;
      };

      /**
       * Content of type
       * {@link goog.soy.data.SanitizedContentKind.TRUSTED_RESOURCE_URI}.
       *
       * The content is a TrustedResourceUri chunk that is not under attacker control.
       * The content direction is LTR.
       *
       * @extends {goog.soy.data.SanitizedContent}
       * @constructor
       */
      goog.soy.data.SanitizedTrustedResourceUri = function () {
        goog.soy.data.SanitizedTrustedResourceUri.base(this, 'constructor');
      };
      goog.inherits(goog.soy.data.SanitizedTrustedResourceUri, goog.soy.data.SanitizedContent);

      /** @override */
      goog.soy.data.SanitizedTrustedResourceUri.prototype.contentKind = goog.soy.data.SanitizedContentKind.TRUSTED_RESOURCE_URI;

      /** @override */
      goog.soy.data.SanitizedTrustedResourceUri.prototype.contentDir = goog.i18n.bidi.Dir.LTR;

      /**
       * Converts sanitized content into TrustedResourceUrl without modification.
       * @return {!goog.html.TrustedResourceUrl}
       */
      goog.soy.data.SanitizedTrustedResourceUri.prototype.toTrustedResourceUrl = function () {
        return goog.html.uncheckedconversions.trustedResourceUrlFromStringKnownToSatisfyTypeContract(goog.string.Const.from('Soy SanitizedContent of kind TRUSTED_RESOURCE_URI produces ' + 'TrustedResourceUrl-contract-compliant value.'), this.toString());
      };

      /**
       * Checks if the value could be used as the Soy type {trusted_resource_uri}.
       * @param {*} value
       * @return {boolean}
       */
      goog.soy.data.SanitizedTrustedResourceUri.isCompatibleWith = function (value) {
        return goog.isString(value) || value instanceof goog.soy.data.SanitizedTrustedResourceUri || value instanceof goog.soy.data.UnsanitizedText || value instanceof goog.html.TrustedResourceUrl;
      };

      /**
       * Content of type {@link goog.soy.data.SanitizedContentKind.ATTRIBUTES}.
       *
       * The content should be safely embeddable within an open tag, such as a
       * key="value" pair. The content direction is LTR.
       *
       * @extends {goog.soy.data.SanitizedContent}
       * @constructor
       */
      goog.soy.data.SanitizedHtmlAttribute = function () {
        goog.soy.data.SanitizedHtmlAttribute.base(this, 'constructor');
      };
      goog.inherits(goog.soy.data.SanitizedHtmlAttribute, goog.soy.data.SanitizedContent);

      /** @override */
      goog.soy.data.SanitizedHtmlAttribute.prototype.contentKind = goog.soy.data.SanitizedContentKind.ATTRIBUTES;

      /** @override */
      goog.soy.data.SanitizedHtmlAttribute.prototype.contentDir = goog.i18n.bidi.Dir.LTR;

      /**
       * Checks if the value could be used as the Soy type {attribute}.
       * @param {*} value
       * @return {boolean}
       */
      goog.soy.data.SanitizedHtmlAttribute.isCompatibleWith = function (value) {
        return goog.isString(value) || value instanceof goog.soy.data.SanitizedHtmlAttribute || value instanceof goog.soy.data.UnsanitizedText;
      };

      /**
       * Content of type {@link goog.soy.data.SanitizedContentKind.STYLE}.
       *
       * The content is non-attacker-exploitable CSS, such as {@code color:#c3d9ff}.
       * The content direction is LTR.
       *
       * @extends {goog.soy.data.SanitizedContent}
       * @constructor
       */
      goog.soy.data.SanitizedStyle = function () {
        goog.soy.data.SanitizedStyle.base(this, 'constructor');
      };
      goog.inherits(goog.soy.data.SanitizedStyle, goog.soy.data.SanitizedContent);

      /** @override */
      goog.soy.data.SanitizedStyle.prototype.contentKind = goog.soy.data.SanitizedContentKind.STYLE;

      /** @override */
      goog.soy.data.SanitizedStyle.prototype.contentDir = goog.i18n.bidi.Dir.LTR;

      /**
       * Checks if the value could be used as the Soy type {css}.
       * @param {*} value
       * @return {boolean}
       */
      goog.soy.data.SanitizedStyle.isCompatibleWith = function (value) {
        return goog.isString(value) || value instanceof goog.soy.data.SanitizedStyle || value instanceof goog.soy.data.UnsanitizedText || value instanceof goog.html.SafeStyle;
      };

      /**
       * Content of type {@link goog.soy.data.SanitizedContentKind.CSS}.
       *
       * The content is non-attacker-exploitable CSS, such as {@code @import url(x)}.
       * The content direction is LTR.
       *
       * @extends {goog.soy.data.SanitizedContent}
       * @constructor
       */
      goog.soy.data.SanitizedCss = function () {
        goog.soy.data.SanitizedCss.base(this, 'constructor');
      };
      goog.inherits(goog.soy.data.SanitizedCss, goog.soy.data.SanitizedContent);

      /** @override */
      goog.soy.data.SanitizedCss.prototype.contentKind = goog.soy.data.SanitizedContentKind.CSS;

      /** @override */
      goog.soy.data.SanitizedCss.prototype.contentDir = goog.i18n.bidi.Dir.LTR;

      /**
       * Checks if the value could be used as the Soy type {css}.
       * @param {*} value
       * @return {boolean}
       */
      goog.soy.data.SanitizedCss.isCompatibleWith = function (value) {
        return goog.isString(value) || value instanceof goog.soy.data.SanitizedCss || value instanceof goog.soy.data.UnsanitizedText || value instanceof goog.html.SafeStyle || // TODO(jakubvrana): Delete.
        value instanceof goog.html.SafeStyleSheet;
      };

      /**
       * Converts SanitizedCss into SafeStyleSheet.
       * Note: SanitizedCss in Soy represents both SafeStyle and SafeStyleSheet in
       * Closure. It's about to be split so that SanitizedCss represents only
       * SafeStyleSheet.
       * @return {!goog.html.SafeStyleSheet}
       */
      goog.soy.data.SanitizedCss.prototype.toSafeStyleSheet = function () {
        var value = this.toString();
        // TODO(jakubvrana): Remove this check when there's a separate type for style
        // declaration.
        goog.asserts.assert(/[@{]|^\s*$/.test(value), 'value doesn\'t look like style sheet: ' + value);
        return goog.html.uncheckedconversions.safeStyleSheetFromStringKnownToSatisfyTypeContract(goog.string.Const.from('Soy SanitizedCss produces SafeStyleSheet-contract-compliant ' + 'value.'), value);
      };
      /*
       * Copyright 2008 Google Inc.
       *
       * Licensed under the Apache License, Version 2.0 (the "License");
       * you may not use this file except in compliance with the License.
       * You may obtain a copy of the License at
       *
       *     http://www.apache.org/licenses/LICENSE-2.0
       *
       * Unless required by applicable law or agreed to in writing, software
       * distributed under the License is distributed on an "AS IS" BASIS,
       * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
       * See the License for the specific language governing permissions and
       * limitations under the License.
       */

      /**
       * @fileoverview
       * Utility functions and classes for Soy.
       *
       * <p>
       * The top portion of this file contains utilities for Soy users:<ul>
       *   <li> soy.StringBuilder: Compatible with the 'stringbuilder' code style.
       * </ul>
       *
       * <p>
       * The bottom portion of this file contains utilities that should only be called
       * by Soy-generated JS code. Please do not use these functions directly from
       * your hand-writen code. Their names all start with '$$'.
       *
       */

      // -----------------------------------------------------------------------------
      // StringBuilder (compatible with the 'stringbuilder' code style).

      (function () {
        var soy = {};
        soy.asserts = {};
        soy.esc = {};
        var soydata = {};

        /**
         * Utility class to facilitate much faster string concatenation in IE,
         * using Array.join() rather than the '+' operator. For other browsers
         * we simply use the '+' operator.
         *
         * @param {Object} var_args Initial items to append,
         *     e.g., new soy.StringBuilder('foo', 'bar').
         * @constructor
         */
        soy.StringBuilder = goog.string.StringBuffer;

        // -----------------------------------------------------------------------------
        // soydata: Defines typed strings, e.g. an HTML string {@code "a<b>c"} is
        // semantically distinct from the plain text string {@code "a<b>c"} and smart
        // templates can take that distinction into account.

        /**
         * A type of textual content.
         *
         * This is an enum of type Object so that these values are unforgeable.
         *
         * @enum {!Object}
         */
        soydata.SanitizedContentKind = goog.soy.data.SanitizedContentKind;

        /**
         * Checks whether a given value is of a given content kind.
         *
         * @param {*} value The value to be examined.
         * @param {soydata.SanitizedContentKind} contentKind The desired content
         *     kind.
         * @return {boolean} Whether the given value is of the given kind.
         * @private
         */
        soydata.isContentKind = function (value, contentKind) {
          // TODO(user): This function should really include the assert on
          // value.constructor that is currently sprinkled at most of the call sites.
          // Unfortunately, that would require a (debug-mode-only) switch statement.
          // TODO(user): Perhaps we should get rid of the contentKind property
          // altogether and only at the constructor.
          return value != null && value.contentKind === contentKind;
        };

        /**
         * Content of type {@link goog.soy.data.SanitizedContentKind.HTML}.
         *
         * The content is a string of HTML that can safely be embedded in a PCDATA
         * context in your app.  If you would be surprised to find that an HTML
         * sanitizer produced {@code s} (e.g.  it runs code or fetches bad URLs) and
         * you wouldn't write a template that produces {@code s} on security or privacy
         * grounds, then don't pass {@code s} here. The default content direction is
         * unknown, i.e. to be estimated when necessary.
         *
         * @constructor
         * @extends {goog.soy.data.SanitizedHtml}
         */
        soydata.SanitizedHtml = function () {
          soydata.SanitizedHtml.base(this, 'constructor'); // Throws an exception.
        };
        goog.inherits(soydata.SanitizedHtml, goog.soy.data.SanitizedHtml);

        /**
         * Returns a SanitizedHtml object for a particular value. The content direction
         * is preserved.
         *
         * This HTML-escapes the value unless it is already SanitizedHtml or SafeHtml.
         *
         * @param {*} value The value to convert. If it is already a SanitizedHtml
         *     object, it is left alone.
         * @return {!soydata.SanitizedHtml} A SanitizedHtml object derived from the
         *     stringified value. It is escaped unless the input is SanitizedHtml or
         *     SafeHtml.
         */
        soydata.SanitizedHtml.from = function (value) {
          // The check is soydata.isContentKind_() inlined for performance.
          if (value != null && value.contentKind === goog.soy.data.SanitizedContentKind.HTML) {
            goog.asserts.assert(value.constructor === goog.soy.data.SanitizedHtml || value.constructor === soydata.SanitizedHtml);
            return (/** @type {!soydata.SanitizedHtml} */value
            );
          }
          if (value instanceof goog.html.SafeHtml) {
            return soydata.VERY_UNSAFE.ordainSanitizedHtml(goog.html.SafeHtml.unwrap(value), value.getDirection());
          }
          return soydata.VERY_UNSAFE.ordainSanitizedHtml(soy.esc.$$escapeHtmlHelper(String(value)), soydata.getContentDir(value));
        };

        /**
         * Checks if the value could be used as the Soy type {html}.
         * @param {*} value
         * @return {boolean}
         */
        soydata.SanitizedHtml.isCompatibleWith = function (value) {
          return goog.isString(value) || value instanceof goog.soy.data.SanitizedHtml || value instanceof goog.soy.data.UnsanitizedText || value instanceof goog.html.SafeHtml;
        };

        /**
         * Content of type {@link soydata.SanitizedContentKind.URI}.
         *
         * The content is a URI chunk that the caller knows is safe to emit in a
         * template. The content direction is LTR.
         *
         * @constructor
         * @extends {goog.soy.data.SanitizedContent}
         */
        soydata.SanitizedUri = function () {
          goog.soy.data.SanitizedContent.call(this); // Throws an exception.
        };
        goog.inherits(soydata.SanitizedUri, goog.soy.data.SanitizedContent);

        /** @override */
        soydata.SanitizedUri.prototype.contentKind = soydata.SanitizedContentKind.URI;

        /** @override */
        soydata.SanitizedUri.prototype.contentDir = goog.i18n.bidi.Dir.LTR;

        /**
         * Unsanitized plain text string.
         *
         * While all strings are effectively safe to use as a plain text, there are no
         * guarantees about safety in any other context such as HTML. This is
         * sometimes used to mark that should never be used unescaped.
         *
         * @param {*} content Plain text with no guarantees.
         * @param {?goog.i18n.bidi.Dir=} opt_contentDir The content direction; null if
         *     unknown and thus to be estimated when necessary. Default: null.
         * @constructor
         * @extends {goog.soy.data.UnsanitizedText}
         */
        soydata.UnsanitizedText = function (content, opt_contentDir) {
          /** @override */
          this.content = String(content);
          this.contentDir = opt_contentDir != null ? opt_contentDir : null;
        };
        goog.inherits(soydata.UnsanitizedText, goog.soy.data.UnsanitizedText);

        /** @override */
        soydata.UnsanitizedText.prototype.contentKind = soydata.SanitizedContentKind.TEXT;

        /**
         * Empty string, used as a type in Soy templates.
         * @enum {string}
         * @private
         */
        soydata.$$EMPTY_STRING_ = {
          VALUE: ''
        };

        /**
         * Creates a factory for SanitizedContent types.
         *
         * This is a hack so that the soydata.VERY_UNSAFE.ordainSanitized* can
         * instantiate Sanitized* classes, without making the Sanitized* constructors
         * publicly usable. Requiring all construction to use the VERY_UNSAFE names
         * helps callers and their reviewers easily tell that creating SanitizedContent
         * is not always safe and calls for careful review.
         *
         * @param {function(new: T)} ctor A constructor.
         * @return {!function(*, ?goog.i18n.bidi.Dir=): T} A factory that takes
         *     content and an optional content direction and returns a new instance. If
         *     the content direction is undefined, ctor.prototype.contentDir is used.
         * @template T
         * @private
         */
        soydata.$$makeSanitizedContentFactory_ = function (ctor) {
          /**
           * @param {string} content
           * @constructor
           * @extends {goog.soy.data.SanitizedContent}
           */
          function InstantiableCtor(content) {
            /** @override */
            this.content = content;
          }
          InstantiableCtor.prototype = ctor.prototype;
          /**
           * Creates a ctor-type SanitizedContent instance.
           *
           * @param {*} content The content to put in the instance.
           * @param {?goog.i18n.bidi.Dir=} opt_contentDir The content direction. If
           *     undefined, ctor.prototype.contentDir is used.
           * @return {!goog.soy.data.SanitizedContent} The new instance. It is actually
           *     of type T above (ctor's type, a descendant of SanitizedContent), but
           *     there is no way to express that here.
           */
          function sanitizedContentFactory(content, opt_contentDir) {
            var result = new InstantiableCtor(String(content));
            if (opt_contentDir !== undefined) {
              result.contentDir = opt_contentDir;
            }
            return result;
          }
          return sanitizedContentFactory;
        };

        /**
         * Creates a factory for SanitizedContent types that should always have their
         * default directionality.
         *
         * This is a hack so that the soydata.VERY_UNSAFE.ordainSanitized* can
         * instantiate Sanitized* classes, without making the Sanitized* constructors
         * publicly usable. Requiring all construction to use the VERY_UNSAFE names
         * helps callers and their reviewers easily tell that creating SanitizedContent
         * is not always safe and calls for careful review.
         *
         * @param {function(new: T, string)} ctor A constructor.
         * @return {!function(*): T} A factory that takes content and returns a new
         *     instance (with default directionality, i.e. ctor.prototype.contentDir).
         * @template T
         * @private
         */
        soydata.$$makeSanitizedContentFactoryWithDefaultDirOnly_ = function (ctor) {
          /**
           * @param {string} content
           * @constructor
           * @extends {goog.soy.data.SanitizedContent}
           */
          function InstantiableCtor(content) {
            /** @override */
            this.content = content;
          }
          InstantiableCtor.prototype = ctor.prototype;
          /**
           * Creates a ctor-type SanitizedContent instance.
           *
           * @param {*} content The content to put in the instance.
           * @return {!goog.soy.data.SanitizedContent} The new instance. It is actually
           *     of type T above (ctor's type, a descendant of SanitizedContent), but
           *     there is no way to express that here.
           */
          function sanitizedContentFactory(content) {
            var result = new InstantiableCtor(String(content));
            return result;
          }
          return sanitizedContentFactory;
        };

        // -----------------------------------------------------------------------------
        // Sanitized content ordainers. Please use these with extreme caution (with the
        // exception of markUnsanitizedText). A good recommendation is to limit usage
        // of these to just a handful of files in your source tree where usages can be
        // carefully audited.


        /**
         * Protects a string from being used in an noAutoescaped context.
         *
         * This is useful for content where there is significant risk of accidental
         * unescaped usage in a Soy template. A great case is for user-controlled
         * data that has historically been a source of vulernabilities.
         *
         * @param {*} content Text to protect.
         * @param {?goog.i18n.bidi.Dir=} opt_contentDir The content direction; null if
         *     unknown and thus to be estimated when necessary. Default: null.
         * @return {!soydata.UnsanitizedText} A wrapper that is rejected by the
         *     Soy noAutoescape print directive.
         */
        soydata.markUnsanitizedText = function (content, opt_contentDir) {
          return new soydata.UnsanitizedText(content, opt_contentDir);
        };

        soydata.VERY_UNSAFE = {};

        /**
        * Takes a leap of faith that the provided content is "safe" to use as a URI
        * in a Soy template.
        *
        * This creates a Soy SanitizedContent object which indicates to Soy there is
        * no need to escape it when printed as a URI (e.g. in an href or src
        * attribute), such as if it's already been encoded or  if it's a Javascript:
        * URI.
        *
        * @param {*} content A chunk of URI that the caller knows is safe to
        *     emit in a template.
        * @return {!soydata.SanitizedUri} Sanitized content wrapper that indicates to
        *     Soy not to escape or filter when printed in URI context.
        */
        soydata.VERY_UNSAFE.ordainSanitizedUri = soydata.$$makeSanitizedContentFactoryWithDefaultDirOnly_(soydata.SanitizedUri);

        // -----------------------------------------------------------------------------
        // Below are private utilities to be used by Soy-generated code only.

        /**
         * Builds an augmented map. The returned map will contain mappings from both
         * the base map and the additional map. If the same key appears in both, then
         * the value from the additional map will be visible, while the value from the
         * base map will be hidden. The base map will be used, but not modified.
         *
         * @param {!Object} baseMap The original map to augment.
         * @param {!Object} additionalMap A map containing the additional mappings.
         * @return {!Object} An augmented map containing both the original and
         *     additional mappings.
         */
        soy.$$augmentMap = function (baseMap, additionalMap) {
          return soy.$$assignDefaults(soy.$$assignDefaults({}, additionalMap), baseMap);
        };

        /**
         * Copies extra properties into an object if they do not already exist. The
         * destination object is mutated in the process.
         *
         * @param {!Object} obj The destination object to update.
         * @param {!Object} defaults An object with default properties to apply.
         * @return {!Object} The destination object for convenience.
         */
        soy.$$assignDefaults = function (obj, defaults) {
          for (var key in defaults) {
            if (!(key in obj)) {
              obj[key] = defaults[key];
            }
          }

          return obj;
        };

        /**
         * Checks that the given map key is a string.
         * @param {*} key Key to check.
         * @return {string} The given key.
         */
        soy.$$checkMapKey = function (key) {
          // TODO: Support map literal with nonstring key.
          if (typeof key != 'string') {
            throw Error('Map literal\'s key expression must evaluate to string' + ' (encountered type "' + (typeof key === 'undefined' ? 'undefined' : _typeof(key)) + '").');
          }
          return key;
        };

        /**
         * Gets the keys in a map as an array. There are no guarantees on the order.
         * @param {Object} map The map to get the keys of.
         * @return {!Array<string>} The array of keys in the given map.
         */
        soy.$$getMapKeys = function (map) {
          var mapKeys = [];
          for (var key in map) {
            mapKeys.push(key);
          }
          return mapKeys;
        };

        /**
         * Returns the argument if it is not null.
         *
         * @param {T} val The value to check
         * @return {T} val if is isn't null
         * @template T
         */
        soy.$$checkNotNull = function (val) {
          if (val == null) {
            throw Error('unexpected null value');
          }
          return val;
        };

        /**
         * Gets a consistent unique id for the given delegate template name. Two calls
         * to this function will return the same id if and only if the input names are
         * the same.
         *
         * <p> Important: This function must always be called with a string constant.
         *
         * <p> If Closure Compiler is not being used, then this is just this identity
         * function. If Closure Compiler is being used, then each call to this function
         * will be replaced with a short string constant, which will be consistent per
         * input name.
         *
         * @param {string} delTemplateName The delegate template name for which to get a
         *     consistent unique id.
         * @return {string} A unique id that is consistent per input name.
         *
         * @consistentIdGenerator
         */
        soy.$$getDelTemplateId = function (delTemplateName) {
          return delTemplateName;
        };

        /**
         * Map from registered delegate template key to the priority of the
         * implementation.
         * @type {Object}
         * @private
         */
        soy.$$DELEGATE_REGISTRY_PRIORITIES_ = {};

        /**
         * Map from registered delegate template key to the implementation function.
         * @type {Object}
         * @private
         */
        soy.$$DELEGATE_REGISTRY_FUNCTIONS_ = {};

        /**
         * Registers a delegate implementation. If the same delegate template key (id
         * and variant) has been registered previously, then priority values are
         * compared and only the higher priority implementation is stored (if
         * priorities are equal, an error is thrown).
         *
         * @param {string} delTemplateId The delegate template id.
         * @param {string} delTemplateVariant The delegate template variant (can be
         *     empty string).
         * @param {number} delPriority The implementation's priority value.
         * @param {Function} delFn The implementation function.
         */
        soy.$$registerDelegateFn = function (delTemplateId, delTemplateVariant, delPriority, delFn) {

          var mapKey = 'key_' + delTemplateId + ':' + delTemplateVariant;
          var currPriority = soy.$$DELEGATE_REGISTRY_PRIORITIES_[mapKey];
          if (currPriority === undefined || delPriority > currPriority) {
            // Registering new or higher-priority function: replace registry entry.
            soy.$$DELEGATE_REGISTRY_PRIORITIES_[mapKey] = delPriority;
            soy.$$DELEGATE_REGISTRY_FUNCTIONS_[mapKey] = delFn;
          } else if (delPriority == currPriority) {
            // Registering same-priority function: error.
            throw Error('Encountered two active delegates with the same priority ("' + delTemplateId + ':' + delTemplateVariant + '").');
          } else {
            // Registering lower-priority function: do nothing.
          }
        };

        /**
         * Retrieves the (highest-priority) implementation that has been registered for
         * a given delegate template key (id and variant). If no implementation has
         * been registered for the key, then the fallback is the same id with empty
         * variant. If the fallback is also not registered, and allowsEmptyDefault is
         * true, then returns an implementation that is equivalent to an empty template
         * (i.e. rendered output would be empty string).
         *
         * @param {string} delTemplateId The delegate template id.
         * @param {string} delTemplateVariant The delegate template variant (can be
         *     empty string).
         * @param {boolean} allowsEmptyDefault Whether to default to the empty template
         *     function if there's no active implementation.
         * @return {Function} The retrieved implementation function.
         */
        soy.$$getDelegateFn = function (delTemplateId, delTemplateVariant, allowsEmptyDefault) {

          var delFn = soy.$$DELEGATE_REGISTRY_FUNCTIONS_['key_' + delTemplateId + ':' + delTemplateVariant];
          if (!delFn && delTemplateVariant != '') {
            // Fallback to empty variant.
            delFn = soy.$$DELEGATE_REGISTRY_FUNCTIONS_['key_' + delTemplateId + ':'];
          }

          if (delFn) {
            return delFn;
          } else if (allowsEmptyDefault) {
            return soy.$$EMPTY_TEMPLATE_FN_;
          } else {
            throw Error('Found no active impl for delegate call to "' + delTemplateId + ':' + delTemplateVariant + '" (and not allowemptydefault="true").');
          }
        };

        /**
         * Private helper soy.$$getDelegateFn(). This is the empty template function
         * that is returned whenever there's no delegate implementation found.
         *
         * @param {Object<string, *>=} opt_data
         * @param {soy.StringBuilder=} opt_sb
         * @param {Object<string, *>=} opt_ijData
         * @return {string}
         * @private
         */
        soy.$$EMPTY_TEMPLATE_FN_ = function (opt_data, opt_sb, opt_ijData) {
          return '';
        };

        // -----------------------------------------------------------------------------
        // Basic directives/functions.


        /**
         * Truncates a string to a given max length (if it's currently longer),
         * optionally adding ellipsis at the end.
         *
         * @param {*} str The string to truncate. Can be other types, but the value will
         *     be coerced to a string.
         * @param {number} maxLen The maximum length of the string after truncation
         *     (including ellipsis, if applicable).
         * @param {boolean} doAddEllipsis Whether to add ellipsis if the string needs
         *     truncation.
         * @return {string} The string after truncation.
         */
        soy.$$truncate = function (str, maxLen, doAddEllipsis) {

          str = String(str);
          if (str.length <= maxLen) {
            return str; // no need to truncate
          }

          // If doAddEllipsis, either reduce maxLen to compensate, or else if maxLen is
          // too small, just turn off doAddEllipsis.
          if (doAddEllipsis) {
            if (maxLen > 3) {
              maxLen -= 3;
            } else {
              doAddEllipsis = false;
            }
          }

          // Make sure truncating at maxLen doesn't cut up a unicode surrogate pair.
          if (soy.$$isHighSurrogate_(str.charAt(maxLen - 1)) && soy.$$isLowSurrogate_(str.charAt(maxLen))) {
            maxLen -= 1;
          }

          // Truncate.
          str = str.substring(0, maxLen);

          // Add ellipsis.
          if (doAddEllipsis) {
            str += '...';
          }

          return str;
        };

        /**
         * Private helper for $$truncate() to check whether a char is a high surrogate.
         * @param {string} ch The char to check.
         * @return {boolean} Whether the given char is a unicode high surrogate.
         * @private
         */
        soy.$$isHighSurrogate_ = function (ch) {
          return 0xD800 <= ch && ch <= 0xDBFF;
        };

        /**
         * Private helper for $$truncate() to check whether a char is a low surrogate.
         * @param {string} ch The char to check.
         * @return {boolean} Whether the given char is a unicode low surrogate.
         * @private
         */
        soy.$$isLowSurrogate_ = function (ch) {
          return 0xDC00 <= ch && ch <= 0xDFFF;
        };

        // -----------------------------------------------------------------------------
        // Assertion methods used by runtime.

        /**
         * Checks if the type assertion is true if goog.asserts.ENABLE_ASSERTS is
         * true. Report errors on runtime types if goog.DEBUG is true.
         * @param {boolean} condition The type check condition.
         * @param {string} paramName The Soy name of the parameter.
         * @param {?} param The JS object for the parameter.
         * @param {!string} jsDocTypeStr SoyDoc type str.
         * @return {?} the param value
         * @throws {goog.asserts.AssertionError} When the condition evaluates to false.
         */
        soy.asserts.assertType = function (condition, paramName, param, jsDocTypeStr) {
          if (goog.asserts.ENABLE_ASSERTS && !condition) {
            var msg = 'expected param ' + paramName + ' of type ' + jsDocTypeStr + (goog.DEBUG ? ', but got ' + goog.debug.runtimeType(param) : '') + '.';
            goog.asserts.fail(msg);
          }
          return param;
        };

        // -----------------------------------------------------------------------------
        // Generated code.


        // START GENERATED CODE FOR ESCAPERS.

        /**
         * @type {function (*) : string}
         */
        soy.esc.$$escapeHtmlHelper = function (v) {
          return goog.string.htmlEscape(String(v));
        };

        /**
         * Allows only data-protocol image URI's.
         *
         * @param {*} value The value to process. May not be a string, but the value
         *     will be coerced to a string.
         * @return {!soydata.SanitizedUri} An escaped version of value.
         */
        soy.$$filterImageDataUri = function (value) {
          // NOTE: Even if it's a SanitizedUri, we will still filter it.
          return soydata.VERY_UNSAFE.ordainSanitizedUri(soy.esc.$$filterImageDataUriHelper(value));
        };

        /**
         * A pattern that vets values produced by the named directives.
         * @private {!RegExp}
         */
        soy.esc.$$FILTER_FOR_FILTER_IMAGE_DATA_URI_ = /^data:image\/(?:bmp|gif|jpe?g|png|tiff|webp);base64,[a-z0-9+\/]+=*$/i;

        /**
         * A helper for the Soy directive |filterImageDataUri
         * @param {*} value Can be of any type but will be coerced to a string.
         * @return {string} The escaped text.
         */
        soy.esc.$$filterImageDataUriHelper = function (value) {
          var str = String(value);
          if (!soy.esc.$$FILTER_FOR_FILTER_IMAGE_DATA_URI_.test(str)) {
            goog.asserts.fail('Bad value `%s` for |filterImageDataUri', [str]);
            return 'data:image/gif;base64,zSoyz';
          }
          return str;
        };

        var incrementaldom = IncrementalDOM;
        var soyIDOM = {};

        /**
         * Calls an expression in case of a function or outputs it as text content.
         * @param {string|number|boolean|function()?} expr
         */
        soyIDOM.renderDynamicContent = function (expr) {
          if (goog.isFunction(expr)) {
            expr();
          } else if (expr != null) {
            incrementaldom.text(expr);
          }
        };

        /**
         * Prints an expression depending on its type.
         * @param {!SanitizedHtml|string|number|boolean|function()} expr
         */
        soyIDOM.print = function (expr) {
          if (expr instanceof soydata.SanitizedHtml) {
            // For HTML content we need to insert a custom element where we can place
            // the content without incremental dom modifying it.
            var el = incrementaldom.elementOpen('html-blob');
            var content = expr.toString();
            if (el.__innerHTML !== content) {
              soy.renderHtml(el, expr);
              el.__innerHTML = content;
            }
            incrementaldom.skip();
            incrementaldom.elementClose('html-blob');
          } else {
            soyIDOM.renderDynamicContent(expr);
          }
        };

        goog.loadModule(function () {
          goog.module('soy.idom');
          return soyIDOM;
        });

        // END GENERATED CODE

        goog.loadModule(function () {
          goog.module('soy');
          return soy;
        });

        goog.loadModule(function () {
          goog.module('soydata');
          return soydata;
        });

        goog.loadModule(function () {
          goog.module('soy.asserts');
          return soy;
        });
      })();

      goog.loadModule(function () {
        goog.module('incrementaldom');
        return IncrementalDOM;
      });
    }
  }).call(typeof exports !== 'undefined' && typeof global !== 'undefined' ? global : window);
});
//# sourceMappingURL=bundle.js.map
