Liferay.Loader.define("layout-admin-web@2.0.60/js/miller_columns/utils/LayoutGetUtils.es", ["exports"], function (exports) {
	"use strict";

	Object.defineProperty(exports, "__esModule", {
		value: true
	});
	/**
  * @param {number} columnIndex
  * @param {object} item
  * @param {number} itemColumnIndex
  * @return {boolean} Returns whether a column is child of an item or not
  * @review
  */
	function columnIsItemChild(columnIndex, item, itemColumnIndex) {
		return item.active && itemColumnIndex < columnIndex;
	}

	/**
  * Return the active item of a given column
  * @param {object} layoutColumns
  * @param {number} columnIndex
  * @return {string}
  * @review
  */
	function getColumnActiveItem(layoutColumns, columnIndex) {
		var column = layoutColumns[columnIndex];

		var activeItem = column.find(function (item) {
			return item.active;
		});

		return activeItem ? activeItem : null;
	}

	/**
  * Get last item of a column
  * @param {object[]} layoutColumns
  * @param {number} columnIndex
  * @return {object|undefined} Returns last item or
  * undefined if the column is empty
  * @review
  */
	function getColumnLastItem(layoutColumns, columnIndex) {
		var column = layoutColumns[columnIndex];

		return column[column.length - 1];
	}

	/**
  * Returns the Home item of an array of columns
  * @param {object[]} layoutColumns
  * @private
  * @return {object|null}
  * @review
  */
	function getHomeItem(layoutColumns) {
		var item = null;

		layoutColumns.forEach(function (layoutColumn) {
			item = item || layoutColumn.find(function (_item) {
				return _item.homePage;
			});
		});

		return item;
	}

	/**
  * Returns an item from its plid
  * @param {object[]} layoutColumns
  * @param {string} itemPlid
  * @private
  * @return {object|null}
  * @review
  */
	function getItem(layoutColumns, itemPlid) {
		var item = null;

		layoutColumns.forEach(function (layoutColumn) {
			item = item || layoutColumn.find(function (_item) {
				return _item.plid === itemPlid;
			});
		});

		return item;
	}

	/**
  * Get the container column of an item
  * @param {object[]} layoutColumns
  * @param {string} itemPlid
  * @return {object[]|null}
  * @review
  */
	function getItemColumn(layoutColumns, itemPlid) {
		var column = null;

		layoutColumns.forEach(function (layoutColumn) {
			var item = layoutColumn.find(function (_item) {
				return _item.plid === itemPlid;
			});

			if (item) {
				column = layoutColumn;
			}
		});

		return column;
	}

	/**
  * Return the index of an item's column
  * @param {object[]} layoutColumns
  * @param {string} itemPlid
  * @return {number}
  * @review
  */
	function getItemColumnIndex(layoutColumns, itemPlid) {
		var column = getItemColumn(layoutColumns, itemPlid);

		return layoutColumns.indexOf(column);
	}

	/**
  * @param {object[]} layoutColumns
  * @param {string} childItemPlid
  * @param {string} parentItemPlid
  * @return {boolean} Returns wheter an item is child of a given item
  * @review
  */
	function itemIsParent(layoutColumns, childItemPlid, parentItemPlid) {
		var childItemColumnIndex = getItemColumnIndex(layoutColumns, childItemPlid);
		var parentItem = getItem(layoutColumns, parentItemPlid);
		var parentItemColumnIndex = getItemColumnIndex(layoutColumns, parentItemPlid);

		return parentItem.active && childItemColumnIndex > parentItemColumnIndex;
	}

	exports.columnIsItemChild = columnIsItemChild;
	exports.getColumnActiveItem = getColumnActiveItem;
	exports.getColumnLastItem = getColumnLastItem;
	exports.getHomeItem = getHomeItem;
	exports.getItem = getItem;
	exports.getItemColumn = getItemColumn;
	exports.getItemColumnIndex = getItemColumnIndex;
	exports.itemIsParent = itemIsParent;
});
//# sourceMappingURL=LayoutGetUtils.es.js.map
