Liferay.Loader.define("layout-admin-web@2.0.60/js/miller_columns/utils/LayoutDropUtils.es", ['exports', './LayoutUpdateUtils.es', './LayoutGetUtils.es', './LayoutDragDrop.es'], function (exports, _LayoutUpdateUtils, _LayoutGetUtils, _LayoutDragDrop) {
	'use strict';

	Object.defineProperty(exports, "__esModule", {
		value: true
	});
	exports.dropItemNextToItem = exports.dropItemInsideItem = exports.dropItemInsideColumn = exports.dropIsValid = undefined;

	function _toConsumableArray(arr) {
		if (Array.isArray(arr)) {
			for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) {
				arr2[i] = arr[i];
			}

			return arr2;
		} else {
			return Array.from(arr);
		}
	}

	/**
  * @param {object} sourceItem
  * @param {string} sourceItemColumnIndex
  * @param {string} targetId
  * @param {string} targetType
  * @return {boolean} Returns whether a drop is valid or not
  * @review
  */
	function dropIsValid(sourceItem, sourceItemColumnIndex, targetId, targetType) {
		var targetColumnIsChild = false;
		var targetEqualsSource = false;

		if (targetType === _LayoutDragDrop.DROP_TARGET_TYPES.column) {
			targetColumnIsChild = (0, _LayoutGetUtils.columnIsItemChild)(targetId, sourceItem, sourceItemColumnIndex);
		} else if (targetType === _LayoutDragDrop.DROP_TARGET_TYPES.item) {
			targetEqualsSource = sourceItem.plid === targetId;
		}

		var targetExists = targetId !== null;

		return targetExists && !targetEqualsSource && !targetColumnIsChild;
	}

	/**
  * Append an item to a column and calculates newParentPlid and priority
  * @param {object} layoutColumns
  * @param {object} sourceItem
  * @param {number} targetColumnIndex
  * @return {object}
  * @review
  */
	function dropItemInsideColumn(layoutColumns, sourceItem, targetColumnIndex) {
		var nextLayoutColumns = (0, _LayoutUpdateUtils.appendItemToColumn)(sourceItem, layoutColumns, targetColumnIndex);

		var newParentPlid = (0, _LayoutGetUtils.getColumnActiveItem)(nextLayoutColumns, targetColumnIndex - 1).plid;

		var priority = layoutColumns[targetColumnIndex].length;

		return {
			layoutColumns: nextLayoutColumns,
			newParentPlid: newParentPlid,
			priority: priority
		};
	}

	/**
  * Inserts an item inside another item's children and
  * calculates new parent plid and priority
  * @param {object} layoutColumns
  * @param {object} sourceItem
  * @param {number} sourceItemColumnIndex
  * @param {bollean} pathUpdated
  * @param {object} targetItem
  * @return {object}
  * @review
  */
	function dropItemInsideItem(layoutColumns, sourceItem, sourceItemColumnIndex, pathUpdated, targetItem) {
		var nextLayoutColumns = layoutColumns;
		var priority = null;

		nextLayoutColumns = (0, _LayoutUpdateUtils.moveItemInside)(layoutColumns, pathUpdated, sourceItem, sourceItemColumnIndex, targetItem);

		if (pathUpdated) {
			var targetColumnIndex = (0, _LayoutGetUtils.getItemColumnIndex)(nextLayoutColumns, targetItem.plid);

			var nextColumn = nextLayoutColumns[targetColumnIndex + 1];

			priority = nextColumn.indexOf(sourceItem);
		}

		return {
			layoutColumns: nextLayoutColumns,
			newParentPlid: targetItem.plid,
			priority: priority
		};
	}

	/**
  * Insert an item next to another item and
  * calculates new parent plid and priority
  * @param {object} layoutColumns
  * @param {object} sourceItem
  * @param {string} dropPosition
  * @param {object} targetItem
  * @return {object}
  * @review
  */
	function dropItemNextToItem(layoutColumns, sourceItem, dropPosition, targetItem) {
		var nextLayoutColumns = (0, _LayoutUpdateUtils.removeItem)(sourceItem.plid, layoutColumns);

		var targetColumn = (0, _LayoutGetUtils.getItemColumn)(nextLayoutColumns, targetItem.plid);
		var targetColumnIndex = nextLayoutColumns.indexOf(targetColumn);

		var parentPlid = (0, _LayoutGetUtils.getColumnActiveItem)(nextLayoutColumns, targetColumnIndex - 1).plid;

		var targetItemIndex = targetColumn.findIndex(function (targetColumnItem) {
			return targetColumnItem.plid === targetItem.plid;
		});

		var priority = dropPosition === _LayoutDragDrop.DRAG_POSITIONS.bottom ? targetItemIndex + 1 : targetItemIndex;

		var nextTargetColumn = [].concat(_toConsumableArray(targetColumn));

		nextTargetColumn.splice(priority, 0, sourceItem);

		nextLayoutColumns[targetColumnIndex] = nextTargetColumn;

		return {
			layoutColumns: nextLayoutColumns,
			newParentPlid: parentPlid,
			priority: priority
		};
	}

	exports.dropIsValid = dropIsValid;
	exports.dropItemInsideColumn = dropItemInsideColumn;
	exports.dropItemInsideItem = dropItemInsideItem;
	exports.dropItemNextToItem = dropItemNextToItem;
});
//# sourceMappingURL=LayoutDropUtils.es.js.map
