Liferay.Loader.define("layout-admin-web@2.0.60/js/miller_columns/utils/LayoutDragDrop.es", ['exports', 'metal-drag-drop/src/all/drag', 'metal-position/src/all/position', 'metal-state/src/all/state'], function (exports, _drag, _position, _state) {
	'use strict';

	Object.defineProperty(exports, "__esModule", {
		value: true
	});
	exports.LayoutDragDrop = exports.DROP_TARGET_TYPES = exports.DRAG_POSITIONS = undefined;

	var _position2 = _interopRequireDefault(_position);

	var _state2 = _interopRequireDefault(_state);

	function _interopRequireDefault(obj) {
		return obj && obj.__esModule ? obj : {
			default: obj
		};
	}

	function _classCallCheck(instance, Constructor) {
		if (!(instance instanceof Constructor)) {
			throw new TypeError("Cannot call a class as a function");
		}
	}

	var _createClass = function () {
		function defineProperties(target, props) {
			for (var i = 0; i < props.length; i++) {
				var descriptor = props[i];
				descriptor.enumerable = descriptor.enumerable || false;
				descriptor.configurable = true;
				if ("value" in descriptor) descriptor.writable = true;
				Object.defineProperty(target, descriptor.key, descriptor);
			}
		}

		return function (Constructor, protoProps, staticProps) {
			if (protoProps) defineProperties(Constructor.prototype, protoProps);
			if (staticProps) defineProperties(Constructor, staticProps);
			return Constructor;
		};
	}();

	function _possibleConstructorReturn(self, call) {
		if (!self) {
			throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
		}

		return call && (typeof call === "object" || typeof call === "function") ? call : self;
	}

	function _inherits(subClass, superClass) {
		if (typeof superClass !== "function" && superClass !== null) {
			throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
		}

		subClass.prototype = Object.create(superClass && superClass.prototype, {
			constructor: {
				value: subClass,
				enumerable: false,
				writable: true,
				configurable: true
			}
		});
		if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
	}

	/**
  * Positions where elements can be dragged to
  * @review
  */

	var DRAG_POSITIONS = {
		bottom: 'layout-column-item-drag-bottom',
		inside: 'layout-column-item-drag-inside',
		top: 'layout-column-item-drag-top'
	};

	/**
  * Possible drop target types
  * @review
  */

	var DROP_TARGET_TYPES = {
		column: 'layout-column',
		item: 'layout-column-item'
	};

	/**
  * LayoutDragDrop
  */

	var LayoutDragDrop = function (_State) {
		_inherits(LayoutDragDrop, _State);

		/**
   * @inheritDoc
   * @review
   */
		function LayoutDragDrop(config) {
			var _ref;

			_classCallCheck(this, LayoutDragDrop);

			for (var _len = arguments.length, args = Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
				args[_key - 1] = arguments[_key];
			}

			var _this = _possibleConstructorReturn(this, (_ref = LayoutDragDrop.__proto__ || Object.getPrototypeOf(LayoutDragDrop)).call.apply(_ref, [this, config].concat(args)));

			_this._initializeDragAndDrop();
			return _this;
		}

		/**
   * @inheritDoc
   * @review
   */


		_createClass(LayoutDragDrop, [{
			key: 'dispose',
			value: function dispose() {
				this._dragDrop.dispose();
			}
		}, {
			key: 'addTarget',
			value: function addTarget(target) {
				this._dragDrop.addTarget(target);
			}
		}, {
			key: '_handleDrag',
			value: function _handleDrag(data) {
				var targetItem = data.target;

				if (targetItem) {
					var mouseY = data.originalEvent.clientY;
					var placeholderItemRegion = _position2.default.getRegion(data.placeholder);
					var sourceItemPlid = data.source.dataset.layoutColumnItemPlid;
					var targetItemRegion = _position2.default.getRegion(targetItem);

					var targetId = null;
					var targetType = null;

					if (targetItem.dataset.layoutColumnIndex) {
						targetId = targetItem.dataset.layoutColumnIndex;
						targetId = targetId === '0' ? null : targetId;
						targetType = DROP_TARGET_TYPES.column;
					} else if (targetItem.dataset.layoutColumnItemPlid) {
						targetId = targetItem.dataset.layoutColumnItemPlid;
						targetType = DROP_TARGET_TYPES.item;

						if (placeholderItemRegion.top > targetItemRegion.top && placeholderItemRegion.bottom < targetItemRegion.bottom) {
							this._draggingItemPosition = DRAG_POSITIONS.inside;
						} else if (Math.abs(mouseY - targetItemRegion.top) <= Math.abs(mouseY - targetItemRegion.bottom)) {
							this._draggingItemPosition = DRAG_POSITIONS.top;
						} else {
							this._draggingItemPosition = DRAG_POSITIONS.bottom;
						}
					}

					this.emit('dragLayoutColumnItem', {
						position: this._draggingItemPosition,
						sourceItemPlid: sourceItemPlid,
						targetId: targetId,
						targetType: targetType
					});
				}
			}
		}, {
			key: '_handleDragEnd',
			value: function _handleDragEnd() {
				this.emit('leaveLayoutColumnItem');
			}
		}, {
			key: '_handleDragStart',
			value: function _handleDragStart(data, event) {
				var sourceItemPlid = event.target.getActiveDrag().dataset.layoutColumnItemPlid;

				this.emit('startMovingLayoutColumnItem', {
					sourceItemPlid: sourceItemPlid
				});
			}
		}, {
			key: '_handleDrop',
			value: function _handleDrop(data, event) {
				event.preventDefault();

				var sourceItemPlid = data.source.dataset.layoutColumnItemPlid;
				var targetId = null;
				var targetType = null;

				if (data.target) {
					if (data.target.dataset.layoutColumnIndex) {
						targetId = data.target.dataset.layoutColumnIndex;
						targetId = targetId === '0' ? null : targetId;
						targetType = DROP_TARGET_TYPES.column;
					} else if (data.target.dataset.layoutColumnItemPlid) {
						targetId = data.target.dataset.layoutColumnItemPlid;
						targetType = DROP_TARGET_TYPES.item;
					}
				}

				this.emit('dropLayoutColumnItem', {
					sourceItemPlid: sourceItemPlid,
					targetId: targetId,
					targetType: targetType
				});
			}
		}, {
			key: '_initializeDragAndDrop',
			value: function _initializeDragAndDrop() {
				if (this._dragDrop) {
					this._dragDrop.dispose();
				}

				this._dragDrop = new _drag.DragDrop({
					autoScroll: true,
					dragPlaceholder: _drag.Drag.Placeholder.CLONE,
					handles: '.layout-drag-handler',
					scrollContainers: '.layout-column, .layout-columns',
					sources: '.layout-drag-item',
					targets: '.layout-drop-target-item'
				});

				this._dragDrop.on(_drag.DragDrop.Events.DRAG, this._handleDrag.bind(this));

				this._dragDrop.on(_drag.DragDrop.Events.END, this._handleDrop.bind(this));

				this._dragDrop.on(_drag.Drag.Events.START, this._handleDragStart.bind(this));

				this._dragDrop.on(_drag.DragDrop.Events.TARGET_LEAVE, this._handleDragEnd.bind(this));
			}
		}]);

		return LayoutDragDrop;
	}(_state2.default);

	/**
  * State definition.
  * @type {!Object}
  * @static
  */

	LayoutDragDrop.STATE = {

		/**
   * Internal DragDrop instance.
   * @default null
   * @instance
   * @memberOf LayoutDragDrop
   * @review
   * @type {object|null}
   */

		_dragDrop: _state.Config.internal().value(null),

		/**
   * Position of the dragging card
   * @default undefined
   * @instance
   * @memberOf LayoutDragDrop
   * @review
   * @type {!string}
   */

		_draggingItemPosition: _state.Config.internal().string()
	};

	exports.DRAG_POSITIONS = DRAG_POSITIONS;
	exports.DROP_TARGET_TYPES = DROP_TARGET_TYPES;
	exports.LayoutDragDrop = LayoutDragDrop;
	exports.default = LayoutDragDrop;
});
//# sourceMappingURL=LayoutDragDrop.es.js.map
