Liferay.Loader.define("layout-admin-web@2.0.60/js/fragments_editor/fragment_processors/EditableTextFragmentProcessor.es", ['exports', 'metal-events/src/events', 'metal/src/metal'], function (exports, _events, _metal) {
	'use strict';

	Object.defineProperty(exports, "__esModule", {
		value: true
	});
	exports.init = exports.getActiveEditableElement = exports.destroy = undefined;


	/**
  * Enter key keycode
  * @review
  * @type {number}
  */

	var KEY_ENTER = 13;

	var _destroyedCallback = void 0;
	var _editableElement = void 0;
	var _editor = void 0;
	var _editorEventHandler = void 0;

	/**
  * Destroys, if any, an existing instance of AlloyEditor.
  */

	function destroy() {
		if (_editor) {
			_editorEventHandler.removeAllListeners();
			_editorEventHandler.dispose();

			var editorData = _editor.get('nativeEditor').getData();

			_editableElement.innerHTML = editorData;

			_editor.destroy();

			_editableElement = null;
			_editor = null;
			_editorEventHandler = null;

			_destroyedCallback();
			_destroyedCallback = null;
		}
	}

	/**
  * Returns the existing editable element or null.
  * @returns {HTMLElement|null}
  */

	function getActiveEditableElement() {
		return _editableElement;
	}

	/**
  * Creates an instance of AlloyEditor and destroys the existing one if any.
  * @param {HTMLElement} editableElement
  * @param {string} fragmentEntryLinkId
  * @param {string} portletNamespace
  * @param {Object} options
  * @param {function} changedCallback
  * @param {function} destroyedCallback
  */

	function init(editableElement, fragmentEntryLinkId, portletNamespace, options, changedCallback, destroyedCallback) {
		destroy();

		var defaultEditorConfiguration = options.defaultEditorConfiguration;

		var editableContent = editableElement.innerHTML;
		var wrapper = document.createElement('div');

		wrapper.dataset.lfrEditableId = editableElement.id;
		wrapper.innerHTML = editableContent;

		var editorName = portletNamespace + 'FragmentEntryLinkEditable_' + editableElement.id;

		wrapper.setAttribute('id', editorName);
		wrapper.setAttribute('name', editorName);

		editableElement.innerHTML = '';
		editableElement.appendChild(wrapper);

		_editableElement = editableElement;
		_editorEventHandler = new _events.EventHandler();
		_destroyedCallback = destroyedCallback;

		_editor = AlloyEditor.editable(wrapper, _getEditorConfiguration(editableElement, portletNamespace, fragmentEntryLinkId, defaultEditorConfiguration, editorName));

		var nativeEditor = _editor.get('nativeEditor');

		_editorEventHandler.add(nativeEditor.on('key', _handleNativeEditorKey));

		_editorEventHandler.add(nativeEditor.on('change', function () {
			return changedCallback(nativeEditor.getData());
		}));

		_editorEventHandler.add(nativeEditor.on('actionPerformed', function () {
			return changedCallback(nativeEditor.getData());
		}));

		_editorEventHandler.add(nativeEditor.on('blur', function (event) {
			if (_editor._mainUI.state.hidden) {
				requestAnimationFrame(destroy);
			}
		}));

		_editorEventHandler.add(nativeEditor.on('instanceReady', function () {
			return nativeEditor.focus();
		}));
	}

	/**
  * Returns a configuration object for a AlloyEditor instance.
  * @param {HTMLElement} editableElement
  * @param {string} portletNamespace
  * @param {string} fragmentEntryLinkId
  * @param {object} defaultEditorConfiguration
  */

	function _getEditorConfiguration(editableElement, portletNamespace, fragmentEntryLinkId, defaultEditorConfiguration, editorName) {
		return _metal.object.mixin({}, defaultEditorConfiguration.editorConfig || {}, {
			filebrowserImageBrowseLinkUrl: defaultEditorConfiguration.editorConfig.filebrowserImageBrowseLinkUrl.replace('_EDITOR_NAME_', editorName),

			filebrowserImageBrowseUrl: defaultEditorConfiguration.editorConfig.filebrowserImageBrowseUrl.replace('_EDITOR_NAME_', editorName),

			title: editorName
		});
	}

	/**
  * Handle native editor key presses.
  * It avoids including line breaks on text editors.
  * @param {Event} event
  * @private
  * @review
  */

	function _handleNativeEditorKey(event) {
		if (event.data.keyCode === KEY_ENTER && _editableElement && _editableElement.getAttribute('type') === 'text') {
			event.cancel();
		}
	}

	exports.destroy = destroy;
	exports.getActiveEditableElement = getActiveEditableElement;
	exports.init = init;
	exports.default = {
		destroy: destroy,
		getActiveEditableElement: getActiveEditableElement,
		init: init
	};
});
//# sourceMappingURL=EditableTextFragmentProcessor.es.js.map
