Liferay.Loader.define("layout-admin-web@2.0.60/js/fragments_editor/fragment_entry_link/FragmentEditableField.es", ['exports', 'metal-component/src/all/component', 'metal-state/src/all/state', 'metal/src/metal', 'metal-soy/src/Soy', '../fragment_processors/FragmentProcessors.es', '../fragment_processors/EditableTextFragmentProcessor.es', './FragmentEditableField.soy', './FragmentEditableFieldTooltip.es'], function (exports, _component, _state, _metal, _Soy, _FragmentProcessors, _EditableTextFragmentProcessor, _FragmentEditableField) {
	'use strict';

	Object.defineProperty(exports, "__esModule", {
		value: true
	});
	exports.FragmentEditableField = undefined;

	var _component2 = _interopRequireDefault(_component);

	var _Soy2 = _interopRequireDefault(_Soy);

	var _FragmentProcessors2 = _interopRequireDefault(_FragmentProcessors);

	var _FragmentEditableField2 = _interopRequireDefault(_FragmentEditableField);

	function _interopRequireDefault(obj) {
		return obj && obj.__esModule ? obj : {
			default: obj
		};
	}

	function _classCallCheck(instance, Constructor) {
		if (!(instance instanceof Constructor)) {
			throw new TypeError("Cannot call a class as a function");
		}
	}

	var _createClass = function () {
		function defineProperties(target, props) {
			for (var i = 0; i < props.length; i++) {
				var descriptor = props[i];
				descriptor.enumerable = descriptor.enumerable || false;
				descriptor.configurable = true;
				if ("value" in descriptor) descriptor.writable = true;
				Object.defineProperty(target, descriptor.key, descriptor);
			}
		}

		return function (Constructor, protoProps, staticProps) {
			if (protoProps) defineProperties(Constructor.prototype, protoProps);
			if (staticProps) defineProperties(Constructor, staticProps);
			return Constructor;
		};
	}();

	function _possibleConstructorReturn(self, call) {
		if (!self) {
			throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
		}

		return call && (typeof call === "object" || typeof call === "function") ? call : self;
	}

	function _inherits(subClass, superClass) {
		if (typeof superClass !== "function" && superClass !== null) {
			throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
		}

		subClass.prototype = Object.create(superClass && superClass.prototype, {
			constructor: {
				value: subClass,
				enumerable: false,
				writable: true,
				configurable: true
			}
		});
		if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
	}

	/**
  * Buttons rendered inside the tooltip
  * @review
  */

	var TOOLTIP_BUTTONS = {
		edit: {
			id: 'edit',
			label: Liferay.Language.get('edit')
		},

		map: {
			id: 'map',
			label: Liferay.Language.get('map[relational]')
		},

		selectImage: {
			id: 'selectImage',
			label: Liferay.Language.get('select-image')
		}
	};

	var FragmentEditableField = function (_Component) {
		_inherits(FragmentEditableField, _Component);

		function FragmentEditableField() {
			_classCallCheck(this, FragmentEditableField);

			return _possibleConstructorReturn(this, (FragmentEditableField.__proto__ || Object.getPrototypeOf(FragmentEditableField)).apply(this, arguments));
		}

		_createClass(FragmentEditableField, [{
			key: 'created',
			value: function created() {
				this._handleBeforeNavigate = this._handleBeforeNavigate.bind(this);
				this._handleEditableChanged = this._handleEditableChanged.bind(this);
				this._handleEditableDestroyed = this._handleEditableDestroyed.bind(this);

				this._beforeNavigateHandler = Liferay.on('beforeNavigate', this._handleBeforeNavigate);
			}
		}, {
			key: 'disposed',
			value: function disposed() {
				this._destroyProcessors();
			}
		}, {
			key: 'prepareStateForRender',
			value: function prepareStateForRender(state) {
				var translatedContent = this.editableValues[this.languageId] || this.editableValues[this.defaultLanguageId] || this.editableValues.defaultValue;

				var content = _Soy2.default.toIncDom(translatedContent || this.content);

				if (this.type === 'image' && translatedContent) {
					var tempContent = document.createElement('div');

					tempContent.innerHTML = this.content;

					var tempImage = tempContent.querySelector('img');

					if (tempImage) {
						tempImage.src = translatedContent;
					}

					content = _Soy2.default.toIncDom(tempContent.innerHTML);
				}

				var _tooltipButtons = this._getTooltipButtons(this.type);

				return _metal.object.mixin({}, state, {
					content: content,
					_tooltipButtons: _tooltipButtons
				});
			}
		}, {
			key: 'rendered',
			value: function rendered() {
				if (this._showEditor) {
					this._showEditor = false;
					this._enableEditor();
				}

				if (this.refs.editable !== this._tooltipAlignElement) {
					this._tooltipAlignElement = this.refs.editable;
				}
			}
		}, {
			key: 'shouldUpdate',
			value: function shouldUpdate(changes) {
				return !!changes._showTooltip;
			}
		}, {
			key: '_destroyProcessors',
			value: function _destroyProcessors() {
				Object.values(_FragmentProcessors2.default).forEach(function (fragmentProcessor) {
					return fragmentProcessor.destroy();
				});
			}
		}, {
			key: '_enableEditor',
			value: function _enableEditor() {
				var _ref = _FragmentProcessors2.default[this.type] || _FragmentProcessors2.default.fallback,
				    init = _ref.init;

				init(this.refs.editable, this.fragmentEntryLinkId, this.portletNamespace, this.processorsOptions, this._handleEditableChanged, this._handleEditableDestroyed);

				this._editing = true;
			}
		}, {
			key: '_getTooltipButtons',
			value: function _getTooltipButtons(editableType) {
				var _tooltipButtons = [];

				if (this.showMapping) {
					_tooltipButtons.push(TOOLTIP_BUTTONS.map);
				}

				if (editableType === 'image') {
					_tooltipButtons.push(TOOLTIP_BUTTONS.selectImage);
				} else {
					_tooltipButtons.push(TOOLTIP_BUTTONS.edit);
				}

				return _tooltipButtons;
			}
		}, {
			key: '_handleBeforeNavigate',
			value: function _handleBeforeNavigate() {
				if (this._beforeNavigateHandler) {
					this._beforeNavigateHandler.detach();
					this._beforeNavigateHandler = null;
				}

				this._destroyProcessors();
			}
		}, {
			key: '_handleEditableClick',
			value: function _handleEditableClick(event) {
				event.preventDefault();
				event.stopPropagation();

				if (this._tooltipLabel) {
					this._showTooltip = false;
					this._tooltipLabel = '';
				}

				if (this.showMapping && !this._editing || (0, _EditableTextFragmentProcessor.getActiveEditableElement)() !== this.refs.editable) {
					if (!this.showMapping) {
						this._showTooltip = false;
						this._enableEditor();
					} else {
						this._showTooltip = !this._showTooltip;
					}

					if (!this._showTooltip) {
						this._handleEditableMouseEnter();
					}
				}
			}
		}, {
			key: '_handleEditableDestroyed',
			value: function _handleEditableDestroyed() {
				this._editing = false;
			}
		}, {
			key: '_handleEditableMouseEnter',
			value: function _handleEditableMouseEnter() {
				if (!this._editing && this.editableValues.mappedField && !this._showTooltip) {
					this._showTooltip = true;
					this._tooltipLabel = this.editableValues.mappedField;
				}
			}
		}, {
			key: '_handleEditableMouseLeave',
			value: function _handleEditableMouseLeave() {
				if (this._tooltipLabel && !this._editing) {
					this._showTooltip = false;
					this._tooltipLabel = '';
				}
			}
		}, {
			key: '_handleEditableChanged',
			value: function _handleEditableChanged(newValue) {
				this.emit('editableChanged', {
					editableId: this.editableId,
					value: newValue
				});
			}
		}, {
			key: '_handleOutsideTooltipClick',
			value: function _handleOutsideTooltipClick() {
				this._showTooltip = false;
			}
		}, {
			key: '_handleTooltipButtonClick',
			value: function _handleTooltipButtonClick(event) {
				var buttonId = event.buttonId;


				if (buttonId === TOOLTIP_BUTTONS.edit.id || buttonId === TOOLTIP_BUTTONS.selectImage.id) {
					this._showEditor = true;
				} else if (buttonId === TOOLTIP_BUTTONS.map.id) {
					this.emit('mapButtonClicked', {
						editableId: this.editableId,
						editableType: this.type,
						mappedFieldId: this.editableValues.mappedField || ''
					});
				}

				this._showTooltip = false;
			}
		}]);

		return FragmentEditableField;
	}(_component2.default);

	/**
  * State definition.
  * @review
  * @static
  * @type {!Object}
  */

	FragmentEditableField.STATE = {

		/**
   * Editable content to be rendered
   * @default undefined
   * @instance
   * @memberOf FragmentEditableField
   * @review
   * @type {!string}
   */

		content: _state.Config.string().required(),

		/**
   * Default language id.
   * @default undefined
   * @instance
   * @memberOf FragmentsEditor
   * @review
   * @type {!string}
   */

		defaultLanguageId: _state.Config.string().required(),

		/**
   * Editable ID
   * @default undefined
   * @instance
   * @memberOf FragmentEditableField
   * @review
   * @type {!string}
   */

		editableId: _state.Config.string().required(),

		/**
   * Editable values
   * @default undefined
   * @instance
   * @memberOf FragmentEditableField
   * @review
   * @type {!object}
   */

		editableValues: _state.Config.object().required(),

		/**
   * FragmentEntryLink id
   * @default undefined
   * @instance
   * @memberOf FragmentEditableField
   * @review
   * @type {!string}
   */

		fragmentEntryLinkId: _state.Config.string().required(),

		/**
   * Currently selected language id.
   * @default undefined
   * @instance
   * @memberOf FragmentsEditor
   * @review
   * @type {!string}
   */

		languageId: _state.Config.string().required(),

		/**
   * Portlet namespace
   * @default undefined
   * @instance
   * @memberOf FragmentEditableField
   * @review
   * @type {!string}
   */

		portletNamespace: _state.Config.string().required(),

		/**
   * Set of options that are sent to the processors.
   * @default undefined
   * @instance
   * @memberOf FragmentEditableField
   * @review
   * @type {!object}
   */

		processorsOptions: _state.Config.object().required(),

		/**
   * Editable type
   * @default undefined
   * @instance
   * @memberOf FragmentEditableField
   * @review
   * @type {!string}
   */

		type: _state.Config.string().required(),

		/**
   * True if mapping is activated
   * @default undefined
   * @instance
   * @memberOf FragmentEditableField
   * @review
   * @type {!boolean}
   */

		showMapping: _state.Config.bool().required(),

		/**
   * Flag indicating if the editable editor is active.
   * @default false
   * @instance
   * @memberOf FragmentEditableField
   * @private
   * @review
   * @type {boolean}
   */

		_editing: _state.Config.internal().bool().value(false),

		/**
   * Flag indicating if the editable editor should be enabled.
   * @default false
   * @instance
   * @memberOf FragmentEditableField
   * @private
   * @review
   * @type {boolean}
   */

		_showEditor: _state.Config.internal().bool().value(false),

		/**
   * Flag indicating if the click tooltip should be visible.
   * @default false
   * @instance
   * @memberOf FragmentEditableField
   * @private
   * @review
   * @type {boolean}
   */

		_showTooltip: _state.Config.internal().bool().value(false),

		/**
   * Reference element used for aligning the tooltip
   * @default undefined
   * @instance
   * @memberOf FragmentEditableField
   * @review
   * @type {HTMLElement}
   */

		_tooltipAlignElement: _state.Config.internal().object(),

		/**
   * List of buttons rendered inside the tooltip
   * @default undefined
   * @instance
   * @memberOf FragmentEditableField
   * @review
   * @type {Array<{
   *   id: !string,
   *   label: !string
   * }>}
   */

		_tooltipButtons: _state.Config.internal().arrayOf(_state.Config.shapeOf({
			id: _state.Config.string().required(),
			label: _state.Config.string().required()
		})),

		/**
   * Label shown inside editable's tooltip instead of action buttons
   * @default ''
   * @instance
   * @memberOf FragmentEditableField
   * @private
   * @review
   * @type {string}
   */

		_tooltipLabel: _state.Config.internal().string().value('')
	};

	_Soy2.default.register(FragmentEditableField, _FragmentEditableField2.default);

	exports.FragmentEditableField = FragmentEditableField;
	exports.default = FragmentEditableField;
});
//# sourceMappingURL=FragmentEditableField.es.js.map
