/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.admin.web.internal.display.context;

import com.liferay.asset.display.contributor.AssetDisplayContributor;
import com.liferay.asset.display.contributor.AssetDisplayContributorTracker;
import com.liferay.asset.kernel.AssetRendererFactoryRegistryUtil;
import com.liferay.asset.kernel.model.AssetRendererFactory;
import com.liferay.asset.kernel.model.ClassType;
import com.liferay.asset.kernel.model.ClassTypeReader;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.DropdownItem;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.DropdownItemList;
import com.liferay.layout.admin.web.internal.security.permission.resource.LayoutPageTemplatePermission;
import com.liferay.layout.admin.web.internal.util.LayoutPageTemplatePortletUtil;
import com.liferay.layout.page.template.model.LayoutPageTemplateEntry;
import com.liferay.layout.page.template.service.LayoutPageTemplateEntryServiceUtil;
import com.liferay.portal.kernel.dao.search.EmptyOnClickRowChecker;
import com.liferay.portal.kernel.dao.search.RowChecker;
import com.liferay.portal.kernel.dao.search.SearchContainer;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.List;
import java.util.Objects;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletURL;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.servlet.http.HttpServletRequest;

public class DisplayPageDisplayContext {
    private final AssetDisplayContributorTracker _assetDisplayContributorTracker;
    private SearchContainer _displayPagesSearchContainer;
    private String _keywords;
    private Long _layoutPageTemplateEntryId;
    private String _orderByCol;
    private String _orderByType;
    private final RenderRequest _renderRequest;
    private final RenderResponse _renderResponse;
    private final HttpServletRequest _request;
    private final ThemeDisplay _themeDisplay;

    public DisplayPageDisplayContext(RenderRequest renderRequest, RenderResponse renderResponse, HttpServletRequest request) {
        this._renderRequest = renderRequest;
        this._renderResponse = renderResponse;
        this._request = request;
        this._assetDisplayContributorTracker = (AssetDisplayContributorTracker)request.getAttribute("ASSET_DISPLAY_CONTRIBUTOR_TRACKER");
        this._themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
    }

    public List<DropdownItem> getActionDropdownItems() {
        return new DropdownItemList(){
            {
                this.add(dropdownItem -> {
                    dropdownItem.putData("action", "deleteSelectedDisplayPages");
                    dropdownItem.setIcon("times-circle");
                    dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)DisplayPageDisplayContext.this._request, (String)"delete"));
                    dropdownItem.setQuickAction(true);
                });
            }
        };
    }

    public String getClearResultsURL() {
        PortletURL clearResultsURL = this.getPortletURL();
        clearResultsURL.setParameter("keywords", "");
        return clearResultsURL.toString();
    }

    public SearchContainer getDisplayPagesSearchContainer() throws PortalException {
        if (this._displayPagesSearchContainer != null) {
            return this._displayPagesSearchContainer;
        }
        SearchContainer displayPagesSearchContainer = new SearchContainer((PortletRequest)this._renderRequest, this._renderResponse.createRenderURL(), null, "there-are-no-display-pages");
        displayPagesSearchContainer.setRowChecker((RowChecker)new EmptyOnClickRowChecker((PortletResponse)this._renderResponse));
        displayPagesSearchContainer.setOrderByCol(this.getOrderByCol());
        OrderByComparator<LayoutPageTemplateEntry> orderByComparator = LayoutPageTemplatePortletUtil.getLayoutPageTemplateEntryOrderByComparator(this.getOrderByCol(), this.getOrderByType());
        displayPagesSearchContainer.setOrderByComparator(orderByComparator);
        displayPagesSearchContainer.setOrderByType(this.getOrderByType());
        List layoutPageTemplateEntries = null;
        int layoutPageTemplateEntriesCount = 0;
        if (this.isSearch()) {
            layoutPageTemplateEntries = LayoutPageTemplateEntryServiceUtil.getLayoutPageTemplateEntries((long)this._themeDisplay.getScopeGroupId(), (String)this.getKeywords(), (int)1, (int)displayPagesSearchContainer.getStart(), (int)displayPagesSearchContainer.getEnd(), orderByComparator);
            layoutPageTemplateEntriesCount = LayoutPageTemplateEntryServiceUtil.getLayoutPageTemplateEntriesCount((long)this._themeDisplay.getScopeGroupId(), (String)this.getKeywords(), (int)1);
        } else {
            layoutPageTemplateEntries = LayoutPageTemplateEntryServiceUtil.getLayoutPageTemplateEntries((long)this._themeDisplay.getScopeGroupId(), (int)1, (int)displayPagesSearchContainer.getStart(), (int)displayPagesSearchContainer.getEnd(), orderByComparator);
            layoutPageTemplateEntriesCount = LayoutPageTemplateEntryServiceUtil.getLayoutPageTemplateEntriesCount((long)this._themeDisplay.getScopeGroupId(), (int)1);
        }
        displayPagesSearchContainer.setResults(layoutPageTemplateEntries);
        displayPagesSearchContainer.setTotal(layoutPageTemplateEntriesCount);
        this._displayPagesSearchContainer = displayPagesSearchContainer;
        return this._displayPagesSearchContainer;
    }

    public List<DropdownItem> getFilterDropdownItems() {
        return new DropdownItemList(){
            {
                this.addGroup(dropdownGroupItem -> {
                    dropdownGroupItem.setDropdownItems(DisplayPageDisplayContext.this._getFilterNavigationDropdownItems());
                    dropdownGroupItem.setLabel(LanguageUtil.get((HttpServletRequest)DisplayPageDisplayContext.this._request, (String)"filter-by-navigation"));
                });
                this.addGroup(dropdownGroupItem -> {
                    dropdownGroupItem.setDropdownItems(DisplayPageDisplayContext.this._getOrderByDropdownItems());
                    dropdownGroupItem.setLabel(LanguageUtil.get((HttpServletRequest)DisplayPageDisplayContext.this._request, (String)"order-by"));
                });
            }
        };
    }

    public String getKeywords() {
        if (this._keywords != null) {
            return this._keywords;
        }
        this._keywords = ParamUtil.getString((HttpServletRequest)this._request, (String)"keywords");
        return this._keywords;
    }

    public long getLayoutPageTemplateEntryId() {
        if (Validator.isNotNull((Long)this._layoutPageTemplateEntryId)) {
            return this._layoutPageTemplateEntryId;
        }
        this._layoutPageTemplateEntryId = ParamUtil.getLong((HttpServletRequest)this._request, (String)"layoutPageTemplateEntryId");
        return this._layoutPageTemplateEntryId;
    }

    public String getOrderByCol() {
        if (Validator.isNotNull((String)this._orderByCol)) {
            return this._orderByCol;
        }
        this._orderByCol = ParamUtil.getString((HttpServletRequest)this._request, (String)"orderByCol", (String)"create-date");
        return this._orderByCol;
    }

    public String getOrderByType() {
        if (Validator.isNotNull((String)this._orderByType)) {
            return this._orderByType;
        }
        this._orderByType = ParamUtil.getString((HttpServletRequest)this._request, (String)"orderByType", (String)"asc");
        return this._orderByType;
    }

    public PortletURL getPortletURL() {
        String orderByType;
        String orderByCol;
        PortletURL portletURL = this._renderResponse.createRenderURL();
        portletURL.setParameter("mvcPath", "/view_display_pages.jsp");
        portletURL.setParameter("tabs1", "display-pages");
        portletURL.setParameter("redirect", this._themeDisplay.getURLCurrent());
        String keywords = this.getKeywords();
        if (Validator.isNotNull((String)keywords)) {
            portletURL.setParameter("keywords", keywords);
        }
        if (Validator.isNotNull((String)(orderByCol = this.getOrderByCol()))) {
            portletURL.setParameter("orderByCol", orderByCol);
        }
        if (Validator.isNotNull((String)(orderByType = this.getOrderByType()))) {
            portletURL.setParameter("orderByType", orderByType);
        }
        return portletURL;
    }

    public String getSearchActionURL() {
        PortletURL searchActionURL = this.getPortletURL();
        return searchActionURL.toString();
    }

    public String getSortingURL() {
        PortletURL sortingURL = this.getPortletURL();
        sortingURL.setParameter("orderByType", Objects.equals(this.getOrderByType(), "asc") ? "desc" : "asc");
        return sortingURL.toString();
    }

    public String getSubtypeLabel(LayoutPageTemplateEntry layoutPageTemplateEntry) throws PortalException {
        AssetRendererFactory assetRendererFactory = AssetRendererFactoryRegistryUtil.getAssetRendererFactoryByClassName((String)layoutPageTemplateEntry.getClassName());
        if (assetRendererFactory == null || layoutPageTemplateEntry.getClassTypeId() <= 0L) {
            return "";
        }
        ClassTypeReader classTypeReader = assetRendererFactory.getClassTypeReader();
        ClassType classType = classTypeReader.getClassType(layoutPageTemplateEntry.getClassTypeId(), this._themeDisplay.getLocale());
        return classType.getName();
    }

    public int getTotalItems() throws Exception {
        SearchContainer displayPagesSearchContainer = this.getDisplayPagesSearchContainer();
        return displayPagesSearchContainer.getTotal();
    }

    public String getTypeLabel(LayoutPageTemplateEntry layoutPageTemplateEntry) {
        AssetDisplayContributor assetDisplayContributor = this._assetDisplayContributorTracker.getAssetDisplayContributor(layoutPageTemplateEntry.getClassName());
        if (assetDisplayContributor == null) {
            return "";
        }
        return assetDisplayContributor.getLabel(this._themeDisplay.getLocale());
    }

    public boolean isDisabledDisplayPagesManagementBar() throws PortalException {
        return !this._hasDisplayPagesResults();
    }

    public boolean isSearch() {
        return Validator.isNotNull((String)this.getKeywords());
    }

    public boolean isShowAddButton(String actionId) {
        return LayoutPageTemplatePermission.contains(this._themeDisplay.getPermissionChecker(), this._themeDisplay.getSiteGroupId(), actionId);
    }

    public boolean isShowDisplayPagesSearch() throws PortalException {
        if (this._hasDisplayPagesResults()) {
            return true;
        }
        return this.isSearch();
    }

    private List<DropdownItem> _getFilterNavigationDropdownItems() {
        return new DropdownItemList(){
            {
                this.add(dropdownItem -> {
                    dropdownItem.setActive(true);
                    dropdownItem.setHref((Object)DisplayPageDisplayContext.this.getPortletURL());
                    dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)DisplayPageDisplayContext.this._request, (String)"all"));
                });
            }
        };
    }

    private List<DropdownItem> _getOrderByDropdownItems() {
        return new DropdownItemList(){
            {
                this.add(dropdownItem -> {
                    dropdownItem.setActive(Objects.equals(DisplayPageDisplayContext.this.getOrderByCol(), "create-date"));
                    dropdownItem.setHref(DisplayPageDisplayContext.this.getPortletURL(), new Object[]{"orderByCol", "create-date"});
                    dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)DisplayPageDisplayContext.this._request, (String)"create-date"));
                });
                this.add(dropdownItem -> {
                    dropdownItem.setActive(Objects.equals(DisplayPageDisplayContext.this.getOrderByCol(), "name"));
                    dropdownItem.setHref(DisplayPageDisplayContext.this.getPortletURL(), new Object[]{"orderByCol", "name"});
                    dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)DisplayPageDisplayContext.this._request, (String)"name"));
                });
            }
        };
    }

    private boolean _hasDisplayPagesResults() throws PortalException {
        SearchContainer searchContainer = this.getDisplayPagesSearchContainer();
        return searchContainer.getTotal() > 0;
    }
}

