Liferay.Loader.define("layout-admin-web@2.0.15/js/fragments_editor/sidebar/FragmentsEditorSidebar.es", ['exports', 'metal-component/src/all/component', 'metal-state/src/all/state', 'metal-events/src/events', 'metal-soy/src/Soy', './FragmentsEditorSidebar.soy', 'frontend-taglib/contextual_sidebar/ContextualSidebar.es', './SidebarAddedFragments.es', './SidebarAvailableFragments.es', './SidebarMapping.es'], function (exports, _component, _state, _events, _Soy, _FragmentsEditorSidebar) {
	'use strict';

	Object.defineProperty(exports, "__esModule", {
		value: true
	});
	exports.FragmentsEditorSidebar = undefined;

	var _component2 = _interopRequireDefault(_component);

	var _Soy2 = _interopRequireDefault(_Soy);

	var _FragmentsEditorSidebar2 = _interopRequireDefault(_FragmentsEditorSidebar);

	function _interopRequireDefault(obj) {
		return obj && obj.__esModule ? obj : {
			default: obj
		};
	}

	var _extends = Object.assign || function (target) {
		for (var i = 1; i < arguments.length; i++) {
			var source = arguments[i];

			for (var key in source) {
				if (Object.prototype.hasOwnProperty.call(source, key)) {
					target[key] = source[key];
				}
			}
		}

		return target;
	};

	function _classCallCheck(instance, Constructor) {
		if (!(instance instanceof Constructor)) {
			throw new TypeError("Cannot call a class as a function");
		}
	}

	var _createClass = function () {
		function defineProperties(target, props) {
			for (var i = 0; i < props.length; i++) {
				var descriptor = props[i];
				descriptor.enumerable = descriptor.enumerable || false;
				descriptor.configurable = true;
				if ("value" in descriptor) descriptor.writable = true;
				Object.defineProperty(target, descriptor.key, descriptor);
			}
		}

		return function (Constructor, protoProps, staticProps) {
			if (protoProps) defineProperties(Constructor.prototype, protoProps);
			if (staticProps) defineProperties(Constructor, staticProps);
			return Constructor;
		};
	}();

	function _possibleConstructorReturn(self, call) {
		if (!self) {
			throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
		}

		return call && (typeof call === "object" || typeof call === "function") ? call : self;
	}

	function _inherits(subClass, superClass) {
		if (typeof superClass !== "function" && superClass !== null) {
			throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
		}

		subClass.prototype = Object.create(superClass && superClass.prototype, {
			constructor: {
				value: subClass,
				enumerable: false,
				writable: true,
				configurable: true
			}
		});
		if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
	}

	/**
  * Added tab ID
  * @review
  * @type {!string}
  */

	var ADDED_TAB_ID = 'added';

	/**
  * Default selected tab
  * @review
  * @type {!string}
  */

	var DEFAULT_TAB_ID = 'available';

	/**
  * FragmentsEditorSidebar
  * @review
  */

	var FragmentsEditorSidebar = function (_Component) {
		_inherits(FragmentsEditorSidebar, _Component);

		function FragmentsEditorSidebar() {
			_classCallCheck(this, FragmentsEditorSidebar);

			return _possibleConstructorReturn(this, (FragmentsEditorSidebar.__proto__ || Object.getPrototypeOf(FragmentsEditorSidebar)).apply(this, arguments));
		}

		_createClass(FragmentsEditorSidebar, [{
			key: 'created',
			value: function created() {
				var addedTab = this.sidebarTabs.find(function (tab) {
					return tab.id === ADDED_TAB_ID;
				});

				if (addedTab) {
					this._addedTabEnabled = addedTab.enabled;
				}
			}
		}, {
			key: 'dispose',
			value: function dispose() {
				this._disposeTabEventProxy();
			}
		}, {
			key: 'prepareStateForRender',
			value: function prepareStateForRender(state) {
				return _extends({}, state, {
					sidebarTabs: state.sidebarTabs.map(function (sidebarTab) {
						return sidebarTab.id !== ADDED_TAB_ID ? sidebarTab : _extends({}, sidebarTab, { enabled: state._addedTabEnabled });
					})
				});
			}
		}, {
			key: 'rendered',
			value: function rendered() {
				if (this.refs.contextualSidebar && this.refs.contextualSidebar.refs.sidebarTab) {
					this._updateTabEventProxy(this.refs.contextualSidebar.refs.sidebarTab);
				}
			}
		}, {
			key: 'syncVisible',
			value: function syncVisible() {}
		}, {
			key: 'toggleAddedTab',
			value: function toggleAddedTab(enabled) {
				this._addedTabEnabled = !!enabled;

				if (!enabled) {
					this._selectedTab = DEFAULT_TAB_ID;
				}
			}
		}, {
			key: '_disposeTabEventProxy',
			value: function _disposeTabEventProxy() {
				if (this._tabEventProxy) {
					this._tabEventProxy.dispose();

					this._tabEventProxy = null;
				}
			}
		}, {
			key: '_handleHide',
			value: function _handleHide() {
				this.emit('hide');
			}
		}, {
			key: '_handleHideSidebarButtonClick',
			value: function _handleHideSidebarButtonClick() {
				this.emit('hide');
			}
		}, {
			key: '_handleTabClick',
			value: function _handleTabClick(event) {
				this._selectedTab = event.delegateTarget.dataset.tabId || DEFAULT_TAB_ID;
			}
		}, {
			key: '_updateTabEventProxy',
			value: function _updateTabEventProxy(sidebarTab) {
				if (!this._tabEventProxy) {
					this._tabEventProxy = new _events.EventEmitterProxy(sidebarTab, this);
				} else {
					this._tabEventProxy.setOriginEmitter(sidebarTab);
				}
			}
		}]);

		return FragmentsEditorSidebar;
	}(_component2.default);

	/**
  * State definition.
  * @review
  * @static
  * @type {!Object}
  */

	FragmentsEditorSidebar.STATE = {

		/**
   * Tabs being shown in sidebar
   * @default undefined
   * @instance
   * @memberOf FragmentsEditorSidebar
   * @review
   * @type {!Array<{
   *   enabled: bool,
   * 	 id: string,
   * 	 label: string
   * }>}
   */

		sidebarTabs: _state.Config.arrayOf(_state.Config.shapeOf({
			enabled: _state.Config.bool().required(),
			id: _state.Config.string().required(),
			label: _state.Config.string().required()
		})).required(),

		/**
   * Whether to show added tab or not
   * @default null
   * @instance
   * @memberOf FragmentsEditorSidebar
   * @private
   * @review
   * @type {bool}
   */

		_addedTabEnabled: _state.Config.bool().internal().value(null),

		/**
   * Tab selected inside sidebar
   * @default DEFAULT_TAB_ID
   * @instance
   * @memberOf FragmentsEditorSidebar
   * @private
   * @review
   * @type {string}
   */

		_selectedTab: _state.Config.string().internal().value(DEFAULT_TAB_ID),

		/**
   * Event proxy used for propagating tabs events
   * @default null
   * @instance
   * @memberOf FragmentsEditorSidebar
   * @private
   * @review
   * @type {object|null}
   */

		_tabEventProxy: _state.Config.object().internal().value(null)
	};

	_Soy2.default.register(FragmentsEditorSidebar, _FragmentsEditorSidebar2.default);

	exports.FragmentsEditorSidebar = FragmentsEditorSidebar;
	exports.default = FragmentsEditorSidebar;
});
//# sourceMappingURL=FragmentsEditorSidebar.es.js.map
