Liferay.Loader.define("layout-admin-web@2.0.15/js/fragments_editor/FragmentsEditor.es", ['exports', 'metal-component/src/all/component', 'metal-soy/src/Soy', 'metal-state/src/all/state', './fragment_entry_link/FragmentEntryLink.es', './FragmentsEditor.soy', './dialogs/SelectMappingDialog.es', './dialogs/SelectMappingTypeDialog.es', './fragment_entry_link/FragmentEntryLinkList.es', './sidebar/FragmentsEditorSidebar.es', './toolbar/FragmentsEditorToolbar.es'], function (exports, _component, _Soy, _state, _FragmentEntryLink, _FragmentsEditor) {
	'use strict';

	Object.defineProperty(exports, "__esModule", {
		value: true
	});
	exports.FragmentsEditor = undefined;

	var _component2 = _interopRequireDefault(_component);

	var _Soy2 = _interopRequireDefault(_Soy);

	var _FragmentEntryLink2 = _interopRequireDefault(_FragmentEntryLink);

	var _FragmentsEditor2 = _interopRequireDefault(_FragmentsEditor);

	function _interopRequireDefault(obj) {
		return obj && obj.__esModule ? obj : {
			default: obj
		};
	}

	var _extends = Object.assign || function (target) {
		for (var i = 1; i < arguments.length; i++) {
			var source = arguments[i];

			for (var key in source) {
				if (Object.prototype.hasOwnProperty.call(source, key)) {
					target[key] = source[key];
				}
			}
		}

		return target;
	};

	function _defineProperty(obj, key, value) {
		if (key in obj) {
			Object.defineProperty(obj, key, {
				value: value,
				enumerable: true,
				configurable: true,
				writable: true
			});
		} else {
			obj[key] = value;
		}

		return obj;
	}

	function _toConsumableArray(arr) {
		if (Array.isArray(arr)) {
			for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) {
				arr2[i] = arr[i];
			}

			return arr2;
		} else {
			return Array.from(arr);
		}
	}

	function _classCallCheck(instance, Constructor) {
		if (!(instance instanceof Constructor)) {
			throw new TypeError("Cannot call a class as a function");
		}
	}

	var _createClass = function () {
		function defineProperties(target, props) {
			for (var i = 0; i < props.length; i++) {
				var descriptor = props[i];
				descriptor.enumerable = descriptor.enumerable || false;
				descriptor.configurable = true;
				if ("value" in descriptor) descriptor.writable = true;
				Object.defineProperty(target, descriptor.key, descriptor);
			}
		}

		return function (Constructor, protoProps, staticProps) {
			if (protoProps) defineProperties(Constructor.prototype, protoProps);
			if (staticProps) defineProperties(Constructor, staticProps);
			return Constructor;
		};
	}();

	function _possibleConstructorReturn(self, call) {
		if (!self) {
			throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
		}

		return call && (typeof call === "object" || typeof call === "function") ? call : self;
	}

	function _inherits(subClass, superClass) {
		if (typeof superClass !== "function" && superClass !== null) {
			throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
		}

		subClass.prototype = Object.create(superClass && superClass.prototype, {
			constructor: {
				value: subClass,
				enumerable: false,
				writable: true,
				configurable: true
			}
		});
		if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
	}

	var FragmentsEditor = function (_Component) {
		_inherits(FragmentsEditor, _Component);

		function FragmentsEditor() {
			_classCallCheck(this, FragmentsEditor);

			return _possibleConstructorReturn(this, (FragmentsEditor.__proto__ || Object.getPrototypeOf(FragmentsEditor)).apply(this, arguments));
		}

		_createClass(FragmentsEditor, [{
			key: 'rendered',
			value: function rendered(firstRender) {
				if (firstRender) {
					this._translationStatus = this._getTranslationStatus(Object.keys(this.availableLanguages).filter(function (languageId) {
						return languageId !== '_INJECTED_DATA_';
					}), this._getEditableValues());
				}
			}
		}, {
			key: '_deleteFragmentEntryLink',
			value: function _deleteFragmentEntryLink(fragmentEntryLinkId) {
				var _this2 = this;

				if (!this._dirty) {
					this._dirty = true;

					var formData = new FormData();

					formData.append(this.portletNamespace + 'fragmentEntryLinkId', fragmentEntryLinkId);

					fetch(this.deleteFragmentEntryLinkURL, {
						body: formData,
						credentials: 'include',
						method: 'POST'
					}).then(function () {
						_this2._lastSaveDate = new Date().toLocaleTimeString(Liferay.ThemeDisplay.getBCP47LanguageId());

						_this2._dirty = false;
					});
				}
			}
		}, {
			key: '_fetchFragmentContent',
			value: function _fetchFragmentContent(fragmentEntryLinkId) {
				var formData = new FormData();

				formData.append(this.portletNamespace + 'fragmentEntryLinkId', fragmentEntryLinkId);

				return fetch(this.renderFragmentEntryURL, {
					body: formData,
					credentials: 'include',
					method: 'POST'
				}).then(function (response) {
					return response.json();
				}).then(function (response) {
					return response.content;
				});
			}
		}, {
			key: '_focusFragmentEntryLink',
			value: function _focusFragmentEntryLink(fragmentEntryLinkId) {
				this.refs.fragmentsEditorRender.focusFragmentEntryLink(fragmentEntryLinkId);
			}
		}, {
			key: '_getEditableValues',
			value: function _getEditableValues() {
				var _this3 = this;

				return this.fragmentEntryLinks.map(function (fragmentEntryLink) {
					var component = _this3._getFragmentEntryLinkComponent(fragmentEntryLink.fragmentEntryLinkId);

					return component ? component.getEditableValues() : null;
				}).filter(function (editableValues) {
					return editableValues;
				});
			}
		}, {
			key: '_getFragmentEntryLinkComponent',
			value: function _getFragmentEntryLinkComponent(fragmentEntryLinkId) {
				return this.refs.fragmentsEditorRender.refs['fragmentEntryLink_' + fragmentEntryLinkId];
			}
		}, {
			key: '_getFragmentEntryLinkIndex',
			value: function _getFragmentEntryLinkIndex(fragmentEntryLinkId) {
				return this.fragmentEntryLinks.indexOf(this.fragmentEntryLinks.find(function (fragmentEntryLink) {
					return fragmentEntryLink.fragmentEntryLinkId === fragmentEntryLinkId;
				}));
			}
		}, {
			key: '_getNewFragmentEntryLinkPosition',
			value: function _getNewFragmentEntryLinkPosition() {
				var position = Math.max.apply(Math, [0].concat(_toConsumableArray(this.fragmentEntryLinks.map(function (fragmentEntryLink) {
					return fragmentEntryLink.position;
				}))));

				return position + 1;
			}
		}, {
			key: '_getTranslationStatus',
			value: function _getTranslationStatus(languageIds, editableValues) {
				var translationKeys = editableValues.map(function (editableValue) {
					return Object.keys(editableValue).map(function (editableValueId) {
						return editableValue[editableValueId].defaultValue;
					});
				}).reduce(function (acc, val) {
					return acc.concat(val);
				}, []);

				var languageValues = languageIds.map(function (languageId) {
					var values = editableValues.map(function (editableValue) {
						return Object.keys(editableValue).map(function (editableValueId) {
							return editableValue[editableValueId][languageId];
						});
					}).reduce(function (acc, val) {
						return acc.concat(val);
					}, []).filter(function (localeValue) {
						return localeValue;
					});

					return {
						languageId: languageId,
						values: values
					};
				});

				return {
					languageValues: languageValues,
					translationKeys: translationKeys
				};
			}
		}, {
			key: '_handleEditableChanged',
			value: function _handleEditableChanged(data) {
				this._setFragmentEntryLinkEditableValue(data.fragmentEntryLinkId, data.editableId, _defineProperty({}, this.languageId || 'defaultValue', data.value));
			}
		}, {
			key: '_handleFragmentCollectionEntryClick',
			value: function _handleFragmentCollectionEntryClick(event) {
				var _this4 = this;

				if (!this._dirty) {
					this._dirty = true;

					var formData = new FormData();
					var position = this._getNewFragmentEntryLinkPosition();

					formData.append(this.portletNamespace + 'fragmentId', event.fragmentEntryId);

					formData.append(this.portletNamespace + 'classNameId', this.classNameId);

					formData.append(this.portletNamespace + 'classPK', this.classPK);

					formData.append(this.portletNamespace + 'position', position);

					fetch(this.addFragmentEntryLinkURL, {
						body: formData,
						credentials: 'include',
						method: 'POST'
					}).then(function (response) {
						return response.json();
					}).then(function (response) {
						if (!response.fragmentEntryLinkId) {
							throw new Error();
						}

						_this4.fragmentEntryLinks = [].concat(_toConsumableArray(_this4.fragmentEntryLinks), [{
							config: {},
							content: '',
							editableValues: JSON.parse(response.editableValues),
							fragmentEntryId: event.fragmentEntryId,
							fragmentEntryLinkId: response.fragmentEntryLinkId,
							name: event.fragmentName,
							position: position
						}]);

						_this4._focusFragmentEntryLink(response.fragmentEntryLinkId);

						return _this4._fetchFragmentContent(response.fragmentEntryLinkId).then(function (content) {
							var index = _this4._getFragmentEntryLinkIndex(response.fragmentEntryLinkId);

							if (index !== -1) {
								var newFragmentEntryLinks = [].concat(_toConsumableArray(_this4.fragmentEntryLinks));

								var newFragmentEntryLink = _extends({}, newFragmentEntryLinks[index], { content: content });

								newFragmentEntryLinks[index] = newFragmentEntryLink;
								_this4.fragmentEntryLinks = newFragmentEntryLinks;
							}
						}).then(function () {
							_this4._lastSaveDate = new Date().toLocaleTimeString(Liferay.ThemeDisplay.getBCP47LanguageId());

							_this4._dirty = false;

							if (_this4.refs.sidebar) {
								_this4.refs.sidebar.toggleAddedTab(true);
							}

							_this4._focusFragmentEntryLink(response.fragmentEntryLinkId);
						});
					});
				}
			}
		}, {
			key: '_handleFragmentMove',
			value: function _handleFragmentMove(data) {
				var _this5 = this;

				var direction = data.direction;
				var index = this._getFragmentEntryLinkIndex(data.fragmentEntryLinkId);

				if (direction === _FragmentEntryLink2.default.MOVE_DIRECTIONS.DOWN && index < this.fragmentEntryLinks.length - 1 || direction === _FragmentEntryLink2.default.MOVE_DIRECTIONS.UP && index > 0) {
					var formData = new FormData();

					formData.append(this.portletNamespace + 'fragmentEntryLinkId1', this.fragmentEntryLinks[index].fragmentEntryLinkId);

					formData.append(this.portletNamespace + 'fragmentEntryLinkId2', this.fragmentEntryLinks[index + direction].fragmentEntryLinkId);

					fetch(this.updateFragmentEntryLinksURL, {
						body: formData,
						credentials: 'include',
						method: 'POST'
					}).then(function () {
						_this5._lastSaveDate = new Date().toLocaleTimeString(Liferay.ThemeDisplay.getBCP47LanguageId());

						_this5._dirty = false;
					});

					this.fragmentEntryLinks = this._swapListElements(Array.prototype.slice.call(this.fragmentEntryLinks), index, index + direction);
				}
			}
		}, {
			key: '_handleFragmentRemove',
			value: function _handleFragmentRemove(data) {
				var index = this._getFragmentEntryLinkIndex(data.fragmentEntryLinkId);

				if (index !== -1) {
					this.fragmentEntryLinks = [].concat(_toConsumableArray(this.fragmentEntryLinks.slice(0, index)), _toConsumableArray(this.fragmentEntryLinks.slice(index + 1)));

					if (this.fragmentEntryLinks.length === 0 && this.refs.sidebar) {
						this.refs.sidebar.toggleAddedTab(false);
					}

					this._translationStatus = this._getTranslationStatus(Object.keys(this.availableLanguages).filter(function (languageId) {
						return languageId !== '_INJECTED_DATA_';
					}), this._getEditableValues());

					this._deleteFragmentEntryLink(data.fragmentEntryLinkId);
				}
			}
		}, {
			key: '_handleHideContextualSidebar',
			value: function _handleHideContextualSidebar() {
				this._contextualSidebarVisible = false;
			}
		}, {
			key: '_handleMappeableFieldClicked',
			value: function _handleMappeableFieldClicked(event) {
				this._selectMappingDialogEditableId = event.editableId;
				this._selectMappingDialogEditableType = event.editableType;
				this._selectMappingDialogFragmentEntryLinkId = event.fragmentEntryLinkId;
				this._selectMappingDialogMappedFieldId = event.mappedFieldId;

				if (this.selectedMappingTypes && this.selectedMappingTypes.type) {
					this._selectMappingDialogVisible = true;
				} else {
					this._handleSelectAssetTypeButtonClick();
				}
			}
		}, {
			key: '_handleMappeableFieldSelected',
			value: function _handleMappeableFieldSelected(event) {
				this._setFragmentEntryLinkEditableValue(event.fragmentEntryLinkId, event.editableId, { mappedField: event.key });
			}
		}, {
			key: '_handleMappingTypeSelected',
			value: function _handleMappingTypeSelected(event) {
				this.selectedMappingTypes = event.mappingTypes;

				if (this._selectMappingDialogFragmentEntryLinkId && this._selectMappingDialogEditableId) {

					this._selectMappingDialogVisible = true;
				}
			}
		}, {
			key: '_handleSelectAssetTypeButtonClick',
			value: function _handleSelectAssetTypeButtonClick() {
				this._selectMappingTypeDialogVisible = true;
			}
		}, {
			key: '_handleSelectMappingDialogVisibleChanged',
			value: function _handleSelectMappingDialogVisibleChanged(change) {
				this._selectMappingDialogVisible = change.newVal;
			}
		}, {
			key: '_handleSelectMappingTypeDialogVisibleChanged',
			value: function _handleSelectMappingTypeDialogVisibleChanged(change) {
				this._selectMappingTypeDialogVisible = change.newVal;
			}
		}, {
			key: '_handleToggleContextualSidebarButtonClick',
			value: function _handleToggleContextualSidebarButtonClick() {
				this._contextualSidebarVisible = !this._contextualSidebarVisible;
			}
		}, {
			key: '_handleToggleHighlightMapping',
			value: function _handleToggleHighlightMapping() {
				this._highlightMapping = !this._highlightMapping;
			}
		}, {
			key: '_handleTranslationLanguageChange',
			value: function _handleTranslationLanguageChange(event) {
				this.languageId = event.languageId;
			}
		}, {
			key: '_swapListElements',
			value: function _swapListElements(list, indexA, indexB) {
				var _ref = [list[indexB], list[indexA]];
				list[indexA] = _ref[0];
				list[indexB] = _ref[1];


				return list;
			}
		}, {
			key: '_setFragmentEntryLinkEditableValue',
			value: function _setFragmentEntryLinkEditableValue(fragmentEntryLinkId, editableValueId, editableValueContent) {
				var component = this._getFragmentEntryLinkComponent(fragmentEntryLinkId);

				var index = this._getFragmentEntryLinkIndex(fragmentEntryLinkId);

				if (component && index !== -1) {
					var newEditableValues = component.setEditableValue(editableValueId, editableValueContent);

					var newFragmentEntryLink = _extends({}, this.fragmentEntryLinks[index], { editableValues: newEditableValues });

					var newFragmentEntryLinks = [].concat(_toConsumableArray(this.fragmentEntryLinks));
					newFragmentEntryLinks[index] = newFragmentEntryLink;

					this.fragmentEntryLinks = newFragmentEntryLinks;

					this._updateFragmentEntryLink(newFragmentEntryLink);
				}
			}
		}, {
			key: '_updateFragmentEntryLink',
			value: function _updateFragmentEntryLink(fragmentEntryLink) {
				var _this6 = this;

				if (!this._dirty) {
					this._dirty = true;

					var formData = new FormData();

					formData.append(this.portletNamespace + 'fragmentEntryLinkId', fragmentEntryLink.fragmentEntryLinkId);

					formData.append(this.portletNamespace + 'editableValues', JSON.stringify(fragmentEntryLink.editableValues));

					fetch(this.editFragmentEntryLinkURL, {
						body: formData,
						credentials: 'include',
						method: 'POST'
					}).then(function () {
						_this6._lastSaveDate = new Date().toLocaleTimeString(Liferay.ThemeDisplay.getBCP47LanguageId());

						_this6._translationStatus = _this6._getTranslationStatus(Object.keys(_this6.availableLanguages).filter(function (languageId) {
							return languageId !== '_INJECTED_DATA_';
						}), _this6._getEditableValues());

						_this6._dirty = false;
					});
				}
			}
		}]);

		return FragmentsEditor;
	}(_component2.default);

	/**
  * State definition.
  * @review
  * @static
  * @type {!Object}
  */

	FragmentsEditor.STATE = {

		/**
   * URL for associating fragment entries to the underlying model.
   * @default undefined
   * @instance
   * @memberOf FragmentsEditor
   * @review
   * @type {!string}
   */

		addFragmentEntryLinkURL: _state.Config.string().required(),

		/**
   * List of available languages for translation.
   * @default undefined
   * @instance
   * @memberOf FragmentsEditor
   * @review
   * @type {!object}
   */

		availableLanguages: _state.Config.object().required(),

		/**
   * Class name id used for storing changes.
   * @default undefined
   * @instance
   * @memberOf FragmentsEditor
   * @review
   * @type {!string}
   */

		classNameId: _state.Config.string().required(),

		/**
   * Class primary key used for storing changes.
   * @default undefined
   * @instance
   * @memberOf FragmentsEditor
   * @review
   * @type {!string}
   */

		classPK: _state.Config.string().required(),

		/**
   * Default configurations for AlloyEditor instances.
   * @default {}
   * @instance
   * @memberOf FragmentsEditor
   * @review
   * @type {object}
   */

		defaultEditorConfigurations: _state.Config.object().value({}),

		/**
   * Default language id.
   * @default undefined
   * @instance
   * @memberOf FragmentsEditor
   * @review
   * @type {!string}
   */

		defaultLanguageId: _state.Config.string().required(),

		/**
   * URL for removing fragment entries of the underlying model.
   * @default undefined
   * @instance
   * @memberOf FragmentsEditor
   * @review
   * @type {!string}
   */

		deleteFragmentEntryLinkURL: _state.Config.string().required(),

		/**
   * URL for updating a distinct fragment entries of the editor.
   * @default undefined
   * @instance
   * @memberOf FragmentsEditor
   * @review
   * @type {!string}
   */

		editFragmentEntryLinkURL: _state.Config.string().required(),

		/**
   * Available entries that can be used, organized by collections.
   * @default undefined
   * @instance
   * @memberOf FragmentsEditor
   * @review
   * @type {!Array<object>}
   */

		fragmentCollections: _state.Config.arrayOf(_state.Config.shapeOf({
			entries: _state.Config.arrayOf(_state.Config.shapeOf({
				fragmentEntryId: _state.Config.string().required(),
				name: _state.Config.string().required()
			})).required(),
			fragmentCollectionId: _state.Config.string().required(),
			name: _state.Config.string().required()
		})).required(),

		/**
   * List of fragment instances being used, the order
   * of the elements in this array defines their position.
   * @default []
   * @instance
   * @memberOf FragmentsEditor
   * @review
   * @type {Array<{
   *   config: Object,
   *   content: string,
   *   editableValues: Object,
   *   fragmentEntryId: !string,
   *   fragmentEntryLinkId: !string,
   *   name: !string,
   *   position: !number
   * }>}
   */

		fragmentEntryLinks: _state.Config.arrayOf(_state.Config.shapeOf({
			config: _state.Config.object().value({}),
			content: _state.Config.any().value(''),
			editableValues: _state.Config.object().value({}),
			fragmentEntryId: _state.Config.string().required(),
			fragmentEntryLinkId: _state.Config.string().required(),
			name: _state.Config.string().required(),
			position: _state.Config.number().required()
		})).value([]),

		/**
   * URL for obtaining the class types of an asset
   * created.
   * @default undefined
   * @instance
   * @memberOf FragmentsEditor
   * @review
   * @type {!string}
   */

		getAssetClassTypesURL: _state.Config.string(),

		/**
   * URL for obtaining the asset types for which asset display pages can be
   * created.
   * @default undefined
   * @instance
   * @memberOf FragmentsEditor
   * @review
   * @type {!string}
   */

		getAssetDisplayContributorsURL: _state.Config.string(),

		/**
   * Optional ID provided by the template system.
   * @default ''
   * @instance
   * @memberOf FragmentsEditor
   * @review
   * @type {string}
   */

		id: _state.Config.string().value(''),

		/**
   * Image selector url
   * @default undefined
   * @instance
   * @memberOf FragmentsEditor
   * @review
   * @type {!string}
   */

		imageSelectorURL: _state.Config.string().required(),

		/**
   * URL for getting the list of mapping fields
   * @default null
   * @instance
   * @memberOf FragmentsEditor
   * @review
   * @type {string}
   */

		mappingFieldsURL: _state.Config.string().value(null),

		/**
   * Currently selected language id.
   * @default undefined
   * @instance
   * @memberOf FragmentsEditor
   * @review
   * @type {!string}
   */

		languageId: _state.Config.string().required(),

		/**
   * Portlet namespace needed for prefixing form inputs
   * @default undefined
   * @instance
   * @memberOf FragmentsEditor
   * @review
   * @type {!string}
   */

		portletNamespace: _state.Config.string().required(),

		/**
   *
   * @default undefined
   * @instance
   * @memberOf FragmentsEditor
   * @review
   * @type {!string}
   */

		publishLayoutPageTemplateEntryURL: _state.Config.string(),

		/**
   * URL for redirect.
   * @default undefined
   * @instance
   * @memberOf FragmentsEditor
   * @review
   * @type {!string}
   */

		redirectURL: _state.Config.string().required(),

		/**
   * URL for getting a fragment content.
   * @default undefined
   * @instance
   * @memberOf FragmentsEditor
   * @review
   * @type {!string}
   */

		renderFragmentEntryURL: _state.Config.string().required(),

		/**
   * Selected mapping types
   * @default {}
   * @instance
   * @memberOf FragmentsEditor
   * @review
   * @type {{
   *   subtype: {
   *   	id: !string,
   *   	label: !string
   *   },
   *   type: {
   *   	id: !string,
   *   	label: !string
   *   }
   * }}
   */

		selectedMappingTypes: _state.Config.shapeOf({
			subtype: _state.Config.shapeOf({
				id: _state.Config.string().required(),
				label: _state.Config.string().required()
			}),
			type: _state.Config.shapeOf({
				id: _state.Config.string().required(),
				label: _state.Config.string().required()
			})
		}).value({}),

		/**
   * Path of the available icons.
   * @default undefined
   * @instance
   * @memberOf FragmentsEditor
   * @review
   * @type {!string}
   */

		spritemap: _state.Config.string().required(),

		/**
      * URL for swapping to fragmentEntryLinks.
      * @default undefined
      * @instance
      * @memberOf FragmentsEditor
      * @review
      * @type {!string}
      */

		updateFragmentEntryLinksURL: _state.Config.string().required(),

		/**
   * URL for updating the asset type associated to a template.
   * @default undefined
   * @instance
   * @memberOf FragmentsEditor
   * @review
   * @type {!string}
   */

		updateLayoutPageTemplateEntryAssetTypeURL: _state.Config.string(),

		/**
   * Allow opening/closing contextual sidebar
   * @default true
   * @instance
   * @memberOf FragmentsEditor
   * @private
   * @review
   * @type {boolean}
   */

		_contextualSidebarVisible: _state.Config.bool().internal().value(true),

		/**
   * When true, it indicates that are changes pending to save.
   * @default false
   * @instance
   * @memberOf FragmentsEditor
   * @private
   * @review
   * @type {boolean}
   */

		_dirty: _state.Config.bool().internal().value(false),

		/**
   * If true, editable values should be highlighted.
   * @default false
   * @instance
   * @memberOf FragmentsEditor
   * @private
   * @review
   * @type {boolean}
   */

		_highlightMapping: _state.Config.bool().internal().value(false),

		/**
   * Last data when the autosave has been executed.
   * @default ''
   * @instance
   * @memberOf FragmentsEditor
   * @private
   * @type {string}
   */

		_lastSaveDate: _state.Config.string().internal().value(''),

		/**
   * Editable type of the field that is being mapped
   * @default ''
   * @instance
   * @memberOf FragmentsEditor
   * @private
   * @review
   * @type {string}
   */

		_selectMappingDialogEditableType: _state.Config.string().internal().value(''),

		/**
   * EditableId of the field that is being mapped
   * @default ''
   * @instance
   * @memberOf FragmentsEditor
   * @private
   * @review
   * @type {string}
   */

		_selectMappingDialogEditableId: _state.Config.string().internal().value(''),

		/**
   * FragmentEntryLinkId of the field that is being mapped
   * @default ''
   * @instance
   * @memberOf FragmentsEditor
   * @private
   * @review
   * @type {string}
   */

		_selectMappingDialogFragmentEntryLinkId: _state.Config.string().internal().value(''),

		/**
   * Mapped field ID of the field that is being mapped
   * @default ''
   * @instance
   * @memberOf FragmentsEditor
   * @private
   * @review
   * @type {string}
   */

		_selectMappingDialogMappedFieldId: _state.Config.string().internal().value(''),

		/**
   * Flag indicating if the SelectMappingDialog should be shown
   * @default false
   * @instance
   * @memberOf FragmentsEditor
   * @private
   * @review
   * @type {boolean}
   */

		_selectMappingDialogVisible: _state.Config.bool().internal().value(false),

		/**
   * Flag indicating if the SelectMappingTypeDialog should be shown
   * @default false
   * @instance
   * @memberOf FragmentsEditor
   * @private
   * @review
   * @type {boolean}
   */

		_selectMappingTypeDialogVisible: _state.Config.bool().internal().value(false)
	};

	_Soy2.default.register(FragmentsEditor, _FragmentsEditor2.default);

	exports.FragmentsEditor = FragmentsEditor;
	exports.default = FragmentsEditor;
});
//# sourceMappingURL=FragmentsEditor.es.js.map
