/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.admin.web.internal.exportimport.data.handler;

import com.liferay.counter.kernel.service.CounterLocalService;
import com.liferay.exportimport.controller.PortletExportController;
import com.liferay.exportimport.controller.PortletImportController;
import com.liferay.exportimport.data.handler.base.BaseStagedModelDataHandler;
import com.liferay.exportimport.kernel.lar.ExportImportHelper;
import com.liferay.exportimport.kernel.lar.ExportImportPathUtil;
import com.liferay.exportimport.kernel.lar.ExportImportProcessCallbackRegistry;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.PortletDataContextFactory;
import com.liferay.exportimport.kernel.lar.PortletDataException;
import com.liferay.exportimport.kernel.lar.PortletDataHandlerStatusMessageSender;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandler;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.exportimport.kernel.lar.StagedModelModifiedDateComparator;
import com.liferay.exportimport.kernel.lifecycle.ExportImportLifecycleManager;
import com.liferay.exportimport.kernel.staging.LayoutStagingUtil;
import com.liferay.exportimport.kernel.staging.Staging;
import com.liferay.exportimport.lar.PermissionImporter;
import com.liferay.fragment.model.FragmentEntryLink;
import com.liferay.fragment.service.FragmentEntryLinkLocalService;
import com.liferay.petra.reflect.ReflectionUtil;
import com.liferay.portal.kernel.backgroundtask.BackgroundTaskThreadLocal;
import com.liferay.portal.kernel.exception.NoSuchLayoutException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Image;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutBranch;
import com.liferay.portal.kernel.model.LayoutFriendlyURL;
import com.liferay.portal.kernel.model.LayoutPrototype;
import com.liferay.portal.kernel.model.LayoutRevision;
import com.liferay.portal.kernel.model.LayoutSet;
import com.liferay.portal.kernel.model.LayoutStagingHandler;
import com.liferay.portal.kernel.model.LayoutTemplate;
import com.liferay.portal.kernel.model.LayoutTypePortlet;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.ImageLocalService;
import com.liferay.portal.kernel.service.LayoutFriendlyURLLocalService;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.service.LayoutPrototypeLocalService;
import com.liferay.portal.kernel.service.LayoutSetLocalService;
import com.liferay.portal.kernel.service.LayoutTemplateLocalService;
import com.liferay.portal.kernel.service.PortletLocalService;
import com.liferay.portal.kernel.service.ResourceLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.service.permission.PortletPermissionUtil;
import com.liferay.portal.kernel.settings.PortletInstanceSettingsLocator;
import com.liferay.portal.kernel.settings.Settings;
import com.liferay.portal.kernel.settings.SettingsFactoryUtil;
import com.liferay.portal.kernel.settings.SettingsLocator;
import com.liferay.portal.kernel.transaction.Propagation;
import com.liferay.portal.kernel.transaction.TransactionConfig;
import com.liferay.portal.kernel.transaction.TransactionInvokerUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.model.adapter.impl.StagedThemeImpl;
import com.liferay.portal.service.impl.LayoutLocalServiceHelper;
import com.liferay.portal.util.PropsValues;
import com.liferay.sites.kernel.util.SitesUtil;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Callable;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={StagedModelDataHandler.class})
public class LayoutStagedModelDataHandler
extends BaseStagedModelDataHandler<Layout> {
    public static final String[] CLASS_NAMES = new String[]{Layout.class.getName()};
    private static final String _SAME_GROUP_FRIENDLY_URL = "/[$SAME_GROUP_FRIENDLY_URL$]";
    private static final Log _log = LogFactoryUtil.getLog(LayoutStagedModelDataHandler.class);
    private static final TransactionConfig _transactionConfig = TransactionConfig.Factory.create((Propagation)Propagation.SUPPORTS, (Class[])new Class[]{PortalException.class, SystemException.class}, (Class[])new Class[0]);
    private CounterLocalService _counterLocalService;
    @Reference
    private ExportImportHelper _exportImportHelper;
    private ExportImportLifecycleManager _exportImportLifecycleManager;
    @Reference
    private ExportImportProcessCallbackRegistry _exportImportProcessCallbackRegistry;
    @Reference
    private FragmentEntryLinkLocalService _fragmentEntryLinkLocalService;
    private GroupLocalService _groupLocalService;
    private ImageLocalService _imageLocalService;
    private LayoutFriendlyURLLocalService _layoutFriendlyURLLocalService;
    private LayoutLocalService _layoutLocalService;
    private LayoutLocalServiceHelper _layoutLocalServiceHelper;
    private LayoutPrototypeLocalService _layoutPrototypeLocalService;
    private LayoutSetLocalService _layoutSetLocalService;
    private LayoutTemplateLocalService _layoutTemplateLocalService;
    @Reference
    private PermissionImporter _permissionImporter;
    @Reference
    private Portal _portal;
    @Reference
    private PortletDataContextFactory _portletDataContextFactory;
    @Reference
    private PortletDataHandlerStatusMessageSender _portletDataHandlerStatusMessageSender;
    private PortletExportController _portletExportController;
    private PortletImportController _portletImportController;
    private PortletLocalService _portletLocalService;
    private ResourceLocalService _resourceLocalService;
    @Reference
    private Staging _staging;
    @Reference
    private UserLocalService _userLocalService;

    public void deleteStagedModel(Layout layout) throws PortalException {
        this._layoutLocalService.deleteLayout(layout);
    }

    public void deleteStagedModel(String uuid, long groupId, String className, String extraData) throws PortalException {
        JSONObject extraDataJSONObject = JSONFactoryUtil.createJSONObject((String)extraData);
        boolean privateLayout = extraDataJSONObject.getBoolean("privateLayout");
        Layout layout = this._layoutLocalService.fetchLayoutByUuidAndGroupId(uuid, groupId, privateLayout);
        if (layout != null) {
            this.deleteStagedModel(layout);
        }
    }

    public List<Layout> fetchStagedModelsByUuidAndCompanyId(String uuid, long companyId) {
        return this._layoutLocalService.getLayoutsByUuidAndCompanyId(uuid, companyId, -1, -1, (OrderByComparator)new StagedModelModifiedDateComparator());
    }

    public String[] getClassNames() {
        return CLASS_NAMES;
    }

    public String getDisplayName(Layout layout) {
        return layout.getNameCurrentValue();
    }

    public Map<String, String> getReferenceAttributes(PortletDataContext portletDataContext, Layout layout) {
        HashMap<String, String> referenceAttributes = new HashMap<String, String>();
        referenceAttributes.put("layout-id", String.valueOf(layout.getLayoutId()));
        referenceAttributes.put("private-layout", String.valueOf(layout.isPrivateLayout()));
        return referenceAttributes;
    }

    public boolean validateReference(PortletDataContext portletDataContext, Element referenceElement) {
        this.validateMissingGroupReference(portletDataContext, referenceElement);
        String uuid = referenceElement.attributeValue("uuid");
        Map groupIds = portletDataContext.getNewPrimaryKeysMap(Group.class);
        long groupId = GetterUtil.getLong((String)referenceElement.attributeValue("group-id"));
        groupId = MapUtil.getLong((Map)groupIds, (long)groupId);
        boolean privateLayout = GetterUtil.getBoolean((String)referenceElement.attributeValue("private-layout"));
        Layout existingLayout = this.fetchMissingReference(uuid, groupId, privateLayout);
        return existingLayout != null;
    }

    protected String[] appendPortletIds(String[] portletIds, String[] newPortletIds, String portletsMergeMode) {
        for (String portletId : newPortletIds) {
            if (ArrayUtil.contains((Object[])portletIds, (Object)portletId)) continue;
            portletIds = portletsMergeMode.equals("ADD_TO_BOTTOM") ? (String[])ArrayUtil.append((Object[])portletIds, (Object)portletId) : (String[])ArrayUtil.append((Object[])new String[]{portletId}, (Object[])portletIds);
        }
        return portletIds;
    }

    protected void deleteMissingLayoutFriendlyURLs(PortletDataContext portletDataContext, Layout layout) {
        Map layoutFriendlyURLIds = portletDataContext.getNewPrimaryKeysMap(LayoutFriendlyURL.class);
        List layoutFriendlyURLs = this._layoutFriendlyURLLocalService.getLayoutFriendlyURLs(layout.getPlid());
        for (LayoutFriendlyURL layoutFriendlyURL : layoutFriendlyURLs) {
            if (layoutFriendlyURLIds.containsValue(layoutFriendlyURL.getLayoutFriendlyURLId())) continue;
            this._layoutFriendlyURLLocalService.deleteLayoutFriendlyURL(layoutFriendlyURL);
        }
    }

    protected void doExportStagedModel(PortletDataContext portletDataContext, Layout layout) throws Exception {
        Layout parentLayout;
        Element layoutElement = portletDataContext.getExportDataElement((ClassedModel)layout);
        this.populateElementLayoutMetadata(layoutElement, layout);
        layoutElement.addAttribute("action", "add");
        portletDataContext.setPlid(layout.getPlid());
        long parentLayoutId = layout.getParentLayoutId();
        if (parentLayoutId != 0L && (parentLayout = this._layoutLocalService.fetchLayout(layout.getGroupId(), layout.isPrivateLayout(), parentLayoutId)) != null) {
            StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)layout, (StagedModel)parentLayout, (String)"parent");
            layoutElement.addAttribute("parent-layout-uuid", parentLayout.getUuid());
        }
        List layoutFriendlyURLs = this._layoutFriendlyURLLocalService.getLayoutFriendlyURLs(layout.getPlid());
        for (LayoutFriendlyURL layoutFriendlyURL : layoutFriendlyURLs) {
            StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)layout, (StagedModel)layoutFriendlyURL, (String)"dependency");
        }
        List fragmentEntryLinks = this._fragmentEntryLinkLocalService.getFragmentEntryLinks(layout.getGroupId(), this._portal.getClassNameId(Layout.class), layout.getPlid());
        for (FragmentEntryLink fragmentEntryLink : fragmentEntryLinks) {
            StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)layout, (StagedModel)fragmentEntryLink, (String)"dependency");
        }
        if (layout.isIconImage()) {
            this.exportLayoutIconImage(portletDataContext, layout, layoutElement);
        }
        if (Objects.equals(layout.getType(), "link_to_layout")) {
            this.exportLinkedLayout(portletDataContext, layout, layoutElement);
        } else if (Objects.equals(layout.getType(), "portlet")) {
            this.exportLayoutPortlets(portletDataContext, layout, layoutElement);
        }
        this.fixExportTypeSettings(layout);
        this.exportTheme(portletDataContext, layout);
        portletDataContext.addClassedModel(layoutElement, ExportImportPathUtil.getModelPath((StagedModel)layout), (ClassedModel)LayoutStagingUtil.mergeLayoutRevisionIntoLayout((Layout)layout));
    }

    protected void doImportMissingReference(PortletDataContext portletDataContext, Element referenceElement) throws PortletDataException {
        this.importMissingGroupReference(portletDataContext, referenceElement);
        String uuid = referenceElement.attributeValue("uuid");
        Map groupIds = portletDataContext.getNewPrimaryKeysMap(Group.class);
        long groupId = GetterUtil.getLong((String)referenceElement.attributeValue("group-id"));
        groupId = MapUtil.getLong((Map)groupIds, (long)groupId);
        boolean privateLayout = GetterUtil.getBoolean((String)referenceElement.attributeValue("private-layout"));
        Layout existingLayout = this._layoutLocalService.fetchLayoutByUuidAndGroupId(uuid, groupId, privateLayout);
        if (existingLayout == null || existingLayout.getGroupId() != portletDataContext.getGroupId() || existingLayout.isPrivateLayout() != portletDataContext.isPrivateLayout()) {
            return;
        }
        Map layouts = portletDataContext.getNewPrimaryKeysMap(Layout.class + ".layout");
        long layoutId = GetterUtil.getLong((String)referenceElement.attributeValue("layout-id"));
        layouts.put(layoutId, existingLayout);
        Map layoutPlids = portletDataContext.getNewPrimaryKeysMap(Layout.class);
        long plid = GetterUtil.getLong((String)referenceElement.attributeValue("class-pk"));
        layoutPlids.put(plid, existingLayout.getPlid());
    }

    protected void doImportStagedModel(PortletDataContext portletDataContext, Layout layout) throws Exception {
        long layoutId;
        final long groupId = portletDataContext.getGroupId();
        long userId = portletDataContext.getUserId(layout.getUserUuid());
        Element layoutElement = portletDataContext.getImportDataStagedModelElement((StagedModel)layout);
        long oldLayoutId = layoutId = GetterUtil.getLong((String)layoutElement.attributeValue("layout-id"));
        final boolean privateLayout = portletDataContext.isPrivateLayout();
        Map layouts = portletDataContext.getNewPrimaryKeysMap(Layout.class + ".layout");
        Layout existingLayout = null;
        Layout importedLayout = null;
        String friendlyURL = layout.getFriendlyURL();
        String layoutsImportMode = MapUtil.getString((Map)portletDataContext.getParameterMap(), (String)"LAYOUTS_IMPORT_MODE", (String)"MERGE_BY_LAYOUT_UUID");
        if (layoutsImportMode.equals("ADD_AS_NEW")) {
            layoutId = this._layoutLocalService.getNextLayoutId(groupId, privateLayout);
            friendlyURL = "/" + layoutId;
        } else if (layoutsImportMode.equals("MERGE_BY_LAYOUT_NAME")) {
            Locale locale = LocaleUtil.getSiteDefault();
            String localizedName = layout.getName(locale);
            List previousLayouts = this._layoutLocalService.getLayouts(groupId, privateLayout);
            for (Layout curLayout : previousLayouts) {
                if (!localizedName.equals(curLayout.getName(locale)) && !friendlyURL.equals(curLayout.getFriendlyURL())) continue;
                existingLayout = curLayout;
                break;
            }
            if (existingLayout == null) {
                layoutId = this._layoutLocalService.getNextLayoutId(groupId, privateLayout);
            }
        } else if (layoutsImportMode.equals("CREATED_FROM_PROTOTYPE")) {
            existingLayout = this._layoutLocalService.fetchLayoutByUuidAndGroupId(layout.getUuid(), groupId, privateLayout);
            if (SitesUtil.isLayoutModifiedSinceLastMerge((Layout)existingLayout)) {
                layouts.put(oldLayoutId, existingLayout);
                return;
            }
            LayoutFriendlyURL layoutFriendlyURL = this._layoutFriendlyURLLocalService.fetchFirstLayoutFriendlyURL(groupId, privateLayout, friendlyURL);
            if (layoutFriendlyURL != null && existingLayout == null) {
                Layout mergeFailFriendlyURLLayout = this._layoutLocalService.getLayout(layoutFriendlyURL.getPlid());
                SitesUtil.addMergeFailFriendlyURLLayout((Layout)mergeFailFriendlyURLLayout);
                if (!_log.isWarnEnabled()) {
                    return;
                }
                StringBundler sb = new StringBundler(6);
                sb.append("Layout with layout ID ");
                sb.append(layout.getLayoutId());
                sb.append(" cannot be propagated because the friendly URL ");
                sb.append("conflicts with the friendly URL of layout with ");
                sb.append("layout ID ");
                sb.append(mergeFailFriendlyURLLayout.getLayoutId());
                _log.warn((Object)sb.toString());
                return;
            }
        } else {
            existingLayout = this._layoutLocalService.fetchLayoutByUuidAndGroupId(layout.getUuid(), groupId, privateLayout);
            if (existingLayout == null) {
                existingLayout = this._layoutLocalService.fetchLayoutByFriendlyURL(groupId, privateLayout, friendlyURL);
            }
            if (existingLayout == null) {
                layoutId = this._layoutLocalService.getNextLayoutId(groupId, privateLayout);
            }
        }
        if (_log.isDebugEnabled()) {
            StringBundler sb = new StringBundler(7);
            sb.append("Layout with {groupId=");
            sb.append(groupId);
            sb.append(",privateLayout=");
            sb.append(privateLayout);
            sb.append(",layoutId=");
            sb.append(layoutId);
            if (existingLayout == null) {
                sb.append("} does not exist");
                _log.debug((Object)sb.toString());
            } else {
                sb.append("} exists");
                _log.debug((Object)sb.toString());
            }
        }
        if (existingLayout == null) {
            long plid = this._counterLocalService.increment();
            importedLayout = this._layoutLocalService.createLayout(plid);
            if (layoutsImportMode.equals("CREATED_FROM_PROTOTYPE")) {
                importedLayout.setSourcePrototypeLayoutUuid(layout.getUuid());
                layoutId = this._layoutLocalService.getNextLayoutId(groupId, privateLayout);
            } else {
                importedLayout.setCreateDate(layout.getCreateDate());
                importedLayout.setModifiedDate(layout.getModifiedDate());
                importedLayout.setLayoutPrototypeUuid(layout.getLayoutPrototypeUuid());
                importedLayout.setLayoutPrototypeLinkEnabled(layout.isLayoutPrototypeLinkEnabled());
                importedLayout.setSourcePrototypeLayoutUuid(layout.getSourcePrototypeLayoutUuid());
            }
            importedLayout.setUuid(layout.getUuid());
            importedLayout.setGroupId(groupId);
            importedLayout.setUserId(userId);
            importedLayout.setPrivateLayout(privateLayout);
            importedLayout.setLayoutId(layoutId);
            this.initNewLayoutPermissions(portletDataContext.getCompanyId(), groupId, userId, layout, importedLayout, privateLayout);
            LayoutSet layoutSet = this._layoutSetLocalService.getLayoutSet(groupId, privateLayout);
            importedLayout.setLayoutSet(layoutSet);
        } else {
            importedLayout = existingLayout;
        }
        portletDataContext.setPlid(importedLayout.getPlid());
        portletDataContext.setOldPlid(layout.getPlid());
        long parentLayoutId = layout.getParentLayoutId();
        String parentLayoutUuid = GetterUtil.getString((String)layoutElement.attributeValue("parent-layout-uuid"));
        Element parentLayoutElement = portletDataContext.getReferenceDataElement((StagedModel)layout, Layout.class, layout.getGroupId(), parentLayoutUuid);
        if (parentLayoutId != 0L && parentLayoutElement != null) {
            StagedModelDataHandlerUtil.importStagedModel((PortletDataContext)portletDataContext, (Element)parentLayoutElement);
            Layout importedParentLayout = (Layout)layouts.get(parentLayoutId);
            parentLayoutId = importedParentLayout.getLayoutId();
        }
        if (_log.isDebugEnabled()) {
            StringBundler sb = new StringBundler(4);
            sb.append("Importing layout with layout ID ");
            sb.append(layoutId);
            sb.append(" and parent layout ID ");
            sb.append(parentLayoutId);
            _log.debug((Object)sb.toString());
        }
        importedLayout.setCompanyId(portletDataContext.getCompanyId());
        if (layout.getLayoutPrototypeUuid() != null) {
            importedLayout.setModifiedDate(new Date());
        }
        importedLayout.setParentLayoutId(parentLayoutId);
        importedLayout.setName(layout.getName());
        importedLayout.setTitle(layout.getTitle());
        importedLayout.setDescription(layout.getDescription());
        importedLayout.setKeywords(layout.getKeywords());
        importedLayout.setRobots(layout.getRobots());
        importedLayout.setType(layout.getType());
        String portletsMergeMode = MapUtil.getString((Map)portletDataContext.getParameterMap(), (String)"PORTLETS_MERGE_MODE", (String)"REPLACE");
        if (Objects.equals(layout.getType(), "portlet") && Validator.isNotNull((String)layout.getTypeSettings()) && !portletsMergeMode.equals("REPLACE")) {
            this.mergePortlets(importedLayout, layout.getTypeSettings(), portletsMergeMode);
        } else if (Objects.equals(layout.getType(), "link_to_layout")) {
            this.importLinkedLayout(portletDataContext, layout, importedLayout, layoutElement);
            this.updateTypeSettings(importedLayout, layout);
        } else {
            this.updateTypeSettings(importedLayout, layout);
        }
        importedLayout.setHidden(layout.isHidden());
        importedLayout.setFriendlyURL(this.getUniqueFriendlyURL(portletDataContext, importedLayout, friendlyURL));
        if (layout.getIconImageId() > 0L) {
            this.importLayoutIconImage(portletDataContext, importedLayout, layoutElement);
        } else if (importedLayout.getIconImageId() > 0L) {
            this._imageLocalService.deleteImage(importedLayout.getIconImageId());
            importedLayout.setIconImageId(0L);
        }
        if (existingLayout == null) {
            try {
                final long finalParentLayoutId = parentLayoutId;
                int priority = (Integer)TransactionInvokerUtil.invoke((TransactionConfig)_transactionConfig, (Callable)new Callable<Integer>(){

                    @Override
                    public Integer call() throws Exception {
                        return LayoutStagedModelDataHandler.this._layoutLocalServiceHelper.getNextPriority(groupId, privateLayout, finalParentLayoutId, null, -1);
                    }
                });
                importedLayout.setPriority(priority);
            }
            catch (Throwable t) {
                ReflectionUtil.throwException((Throwable)t);
            }
        }
        importedLayout.setLayoutPrototypeUuid(layout.getLayoutPrototypeUuid());
        importedLayout.setLayoutPrototypeLinkEnabled(layout.isLayoutPrototypeLinkEnabled());
        ServiceContext serviceContext = portletDataContext.createServiceContext((StagedModel)layout);
        importedLayout.setExpandoBridgeAttributes(serviceContext);
        this._staging.updateLastImportSettings(layoutElement, importedLayout, portletDataContext);
        this.fixImportTypeSettings(importedLayout);
        this.importTheme(portletDataContext, layout, importedLayout);
        this._layoutLocalService.updateLayout(importedLayout);
        this._layoutSetLocalService.updatePageCount(groupId, privateLayout);
        Map layoutPlids = portletDataContext.getNewPrimaryKeysMap(Layout.class);
        layoutPlids.put(layout.getPlid(), importedLayout.getPlid());
        layouts.put(oldLayoutId, importedLayout);
        if (Objects.equals(layout.getType(), "portlet") && Validator.isNotNull((String)layout.getTypeSettings())) {
            this.importLayoutPortlets(portletDataContext, importedLayout, layoutElement);
        }
        this.importAssets(portletDataContext, layout, importedLayout);
        this.importFragmentEntryLinks(portletDataContext, layout, importedLayout);
        this.importLayoutFriendlyURLs(portletDataContext, layout, importedLayout);
        portletDataContext.importClassedModel((ClassedModel)layout, (ClassedModel)importedLayout);
    }

    protected void exportLayoutIconImage(PortletDataContext portletDataContext, Layout layout, Element layoutElement) throws Exception {
        Image image = this._imageLocalService.getImage(layout.getIconImageId());
        if (image != null && image.getTextObj() != null) {
            String iconPath = ExportImportPathUtil.getModelPath((long)portletDataContext.getScopeGroupId(), (String)Image.class.getName(), (long)image.getImageId());
            Element iconImagePathElement = layoutElement.addElement("icon-image-path");
            iconImagePathElement.addText(iconPath);
            portletDataContext.addZipEntry(iconPath, image.getTextObj());
        } else {
            if (_log.isWarnEnabled()) {
                StringBundler sb = new StringBundler(4);
                sb.append("Unable to export icon image ");
                sb.append(layout.getIconImageId());
                sb.append(" to layout ");
                sb.append(layout.getLayoutId());
                _log.warn((Object)sb.toString());
            }
            layout.setIconImageId(0L);
        }
    }

    protected void exportLayoutPortlets(PortletDataContext portletDataContext, Layout layout, Element layoutElement) throws Exception {
        Map parameterMap = portletDataContext.getParameterMap();
        boolean permissions = MapUtil.getBoolean((Map)parameterMap, (String)"PERMISSIONS");
        Element portletsElement = layoutElement.addElement("portlets");
        long previousScopeGroupId = portletDataContext.getScopeGroupId();
        Map<String, Object[]> portletIds = this.getPortletids(portletDataContext, layout);
        for (Map.Entry<String, Object[]> portletIdsEntry : portletIds.entrySet()) {
            String portletId = (String)portletIdsEntry.getValue()[0];
            long scopeGroupId = (Long)portletIdsEntry.getValue()[1];
            String scopeType = (String)portletIdsEntry.getValue()[2];
            String scopeLayoutUuid = (String)portletIdsEntry.getValue()[3];
            portletDataContext.setPlid(layout.getPlid());
            portletDataContext.setOldPlid(layout.getPlid());
            portletDataContext.setPortletId(portletId);
            portletDataContext.setScopeGroupId(scopeGroupId);
            portletDataContext.setScopeType(scopeType);
            portletDataContext.setScopeLayoutUuid(scopeLayoutUuid);
            Map exportPortletControlsMap = this._exportImportHelper.getExportPortletControlsMap(layout.getCompanyId(), portletId, parameterMap, portletDataContext.getType());
            try {
                this._exportImportLifecycleManager.fireExportImportLifecycleEvent(9, this.getProcessFlag(), portletDataContext.getExportImportProcessId(), new Serializable[]{this._portletDataContextFactory.clonePortletDataContext(portletDataContext)});
                this._portletExportController.exportPortlet(portletDataContext, layout.getPlid(), portletsElement, permissions, ((Boolean)exportPortletControlsMap.get("PORTLET_ARCHIVED_SETUPS")).booleanValue(), ((Boolean)exportPortletControlsMap.get("PORTLET_DATA")).booleanValue(), ((Boolean)exportPortletControlsMap.get("PORTLET_SETUP")).booleanValue(), ((Boolean)exportPortletControlsMap.get("PORTLET_USER_PREFERENCES")).booleanValue());
                this._exportImportLifecycleManager.fireExportImportLifecycleEvent(8, this.getProcessFlag(), portletDataContext.getExportImportProcessId(), new Serializable[]{this._portletDataContextFactory.clonePortletDataContext(portletDataContext)});
            }
            catch (Throwable t) {
                this._exportImportLifecycleManager.fireExportImportLifecycleEvent(7, this.getProcessFlag(), portletDataContext.getExportImportProcessId(), new Serializable[]{this._portletDataContextFactory.clonePortletDataContext(portletDataContext), t});
                throw t;
            }
        }
        portletDataContext.setScopeGroupId(previousScopeGroupId);
    }

    protected void exportLinkedLayout(PortletDataContext portletDataContext, Layout layout, Element layoutElement) throws Exception {
        block3: {
            UnicodeProperties typeSettingsProperties = layout.getTypeSettingsProperties();
            long linkToLayoutId = GetterUtil.getLong((String)typeSettingsProperties.getProperty("linkToLayoutId", ""));
            if (linkToLayoutId > 0L) {
                try {
                    Layout linkedToLayout = this._layoutLocalService.getLayout(portletDataContext.getScopeGroupId(), layout.isPrivateLayout(), linkToLayoutId);
                    StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)layout, (StagedModel)linkedToLayout, (String)"strong");
                    layoutElement.addAttribute("linked-to-layout-uuid", linkedToLayout.getUuid());
                }
                catch (NoSuchLayoutException nsle) {
                    if (!_log.isDebugEnabled()) break block3;
                    _log.debug((Object)nsle, (Throwable)nsle);
                }
            }
        }
    }

    protected void exportTheme(PortletDataContext portletDataContext, Layout layout) throws Exception {
        boolean exportThemeSettings = MapUtil.getBoolean((Map)portletDataContext.getParameterMap(), (String)"THEME_REFERENCE");
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Export theme settings " + exportThemeSettings));
        }
        if (exportThemeSettings && !portletDataContext.isPerformDirectBinaryImport() && !layout.isInheritLookAndFeel()) {
            StagedThemeImpl stagedTheme = new StagedThemeImpl(layout.getTheme());
            Element layoutElement = portletDataContext.getExportDataElement((ClassedModel)layout);
            portletDataContext.addReferenceElement((ClassedModel)layout, layoutElement, (ClassedModel)stagedTheme, "dependency", true);
        }
    }

    protected Object[] extractFriendlyURLInfo(Layout layout) {
        if (!Objects.equals(layout.getType(), "url")) {
            return null;
        }
        UnicodeProperties typeSettings = layout.getTypeSettingsProperties();
        String url = GetterUtil.getString((String)typeSettings.getProperty("url"));
        String friendlyURLPrivateGroupPath = PropsValues.LAYOUT_FRIENDLY_URL_PRIVATE_GROUP_SERVLET_MAPPING;
        String friendlyURLPrivateUserPath = PropsValues.LAYOUT_FRIENDLY_URL_PRIVATE_USER_SERVLET_MAPPING;
        String friendlyURLPublicPath = PropsValues.LAYOUT_FRIENDLY_URL_PUBLIC_SERVLET_MAPPING;
        if (!(url.startsWith(friendlyURLPrivateGroupPath) || url.startsWith(friendlyURLPrivateUserPath) || url.startsWith(friendlyURLPublicPath))) {
            return null;
        }
        int x = url.indexOf(47, 1);
        if (x == -1) {
            return null;
        }
        int y = url.indexOf(47, x + 1);
        if (y == -1) {
            return null;
        }
        return new Object[]{url.substring(x, y), url, x, y};
    }

    protected Layout fetchMissingReference(String uuid, long groupId, boolean privateLayout) {
        Layout layout = this._layoutLocalService.fetchLayoutByUuidAndGroupId(uuid, groupId, privateLayout);
        if (layout != null) {
            return layout;
        }
        try {
            Group originalGroup = this._groupLocalService.getGroup(groupId);
            for (Group group = originalGroup.getParentGroup(); group != null && (layout = this._layoutLocalService.fetchLayoutByUuidAndGroupId(uuid, group.getGroupId(), privateLayout)) == null; group = group.getParentGroup()) {
            }
            if (layout == null) {
                List<Layout> layouts = this.fetchStagedModelsByUuidAndCompanyId(uuid, originalGroup.getCompanyId());
                if (ListUtil.isEmpty(layouts)) {
                    return null;
                }
                layout = layouts.get(0);
            }
            return layout;
        }
        catch (Exception e) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)e, (Throwable)e);
            } else if (_log.isWarnEnabled()) {
                _log.warn((Object)("Unable to fetch missing reference layout from group " + groupId));
            }
            return null;
        }
    }

    protected void fixExportTypeSettings(Layout layout) throws Exception {
        Object[] friendlyURLInfo = this.extractFriendlyURLInfo(layout);
        if (friendlyURLInfo == null) {
            return;
        }
        String friendlyURL = (String)friendlyURLInfo[0];
        Group group = layout.getGroup();
        String groupFriendlyURL = group.getFriendlyURL();
        if (!friendlyURL.equals(groupFriendlyURL)) {
            return;
        }
        UnicodeProperties typeSettings = layout.getTypeSettingsProperties();
        String url = (String)friendlyURLInfo[1];
        int x = (Integer)friendlyURLInfo[2];
        int y = (Integer)friendlyURLInfo[3];
        typeSettings.setProperty("url", url.substring(0, x) + _SAME_GROUP_FRIENDLY_URL + url.substring(y));
    }

    protected void fixImportTypeSettings(Layout layout) throws Exception {
        Object[] friendlyURLInfo = this.extractFriendlyURLInfo(layout);
        if (friendlyURLInfo == null) {
            return;
        }
        String friendlyURL = (String)friendlyURLInfo[0];
        if (!friendlyURL.equals(_SAME_GROUP_FRIENDLY_URL)) {
            return;
        }
        Group group = layout.getGroup();
        UnicodeProperties typeSettings = layout.getTypeSettingsProperties();
        String url = (String)friendlyURLInfo[1];
        int x = (Integer)friendlyURLInfo[2];
        int y = (Integer)friendlyURLInfo[3];
        typeSettings.setProperty("url", url.substring(0, x) + group.getFriendlyURL() + url.substring(y));
    }

    protected Map<String, Object[]> getPortletids(PortletDataContext portletDataContext, Layout layout) throws Exception {
        if (!LayoutStagingUtil.prepareLayoutStagingHandler((PortletDataContext)portletDataContext, (Layout)layout) || !layout.isSupportsEmbeddedPortlets()) {
            return Collections.emptyMap();
        }
        HashMap<String, Object[]> portletIds = new HashMap<String, Object[]>();
        LayoutTypePortlet layoutTypePortlet = (LayoutTypePortlet)layout.getLayoutType();
        for (Portlet portlet : layoutTypePortlet.getAllPortlets(false)) {
            String portletId = portlet.getPortletId();
            Settings portletInstanceSettings = SettingsFactoryUtil.getSettings((SettingsLocator)new PortletInstanceSettingsLocator(layout, portletId));
            String scopeType = portletInstanceSettings.getValue("lfrScopeType", null);
            String scopeLayoutUuid = portletInstanceSettings.getValue("lfrScopeLayoutUuid", null);
            long scopeGroupId = portletDataContext.getScopeGroupId();
            if (Validator.isNotNull((String)scopeType)) {
                Group scopeGroup = null;
                if (scopeType.equals("company")) {
                    scopeGroup = this._groupLocalService.getCompanyGroup(layout.getCompanyId());
                } else if (scopeType.equals("layout")) {
                    Layout scopeLayout = null;
                    scopeLayout = this._layoutLocalService.fetchLayoutByUuidAndGroupId(scopeLayoutUuid, portletDataContext.getGroupId(), portletDataContext.isPrivateLayout());
                    if (scopeLayout == null) continue;
                    scopeGroup = scopeLayout.getScopeGroup();
                } else {
                    throw new IllegalArgumentException("Scope type " + scopeType + " is invalid");
                }
                if (scopeGroup != null) {
                    scopeGroupId = scopeGroup.getGroupId();
                }
            }
            String key = PortletPermissionUtil.getPrimaryKey((long)layout.getPlid(), (String)portletId);
            portletIds.put(key, new Object[]{portletId, scopeGroupId, scopeType, scopeLayoutUuid});
        }
        return portletIds;
    }

    protected String getUniqueFriendlyURL(PortletDataContext portletDataContext, Layout existingLayout, String friendlyURL) {
        Layout duplicateFriendlyURLLayout;
        int i = 1;
        while ((duplicateFriendlyURLLayout = this._layoutLocalService.fetchLayoutByFriendlyURL(portletDataContext.getGroupId(), portletDataContext.isPrivateLayout(), friendlyURL)) != null && duplicateFriendlyURLLayout.getPlid() != existingLayout.getPlid()) {
            friendlyURL = friendlyURL + i;
            ++i;
        }
        return friendlyURL;
    }

    protected void importAssets(PortletDataContext portletDataContext, Layout layout, Layout importedLayout) throws Exception {
        long userId = portletDataContext.getUserId(layout.getUserUuid());
        long[] assetCategoryIds = portletDataContext.getAssetCategoryIds(Layout.class, layout.getPlid());
        String[] assetTagNames = portletDataContext.getAssetTagNames(Layout.class, layout.getPlid());
        this._layoutLocalService.updateAsset(userId, importedLayout, assetCategoryIds, assetTagNames);
    }

    protected void importFragmentEntryLinks(PortletDataContext portletDataContext, Layout layout, Layout importedLayout) throws Exception {
        this._fragmentEntryLinkLocalService.deleteLayoutPageTemplateEntryFragmentEntryLinks(portletDataContext.getScopeGroupId(), this._portal.getClassNameId(Layout.class), importedLayout.getPlid());
        List fragmentEntryLinkElements = portletDataContext.getReferenceDataElements((StagedModel)layout, FragmentEntryLink.class);
        for (Element fragmentEntryLinkElement : fragmentEntryLinkElements) {
            String fragmentEntryLinkPath = fragmentEntryLinkElement.attributeValue("path");
            FragmentEntryLink fragmentEntryLink = (FragmentEntryLink)portletDataContext.getZipEntryAsObject(fragmentEntryLinkPath);
            fragmentEntryLink.setClassNameId(this._portal.getClassNameId(Layout.class));
            fragmentEntryLink.setClassPK(importedLayout.getPlid());
            StagedModelDataHandlerUtil.importStagedModel((PortletDataContext)portletDataContext, (StagedModel)fragmentEntryLink);
        }
    }

    protected void importLayoutFriendlyURLs(PortletDataContext portletDataContext, Layout layout, Layout importedLayout) throws Exception {
        List layoutFriendlyURLElements = portletDataContext.getReferenceDataElements((StagedModel)layout, LayoutFriendlyURL.class);
        for (Element layoutFriendlyURLElement : layoutFriendlyURLElements) {
            String layoutFriendlyURLPath = layoutFriendlyURLElement.attributeValue("path");
            LayoutFriendlyURL layoutFriendlyURL = (LayoutFriendlyURL)portletDataContext.getZipEntryAsObject(layoutFriendlyURLPath);
            StagedModelDataHandlerUtil.importStagedModel((PortletDataContext)portletDataContext, (StagedModel)layoutFriendlyURL);
        }
        this.deleteMissingLayoutFriendlyURLs(portletDataContext, importedLayout);
    }

    protected void importLayoutIconImage(PortletDataContext portletDataContext, Layout importedLayout, Element layoutElement) throws Exception {
        String iconImagePath = layoutElement.elementText("icon-image-path");
        byte[] iconBytes = portletDataContext.getZipEntryAsByteArray(iconImagePath);
        if (ArrayUtil.isNotEmpty((byte[])iconBytes)) {
            if (importedLayout.getIconImageId() == 0L) {
                long iconImageId = this._counterLocalService.increment();
                importedLayout.setIconImageId(iconImageId);
            }
            this._imageLocalService.updateImage(importedLayout.getIconImageId(), iconBytes);
        }
    }

    protected void importLayoutPortlets(PortletDataContext portletDataContext, Layout layout, Element layoutElement) throws Exception {
        boolean layoutSetPrototypeLinkEnabled = MapUtil.getBoolean((Map)portletDataContext.getParameterMap(), (String)"LAYOUT_SET_PROTOTYPE_LINK_ENABLED");
        if (layoutSetPrototypeLinkEnabled && Validator.isNotNull((String)portletDataContext.getLayoutSetPrototypeUuid()) && SitesUtil.isLayoutModifiedSinceLastMerge((Layout)layout)) {
            return;
        }
        Map parameterMap = portletDataContext.getParameterMap();
        boolean permissions = MapUtil.getBoolean((Map)parameterMap, (String)"PERMISSIONS");
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        this._permissionImporter.clearCache();
        Element portletsElement = layoutElement.element("portlets");
        if (portletsElement == null) {
            return;
        }
        for (Element portletElement : portletsElement.elements()) {
            String portletPath = portletElement.attributeValue("path");
            String portletId = portletElement.attributeValue("portlet-id");
            long oldPlid = GetterUtil.getLong((String)portletElement.attributeValue("old-plid"));
            Portlet portlet = this._portletLocalService.getPortletById(portletDataContext.getCompanyId(), portletId);
            if (!portlet.isActive() || portlet.isUndeployedPortlet()) continue;
            portletDataContext.setPlid(layout.getPlid());
            portletDataContext.setOldPlid(oldPlid);
            portletDataContext.setPortletId(portletId);
            if (BackgroundTaskThreadLocal.hasBackgroundTask()) {
                this._portletDataHandlerStatusMessageSender.sendStatusMessage("portlet", portletId, portletDataContext.getManifestSummary());
            }
            Document portletDocument = SAXReaderUtil.read((String)portletDataContext.getZipEntryAsString(portletPath));
            portletElement = portletDocument.getRootElement();
            this._exportImportHelper.setPortletScope(portletDataContext, portletElement);
            long portletPreferencesGroupId = portletDataContext.getGroupId();
            Element portletDataElement = portletElement.element("portlet-data");
            Map importPortletControlsMap = this._exportImportHelper.getImportPortletControlsMap(portletDataContext.getCompanyId(), portletId, parameterMap, portletDataElement, portletDataContext.getManifestSummary());
            if (layout != null) {
                portletPreferencesGroupId = layout.getGroupId();
            }
            try {
                this._exportImportLifecycleManager.fireExportImportLifecycleEvent(12, this.getProcessFlag(), portletDataContext.getExportImportProcessId(), new Serializable[]{this._portletDataContextFactory.clonePortletDataContext(portletDataContext)});
                this._portletImportController.importPortletPreferences(portletDataContext, portletDataContext.getCompanyId(), portletPreferencesGroupId, layout, portletElement, false, ((Boolean)importPortletControlsMap.get("PORTLET_ARCHIVED_SETUPS")).booleanValue(), ((Boolean)importPortletControlsMap.get("PORTLET_DATA")).booleanValue(), ((Boolean)importPortletControlsMap.get("PORTLET_SETUP")).booleanValue(), ((Boolean)importPortletControlsMap.get("PORTLET_USER_PREFERENCES")).booleanValue());
                if (((Boolean)importPortletControlsMap.get("PORTLET_DATA")).booleanValue()) {
                    this._portletImportController.importPortletData(portletDataContext, portletDataElement);
                }
                this._exportImportLifecycleManager.fireExportImportLifecycleEvent(11, this.getProcessFlag(), portletDataContext.getExportImportProcessId(), new Serializable[]{this._portletDataContextFactory.clonePortletDataContext(portletDataContext)});
            }
            catch (Throwable t) {
                this._exportImportLifecycleManager.fireExportImportLifecycleEvent(10, this.getProcessFlag(), portletDataContext.getExportImportProcessId(), new Serializable[]{this._portletDataContextFactory.clonePortletDataContext(portletDataContext), t});
                throw t;
            }
            finally {
                this._portletImportController.resetPortletScope(portletDataContext, portletPreferencesGroupId);
            }
            if (permissions) {
                this._permissionImporter.importPortletPermissions(portletDataContext.getCompanyId(), portletDataContext.getGroupId(), serviceContext.getUserId(), layout, portletElement, portletId);
            }
            try {
                this._portletImportController.importPortletPreferences(portletDataContext, portletDataContext.getCompanyId(), portletDataContext.getGroupId(), null, portletElement, false, ((Boolean)importPortletControlsMap.get("PORTLET_ARCHIVED_SETUPS")).booleanValue(), ((Boolean)importPortletControlsMap.get("PORTLET_DATA")).booleanValue(), ((Boolean)importPortletControlsMap.get("PORTLET_SETUP")).booleanValue(), ((Boolean)importPortletControlsMap.get("PORTLET_USER_PREFERENCES")).booleanValue());
            }
            catch (Throwable t) {
                throw t;
            }
            finally {
                this._portletImportController.resetPortletScope(portletDataContext, portletPreferencesGroupId);
            }
        }
    }

    protected void importLinkedLayout(PortletDataContext portletDataContext, Layout layout, Layout importedLayout, Element layoutElement) throws Exception {
        UnicodeProperties typeSettingsProperties = layout.getTypeSettingsProperties();
        long linkToLayoutId = GetterUtil.getLong((String)typeSettingsProperties.getProperty("linkToLayoutId", ""));
        String linkedToLayoutUuid = layoutElement.attributeValue("linked-to-layout-uuid");
        if (Validator.isNull((String)linkedToLayoutUuid) || linkToLayoutId <= 0L) {
            return;
        }
        this._exportImportProcessCallbackRegistry.registerCallback(portletDataContext.getExportImportProcessId(), (Callable)new ImportLinkedLayoutCallable(portletDataContext.getScopeGroupId(), portletDataContext.isPrivateLayout(), importedLayout.getUuid(), linkedToLayoutUuid));
    }

    protected void importTheme(PortletDataContext portletDataContext, Layout layout, Layout importedLayout) throws Exception {
        boolean importThemeSettings = MapUtil.getBoolean((Map)portletDataContext.getParameterMap(), (String)"THEME_REFERENCE");
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Import theme settings " + importThemeSettings));
        }
        if (importThemeSettings) {
            importedLayout.setThemeId(layout.getThemeId());
            importedLayout.setColorSchemeId(layout.getColorSchemeId());
            importedLayout.setCss(layout.getCss());
        } else {
            importedLayout.setThemeId("");
            importedLayout.setColorSchemeId("");
            importedLayout.setCss("");
        }
    }

    protected void initNewLayoutPermissions(long companyId, long groupId, long userId, Layout layout, Layout importedLayout, boolean privateLayout) throws Exception {
        boolean addGroupPermissions = true;
        Group group = importedLayout.getGroup();
        if (privateLayout && group.isUser()) {
            addGroupPermissions = false;
        }
        boolean addGuestPermissions = false;
        if (!privateLayout || Objects.equals(layout.getType(), "control_panel")) {
            addGuestPermissions = true;
        }
        this._resourceLocalService.addResources(companyId, groupId, userId, Layout.class.getName(), importedLayout.getPlid(), false, addGroupPermissions, addGuestPermissions);
    }

    protected boolean isSkipImportReferenceStagedModels() {
        return true;
    }

    protected void mergePortlets(Layout layout, String newTypeSettings, String portletsMergeMode) {
        try {
            UnicodeProperties previousTypeSettingsProperties = layout.getTypeSettingsProperties();
            LayoutTypePortlet previousLayoutType = (LayoutTypePortlet)layout.getLayoutType();
            LayoutTemplate previousLayoutTemplate = previousLayoutType.getLayoutTemplate();
            List previousColumns = previousLayoutTemplate.getColumns();
            UnicodeProperties newTypeSettingsProperties = new UnicodeProperties(true);
            newTypeSettingsProperties.load(newTypeSettings);
            String layoutTemplateId = newTypeSettingsProperties.getProperty("layout-template-id");
            previousTypeSettingsProperties.setProperty("layout-template-id", layoutTemplateId);
            String nestedColumnIds = newTypeSettingsProperties.getProperty("nested-column-ids");
            if (Validator.isNotNull((String)nestedColumnIds)) {
                String[] nestedColumnIdsArray;
                previousTypeSettingsProperties.setProperty("nested-column-ids", nestedColumnIds);
                for (String nestedColumnId : nestedColumnIdsArray = StringUtil.split((String)nestedColumnIds)) {
                    String nestedColumnValue = newTypeSettingsProperties.getProperty(nestedColumnId);
                    previousTypeSettingsProperties.setProperty(nestedColumnId, nestedColumnValue);
                }
            }
            LayoutTemplate newLayoutTemplate = this._layoutTemplateLocalService.getLayoutTemplate(layoutTemplateId, false, null);
            Object[] newPortletIds = new String[]{};
            for (String columnId : newLayoutTemplate.getColumns()) {
                String columnValue = newTypeSettingsProperties.getProperty(columnId);
                Object[] portletIds = StringUtil.split((String)columnValue);
                if (!previousColumns.contains(columnId)) {
                    newPortletIds = (String[])ArrayUtil.append((Object[])newPortletIds, (Object[])portletIds);
                    continue;
                }
                String[] previousPortletIds = StringUtil.split((String)previousTypeSettingsProperties.getProperty(columnId));
                portletIds = this.appendPortletIds(previousPortletIds, (String[])portletIds, portletsMergeMode);
                previousTypeSettingsProperties.setProperty(columnId, StringUtil.merge((Object[])portletIds));
            }
            String columnId = (String)previousColumns.get(0);
            Object[] portletIds = StringUtil.split((String)previousTypeSettingsProperties.getProperty(columnId));
            this.appendPortletIds((String[])portletIds, (String[])newPortletIds, portletsMergeMode);
            previousTypeSettingsProperties.setProperty(columnId, StringUtil.merge((Object[])portletIds));
            layout.setTypeSettings(previousTypeSettingsProperties.toString());
        }
        catch (IOException ioe) {
            layout.setTypeSettings(newTypeSettings);
        }
    }

    protected void populateElementLayoutMetadata(Element layoutElement, Layout layout) throws Exception {
        LayoutRevision layoutRevision;
        LayoutStagingHandler layoutStagingHandler = LayoutStagingUtil.getLayoutStagingHandler((Layout)layout);
        if (layoutStagingHandler != null && (layoutRevision = layoutStagingHandler.getLayoutRevision()) != null) {
            layoutElement.addAttribute("layout-revision-id", String.valueOf(layoutRevision.getLayoutRevisionId()));
            layoutElement.addAttribute("layout-branch-id", String.valueOf(layoutRevision.getLayoutBranchId()));
            LayoutBranch layoutBranch = layoutRevision.getLayoutBranch();
            layoutElement.addAttribute("layout-branch-name", String.valueOf(layoutBranch.getName()));
        }
        layoutElement.addAttribute("layout-uuid", layout.getUuid());
        layoutElement.addAttribute("layout-id", String.valueOf(layout.getLayoutId()));
        layoutElement.addAttribute("layout-priority", String.valueOf(layout.getPriority()));
        String layoutPrototypeUuid = layout.getLayoutPrototypeUuid();
        if (Validator.isNotNull((String)layoutPrototypeUuid)) {
            LayoutPrototype layoutPrototype = this._layoutPrototypeLocalService.getLayoutPrototypeByUuidAndCompanyId(layoutPrototypeUuid, layout.getCompanyId());
            long defaultUserId = this._userLocalService.getDefaultUserId(layout.getCompanyId());
            if (defaultUserId == layoutPrototype.getUserId()) {
                layoutElement.addAttribute("preloaded", "true");
            }
            layoutElement.addAttribute("layout-prototype-uuid", layoutPrototypeUuid);
            layoutElement.addAttribute("layout-prototype-name", layoutPrototype.getName(LocaleUtil.getDefault()));
        }
    }

    @Reference(unbind="-")
    protected void setCounterLocalService(CounterLocalService counterLocalService) {
        this._counterLocalService = counterLocalService;
    }

    @Reference(unbind="-")
    protected void setExportImportLifecycleManager(ExportImportLifecycleManager exportImportLifecycleManager) {
        this._exportImportLifecycleManager = exportImportLifecycleManager;
    }

    @Reference(unbind="-")
    protected void setGroupLocalService(GroupLocalService groupLocalService) {
        this._groupLocalService = groupLocalService;
    }

    @Reference(unbind="-")
    protected void setImageLocalService(ImageLocalService imageLocalService) {
        this._imageLocalService = imageLocalService;
    }

    @Reference(unbind="-")
    protected void setLayoutFriendlyURLLocalService(LayoutFriendlyURLLocalService layoutFriendlyURLLocalService) {
        this._layoutFriendlyURLLocalService = layoutFriendlyURLLocalService;
    }

    @Reference(unbind="-")
    protected void setLayoutLocalService(LayoutLocalService layoutLocalService) {
        this._layoutLocalService = layoutLocalService;
    }

    @Reference(unbind="-")
    protected void setLayoutLocalServiceHelper(LayoutLocalServiceHelper layoutLocalServiceHelper) {
        this._layoutLocalServiceHelper = layoutLocalServiceHelper;
    }

    @Reference(unbind="-")
    protected void setLayoutPrototypeLocalService(LayoutPrototypeLocalService layoutPrototypeLocalService) {
        this._layoutPrototypeLocalService = layoutPrototypeLocalService;
    }

    @Reference(unbind="-")
    protected void setLayoutSetLocalService(LayoutSetLocalService layoutSetLocalService) {
        this._layoutSetLocalService = layoutSetLocalService;
    }

    @Reference(unbind="-")
    protected void setLayoutTemplateLocalService(LayoutTemplateLocalService layoutTemplateLocalService) {
        this._layoutTemplateLocalService = layoutTemplateLocalService;
    }

    @Reference(unbind="-")
    protected void setPortletExportController(PortletExportController portletExportController) {
        this._portletExportController = portletExportController;
    }

    @Reference(unbind="-")
    protected void setPortletImportController(PortletImportController portletImportController) {
        this._portletImportController = portletImportController;
    }

    @Reference(unbind="-")
    protected void setPortletLocalService(PortletLocalService portletLocalService) {
        this._portletLocalService = portletLocalService;
    }

    @Reference(unbind="-")
    protected void setResourceLocalService(ResourceLocalService resourceLocalService) {
        this._resourceLocalService = resourceLocalService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateTypeSettings(Layout importedLayout, Layout layout) throws PortalException {
        long groupId = layout.getGroupId();
        try {
            LayoutTypePortlet importedLayoutType = (LayoutTypePortlet)importedLayout.getLayoutType();
            List importedPortletIds = importedLayoutType.getPortletIds();
            layout.setGroupId(importedLayout.getGroupId());
            LayoutTypePortlet layoutTypePortlet = (LayoutTypePortlet)layout.getLayoutType();
            importedPortletIds.removeAll(layoutTypePortlet.getPortletIds());
            if (!importedPortletIds.isEmpty()) {
                this._portletLocalService.deletePortlets(importedLayout.getCompanyId(), importedPortletIds.toArray(new String[importedPortletIds.size()]), importedLayout.getPlid());
            }
            importedLayout.setTypeSettingsProperties(layoutTypePortlet.getTypeSettingsProperties());
        }
        finally {
            layout.setGroupId(groupId);
        }
    }

    private class ImportLinkedLayoutCallable
    implements Callable<Void> {
        private final long _groupId;
        private final String _layoutUuid;
        private final String _linkedToLayoutUuid;
        private final boolean _privateLayout;

        public ImportLinkedLayoutCallable(long groupId, boolean privateLayout, String layoutUuid, String linkedToLayoutUuid) {
            this._groupId = groupId;
            this._privateLayout = privateLayout;
            this._layoutUuid = layoutUuid;
            this._linkedToLayoutUuid = linkedToLayoutUuid;
        }

        @Override
        public Void call() throws Exception {
            Layout layout = LayoutStagedModelDataHandler.this._layoutLocalService.fetchLayoutByUuidAndGroupId(this._layoutUuid, this._groupId, this._privateLayout);
            if (layout == null) {
                return null;
            }
            Layout linkedToLayout = LayoutStagedModelDataHandler.this._layoutLocalService.fetchLayoutByUuidAndGroupId(this._linkedToLayoutUuid, this._groupId, this._privateLayout);
            if (linkedToLayout == null) {
                if (_log.isWarnEnabled()) {
                    StringBundler sb = new StringBundler(6);
                    sb.append("Unable to link layout with friendly URL ");
                    sb.append(layout.getFriendlyURL());
                    sb.append(" and layout ID ");
                    sb.append(layout.getLayoutId());
                    sb.append(" to layout with layout UUID ");
                    sb.append(this._linkedToLayoutUuid);
                    _log.warn((Object)sb.toString());
                }
                return null;
            }
            UnicodeProperties typeSettingsProperties = layout.getTypeSettingsProperties();
            typeSettingsProperties.setProperty("privateLayout", String.valueOf(linkedToLayout.isPrivateLayout()));
            typeSettingsProperties.setProperty("linkToLayoutId", String.valueOf(linkedToLayout.getLayoutId()));
            layout.setTypeSettingsProperties(typeSettingsProperties);
            LayoutStagedModelDataHandler.this._layoutLocalService.updateLayout(layout);
            return null;
        }
    }
}

