/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.admin.web.internal.display.context;

import com.liferay.exportimport.kernel.staging.LayoutStagingUtil;
import com.liferay.exportimport.kernel.staging.StagingUtil;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.CreationMenu;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.DropdownItem;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.DropdownItemList;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.NavigationItem;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.NavigationItemList;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.SafeConsumer;
import com.liferay.layout.admin.web.internal.display.context.OrphanPortletsDisplayContext;
import com.liferay.layout.page.template.model.LayoutPageTemplateCollection;
import com.liferay.layout.page.template.service.LayoutPageTemplateCollectionService;
import com.liferay.layout.page.template.service.LayoutPageTemplateEntryServiceUtil;
import com.liferay.layout.page.template.util.comparator.LayoutPageTemplateCollectionNameComparator;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutRevision;
import com.liferay.portal.kernel.model.LayoutSet;
import com.liferay.portal.kernel.model.LayoutSetBranch;
import com.liferay.portal.kernel.model.LayoutTypeController;
import com.liferay.portal.kernel.portlet.LiferayPortletRequest;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.portlet.LiferayWindowState;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.LayoutLocalServiceUtil;
import com.liferay.portal.kernel.service.LayoutSetBranchLocalServiceUtil;
import com.liferay.portal.kernel.service.LayoutSetLocalServiceUtil;
import com.liferay.portal.kernel.service.permission.GroupPermissionUtil;
import com.liferay.portal.kernel.service.permission.LayoutPermissionUtil;
import com.liferay.portal.kernel.theme.PortletDisplay;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.Accessor;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.LayoutDescription;
import com.liferay.portal.util.LayoutListUtil;
import com.liferay.portal.util.LayoutTypeControllerTracker;
import com.liferay.portlet.layoutsadmin.display.context.GroupDisplayContextHelper;
import com.liferay.site.navigation.model.SiteNavigationMenu;
import com.liferay.site.navigation.service.SiteNavigationMenuLocalServiceUtil;
import com.liferay.staging.StagingGroupHelper;
import com.liferay.staging.StagingGroupHelperUtil;
import com.liferay.taglib.security.PermissionsURLTag;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.ResourceBundle;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;
import javax.servlet.http.HttpServletRequest;

public class LayoutsAdminDisplayContext {
    private Long _activeLayoutSetBranchId;
    private final GroupDisplayContextHelper _groupDisplayContextHelper;
    private Long _homePagePlid;
    private String _homePageTitle;
    private List<LayoutDescription> _layoutDescriptions;
    private Long _layoutId;
    private final LiferayPortletRequest _liferayPortletRequest;
    private final LiferayPortletResponse _liferayPortletResponse;
    private String _navigation;
    private String _orderByCol;
    private String _orderByType;
    private Long _parentLayoutId;
    private Boolean _privateLayout;
    private String _redirect;
    private final HttpServletRequest _request;
    private String _rootNodeName;
    private Layout _selLayout;
    private LayoutSet _selLayoutSet;
    private Long _selPlid;
    private String _tabs1;
    private final ThemeDisplay _themeDisplay;

    public LayoutsAdminDisplayContext(LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse) {
        this._liferayPortletRequest = liferayPortletRequest;
        this._liferayPortletResponse = liferayPortletResponse;
        this._themeDisplay = (ThemeDisplay)liferayPortletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        this._request = PortalUtil.getHttpServletRequest((PortletRequest)this._liferayPortletRequest);
        this._groupDisplayContextHelper = new GroupDisplayContextHelper(this._request);
        this._liferayPortletRequest.setAttribute("LAYOUT_DESCRIPTIONS", this.getLayoutDescriptions());
    }

    public List<DropdownItem> getActionDropdownItems() {
        return new DropdownItemList(){
            {
                this.add(dropdownItem -> {
                    dropdownItem.putData("action", "deleteSelectedPages");
                    dropdownItem.setIcon("trash");
                    dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)LayoutsAdminDisplayContext.this._request, (String)"delete"));
                    dropdownItem.setQuickAction(true);
                });
            }
        };
    }

    public List<DropdownItem> getAddLayoutDropdownItems() {
        return new DropdownItemList(){
            {
                if (LayoutsAdminDisplayContext.this.isShowPublicPages()) {
                    this.add(SafeConsumer.ignore(dropdownItem -> {
                        dropdownItem.setHref((Object)LayoutsAdminDisplayContext.this.getSelectLayoutPageTemplateEntryURL(false));
                        dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)LayoutsAdminDisplayContext.this._request, (String)"public-page"));
                    }));
                }
                this.add(SafeConsumer.ignore(dropdownItem -> {
                    dropdownItem.setHref((Object)LayoutsAdminDisplayContext.this.getSelectLayoutPageTemplateEntryURL(true));
                    dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)LayoutsAdminDisplayContext.this._request, (String)"private-page"));
                }));
            }
        };
    }

    public String getAutoSiteNavigationMenuNames() {
        List siteNavigationMenus = SiteNavigationMenuLocalServiceUtil.getAutoSiteNavigationMenus((long)this._themeDisplay.getScopeGroupId());
        return ListUtil.toString((List)siteNavigationMenus, (Accessor)SiteNavigationMenu.NAME_ACCESSOR, (String)", ");
    }

    public JSONArray getBreadcrumbEntriesJSONArray() throws PortalException {
        JSONArray breadcrumbEntriesJSONArray = JSONFactoryUtil.createJSONArray();
        breadcrumbEntriesJSONArray.put(this._getBreadcrumbEntryJSONObject(0L, this._getTitle(this.isPrivatePages())));
        if (this.getSelPlid() == 0L) {
            return breadcrumbEntriesJSONArray;
        }
        Layout selLayout = this.getSelLayout();
        if (selLayout == null) {
            return breadcrumbEntriesJSONArray;
        }
        List layouts = selLayout.getAncestors();
        Collections.reverse(layouts);
        for (Layout layout : layouts) {
            breadcrumbEntriesJSONArray.put(this._getBreadcrumbEntryJSONObject(layout.getPlid(), layout.getName(this._themeDisplay.getLocale())));
        }
        breadcrumbEntriesJSONArray.put(this._getBreadcrumbEntryJSONObject(selLayout.getPlid(), selLayout.getName(this._themeDisplay.getLocale())));
        return breadcrumbEntriesJSONArray;
    }

    public String getConfigureLayoutURL(Layout layout) {
        PortletURL configureLayoutURL = this._liferayPortletResponse.createRenderURL();
        configureLayoutURL.setParameter("mvcRenderCommandName", "/layout/edit_layout");
        configureLayoutURL.setParameter("redirect", this._themeDisplay.getURLCurrent());
        configureLayoutURL.setParameter("backURL", this._themeDisplay.getURLCurrent());
        PortletDisplay portletDisplay = this._themeDisplay.getPortletDisplay();
        configureLayoutURL.setParameter("portletResource", portletDisplay.getId());
        configureLayoutURL.setParameter("groupId", String.valueOf(layout.getGroupId()));
        configureLayoutURL.setParameter("selPlid", String.valueOf(layout.getPlid()));
        configureLayoutURL.setParameter("privateLayout", String.valueOf(layout.isPrivateLayout()));
        return configureLayoutURL.toString();
    }

    public String getCopyLayoutURL(Layout layout) {
        PortletURL copyLayoutURL = this._liferayPortletResponse.createActionURL();
        copyLayoutURL.setParameter("javax.portlet.action", "/layout/copy_layout");
        copyLayoutURL.setParameter("groupId", String.valueOf(this.getGroupId()));
        copyLayoutURL.setParameter("liveGroupId", String.valueOf(this.getLiveGroupId()));
        copyLayoutURL.setParameter("stagingGroupId", String.valueOf(this.getStagingGroupId()));
        copyLayoutURL.setParameter("privateLayout", String.valueOf(this.isPrivateLayout()));
        copyLayoutURL.setParameter("layoutId", String.valueOf(layout.getLayoutId()));
        return copyLayoutURL.toString();
    }

    public CreationMenu getCreationMenu() {
        return new CreationMenu(){
            {
                if (LayoutsAdminDisplayContext.this.isShowPublicPages()) {
                    this.addPrimaryDropdownItem(SafeConsumer.ignore(dropdownItem -> {
                        dropdownItem.setHref((Object)LayoutsAdminDisplayContext.this.getSelectLayoutPageTemplateEntryURL(false));
                        dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)LayoutsAdminDisplayContext.this._request, (String)"public-page"));
                    }));
                }
                this.addPrimaryDropdownItem(SafeConsumer.ignore(dropdownItem -> {
                    dropdownItem.setHref((Object)LayoutsAdminDisplayContext.this.getSelectLayoutPageTemplateEntryURL(true));
                    dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)LayoutsAdminDisplayContext.this._request, (String)"private-page"));
                }));
            }
        };
    }

    public String getDeleteLayoutURL(Layout layout) throws PortalException {
        PortletURL deleteLayoutURL = this._liferayPortletResponse.createActionURL();
        deleteLayoutURL.setParameter("javax.portlet.action", "/layout/delete_layout");
        deleteLayoutURL.setParameter("redirect", this._themeDisplay.getURLCurrent());
        deleteLayoutURL.setParameter("selPlid", String.valueOf(layout.getPlid()));
        deleteLayoutURL.setParameter("layoutSetBranchId", String.valueOf(this._getActiveLayoutSetBranchId()));
        return deleteLayoutURL.toString();
    }

    public String getEditLayoutURL(Layout layout) {
        if (!Objects.equals(layout.getType(), "content")) {
            return "";
        }
        PortletURL editLayoutURL = this._liferayPortletResponse.createRenderURL();
        editLayoutURL.setParameter("mvcPath", "/edit_content_layout.jsp");
        editLayoutURL.setParameter("redirect", this._themeDisplay.getURLCurrent());
        editLayoutURL.setParameter("groupId", String.valueOf(layout.getGroupId()));
        editLayoutURL.setParameter("selPlid", String.valueOf(layout.getPlid()));
        return editLayoutURL.toString();
    }

    public long getFirstLayoutPageTemplateCollectionId() {
        LayoutPageTemplateCollectionService layoutPageTemplateCollectionService = (LayoutPageTemplateCollectionService)this._liferayPortletRequest.getAttribute("LAYOUT_PAGE_TEMPLATE_COLLECTION_SERVICE");
        LayoutPageTemplateCollectionNameComparator layoutPageTemplateCollectionNameComparator = new LayoutPageTemplateCollectionNameComparator(true);
        List layoutPageTemplateCollections = layoutPageTemplateCollectionService.getLayoutPageTemplateCollections(this.getGroupId().longValue(), -1, -1, (OrderByComparator)layoutPageTemplateCollectionNameComparator);
        if (layoutPageTemplateCollections.isEmpty()) {
            return 0L;
        }
        for (LayoutPageTemplateCollection layoutPageTemplateCollection : layoutPageTemplateCollections) {
            int layoutPageTemplateEntriesCount = LayoutPageTemplateEntryServiceUtil.getLayoutPageTemplateEntriesCount((long)this._themeDisplay.getScopeGroupId(), (long)layoutPageTemplateCollection.getLayoutPageTemplateCollectionId(), (int)0);
            if (layoutPageTemplateEntriesCount <= 0) continue;
            return layoutPageTemplateCollection.getLayoutPageTemplateCollectionId();
        }
        return 0L;
    }

    public Group getGroup() {
        return this._groupDisplayContextHelper.getGroup();
    }

    public Long getGroupId() {
        return this._groupDisplayContextHelper.getGroupId();
    }

    public UnicodeProperties getGroupTypeSettings() {
        return this._groupDisplayContextHelper.getGroupTypeSettings();
    }

    public JSONArray getLayoutColumnsJSONArray() throws Exception {
        JSONArray layoutColumnsJSONArray = this._getLayoutColumnsJSONArray();
        while (layoutColumnsJSONArray.length() < 3) {
            layoutColumnsJSONArray.put(JSONFactoryUtil.createJSONArray());
        }
        return layoutColumnsJSONArray;
    }

    public List<LayoutDescription> getLayoutDescriptions() {
        if (this._layoutDescriptions != null) {
            return this._layoutDescriptions;
        }
        this._layoutDescriptions = LayoutListUtil.getLayoutDescriptions((long)this.getGroupId(), (boolean)this.isPrivateLayout(), (String)this.getRootNodeName(), (Locale)this._themeDisplay.getLocale());
        return this._layoutDescriptions;
    }

    public Long getLayoutId() {
        if (this._layoutId != null) {
            return this._layoutId;
        }
        this._layoutId = 0L;
        Layout selLayout = this.getSelLayout();
        if (selLayout != null) {
            this._layoutId = selLayout.getLayoutId();
        }
        return this._layoutId;
    }

    public Group getLiveGroup() {
        return this._groupDisplayContextHelper.getLiveGroup();
    }

    public Long getLiveGroupId() {
        return this._groupDisplayContextHelper.getLiveGroupId();
    }

    public String getMarkAsHomePageLayoutURL(Layout layout) {
        PortletURL markAsHomePageLayoutURL = this._liferayPortletResponse.createActionURL();
        markAsHomePageLayoutURL.setParameter("javax.portlet.action", "/layout/mark_as_home_page_layout");
        markAsHomePageLayoutURL.setParameter("redirect", this._themeDisplay.getURLCurrent());
        markAsHomePageLayoutURL.setParameter("selPlid", String.valueOf(layout.getPlid()));
        return markAsHomePageLayoutURL.toString();
    }

    public String getNavigation() {
        if (this._navigation != null) {
            return this._navigation;
        }
        String defaultNavigation = "public-pages";
        if (!this.isShowPublicPages()) {
            defaultNavigation = "private-pages";
        }
        this._navigation = ParamUtil.getString((PortletRequest)this._liferayPortletRequest, (String)"navigation", (String)defaultNavigation);
        return this._navigation;
    }

    public List<NavigationItem> getNavigationItems() {
        final Group group = this._themeDisplay.getScopeGroup();
        final StagingGroupHelper stagingGroupHelper = StagingGroupHelperUtil.getStagingGroupHelper();
        return new NavigationItemList(){
            {
                if (!group.isCompany()) {
                    this.add(navigationItem -> {
                        navigationItem.setActive(Objects.equals(LayoutsAdminDisplayContext.this.getTabs1(), "pages"));
                        navigationItem.setHref(LayoutsAdminDisplayContext.this.getPortletURL(), new Object[]{"tabs1", "pages"});
                        navigationItem.setLabel(LanguageUtil.get((HttpServletRequest)LayoutsAdminDisplayContext.this._request, (String)"pages"));
                    });
                }
                if (!stagingGroupHelper.isLocalLiveGroup(group) && !stagingGroupHelper.isRemoteLiveGroup(group)) {
                    this.add(navigationItem -> {
                        navigationItem.setActive(Objects.equals(LayoutsAdminDisplayContext.this.getTabs1(), "page-templates"));
                        navigationItem.setHref(LayoutsAdminDisplayContext.this.getPortletURL(), new Object[]{"tabs1", "page-templates"});
                        navigationItem.setLabel(LanguageUtil.get((HttpServletRequest)LayoutsAdminDisplayContext.this._request, (String)"page-templates"));
                    });
                }
                if (!(group.isCompany() || stagingGroupHelper.isLocalLiveGroup(group) || stagingGroupHelper.isRemoteLiveGroup(group))) {
                    this.add(navigationItem -> {
                        navigationItem.setActive(Objects.equals(LayoutsAdminDisplayContext.this.getTabs1(), "display-pages"));
                        navigationItem.setHref(LayoutsAdminDisplayContext.this.getPortletURL(), new Object[]{"tabs1", "display-pages"});
                        navigationItem.setLabel(LanguageUtil.get((HttpServletRequest)LayoutsAdminDisplayContext.this._request, (String)"display-pages"));
                    });
                }
            }
        };
    }

    public String getOrphanPortletsURL(Layout layout) {
        PortletURL orphanPortletsURL = this._liferayPortletResponse.createRenderURL();
        orphanPortletsURL.setParameter("mvcPath", "/orphan_portlets.jsp");
        orphanPortletsURL.setParameter("backURL", this._themeDisplay.getURLCurrent());
        orphanPortletsURL.setParameter("selPlid", String.valueOf(layout.getPlid()));
        return orphanPortletsURL.toString();
    }

    public long getParentLayoutId() {
        if (this._parentLayoutId != null) {
            return this._parentLayoutId;
        }
        this._parentLayoutId = 0L;
        Layout layout = this.getSelLayout();
        if (layout != null) {
            this._parentLayoutId = layout.getLayoutId();
        }
        return this._parentLayoutId;
    }

    public String getPath(Layout layout, Locale locale) throws PortalException {
        List layouts = layout.getAncestors();
        StringBundler sb = new StringBundler(layouts.size() * 4);
        for (Layout curLayout : layouts) {
            sb.append(curLayout.getName(locale));
            sb.append(" ");
            sb.append(">");
            sb.append(" ");
        }
        return sb.toString();
    }

    public String getPermissionsURL(Layout layout) throws Exception {
        return PermissionsURLTag.doTag((String)"", (String)Layout.class.getName(), (String)HtmlUtil.escape((String)layout.getName(this._themeDisplay.getLocale())), null, (String)String.valueOf(layout.getPlid()), (String)LiferayWindowState.POP_UP.toString(), null, (HttpServletRequest)this._themeDisplay.getRequest());
    }

    public String getPortletResource() {
        String portletResource = ParamUtil.getString((HttpServletRequest)this._request, (String)"portletResource");
        if (Validator.isNull((String)portletResource)) {
            PortletDisplay portletDisplay = this._themeDisplay.getPortletDisplay();
            portletResource = portletDisplay.getPortletName();
        }
        return portletResource;
    }

    public PortletURL getPortletURL() {
        PortletURL portletURL = this._liferayPortletResponse.createRenderURL();
        portletURL.setParameter("tabs1", this.getTabs1());
        portletURL.setParameter("navigation", this.getNavigation());
        return portletURL;
    }

    public String getRedirect() {
        if (this._redirect != null) {
            return this._redirect;
        }
        this._redirect = ParamUtil.getString((PortletRequest)this._liferayPortletRequest, (String)"redirect", (String)this._themeDisplay.getURLCurrent());
        return this._redirect;
    }

    public PortletURL getRedirectURL() {
        PortletURL portletURL = this._liferayPortletResponse.createRenderURL();
        portletURL.setParameter("redirect", this.getRedirect());
        portletURL.setParameter("groupId", String.valueOf(this.getSelGroupId()));
        return portletURL;
    }

    public String getRootNodeName() {
        if (this._rootNodeName != null) {
            return this._rootNodeName;
        }
        this._rootNodeName = this.getRootNodeName(this.isPrivateLayout());
        return this._rootNodeName;
    }

    public String getRootNodeName(boolean privateLayout) {
        Group liveGroup = this.getLiveGroup();
        return liveGroup.getLayoutRootNodeName(privateLayout, this._themeDisplay.getLocale());
    }

    public String getSelectLayoutPageTemplateEntryURL(boolean privateLayout) throws PortalException {
        return this.getSelectLayoutPageTemplateEntryURL(this.getFirstLayoutPageTemplateCollectionId(), privateLayout);
    }

    public String getSelectLayoutPageTemplateEntryURL(long layoutPageTemplateCollectionId, boolean privateLayout) {
        return this.getSelectLayoutPageTemplateEntryURL(layoutPageTemplateCollectionId, 0L, privateLayout);
    }

    public String getSelectLayoutPageTemplateEntryURL(long layoutPageTemplateCollectionId, long selPlid, boolean privateLayout) {
        return this.getSelectLayoutPageTemplateEntryURL(layoutPageTemplateCollectionId, selPlid, "basic-pages", privateLayout);
    }

    public String getSelectLayoutPageTemplateEntryURL(long layoutPageTemplateCollectionId, long selPlid, String selectedTab, boolean privateLayout) {
        PortletURL selectLayoutPageTemplateEntryURL = this._liferayPortletResponse.createRenderURL();
        selectLayoutPageTemplateEntryURL.setParameter("mvcPath", "/select_layout_page_template_entry.jsp");
        selectLayoutPageTemplateEntryURL.setParameter("navigation", this.getNavigation());
        selectLayoutPageTemplateEntryURL.setParameter("redirect", this.getRedirect());
        selectLayoutPageTemplateEntryURL.setParameter("backURL", this._themeDisplay.getURLCurrent());
        selectLayoutPageTemplateEntryURL.setParameter("groupId", String.valueOf(this.getSelGroupId()));
        selectLayoutPageTemplateEntryURL.setParameter("selPlid", String.valueOf(selPlid));
        selectLayoutPageTemplateEntryURL.setParameter("privateLayout", String.valueOf(privateLayout));
        if (layoutPageTemplateCollectionId > 0L) {
            selectLayoutPageTemplateEntryURL.setParameter("layoutPageTemplateCollectionId", String.valueOf(layoutPageTemplateCollectionId));
        } else if (Validator.isNotNull((String)selectedTab)) {
            selectLayoutPageTemplateEntryURL.setParameter("selectedTab", selectedTab);
        }
        return selectLayoutPageTemplateEntryURL.toString();
    }

    public Group getSelGroup() {
        return this._groupDisplayContextHelper.getSelGroup();
    }

    public long getSelGroupId() {
        Group selGroup = this.getSelGroup();
        if (selGroup != null) {
            return selGroup.getGroupId();
        }
        return 0L;
    }

    public Layout getSelLayout() {
        if (this._selLayout != null) {
            return this._selLayout;
        }
        if (this.getSelPlid() != 0L) {
            this._selLayout = LayoutLocalServiceUtil.fetchLayout((long)this.getSelPlid());
        }
        return this._selLayout;
    }

    public LayoutSet getSelLayoutSet() throws PortalException {
        if (this._selLayoutSet != null) {
            return this._selLayoutSet;
        }
        Group group = this.getStagingGroup();
        if (group == null) {
            group = this.getLiveGroup();
        }
        this._selLayoutSet = LayoutSetLocalServiceUtil.getLayoutSet((long)group.getGroupId(), (boolean)this.isPrivateLayout());
        return this._selLayoutSet;
    }

    public Long getSelPlid() {
        if (this._selPlid != null) {
            return this._selPlid;
        }
        this._selPlid = ParamUtil.getLong((PortletRequest)this._liferayPortletRequest, (String)"selPlid", (long)0L);
        return this._selPlid;
    }

    public Group getStagingGroup() {
        return this._groupDisplayContextHelper.getStagingGroup();
    }

    public Long getStagingGroupId() {
        return this._groupDisplayContextHelper.getStagingGroupId();
    }

    public String getTabs1() {
        if (this._tabs1 != null) {
            return this._tabs1;
        }
        Group group = this.getGroup();
        this._tabs1 = ParamUtil.getString((PortletRequest)this._liferayPortletRequest, (String)"tabs1", (String)(group.isCompany() ? "page-templates" : "pages"));
        return this._tabs1;
    }

    public int getTotalItems() throws Exception {
        return LayoutLocalServiceUtil.getLayoutsCount((Group)this.getSelGroup(), (boolean)this.isPrivatePages());
    }

    public String getViewLayoutURL(Layout layout) throws PortalException {
        return PortalUtil.getLayoutFullURL((Layout)layout, (ThemeDisplay)this._themeDisplay);
    }

    public boolean hasLayouts() {
        int publicPagesCount;
        int privatePagesCount = LayoutLocalServiceUtil.getLayoutsCount((Group)this.getSelGroup(), (boolean)true, (long)0L);
        return privatePagesCount + (publicPagesCount = LayoutLocalServiceUtil.getLayoutsCount((Group)this.getSelGroup(), (boolean)false, (long)0L)) > 0;
    }

    public boolean isPagesTab() {
        return Objects.equals(this.getTabs1(), "pages");
    }

    public boolean isPrivateLayout() {
        if (this._privateLayout != null) {
            return this._privateLayout;
        }
        Group selGroup = this.getSelGroup();
        if (selGroup.isLayoutSetPrototype() || selGroup.isLayoutSetPrototype()) {
            this._privateLayout = true;
            return this._privateLayout;
        }
        Layout selLayout = this.getSelLayout();
        if (this.getSelLayout() != null) {
            this._privateLayout = selLayout.isPrivateLayout();
            return this._privateLayout;
        }
        Layout layout = this._themeDisplay.getLayout();
        if (!layout.isTypeControlPanel()) {
            this._privateLayout = layout.isPrivateLayout();
            return this._privateLayout;
        }
        this._privateLayout = ParamUtil.getBoolean((PortletRequest)this._liferayPortletRequest, (String)"privateLayout");
        return this._privateLayout;
    }

    public boolean isPrivatePages() {
        return Objects.equals(this.getNavigation(), "private-pages");
    }

    public boolean isPublicPages() {
        return Objects.equals(this.getNavigation(), "public-pages");
    }

    public boolean isShowAddChildPageAction(Layout layout) throws PortalException {
        return LayoutPermissionUtil.contains((PermissionChecker)this._themeDisplay.getPermissionChecker(), (Layout)layout, (String)"ADD_LAYOUT");
    }

    public boolean isShowAddRootLayoutButton() throws PortalException {
        return GroupPermissionUtil.contains((PermissionChecker)this._themeDisplay.getPermissionChecker(), (Group)this.getSelGroup(), (String)"ADD_LAYOUT");
    }

    public boolean isShowConfigureAction(Layout layout) throws PortalException {
        return LayoutPermissionUtil.contains((PermissionChecker)this._themeDisplay.getPermissionChecker(), (Layout)layout, (String)"UPDATE");
    }

    public boolean isShowCopyLayoutAction(Layout layout) throws PortalException {
        if (!this.isShowAddRootLayoutButton()) {
            return false;
        }
        return layout.isTypePortlet();
    }

    public boolean isShowDeleteAction(Layout layout) throws PortalException {
        if (StagingUtil.isIncomplete((Layout)layout)) {
            return false;
        }
        if (!LayoutPermissionUtil.contains((PermissionChecker)this._themeDisplay.getPermissionChecker(), (Layout)layout, (String)"DELETE")) {
            return false;
        }
        Group group = layout.getGroup();
        int layoutsCount = LayoutLocalServiceUtil.getLayoutsCount((Group)group, (boolean)false, (long)0L);
        return !group.isGuest() || layout.isPrivateLayout() || !layout.isRootLayout() || layoutsCount != 1;
    }

    public boolean isShowOrphanPortletsAction(Layout layout) {
        if (StagingUtil.isIncomplete((Layout)layout)) {
            return false;
        }
        if (!layout.isSupportsEmbeddedPortlets()) {
            return false;
        }
        OrphanPortletsDisplayContext orphanPortletsDisplayContext = new OrphanPortletsDisplayContext(this._request, this._liferayPortletRequest, this._liferayPortletResponse);
        return !ListUtil.isEmpty(orphanPortletsDisplayContext.getOrphanPortlets(layout));
    }

    public boolean isShowPermissionsAction(Layout layout) throws PortalException {
        if (StagingUtil.isIncomplete((Layout)layout)) {
            return false;
        }
        Group selGroup = this.getSelGroup();
        if (selGroup.isLayoutPrototype()) {
            return false;
        }
        return LayoutPermissionUtil.contains((PermissionChecker)this._themeDisplay.getPermissionChecker(), (Layout)layout, (String)"PERMISSIONS");
    }

    public boolean isShowPublicPages() {
        Group selGroup = this.getSelGroup();
        return !selGroup.isLayoutSetPrototype() && !selGroup.isLayoutPrototype();
    }

    private JSONObject _getActionURLsJSONObject(Layout layout) throws Exception {
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
        if (this.isShowAddChildPageAction(layout)) {
            jsonObject.put("addURL", this.getSelectLayoutPageTemplateEntryURL(this.getFirstLayoutPageTemplateCollectionId(), layout.getPlid(), layout.isPrivateLayout()));
        }
        if (this.isShowConfigureAction(layout)) {
            jsonObject.put("configureURL", this.getConfigureLayoutURL(layout));
        }
        if (this.isShowCopyLayoutAction(layout)) {
            jsonObject.put("copyLayoutURL", this.getCopyLayoutURL(layout));
        }
        if (this.isShowDeleteAction(layout)) {
            jsonObject.put("deleteURL", this.getDeleteLayoutURL(layout));
        }
        if (this.isShowConfigureAction(layout)) {
            jsonObject.put("editLayoutURL", this.getEditLayoutURL(layout));
            if (layout.getParentLayoutId() == 0L) {
                jsonObject.put("markAsHomePageLayoutURL", this.getMarkAsHomePageLayoutURL(layout));
            }
        }
        if (this.isShowOrphanPortletsAction(layout)) {
            jsonObject.put("orphanPortletsURL", this.getOrphanPortletsURL(layout));
        }
        if (this.isShowPermissionsAction(layout)) {
            jsonObject.put("permissionsURL", this.getPermissionsURL(layout));
        }
        jsonObject.put("viewLayoutURL", this.getViewLayoutURL(layout));
        return jsonObject;
    }

    private long _getActiveLayoutSetBranchId() throws PortalException {
        LayoutRevision layoutRevision;
        if (this._activeLayoutSetBranchId != null) {
            return this._activeLayoutSetBranchId;
        }
        this._activeLayoutSetBranchId = ParamUtil.getLong((HttpServletRequest)this._request, (String)"layoutSetBranchId");
        Layout layout = this.getSelLayout();
        if (layout != null && (layoutRevision = LayoutStagingUtil.getLayoutRevision((Layout)layout)) != null) {
            this._activeLayoutSetBranchId = layoutRevision.getLayoutSetBranchId();
        }
        List layoutSetBranches = LayoutSetBranchLocalServiceUtil.getLayoutSetBranches((long)this._themeDisplay.getScopeGroupId(), (boolean)this.isPrivatePages());
        if (this._activeLayoutSetBranchId == 0L && !layoutSetBranches.isEmpty()) {
            LayoutSetBranch currentUserLayoutSetBranch = LayoutSetBranchLocalServiceUtil.getUserLayoutSetBranch((long)this._themeDisplay.getUserId(), (long)this._themeDisplay.getScopeGroupId(), (boolean)this.isPrivateLayout(), (long)0L, (long)0L);
            this._activeLayoutSetBranchId = currentUserLayoutSetBranch.getLayoutSetBranchId();
        }
        if (this._activeLayoutSetBranchId == 0L && !layoutSetBranches.isEmpty()) {
            LayoutSetBranch layoutSetBranch = LayoutSetBranchLocalServiceUtil.getMasterLayoutSetBranch((long)this._themeDisplay.getScopeGroupId(), (boolean)this.isPrivateLayout());
            this._activeLayoutSetBranchId = layoutSetBranch.getLayoutSetBranchId();
        }
        return this._activeLayoutSetBranchId;
    }

    private JSONObject _getBreadcrumbEntryJSONObject(long plid, String title) {
        JSONObject breadcrumbEntryJSONObject = JSONFactoryUtil.createJSONObject();
        breadcrumbEntryJSONObject.put("title", title);
        PortletURL portletURL = this.getPortletURL();
        portletURL.setParameter("selPlid", String.valueOf(plid));
        breadcrumbEntryJSONObject.put("url", portletURL.toString());
        return breadcrumbEntryJSONObject;
    }

    private JSONObject _getFirstColumn(boolean privatePages) throws PortalException {
        JSONObject pagesJSONObject = JSONFactoryUtil.createJSONObject();
        pagesJSONObject.put("actionURLs", this._getFirstColumnActionURLsJSONObject(privatePages));
        pagesJSONObject.put("active", privatePages ? this.isPrivatePages() : this.isPublicPages());
        pagesJSONObject.put("hasChild", true);
        pagesJSONObject.put("plid", 0L);
        pagesJSONObject.put("title", this._getTitle(privatePages));
        PortletURL privatePagesURL = this.getPortletURL();
        privatePagesURL.setParameter("navigation", privatePages ? "private-pages" : "public-pages");
        privatePagesURL.setParameter("selPlid", String.valueOf(0L));
        pagesJSONObject.put("url", privatePagesURL.toString());
        return pagesJSONObject;
    }

    private JSONObject _getFirstColumnActionURLsJSONObject(boolean privatePages) throws PortalException {
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
        if (GroupPermissionUtil.contains((PermissionChecker)this._themeDisplay.getPermissionChecker(), (long)this.getSelGroupId(), (String)"MANAGE_LAYOUTS")) {
            PortletURL editLayoutSetURL = this._liferayPortletResponse.createRenderURL();
            editLayoutSetURL.setParameter("mvcPath", "/edit_layout_set.jsp");
            editLayoutSetURL.setParameter("redirect", this._themeDisplay.getURLCurrent());
            editLayoutSetURL.setParameter("backURL", this._themeDisplay.getURLCurrent());
            editLayoutSetURL.setParameter("groupId", String.valueOf(this._themeDisplay.getScopeGroupId()));
            editLayoutSetURL.setParameter("privateLayout", String.valueOf(privatePages));
            jsonObject.put("configureURL", editLayoutSetURL.toString());
        }
        return jsonObject;
    }

    private long _getHomePagePlid(boolean privateLayout) {
        if (this._homePagePlid != null) {
            return this._homePagePlid;
        }
        this._homePagePlid = LayoutLocalServiceUtil.getDefaultPlid((long)this.getSelGroupId(), (boolean)privateLayout);
        return this._homePagePlid;
    }

    private String _getHomePageTitle(boolean privateLayout) {
        if (this._homePageTitle != null) {
            return this._homePageTitle;
        }
        Layout defaultLayout = LayoutLocalServiceUtil.fetchDefaultLayout((long)this.getSelGroupId(), (boolean)privateLayout);
        this._homePageTitle = defaultLayout.getName(this._themeDisplay.getLocale());
        return this._homePageTitle;
    }

    private JSONArray _getLayoutColumnsJSONArray() throws Exception {
        JSONArray layoutColumnsJSONArray = JSONFactoryUtil.createJSONArray();
        JSONArray firstColumnJSONArray = JSONFactoryUtil.createJSONArray();
        if (LayoutLocalServiceUtil.hasLayouts((Group)this.getSelGroup(), (boolean)false) && this.isShowPublicPages()) {
            firstColumnJSONArray.put(this._getFirstColumn(false));
        }
        if (LayoutLocalServiceUtil.hasLayouts((Group)this.getSelGroup(), (boolean)true)) {
            firstColumnJSONArray.put(this._getFirstColumn(true));
        }
        layoutColumnsJSONArray.put(firstColumnJSONArray);
        JSONArray layoutSetBranchesJSONArray = this._getLayoutSetBranchesJSONArray();
        if (layoutSetBranchesJSONArray.length() > 0) {
            layoutColumnsJSONArray.put(layoutSetBranchesJSONArray);
        }
        layoutColumnsJSONArray.put(this._getLayoutsJSONArray(0L, this.isPrivatePages()));
        if (this.getSelPlid() == 0L) {
            return layoutColumnsJSONArray;
        }
        Layout selLayout = this.getSelLayout();
        if (selLayout == null) {
            return layoutColumnsJSONArray;
        }
        List layouts = selLayout.getAncestors();
        Collections.reverse(layouts);
        for (Layout layout : layouts) {
            layoutColumnsJSONArray.put(this._getLayoutsJSONArray(layout.getLayoutId(), selLayout.isPrivateLayout()));
        }
        layoutColumnsJSONArray.put(this._getLayoutsJSONArray(selLayout.getLayoutId(), selLayout.isPrivateLayout()));
        return layoutColumnsJSONArray;
    }

    private JSONArray _getLayoutSetBranchesJSONArray() throws PortalException {
        JSONArray jsonArray = JSONFactoryUtil.createJSONArray();
        List layoutSetBranches = LayoutSetBranchLocalServiceUtil.getLayoutSetBranches((long)this._themeDisplay.getScopeGroupId(), (boolean)this.isPrivatePages());
        for (LayoutSetBranch layoutSetBranch : layoutSetBranches) {
            JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
            jsonObject.put("active", layoutSetBranch.getLayoutSetBranchId() == this._getActiveLayoutSetBranchId());
            jsonObject.put("hasChild", true);
            jsonObject.put("plid", 0L);
            jsonObject.put("title", LanguageUtil.get((HttpServletRequest)this._request, (String)layoutSetBranch.getName()));
            PortletURL portletURL = this.getPortletURL();
            portletURL.setParameter("layoutSetBranchId", String.valueOf(layoutSetBranch.getLayoutSetBranchId()));
            jsonObject.put("url", portletURL.toString());
            jsonArray.put(jsonObject);
        }
        return jsonArray;
    }

    private JSONArray _getLayoutsJSONArray(long parentLayoutId, boolean privateLayout) throws Exception {
        JSONArray layoutsJSONArray = JSONFactoryUtil.createJSONArray();
        List layouts = LayoutLocalServiceUtil.getLayouts((long)this.getSelGroupId(), (boolean)privateLayout, (long)parentLayoutId, (boolean)true, (int)-1, (int)-1, null);
        for (Layout layout : layouts) {
            LayoutRevision layoutRevision;
            UnicodeProperties typeSettingsProperties = layout.getTypeSettingsProperties();
            boolean visible = GetterUtil.getBoolean((String)typeSettingsProperties.getProperty("visible"), (boolean)true);
            if (!visible || this._getActiveLayoutSetBranchId() > 0L && (layoutRevision = LayoutStagingUtil.getLayoutRevision((Layout)layout)).isIncomplete()) continue;
            JSONObject layoutJSONObject = JSONFactoryUtil.createJSONObject();
            layoutJSONObject.put("actionURLs", this._getActionURLsJSONObject(layout));
            layoutJSONObject.put("active", this._isActive(layout.getPlid()));
            LayoutTypeController layoutTypeController = LayoutTypeControllerTracker.getLayoutTypeController((String)layout.getType());
            ResourceBundle layoutTypeResourceBundle = ResourceBundleUtil.getBundle((String)"content.Language", (Locale)this._themeDisplay.getLocale(), layoutTypeController.getClass());
            layoutJSONObject.put("description", LanguageUtil.get((HttpServletRequest)this._request, (ResourceBundle)layoutTypeResourceBundle, (String)("layout.types." + layout.getType())));
            layoutJSONObject.put("homePage", this._getHomePagePlid(privateLayout) == layout.getPlid());
            int childLayoutsCount = LayoutLocalServiceUtil.getLayoutsCount((Group)this.getSelGroup(), (boolean)this.isPrivatePages(), (long)layout.getLayoutId());
            layoutJSONObject.put("hasChild", childLayoutsCount > 0);
            layoutJSONObject.put("homePageTitle", this._getHomePageTitle(privateLayout));
            layoutJSONObject.put("plid", layout.getPlid());
            if (childLayoutsCount > 0) {
                PortletURL portletURL = this.getPortletURL();
                portletURL.setParameter("selPlid", String.valueOf(layout.getPlid()));
                portletURL.setParameter("layoutSetBranchId", String.valueOf(this._getActiveLayoutSetBranchId()));
                layoutJSONObject.put("url", portletURL.toString());
            }
            layoutJSONObject.put("title", layout.getName(this._themeDisplay.getLocale()));
            layoutsJSONArray.put(layoutJSONObject);
        }
        return layoutsJSONArray;
    }

    private String _getTitle(boolean privatePages) {
        String title = "pages";
        if (this.isShowPublicPages()) {
            title = privatePages ? "private-pages" : "public-pages";
        }
        return LanguageUtil.get((HttpServletRequest)this._request, (String)title);
    }

    private boolean _isActive(long plid) throws PortalException {
        if (plid == this.getSelPlid()) {
            return true;
        }
        Layout selLayout = this.getSelLayout();
        if (selLayout == null) {
            return false;
        }
        for (Layout layout : selLayout.getAncestors()) {
            if (plid != layout.getPlid()) continue;
            return true;
        }
        return false;
    }
}

