/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.knowledge.base.web.internal.util;

import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.model.AssetRenderer;
import com.liferay.asset.kernel.model.AssetRendererFactory;
import com.liferay.asset.kernel.service.AssetEntryServiceUtil;
import com.liferay.asset.kernel.service.AssetTagLocalServiceUtil;
import com.liferay.asset.kernel.service.AssetTagServiceUtil;
import com.liferay.asset.kernel.service.persistence.AssetEntryQuery;
import com.liferay.blogs.model.BlogsEntry;
import com.liferay.journal.model.JournalArticle;
import com.liferay.journal.service.JournalArticleLocalServiceUtil;
import com.liferay.knowledge.base.model.KBArticle;
import com.liferay.message.boards.model.MBMessage;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.kernel.portlet.PortletProvider;
import com.liferay.portal.kernel.portlet.PortletProviderUtil;
import com.liferay.portal.kernel.portlet.PortletURLFactoryUtil;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.wiki.model.WikiPage;
import com.liferay.wiki.service.WikiPageLocalServiceUtil;
import java.util.LinkedHashSet;
import java.util.List;
import javax.portlet.PortletMode;
import javax.portlet.WindowState;
import javax.servlet.http.HttpServletRequest;

public class KBArticleAssetEntriesUtil {
    private static final Log _log = LogFactoryUtil.getLog(KBArticleAssetEntriesUtil.class);

    public static List<AssetEntry> getAssetEntries(long[] groupIds, long[] classNameIds, long[] assetTagIds, long resourcePrimKey, int start, int end, String orderByColumn) throws PortalException {
        AssetEntryQuery assetEntryQuery = new AssetEntryQuery();
        assetEntryQuery.setAnyTagIds(assetTagIds);
        assetEntryQuery.setClassNameIds(classNameIds);
        assetEntryQuery.setEnd(end + 1);
        assetEntryQuery.setGroupIds(groupIds);
        assetEntryQuery.setOrderByCol1(orderByColumn);
        assetEntryQuery.setStart(start);
        List assetEntries = ListUtil.copy((List)AssetEntryServiceUtil.getEntries((AssetEntryQuery)assetEntryQuery));
        AssetEntry assetEntry = null;
        for (AssetEntry curAssetEntry : assetEntries) {
            if (curAssetEntry.getClassPK() != resourcePrimKey) continue;
            assetEntry = curAssetEntry;
        }
        assetEntries.remove(assetEntry);
        return ListUtil.subList((List)assetEntries, (int)0, (int)10);
    }

    public static long[] getAssetTagIds(long[] groupIds, KBArticle kbArticle) throws PortalException {
        List assetTags = AssetTagServiceUtil.getTags((String)KBArticle.class.getName(), (long)kbArticle.getClassPK());
        long[] tagIds = AssetTagLocalServiceUtil.getTagIds((long[])groupIds, (String[])StringUtil.split((String)ListUtil.toString((List)assetTags, (String)"name")));
        LinkedHashSet<Long> filteredTagIds = new LinkedHashSet<Long>();
        for (long tagId : tagIds) {
            try {
                AssetTagServiceUtil.getTag((long)tagId);
            }
            catch (PrincipalException pe) {
                if (!_log.isDebugEnabled()) continue;
                _log.debug((Object)pe, (Throwable)pe);
                continue;
            }
            filteredTagIds.add(tagId);
        }
        return StringUtil.split((String)StringUtil.merge(filteredTagIds), (long)0L);
    }

    public static long[] getGroupIds(Group companyGroup, KBArticle kbArticle) {
        return new long[]{kbArticle.getGroupId(), companyGroup.getGroupId()};
    }

    public static String getURL(HttpServletRequest httpServletRequest, ThemeDisplay themeDisplay, AssetRendererFactory assetRendererFactory, AssetRenderer assetRenderer) throws Exception {
        long classPK = assetRenderer.getClassPK();
        String className = assetRendererFactory.getClassName();
        String portletId = PortletProviderUtil.getPortletId((String)className, (PortletProvider.Action)PortletProvider.Action.VIEW);
        LiferayPortletURL portletURL = null;
        if (className.equals(BlogsEntry.class.getName())) {
            portletURL = PortletURLFactoryUtil.create((HttpServletRequest)httpServletRequest, (String)portletId, (String)"RENDER_PHASE");
            portletURL.setParameter("mvcRenderCommandName", "/blogs/view_entry");
            portletURL.setParameter("entryId", String.valueOf(classPK));
        } else if (className.equals(JournalArticle.class.getName())) {
            JournalArticle journalArticle = JournalArticleLocalServiceUtil.getLatestArticle((long)classPK);
            portletURL = PortletURLFactoryUtil.create((HttpServletRequest)httpServletRequest, (String)portletId, (String)"RENDER_PHASE");
            portletURL.setParameter("struts_action", "/journal_content/view");
            portletURL.setParameter("groupId", String.valueOf(journalArticle.getGroupId()));
            portletURL.setParameter("articleId", journalArticle.getArticleId());
        } else if (className.equals(KBArticle.class.getName())) {
            portletURL = PortletURLFactoryUtil.create((HttpServletRequest)httpServletRequest, (String)"com_liferay_knowledge_base_web_portlet_ArticlePortlet_INSTANCE_0000", (String)"RENDER_PHASE");
            portletURL.setParameter("mvcPath", "/article/view_article.jsp");
            portletURL.setParameter("resourcePrimKey", String.valueOf(classPK));
        } else if (className.equals(MBMessage.class.getName())) {
            portletURL = PortletURLFactoryUtil.create((HttpServletRequest)httpServletRequest, (String)portletId, (String)"RENDER_PHASE");
            portletURL.setParameter("struts_action", "/message_boards/view_message");
            portletURL.setParameter("messageId", String.valueOf(classPK));
        } else if (className.equals(WikiPage.class.getName())) {
            WikiPage wikiPage = WikiPageLocalServiceUtil.getPage((long)classPK);
            portletURL = PortletURLFactoryUtil.create((HttpServletRequest)httpServletRequest, (String)portletId, (String)"RENDER_PHASE");
            portletURL.setParameter("struts_action", "/wiki/view");
            portletURL.setParameter("nodeId", String.valueOf(wikiPage.getNodeId()));
            portletURL.setParameter("title", wikiPage.getTitle());
        }
        String currentURL = PortalUtil.getCurrentURL((HttpServletRequest)httpServletRequest);
        if (portletURL == null) {
            return currentURL;
        }
        portletURL.setWindowState(WindowState.MAXIMIZED);
        portletURL.setPortletMode(PortletMode.VIEW);
        portletURL.setParameter("returnToFullPageURL", currentURL);
        return portletURL.toString();
    }
}

