/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.knowledge.base.web.internal.selector;

import com.liferay.knowledge.base.model.KBArticle;
import com.liferay.knowledge.base.model.KBFolder;
import com.liferay.knowledge.base.service.KBArticleService;
import com.liferay.knowledge.base.service.KBFolderLocalService;
import com.liferay.knowledge.base.service.KBFolderService;
import com.liferay.knowledge.base.util.comparator.KBFolderNameComparator;
import com.liferay.knowledge.base.web.internal.selector.KBArticleSelection;
import com.liferay.knowledge.base.web.internal.selector.KBArticleSelector;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.List;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"model.class.name=com.liferay.knowledge.base.model.KBFolder"}, service={KBArticleSelector.class})
public class KBFolderKBArticleSelector
implements KBArticleSelector {
    @Reference
    private KBArticleService _kbArticleService;
    @Reference
    private KBFolderLocalService _kbFolderLocalService;
    @Reference
    private KBFolderService _kbFolderService;
    private KBFolder _rootKBFolder;

    @Override
    public KBArticleSelection findByResourcePrimKey(long groupId, String preferredKBFolderUrlTitle, long ancestorResourcePrimKey, long resourcePrimKey) throws PortalException {
        KBFolder ancestorKBFolder = this._rootKBFolder;
        if (ancestorResourcePrimKey != 0L && (ancestorKBFolder = this._kbFolderService.fetchKBFolder(ancestorResourcePrimKey)) == null) {
            return new KBArticleSelection(null, false);
        }
        KBArticle kbArticle = this._kbArticleService.fetchLatestKBArticle(resourcePrimKey, 0);
        if (kbArticle == null || !this.isDescendant(kbArticle, ancestorKBFolder)) {
            KBArticleSelection kbArticleSelection = this.findFirstKBArticle(groupId, ancestorKBFolder, preferredKBFolderUrlTitle);
            if (resourcePrimKey == 0L) {
                kbArticleSelection.setExactMatch(true);
            }
            return kbArticleSelection;
        }
        return new KBArticleSelection(kbArticle, true);
    }

    @Override
    public KBArticleSelection findByUrlTitle(long groupId, String preferredKBFolderUrlTitle, long ancestorResourcePrimKey, String kbFolderUrlTitle, String urlTitle) throws PortalException {
        KBFolder ancestorKBFolder = this._rootKBFolder;
        if (ancestorResourcePrimKey != 0L && (ancestorKBFolder = this._kbFolderService.fetchKBFolder(ancestorResourcePrimKey)) == null) {
            return new KBArticleSelection(null, false);
        }
        KBFolder kbFolder = this._rootKBFolder;
        if (Validator.isNotNull((String)kbFolderUrlTitle)) {
            kbFolder = kbFolderUrlTitle.equals(ancestorKBFolder.getUrlTitle()) ? ancestorKBFolder : this._kbFolderService.fetchKBFolderByUrlTitle(groupId, ancestorKBFolder.getKbFolderId(), kbFolderUrlTitle);
        }
        KBArticle kbArticle = null;
        if (kbFolder != null) {
            kbArticle = this._kbArticleService.fetchKBArticleByUrlTitle(groupId, kbFolder.getKbFolderId(), urlTitle);
        }
        if (kbArticle == null || !this.isDescendant(kbArticle, ancestorKBFolder)) {
            return this.findClosestMatchingKBArticle(groupId, ancestorKBFolder, preferredKBFolderUrlTitle, kbFolderUrlTitle, urlTitle);
        }
        return new KBArticleSelection(kbArticle, true);
    }

    @Activate
    protected void activate() {
        this._rootKBFolder = this._kbFolderLocalService.createKBFolder(0L);
    }

    protected KBArticleSelection findClosestMatchingKBArticle(long groupId, KBFolder ancestorKBFolder, String preferredKBFolderUrlTitle, String kbFolderUrlTitle, String urlTitle) throws PortalException {
        KBFolder kbFolder = this.getCandidateKBFolder(groupId, preferredKBFolderUrlTitle, ancestorKBFolder, kbFolderUrlTitle);
        KBArticle kbArticle = this._kbArticleService.fetchKBArticleByUrlTitle(groupId, kbFolder.getKbFolderId(), urlTitle);
        if (kbArticle != null) {
            return new KBArticleSelection(kbArticle, false);
        }
        kbArticle = this._kbArticleService.fetchFirstChildKBArticle(groupId, kbFolder.getKbFolderId());
        String[] keywords = StringUtil.split((String)urlTitle, (char)'-');
        return new KBArticleSelection(kbArticle, keywords);
    }

    protected KBArticleSelection findFirstKBArticle(long groupId, KBFolder ancestorKBFolder, String preferredKBFolderUrlTitle) throws PortalException {
        KBFolder kbFolder = null;
        int kbArticlesCount = this._kbArticleService.getKBArticlesCount(groupId, ancestorKBFolder.getKbFolderId(), 0);
        if (Validator.isNotNull((String)preferredKBFolderUrlTitle) && kbArticlesCount == 0) {
            kbFolder = this._kbFolderService.fetchKBFolderByUrlTitle(groupId, ancestorKBFolder.getKbFolderId(), preferredKBFolderUrlTitle);
        }
        if (kbFolder == null && kbArticlesCount == 0) {
            kbFolder = this._kbFolderService.fetchFirstChildKBFolder(groupId, ancestorKBFolder.getKbFolderId(), (OrderByComparator)new KBFolderNameComparator(false));
        }
        if (kbFolder == null) {
            kbFolder = ancestorKBFolder;
        }
        KBArticle kbArticle = this._kbArticleService.fetchFirstChildKBArticle(groupId, kbFolder.getKbFolderId(), 0);
        return new KBArticleSelection(kbArticle, true);
    }

    protected KBFolder getCandidateKBFolder(long groupId, String preferredKBFolderUrlTitle, KBFolder ancestorKBFolder, String kbFolderUrlTitle) throws PortalException {
        KBFolder kbFolder = null;
        if (Validator.isNotNull((String)kbFolderUrlTitle)) {
            kbFolder = this._kbFolderService.fetchKBFolderByUrlTitle(groupId, ancestorKBFolder.getKbFolderId(), kbFolderUrlTitle);
        }
        if (kbFolder == null && Validator.isNotNull((String)preferredKBFolderUrlTitle)) {
            kbFolder = this._kbFolderService.fetchKBFolderByUrlTitle(groupId, ancestorKBFolder.getKbFolderId(), preferredKBFolderUrlTitle);
        }
        int kbArticlesCount = this._kbArticleService.getKBArticlesCount(groupId, ancestorKBFolder.getKbFolderId(), 0);
        if (kbFolder == null && kbArticlesCount == 0) {
            kbFolder = this._kbFolderService.fetchFirstChildKBFolder(groupId, ancestorKBFolder.getKbFolderId(), (OrderByComparator)new KBFolderNameComparator(false));
        }
        if (kbFolder == null) {
            return ancestorKBFolder;
        }
        return kbFolder;
    }

    protected boolean isDescendant(KBArticle kbArticle, KBFolder kbFolder) throws PortalException {
        if (kbFolder.getKbFolderId() == 0L) {
            return true;
        }
        if (kbArticle.getKbFolderId() == 0L) {
            return false;
        }
        KBFolder parentKBFolder = this._kbFolderService.getKBFolder(kbArticle.getKbFolderId());
        List ancestorKBFolderIds = parentKBFolder.getAncestorKBFolderIds();
        return ancestorKBFolderIds.contains(kbFolder.getKbFolderId());
    }
}

