/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.knowledge.base.web.internal.portlet;

import com.liferay.knowledge.base.constants.KBFolderConstants;
import com.liferay.knowledge.base.exception.NoSuchArticleException;
import com.liferay.knowledge.base.exception.NoSuchCommentException;
import com.liferay.knowledge.base.model.KBArticle;
import com.liferay.knowledge.base.model.KBFolder;
import com.liferay.knowledge.base.service.KBArticleLocalService;
import com.liferay.knowledge.base.util.KnowledgeBaseUtil;
import com.liferay.knowledge.base.util.comparator.KBArticlePriorityComparator;
import com.liferay.knowledge.base.web.internal.KBUtil;
import com.liferay.knowledge.base.web.internal.portlet.BaseKBPortlet;
import com.liferay.knowledge.base.web.internal.selector.KBArticleSelection;
import com.liferay.knowledge.base.web.internal.selector.KBArticleSelector;
import com.liferay.knowledge.base.web.internal.selector.KBArticleSelectorFactory;
import com.liferay.portal.kernel.exception.NoSuchSubscriptionException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.model.Release;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.kernel.portlet.PortalPreferences;
import com.liferay.portal.kernel.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portal.kernel.portlet.PortletURLFactoryUtil;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.servlet.SessionMessages;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.Validator;
import java.io.IOException;
import java.util.List;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.Portlet;
import javax.portlet.PortletException;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.servlet.http.HttpServletResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"com.liferay.portlet.css-class-wrapper=knowledge-base-portlet knowledge-base-portlet-display", "com.liferay.portlet.display-category=category.cms", "com.liferay.portlet.header-portlet-css=/admin/css/common.css", "com.liferay.portlet.header-portlet-css=/display/css/main.css", "com.liferay.portlet.icon=/icons/display.png", "com.liferay.portlet.scopeable=true", "com.liferay.portlet.struts-path=knowledge_base", "javax.portlet.display-name=Knowledge Base Display", "javax.portlet.expiration-cache=0", "javax.portlet.init-param.always-send-redirect=true", "javax.portlet.init-param.copy-request-parameters=true", "javax.portlet.init-param.template-path=/display/", "javax.portlet.init-param.view-template=/display/view.jsp", "javax.portlet.name=com_liferay_knowledge_base_web_portlet_DisplayPortlet", "javax.portlet.resource-bundle=content.Language", "javax.portlet.security-role-ref=administrator,guest,power-user,user", "javax.portlet.supported-public-render-parameter=categoryId", "javax.portlet.supported-public-render-parameter=tag", "javax.portlet.supports.mime-type=text/html"}, service={Portlet.class})
public class DisplayPortlet
extends BaseKBPortlet {
    @Reference
    private ClassNameLocalService _classNameLocalService;
    @Reference
    private KBArticleLocalService _kbArticleLocalService;
    @Reference(target="(model.class.name=com.liferay.knowledge.base.model.KBArticle)")
    private ModelResourcePermission<KBArticle> _kbArticleModelResourcePermission;
    @Reference
    private KBArticleSelectorFactory _kbArticleSelectorFactory;
    @Reference
    private Portal _portal;

    public void updateRootKBFolderId(ActionRequest actionRequest, ActionResponse actionResponse) throws IOException, PortalException {
        KBFolder kbFolder = null;
        long kbFolderId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"rootKBFolderId");
        long kbFolderGroupId = this._portal.getScopeGroupId((PortletRequest)actionRequest);
        String kbFolderURLTitle = "";
        if (kbFolderId != 0L) {
            kbFolder = this.kbFolderService.getKBFolder(kbFolderId);
            kbFolderGroupId = kbFolder.getGroupId();
            kbFolderURLTitle = kbFolder.getUrlTitle();
        }
        PortalPreferences portalPreferences = PortletPreferencesFactoryUtil.getPortalPreferences((PortletRequest)this._portal.getLiferayPortletRequest((PortletRequest)actionRequest));
        PortletPreferences portletPreferences = actionRequest.getPreferences();
        String contentRootPrefix = GetterUtil.getString((String)portletPreferences.getValue("contentRootPrefix", null));
        String previousPreferredKBFolderURLTitle = KBUtil.getPreferredKBFolderURLTitle(portalPreferences, contentRootPrefix);
        KnowledgeBaseUtil.setPreferredKBFolderURLTitle((PortalPreferences)portalPreferences, (String)contentRootPrefix, (String)kbFolderURLTitle);
        String urlTitle = ParamUtil.getString((PortletRequest)actionRequest, (String)"urlTitle");
        KBArticle kbArticle = null;
        if (Validator.isNotNull((String)urlTitle) && (kbArticle = this._kbArticleLocalService.fetchKBArticleByUrlTitle(kbFolderGroupId, kbFolderURLTitle, urlTitle)) == null && Validator.isNotNull((String)previousPreferredKBFolderURLTitle)) {
            kbArticle = this.findClosestMatchingKBArticle(kbFolderGroupId, previousPreferredKBFolderURLTitle, kbFolderId, urlTitle);
        }
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        if (kbArticle != null && !this._kbArticleModelResourcePermission.contains(themeDisplay.getPermissionChecker(), (ClassedModel)kbArticle, "VIEW")) {
            kbArticle = null;
        }
        LiferayPortletURL redirectURL = PortletURLFactoryUtil.create((PortletRequest)actionRequest, (String)"com_liferay_knowledge_base_web_portlet_DisplayPortlet", (String)"RENDER_PHASE");
        redirectURL.setParameter("kbFolderId", String.valueOf(kbFolderId));
        redirectURL.setParameter("kbFolderUrlTitle", kbFolderURLTitle);
        if (kbArticle != null) {
            redirectURL.setParameter("urlTitle", kbArticle.getUrlTitle());
        }
        actionResponse.sendRedirect(redirectURL.toString());
    }

    protected void addSuccessMessage(ActionRequest actionRequest, ActionResponse actionResponse) {
        String actionName = ParamUtil.getString((PortletRequest)actionRequest, (String)"javax.portlet.action");
        if (actionName.equals("updateRootKBFolderId")) {
            return;
        }
        super.addSuccessMessage(actionRequest, actionResponse);
    }

    @Override
    protected void deleteKBArticle(ActionRequest actionRequest, ActionResponse actionResponse, long resourcePrimKey) throws Exception {
        KBArticle kbArticle = this.kbArticleService.getLatestKBArticle(resourcePrimKey, -1);
        long kbFolderId = kbArticle.getKbFolderId();
        long parentResourcePrimKey = kbArticle.getParentResourcePrimKey();
        super.deleteKBArticle(actionRequest, actionResponse, resourcePrimKey);
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        LiferayPortletURL liferayPortletURL = PortletURLFactoryUtil.create((PortletRequest)actionRequest, (String)this._portal.getPortletId((PortletRequest)actionRequest), (long)themeDisplay.getPlid(), (String)"RENDER_PHASE");
        if (parentResourcePrimKey != kbFolderId) {
            liferayPortletURL.setParameter("resourcePrimKey", String.valueOf(parentResourcePrimKey));
        }
        actionResponse.sendRedirect(liferayPortletURL.toString());
    }

    protected void doDispatch(RenderRequest renderRequest, RenderResponse renderResponse) throws IOException, PortletException {
        if (SessionErrors.contains((PortletRequest)renderRequest, (String)NoSuchArticleException.class.getName()) || SessionErrors.contains((PortletRequest)renderRequest, (String)NoSuchCommentException.class.getName()) || SessionErrors.contains((PortletRequest)renderRequest, (String)NoSuchSubscriptionException.class.getName()) || SessionErrors.contains((PortletRequest)renderRequest, (Class[])PrincipalException.getNestedClasses())) {
            this.include(this.templatePath + "error.jsp", renderRequest, renderResponse);
        } else {
            super.doDispatch(renderRequest, renderResponse);
        }
    }

    @Override
    protected void doRender(RenderRequest renderRequest, RenderResponse renderResponse) throws IOException, PortletException {
        try {
            KBArticleSelection kbArticleSelection = this.getKBArticle(renderRequest);
            renderRequest.setAttribute("KNOWLEDGE_BASE_EXACT_MATCH", (Object)kbArticleSelection.isExactMatch());
            KBArticle kbArticle = kbArticleSelection.getKBArticle();
            if (kbArticle != null && kbArticle.getStatus() != 0) {
                kbArticle = this._kbArticleLocalService.fetchLatestKBArticle(kbArticle.getResourcePrimKey(), 0);
            }
            renderRequest.setAttribute("KNOWLEDGE_BASE_KB_ARTICLE", (Object)kbArticle);
            renderRequest.setAttribute("KNOWLEDGE_BASE_SEARCH_KEYWORDS", (Object)kbArticleSelection.getKeywords());
            renderRequest.setAttribute("KNOWLEDGE_BASE_STATUS", (Object)0);
            String mvcPath = ParamUtil.getString((PortletRequest)renderRequest, (String)"mvcPath");
            if ((mvcPath.equals("") || mvcPath.equals("/display/view_article.jsp")) && !kbArticleSelection.isExactMatch()) {
                HttpServletResponse httpServletResponse = this._portal.getHttpServletResponse((PortletResponse)renderResponse);
                httpServletResponse.setStatus(404);
            }
        }
        catch (Exception e) {
            if (e instanceof NoSuchArticleException || e instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)renderRequest, e.getClass());
                SessionMessages.add((PortletRequest)renderRequest, (String)(this._portal.getPortletId((PortletRequest)renderRequest) + ".hideDefaultErrorMessage"));
            }
            throw new PortletException((Throwable)e);
        }
    }

    protected KBArticle findClosestMatchingKBArticle(long groupId, String oldKBFolderURLTitle, long newKBFolderId, String urlTitle) throws PortalException {
        List kbArticles;
        KBArticle oldKBArticle = this._kbArticleLocalService.fetchKBArticleByUrlTitle(groupId, oldKBFolderURLTitle, urlTitle);
        KBArticle kbArticle = null;
        while (kbArticle == null && oldKBArticle != null) {
            kbArticle = this._kbArticleLocalService.fetchKBArticleByUrlTitle(groupId, newKBFolderId, oldKBArticle.getUrlTitle());
            if (kbArticle != null) continue;
            oldKBArticle = oldKBArticle.getParentKBArticle();
        }
        if (kbArticle == null && !(kbArticles = this._kbArticleLocalService.getKBArticles(groupId, newKBFolderId, 0, 0, 1, (OrderByComparator)new KBArticlePriorityComparator(true))).isEmpty()) {
            kbArticle = (KBArticle)kbArticles.get(0);
        }
        return kbArticle;
    }

    protected KBArticleSelection getKBArticle(RenderRequest renderRequest) throws PortalException {
        String mvcPath = ParamUtil.getString((PortletRequest)renderRequest, (String)"mvcPath");
        if (mvcPath.endsWith("/edit_article.jsp") || mvcPath.endsWith("/history.jsp") || mvcPath.endsWith("/print_article.jsp")) {
            long resourcePrimKey = ParamUtil.getLong((PortletRequest)renderRequest, (String)"resourcePrimKey");
            if (resourcePrimKey == 0L) {
                return new KBArticleSelection(null, false);
            }
            KBArticle latestKBArticle = this._kbArticleLocalService.getLatestKBArticle(resourcePrimKey, -1);
            return new KBArticleSelection(latestKBArticle, true);
        }
        PortletPreferences portletPreferences = renderRequest.getPreferences();
        long kbFolderClassNameId = this._classNameLocalService.getClassNameId(KBFolderConstants.getClassName());
        long parentResourcePrimKey = GetterUtil.getLong((String)portletPreferences.getValue("resourcePrimKey", null));
        long parentResourceClassNameId = GetterUtil.getLong((String)portletPreferences.getValue("resourceClassNameId", null), (long)kbFolderClassNameId);
        long kbFolderId = ParamUtil.getLong((PortletRequest)renderRequest, (String)"kbFolderId");
        if (parentResourceClassNameId == kbFolderClassNameId && kbFolderId != 0L) {
            parentResourcePrimKey = kbFolderId;
        }
        KBArticleSelector kbArticleSelector = this._kbArticleSelectorFactory.getKBArticleSelector(parentResourceClassNameId);
        String urlTitle = ParamUtil.getString((PortletRequest)renderRequest, (String)"urlTitle");
        String preferredKBFolderURLTitle = this.getPreferredKBFolderUrlTitle(renderRequest, portletPreferences);
        if (Validator.isNotNull((String)urlTitle)) {
            String kbFolderUrlTitle = ParamUtil.getString((PortletRequest)renderRequest, (String)"kbFolderUrlTitle");
            return kbArticleSelector.findByUrlTitle(this._portal.getScopeGroupId((PortletRequest)renderRequest), preferredKBFolderURLTitle, parentResourcePrimKey, kbFolderUrlTitle, urlTitle);
        }
        long resourcePrimKey = ParamUtil.getLong((PortletRequest)renderRequest, (String)"resourcePrimKey", (long)0L);
        return kbArticleSelector.findByResourcePrimKey(this._portal.getScopeGroupId((PortletRequest)renderRequest), preferredKBFolderURLTitle, parentResourcePrimKey, resourcePrimKey);
    }

    protected String getPreferredKBFolderUrlTitle(RenderRequest renderRequest, PortletPreferences portletPreferences) throws PortalException {
        PortalPreferences portalPreferences = PortletPreferencesFactoryUtil.getPortalPreferences((PortletRequest)renderRequest);
        String contentRootPrefix = GetterUtil.getString((String)portletPreferences.getValue("contentRootPrefix", null));
        return KBUtil.getPreferredKBFolderURLTitle(portalPreferences, contentRootPrefix);
    }

    @Reference(target="(&(release.bundle.symbolic.name=com.liferay.knowledge.base.web)(&(release.schema.version>=1.2.0)(!(release.schema.version>=1.3.0))))", unbind="-")
    protected void setRelease(Release release) {
    }
}

