/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.knowledge.base.web.internal.display.context;

import com.liferay.knowledge.base.constants.KBFolderConstants;
import com.liferay.knowledge.base.model.KBArticle;
import com.liferay.knowledge.base.model.KBFolder;
import com.liferay.knowledge.base.service.KBArticleLocalServiceUtil;
import com.liferay.knowledge.base.service.KBArticleServiceUtil;
import com.liferay.knowledge.base.service.KBFolderServiceUtil;
import com.liferay.knowledge.base.util.KnowledgeBaseUtil;
import com.liferay.knowledge.base.util.comparator.KBArticlePriorityComparator;
import com.liferay.knowledge.base.web.internal.KBUtil;
import com.liferay.knowledge.base.web.internal.configuration.KBDisplayPortletInstanceConfiguration;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.portlet.PortalPreferences;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.PortalUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.portlet.PortletRequest;

public class KBNavigationDisplayContext {
    private final KBArticle _kbArticle;
    private final KBDisplayPortletInstanceConfiguration _kbDisplayPortletInstanceConfiguration;
    private Boolean _leftNavigationVisible;
    private final PortalPreferences _portalPreferences;
    private final PortletRequest _portletRequest;
    private Long _resourceClassNameId;
    private Long _resourcePrimKey;
    private Long _rootResourcePrimKey;

    public KBNavigationDisplayContext(PortletRequest portletRequest, PortalPreferences portalPreferences, KBDisplayPortletInstanceConfiguration kbDisplayPortletInstanceConfiguration, KBArticle kbArticle) {
        this._portletRequest = portletRequest;
        this._portalPreferences = portalPreferences;
        this._kbDisplayPortletInstanceConfiguration = kbDisplayPortletInstanceConfiguration;
        this._kbArticle = kbArticle;
    }

    public List<Long> getAncestorResourcePrimaryKeys() throws PortalException {
        List<Long> ancestorResourcePrimaryKeys = new ArrayList<Long>();
        if (this._kbArticle != null) {
            KBArticle latestKBArticle = KBArticleLocalServiceUtil.getLatestKBArticle((long)this._kbArticle.getResourcePrimKey(), (int)0);
            ancestorResourcePrimaryKeys = latestKBArticle.getAncestorResourcePrimaryKeys();
            Collections.reverse(ancestorResourcePrimaryKeys);
        } else {
            ancestorResourcePrimaryKeys.add(0L);
        }
        return ancestorResourcePrimaryKeys;
    }

    public List<KBArticle> getChildKBArticles(long groupId, long parentResourcePrimKey, int level) throws PortalException {
        if (parentResourcePrimKey == this.getResourcePrimKey() && level == 0 && !this.isFolderResource()) {
            KBArticle kbArticle = KBArticleServiceUtil.getLatestKBArticle((long)this.getResourcePrimKey(), (int)0);
            return Collections.singletonList(kbArticle);
        }
        boolean maxNestingLevelReached = this.isMaxNestingLevelReached(level);
        List childKBArticles = maxNestingLevelReached ? KBArticleServiceUtil.getAllDescendantKBArticles((long)groupId, (long)parentResourcePrimKey, (int)0, (OrderByComparator)new KBArticlePriorityComparator(true)) : KBArticleServiceUtil.getKBArticles((long)groupId, (long)parentResourcePrimKey, (int)0, (int)-1, (int)-1, (OrderByComparator)new KBArticlePriorityComparator(true));
        return childKBArticles;
    }

    public String getCurrentKBFolderURLTitle() throws PortalException {
        String currentKBFolderURLTitle = KBUtil.getPreferredKBFolderURLTitle(this._portalPreferences, this._kbDisplayPortletInstanceConfiguration.contentRootPrefix());
        long rootResourcePrimKey = this.getRootResourcePrimKey();
        if (rootResourcePrimKey != 0L) {
            KBFolder kbFolder = KBFolderServiceUtil.getKBFolder((long)rootResourcePrimKey);
            currentKBFolderURLTitle = kbFolder.getUrlTitle();
        } else {
            currentKBFolderURLTitle = "";
        }
        return currentKBFolderURLTitle;
    }

    public String getPageTitle() throws PortalException {
        long rootResourcePrimKey = this.getRootResourcePrimKey();
        String pageTitle = null;
        if (this.isFolderResource() && rootResourcePrimKey != 0L) {
            KBFolder kbFolder = KBFolderServiceUtil.getKBFolder((long)rootResourcePrimKey);
            pageTitle = this._kbDisplayPortletInstanceConfiguration.contentRootPrefix() + " " + kbFolder.getName();
            if (this._kbArticle != null) {
                pageTitle = this._kbArticle.getTitle() + " - " + pageTitle;
            }
        } else if (this._kbArticle != null) {
            pageTitle = this._kbArticle.getTitle();
        }
        return pageTitle;
    }

    public long getParentResourcePrimKey() throws PortalException {
        if (this._kbArticle != null) {
            return this._kbArticle.getParentResourcePrimKey();
        }
        return this.getRootResourcePrimKey();
    }

    public long getRootResourcePrimKey() throws PortalException {
        if (this._rootResourcePrimKey == null) {
            this._rootResourcePrimKey = !this.isFolderResource() ? Long.valueOf(this.getResourcePrimKey()) : (this._kbArticle != null ? Long.valueOf(KnowledgeBaseUtil.getKBFolderId((long)this._kbArticle.getParentResourceClassNameId(), (long)this._kbArticle.getParentResourcePrimKey())) : Long.valueOf(KBUtil.getRootResourcePrimKey(this._portletRequest, PortalUtil.getScopeGroupId((PortletRequest)this._portletRequest), this.getResourceClassNameId(), this.getResourcePrimKey())));
        }
        return this._rootResourcePrimKey;
    }

    public boolean isChildKBArticleExpanded(KBArticle childKBArticle, int level) throws PortalException {
        List<Long> ancestorResourcePrimaryKeys = this.getAncestorResourcePrimaryKeys();
        return ancestorResourcePrimaryKeys.size() > 1 && level < ancestorResourcePrimaryKeys.size() && childKBArticle.getResourcePrimKey() == ancestorResourcePrimaryKeys.get(level).longValue();
    }

    public boolean isFolderResource() {
        long kbFolderClassNameId = PortalUtil.getClassNameId((String)KBFolderConstants.getClassName());
        return kbFolderClassNameId == this.getResourceClassNameId();
    }

    public boolean isFurtherExpansionRequired(long parentResourcePrimKey, KBArticle childKBArticle, int level) throws PortalException {
        List<Long> ancestorResourcePrimaryKeys = this.getAncestorResourcePrimaryKeys();
        return !this.isMaxNestingLevelReached(level) && ancestorResourcePrimaryKeys.contains(childKBArticle.getResourcePrimKey());
    }

    public boolean isLeftNavigationVisible() throws PortalException {
        if (this._leftNavigationVisible == null) {
            this._leftNavigationVisible = this.hasMultipleDescendantKBArticles();
        }
        return this._leftNavigationVisible;
    }

    public boolean isMaxNestingLevelReached(int level) {
        int maxNestingLevel = this._kbDisplayPortletInstanceConfiguration.maxNestingLevel();
        boolean maxNestingLevelReached = false;
        if (maxNestingLevel - level <= 1) {
            maxNestingLevelReached = true;
        }
        return maxNestingLevelReached;
    }

    public boolean isTopNavigationVisible() throws PortalException {
        return this.isFolderResource() && !this.isLeftNavigationVisible();
    }

    protected long getResourceClassNameId() {
        if (this._resourceClassNameId == null) {
            this._resourceClassNameId = this._kbDisplayPortletInstanceConfiguration.resourceClassNameId() != 0L ? Long.valueOf(this._kbDisplayPortletInstanceConfiguration.resourceClassNameId()) : Long.valueOf(PortalUtil.getClassNameId((String)KBFolderConstants.getClassName()));
        }
        return this._resourceClassNameId;
    }

    protected long getResourcePrimKey() {
        if (this._resourcePrimKey == null) {
            this._resourcePrimKey = GetterUtil.getLong((Object)this._kbDisplayPortletInstanceConfiguration.resourcePrimKey());
        }
        return this._resourcePrimKey;
    }

    protected boolean hasMultipleDescendantKBArticles() throws PortalException {
        List<KBFolder> kbFolders;
        long scopeGroupId = PortalUtil.getScopeGroupId((PortletRequest)this._portletRequest);
        if (this.isFolderResource() && (kbFolders = KBUtil.getAlternateRootKBFolders(scopeGroupId, this.getResourcePrimKey())).size() > 1) {
            int maxKBArticlesCount = 0;
            for (KBFolder kbFolder : kbFolders) {
                int kbArticlesCount = KBArticleLocalServiceUtil.getKBFolderKBArticlesCount((long)scopeGroupId, (long)kbFolder.getKbFolderId(), (int)0);
                if (kbArticlesCount <= maxKBArticlesCount) continue;
                maxKBArticlesCount = kbArticlesCount;
            }
            return maxKBArticlesCount > 1;
        }
        long rootResourcePrimKey = this.getRootResourcePrimKey();
        int kbArticlesCount = KBArticleLocalServiceUtil.getKBArticlesCount((long)scopeGroupId, (long)rootResourcePrimKey, (int)0);
        if (!this.isFolderResource()) {
            ++kbArticlesCount;
        }
        if (kbArticlesCount == 0) {
            return false;
        }
        if (kbArticlesCount != 1) {
            return true;
        }
        List kbArticles = KBArticleLocalServiceUtil.getKBArticles((long)scopeGroupId, (long)rootResourcePrimKey, (int)0, (int)0, (int)1, null);
        if (kbArticles.isEmpty()) {
            return false;
        }
        KBArticle navigationKBArticle = (KBArticle)kbArticles.get(0);
        int navigationKBArticleChildCount = KBArticleLocalServiceUtil.getKBArticlesCount((long)scopeGroupId, (long)navigationKBArticle.getResourcePrimKey(), (int)0);
        return navigationKBArticleChildCount != 0;
    }
}

