/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.knowledge.base.web.internal.search;

import com.liferay.knowledge.base.exception.NoSuchArticleException;
import com.liferay.knowledge.base.model.KBArticle;
import com.liferay.knowledge.base.model.KBFolder;
import com.liferay.knowledge.base.service.KBArticleServiceUtil;
import com.liferay.knowledge.base.service.KBFolderServiceUtil;
import com.liferay.knowledge.base.web.internal.security.permission.resource.KBArticlePermission;
import com.liferay.knowledge.base.web.internal.security.permission.resource.KBFolderPermission;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.search.EmptyOnClickRowChecker;
import com.liferay.portal.kernel.portlet.LiferayPortletRequest;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.GetterUtil;
import javax.portlet.PortletResponse;
import javax.servlet.http.HttpServletRequest;

public class EntriesChecker
extends EmptyOnClickRowChecker {
    private final LiferayPortletResponse _liferayPortletResponse;
    private final PermissionChecker _permissionChecker;

    public EntriesChecker(LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse) {
        super((PortletResponse)liferayPortletResponse);
        this._liferayPortletResponse = liferayPortletResponse;
        ThemeDisplay themeDisplay = (ThemeDisplay)liferayPortletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        this._permissionChecker = themeDisplay.getPermissionChecker();
    }

    public String getAllRowsCheckBox() {
        return null;
    }

    public String getAllRowsCheckBox(HttpServletRequest request) {
        return null;
    }

    public String getRowCheckBox(HttpServletRequest request, boolean checked, boolean disabled, String primaryKey) {
        KBArticle kbArticle = null;
        KBFolder kbFolder = null;
        long entryId = GetterUtil.getLong((String)primaryKey);
        try {
            kbArticle = KBArticleServiceUtil.getLatestKBArticle((long)entryId, (int)-1);
        }
        catch (Exception e) {
            if (e instanceof NoSuchArticleException) {
                try {
                    kbFolder = KBFolderServiceUtil.getKBFolder((long)entryId);
                }
                catch (Exception e1) {
                    return "";
                }
            }
            return "";
        }
        boolean showInput = false;
        String name = null;
        if (kbArticle != null) {
            name = KBArticle.class.getSimpleName();
            try {
                if (KBArticlePermission.contains(this._permissionChecker, kbArticle, "DELETE")) {
                    showInput = true;
                }
            }
            catch (Exception exception) {}
        } else {
            name = KBFolder.class.getSimpleName();
            try {
                if (KBFolderPermission.contains(this._permissionChecker, kbFolder, "DELETE")) {
                    showInput = true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (!showInput) {
            return "";
        }
        String checkBoxRowIds = this.getEntryRowIds();
        String checkBoxAllRowIds = "'#" + this.getAllRowIds() + "'";
        String checkBoxPostOnClick = this._liferayPortletResponse.getNamespace() + "toggleActionsButton();";
        return this.getRowCheckBox(request, checked, disabled, this._liferayPortletResponse.getNamespace() + "rowIds" + name, primaryKey, checkBoxRowIds, checkBoxAllRowIds, checkBoxPostOnClick);
    }

    protected String getEntryRowIds() {
        StringBundler sb = new StringBundler(9);
        sb.append("['");
        sb.append(this._liferayPortletResponse.getNamespace());
        sb.append("rowIds");
        sb.append(KBArticle.class.getSimpleName());
        sb.append("', '");
        sb.append(this._liferayPortletResponse.getNamespace());
        sb.append("rowIds");
        sb.append(KBFolder.class.getSimpleName());
        sb.append("']");
        return sb.toString();
    }
}

