/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.knowledge.base.web.internal.portlet;

import com.liferay.item.selector.ItemSelectorUploadResponseHandler;
import com.liferay.knowledge.base.constants.KBArticleConstants;
import com.liferay.knowledge.base.constants.KBFolderConstants;
import com.liferay.knowledge.base.exception.KBArticleImportException;
import com.liferay.knowledge.base.exception.KBTemplateContentException;
import com.liferay.knowledge.base.exception.KBTemplateTitleException;
import com.liferay.knowledge.base.exception.NoSuchArticleException;
import com.liferay.knowledge.base.exception.NoSuchCommentException;
import com.liferay.knowledge.base.exception.NoSuchFolderException;
import com.liferay.knowledge.base.exception.NoSuchTemplateException;
import com.liferay.knowledge.base.model.KBArticle;
import com.liferay.knowledge.base.model.KBFolder;
import com.liferay.knowledge.base.model.KBTemplate;
import com.liferay.knowledge.base.web.internal.portlet.BaseKBPortlet;
import com.liferay.knowledge.base.web.internal.upload.KBArticleAttachmentKBUploadFileEntryHandler;
import com.liferay.portal.kernel.exception.NoSuchSubscriptionException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Release;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.kernel.portlet.PortletURLFactoryUtil;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextFactory;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.servlet.SessionMessages;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.upload.UploadPortletRequest;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.upload.UploadFileEntryHandler;
import com.liferay.upload.UploadHandler;
import com.liferay.upload.UploadResponseHandler;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.Portlet;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.PortletResponse;
import javax.portlet.PortletSession;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import javax.portlet.WindowStateException;
import javax.servlet.http.HttpServletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"com.liferay.portlet.add-default-resource=true", "com.liferay.portlet.css-class-wrapper=knowledge-base-portlet knowledge-base-portlet-admin", "com.liferay.portlet.display-category=category.hidden", "com.liferay.portlet.header-portlet-css=/admin/css/common.css", "com.liferay.portlet.header-portlet-css=/admin/css/main.css", "com.liferay.portlet.icon=/icons/admin.png", "com.liferay.portlet.preferences-unique-per-layout=false", "com.liferay.portlet.scopeable=true", "com.liferay.portlet.show-portlet-access-denied=false", "javax.portlet.display-name=Knowledge Base", "javax.portlet.expiration-cache=0", "javax.portlet.init-param.always-send-redirect=true", "javax.portlet.init-param.copy-request-parameters=true", "javax.portlet.init-param.portlet-title-based-navigation=true", "javax.portlet.init-param.template-path=/admin/", "javax.portlet.init-param.view-template=/admin/view.jsp", "javax.portlet.name=com_liferay_knowledge_base_web_portlet_AdminPortlet", "javax.portlet.resource-bundle=content.Language", "javax.portlet.security-role-ref=administrator,guest,power-user,user", "javax.portlet.supported-public-render-parameter=categoryId", "javax.portlet.supported-public-render-parameter=tag", "javax.portlet.supports.mime-type=text/html"}, service={Portlet.class})
public class AdminPortlet
extends BaseKBPortlet {
    @Reference
    private ItemSelectorUploadResponseHandler _itemSelectorUploadResponseHandler;
    @Reference
    private KBArticleAttachmentKBUploadFileEntryHandler _kbArticleAttachmentKBUploadFileEntryHandler;
    @Reference
    private Portal _portal;
    @Reference
    private UploadHandler _uploadHandler;

    public void deleteKBArticles(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        long[] resourcePrimKeys = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"resourcePrimKeys"), (long)0L);
        this.kbArticleService.deleteKBArticles(themeDisplay.getScopeGroupId(), resourcePrimKeys);
    }

    public void deleteKBArticlesAndFolders(ActionRequest actionRequest, ActionResponse actionResponse) throws PortalException {
        long[] deleteKBFolderIds;
        long[] deleteKBArticleResourcePrimKeys;
        for (long deleteKBArticleResourcePrimKey : deleteKBArticleResourcePrimKeys = ParamUtil.getLongValues((PortletRequest)actionRequest, (String)"rowIdsKBArticle")) {
            this.kbArticleService.deleteKBArticle(deleteKBArticleResourcePrimKey);
        }
        for (long deleteKBFolderId : deleteKBFolderIds = ParamUtil.getLongValues((PortletRequest)actionRequest, (String)"rowIdsKBFolder")) {
            this.kbFolderService.deleteKBFolder(deleteKBFolderId);
        }
    }

    public void deleteKBFolder(ActionRequest actionRequest, ActionResponse actionResponse) throws PortalException {
        long kbFolderId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"kbFolderId");
        this.kbFolderService.deleteKBFolder(kbFolderId);
    }

    public void deleteKBTemplate(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        long kbTemplateId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"kbTemplateId");
        this.kbTemplateService.deleteKBTemplate(kbTemplateId);
    }

    public void deleteKBTemplates(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        long[] kbTemplateIds = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"kbTemplateIds"), (long)0L);
        this.kbTemplateService.deleteKBTemplates(themeDisplay.getScopeGroupId(), kbTemplateIds);
    }

    public void importFile(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        try {
            ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
            UploadPortletRequest uploadPortletRequest = this._portal.getUploadPortletRequest((PortletRequest)actionRequest);
            this.checkExceededSizeLimit((PortletRequest)actionRequest);
            long parentKBFolderId = ParamUtil.getLong((HttpServletRequest)uploadPortletRequest, (String)"parentKBFolderId", (long)0L);
            String fileName = uploadPortletRequest.getFileName("file");
            if (Validator.isNull((String)fileName)) {
                throw new KBArticleImportException("File name is null");
            }
            boolean prioritizeByNumericalPrefix = ParamUtil.getBoolean((HttpServletRequest)uploadPortletRequest, (String)"prioritizeByNumericalPrefix");
            try (InputStream inputStream = uploadPortletRequest.getFileAsStream("file");){
                ServiceContext serviceContext = ServiceContextFactory.getInstance((String)AdminPortlet.class.getName(), (PortletRequest)actionRequest);
                serviceContext.setGuestPermissions(new String[]{"VIEW"});
                int importedKBArticlesCount = this.kbArticleService.addKBArticlesMarkdown(themeDisplay.getScopeGroupId(), parentKBFolderId, fileName, prioritizeByNumericalPrefix, inputStream, serviceContext);
                SessionMessages.add((PortletRequest)actionRequest, (String)"importedKBArticlesCount", (Object)importedKBArticlesCount);
            }
        }
        catch (KBArticleImportException kbaie) {
            SessionErrors.add((PortletRequest)actionRequest, ((Object)((Object)kbaie)).getClass(), (Object)((Object)kbaie));
        }
    }

    @Override
    public void serveResource(ResourceRequest resourceRequest, ResourceResponse resourceResponse) throws IOException, PortletException {
        String resourceID = GetterUtil.getString((String)resourceRequest.getResourceID());
        HttpServletRequest request = this._portal.getHttpServletRequest((PortletRequest)resourceRequest);
        if (resourceID.equals("infoPanel")) {
            try {
                List<KBArticle> kbArticles = this.getKBArticles(request);
                resourceRequest.setAttribute("KNOWLEDGE_BASE_KB_ARTICLES", kbArticles);
                List<KBFolder> kbFolders = this.getKBFolders(request);
                resourceRequest.setAttribute("KNOWLEDGE_BASE_KB_FOLDERS", kbFolders);
                PortletSession portletSession = resourceRequest.getPortletSession();
                PortletContext portletContext = portletSession.getPortletContext();
                PortletRequestDispatcher portletRequestDispatcher = portletContext.getRequestDispatcher("/admin/info_panel.jsp");
                portletRequestDispatcher.include((PortletRequest)resourceRequest, (PortletResponse)resourceResponse);
            }
            catch (Exception e) {
                throw new PortletException((Throwable)e);
            }
        } else {
            super.serveResource(resourceRequest, resourceResponse);
        }
    }

    public void subscribeGroupKBArticles(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        String portletId = this._portal.getPortletId((PortletRequest)actionRequest);
        this.kbArticleService.subscribeGroupKBArticles(themeDisplay.getScopeGroupId(), portletId);
    }

    public void unsubscribeGroupKBArticles(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        String portletId = this._portal.getPortletId((PortletRequest)actionRequest);
        this.kbArticleService.unsubscribeGroupKBArticles(themeDisplay.getScopeGroupId(), portletId);
    }

    public void updateKBArticlesPriorities(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        Enumeration enu = actionRequest.getParameterNames();
        HashMap<Long, Double> resourcePrimKeyToPriorityMap = new HashMap<Long, Double>();
        while (enu.hasMoreElements()) {
            String name = (String)enu.nextElement();
            if (!name.startsWith("priority")) continue;
            double priority = ParamUtil.getDouble((PortletRequest)actionRequest, (String)name);
            long resourcePrimKey = GetterUtil.getLong((String)name.substring(8));
            resourcePrimKeyToPriorityMap.put(resourcePrimKey, priority);
        }
        this.kbArticleService.updateKBArticlesPriorities(themeDisplay.getScopeGroupId(), resourcePrimKeyToPriorityMap);
    }

    public void updateKBFolder(ActionRequest actionRequest, ActionResponse actionResponse) throws PortalException {
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        long parentResourceClassNameId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"parentResourceClassNameId");
        long parentResourcePrimKey = ParamUtil.getLong((PortletRequest)actionRequest, (String)"parentResourcePrimKey");
        String name = ParamUtil.getString((PortletRequest)actionRequest, (String)"name");
        String description = ParamUtil.getString((PortletRequest)actionRequest, (String)"description");
        ServiceContext serviceContext = ServiceContextFactory.getInstance((String)KBFolder.class.getName(), (PortletRequest)actionRequest);
        if (cmd.equals("add")) {
            ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
            this.kbFolderService.addKBFolder(themeDisplay.getScopeGroupId(), parentResourceClassNameId, parentResourcePrimKey, name, description, serviceContext);
        } else if (cmd.equals("update")) {
            long kbFolderId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"kbFolderId");
            this.kbFolderService.updateKBFolder(parentResourceClassNameId, parentResourcePrimKey, kbFolderId, name, description, serviceContext);
        }
    }

    public void updateKBTemplate(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        String title = ParamUtil.getString((PortletRequest)actionRequest, (String)"title");
        String content = ParamUtil.getString((PortletRequest)actionRequest, (String)"content");
        ServiceContext serviceContext = ServiceContextFactory.getInstance((String)KBTemplate.class.getName(), (PortletRequest)actionRequest);
        if (cmd.equals("add")) {
            String portletId = this._portal.getPortletId((PortletRequest)actionRequest);
            this.kbTemplateService.addKBTemplate(portletId, title, content, serviceContext);
        } else if (cmd.equals("update")) {
            long kbTemplateId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"kbTemplateId");
            this.kbTemplateService.updateKBTemplate(kbTemplateId, title, content, serviceContext);
        }
    }

    public void uploadKBArticleAttachments(ActionRequest actionRequest, ActionResponse actionResponse) throws PortalException {
        this._uploadHandler.upload((UploadFileEntryHandler)this._kbArticleAttachmentKBUploadFileEntryHandler, (UploadResponseHandler)this._itemSelectorUploadResponseHandler, (PortletRequest)actionRequest, (PortletResponse)actionResponse);
    }

    @Override
    protected String buildEditURL(ActionRequest actionRequest, ActionResponse actionResponse, KBArticle kbArticle) throws PortalException {
        try {
            LiferayPortletURL portletURL = PortletURLFactoryUtil.create((PortletRequest)actionRequest, (String)"com_liferay_knowledge_base_web_portlet_AdminPortlet", (String)"RENDER_PHASE");
            portletURL.setParameter("mvcPath", this.templatePath + "edit_article.jsp");
            portletURL.setParameter("redirect", this.getRedirect(actionRequest, actionResponse));
            portletURL.setParameter("resourcePrimKey", String.valueOf(kbArticle.getResourcePrimKey()));
            portletURL.setWindowState(actionRequest.getWindowState());
            return portletURL.toString();
        }
        catch (WindowStateException wse) {
            throw new PortalException((Throwable)wse);
        }
    }

    protected void doDispatch(RenderRequest renderRequest, RenderResponse renderResponse) throws IOException, PortletException {
        if (SessionErrors.contains((PortletRequest)renderRequest, (String)NoSuchArticleException.class.getName()) || SessionErrors.contains((PortletRequest)renderRequest, (String)NoSuchCommentException.class.getName()) || SessionErrors.contains((PortletRequest)renderRequest, (String)NoSuchSubscriptionException.class.getName()) || SessionErrors.contains((PortletRequest)renderRequest, (String)NoSuchTemplateException.class.getName()) || SessionErrors.contains((PortletRequest)renderRequest, (Class[])PrincipalException.getNestedClasses())) {
            this.include(this.templatePath + "error.jsp", renderRequest, renderResponse);
        } else {
            super.doDispatch(renderRequest, renderResponse);
        }
    }

    @Override
    protected void doRender(RenderRequest renderRequest, RenderResponse renderResponse) throws IOException, PortletException {
        try {
            renderRequest.setAttribute("DL_MIME_TYPE_DISPLAY_CONTEXT", (Object)this.dlMimeTypeDisplayContext);
            KBArticle kbArticle = null;
            long kbArticleClassNameId = this._portal.getClassNameId(KBArticleConstants.getClassName());
            long resourceClassNameId = ParamUtil.getLong((PortletRequest)renderRequest, (String)"resourceClassNameId", (long)kbArticleClassNameId);
            long resourcePrimKey = ParamUtil.getLong((PortletRequest)renderRequest, (String)"resourcePrimKey");
            int status = -1;
            if (resourcePrimKey > 0L && resourceClassNameId == kbArticleClassNameId) {
                kbArticle = this.kbArticleService.getLatestKBArticle(resourcePrimKey, status);
            }
            renderRequest.setAttribute("KNOWLEDGE_BASE_KB_ARTICLE", kbArticle);
            KBArticle parentKBArticle = null;
            KBFolder parentKBFolder = null;
            long kbFolderClassNameId = this._portal.getClassNameId(KBFolderConstants.getClassName());
            long parentResourceClassNameId = ParamUtil.getLong((PortletRequest)renderRequest, (String)"parentResourceClassNameId", (long)kbFolderClassNameId);
            long parentResourcePrimKey = ParamUtil.getLong((PortletRequest)renderRequest, (String)"parentResourcePrimKey");
            if (parentResourcePrimKey > 0L) {
                if (parentResourceClassNameId == kbFolderClassNameId) {
                    parentKBFolder = this.kbFolderService.getKBFolder(parentResourcePrimKey);
                } else {
                    parentKBArticle = this.kbArticleService.getLatestKBArticle(parentResourcePrimKey, status);
                }
            }
            renderRequest.setAttribute("KNOWLEDGE_BASE_PARENT_KB_ARTICLE", parentKBArticle);
            renderRequest.setAttribute("KNOWLEDGE_BASE_PARENT_KB_FOLDER", parentKBFolder);
            KBTemplate kbTemplate = null;
            long kbTemplateId = ParamUtil.getLong((PortletRequest)renderRequest, (String)"kbTemplateId");
            if (kbTemplateId > 0L) {
                kbTemplate = this.kbTemplateService.getKBTemplate(kbTemplateId);
            }
            renderRequest.setAttribute("KNOWLEDGE_BASE_KB_TEMPLATE", kbTemplate);
            renderRequest.setAttribute("KNOWLEDGE_BASE_STATUS", (Object)status);
        }
        catch (Exception e) {
            if (e instanceof NoSuchArticleException || e instanceof NoSuchFolderException || e instanceof NoSuchTemplateException || e instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)renderRequest, e.getClass());
            }
            throw new PortletException((Throwable)e);
        }
    }

    protected List<KBArticle> getKBArticles(HttpServletRequest request) throws Exception {
        long[] kbArticleResourcePrimKeys = ParamUtil.getLongValues((HttpServletRequest)request, (String)"rowIdsKBArticle");
        ArrayList<KBArticle> kbArticles = new ArrayList<KBArticle>();
        for (long kbArticleResourcePrimKey : kbArticleResourcePrimKeys) {
            KBArticle kbArticle = this.kbArticleService.getLatestKBArticle(kbArticleResourcePrimKey, -1);
            kbArticles.add(kbArticle);
        }
        return kbArticles;
    }

    protected List<KBFolder> getKBFolders(HttpServletRequest request) throws Exception {
        long[] kbFolderIds = ParamUtil.getLongValues((HttpServletRequest)request, (String)"rowIdsKBFolder");
        ArrayList<KBFolder> kbFolders = new ArrayList<KBFolder>();
        for (long kbFolderId : kbFolderIds) {
            KBFolder kbFolder = this.kbFolderService.getKBFolder(kbFolderId);
            kbFolders.add(kbFolder);
        }
        return kbFolders;
    }

    @Override
    protected boolean isSessionErrorException(Throwable cause) {
        return cause instanceof KBArticleImportException || cause instanceof KBTemplateContentException || cause instanceof KBTemplateTitleException || cause instanceof NoSuchTemplateException || super.isSessionErrorException(cause);
    }

    @Reference(target="(&(release.bundle.symbolic.name=com.liferay.knowledge.base.web)(release.schema.version=1.2.0))", unbind="-")
    protected void setRelease(Release release) {
    }
}

