/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.knowledge.base.internal.search.spi.model.index.contributor;

import com.liferay.knowledge.base.model.KBArticle;
import com.liferay.knowledge.base.model.KBFolder;
import com.liferay.knowledge.base.service.KBFolderLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.util.HtmlParser;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.search.spi.model.index.contributor.ModelDocumentContributor;
import java.util.ArrayList;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"indexer.class.name=com.liferay.knowledge.base.model.KBArticle"}, service={ModelDocumentContributor.class})
public class KBArticleModelDocumentContributor
implements ModelDocumentContributor<KBArticle> {
    @Reference
    protected KBFolderLocalService kbFolderLocalService;
    private static final Log _log = LogFactoryUtil.getLog(KBArticleModelDocumentContributor.class);
    @Reference
    private HtmlParser _htmlParser;

    public void contribute(Document document, KBArticle kbArticle) {
        block2: {
            document.addText("content", this._htmlParser.extractText(kbArticle.getContent()));
            document.addText("description", kbArticle.getDescription());
            document.addKeyword("folderId", kbArticle.getKbFolderId());
            document.addText("title", kbArticle.getTitle());
            try {
                document.addKeyword("treePath", StringUtil.split((String)kbArticle.buildTreePath(), (char)'/'));
                document.addKeyword("folderNames", this._getKBFolderNames(kbArticle));
            }
            catch (PortalException portalException) {
                if (!_log.isDebugEnabled()) break block2;
                _log.debug((Throwable)portalException);
            }
        }
        document.addKeyword("parentMessageId", kbArticle.getParentResourcePrimKey());
        document.addKeyword("titleKeyword", kbArticle.getTitle(), true);
        document.addKeywordSortable("urlTitle", kbArticle.getUrlTitle());
    }

    private String[] _getKBFolderNames(KBArticle kbArticle) throws PortalException {
        long kbFolderId = kbArticle.getKbFolderId();
        ArrayList<String> kbFolderNames = new ArrayList<String>();
        while (kbFolderId != 0L) {
            KBFolder kbFolder = this.kbFolderLocalService.getKBFolder(kbFolderId);
            kbFolderNames.add(kbFolder.getName());
            kbFolderId = kbFolder.getParentKBFolderId();
        }
        return kbFolderNames.toArray(new String[0]);
    }
}

