/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.knowledge.base.service.impl;

import com.liferay.knowledge.base.constants.KBArticleConstants;
import com.liferay.knowledge.base.model.KBArticle;
import com.liferay.knowledge.base.model.KBComment;
import com.liferay.knowledge.base.service.base.KBCommentServiceBaseImpl;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermissionFactory;
import com.liferay.portal.kernel.security.permission.resource.PortletResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.PortletResourcePermissionFactory;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.util.Collections;
import java.util.List;

public class KBCommentServiceImpl
extends KBCommentServiceBaseImpl {
    private static volatile ModelResourcePermission<KBArticle> _kbArticleModelResourcePermission = ModelResourcePermissionFactory.getInstance(KBCommentServiceImpl.class, (String)"_kbArticleModelResourcePermission", KBArticle.class);
    private static volatile ModelResourcePermission<KBComment> _kbCommentModelResourcePermission = ModelResourcePermissionFactory.getInstance(KBCommentServiceImpl.class, (String)"_kbCommentModelResourcePermission", KBComment.class);
    private static volatile PortletResourcePermission _portletResourcePermission = PortletResourcePermissionFactory.getInstance(KBCommentServiceImpl.class, (String)"_portletResourcePermission", (String)"com.liferay.knowledge.base.admin");

    public KBComment deleteKBComment(KBComment kbComment) throws PortalException {
        _kbCommentModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)kbComment, "DELETE");
        return this.kbCommentLocalService.deleteKBComment(kbComment);
    }

    public KBComment deleteKBComment(long kbCommentId) throws PortalException {
        KBComment kbComment = this.kbCommentPersistence.findByPrimaryKey(kbCommentId);
        return this.deleteKBComment(kbComment);
    }

    public KBComment getKBComment(long kbCommentId) throws PortalException {
        _kbCommentModelResourcePermission.check(this.getPermissionChecker(), kbCommentId, "VIEW");
        return this.kbCommentLocalService.getKBComment(kbCommentId);
    }

    public List<KBComment> getKBComments(long groupId, int status, int start, int end) throws PortalException {
        if (_portletResourcePermission.contains(this.getPermissionChecker(), groupId, "VIEW_SUGGESTIONS")) {
            return this.kbCommentLocalService.getKBComments(groupId, status, start, end);
        }
        return Collections.emptyList();
    }

    public List<KBComment> getKBComments(long groupId, int status, int start, int end, OrderByComparator<KBComment> obc) throws PortalException {
        if (_portletResourcePermission.contains(this.getPermissionChecker(), groupId, "VIEW_SUGGESTIONS")) {
            return this.kbCommentLocalService.getKBComments(groupId, status, start, end, obc);
        }
        return Collections.emptyList();
    }

    public List<KBComment> getKBComments(long groupId, int start, int end, OrderByComparator<KBComment> obc) throws PortalException {
        if (_portletResourcePermission.contains(this.getPermissionChecker(), groupId, "VIEW_SUGGESTIONS")) {
            return this.kbCommentLocalService.getKBComments(groupId, start, end, obc);
        }
        return Collections.emptyList();
    }

    public List<KBComment> getKBComments(long groupId, String className, long classPK, int status, int start, int end) throws PortalException {
        if (this._containsViewSuggestionPermission(this.getPermissionChecker(), groupId, className, classPK)) {
            return this.kbCommentLocalService.getKBComments(className, classPK, status, start, end);
        }
        return Collections.emptyList();
    }

    public List<KBComment> getKBComments(long groupId, String className, long classPK, int status, int start, int end, OrderByComparator<KBComment> obc) throws PortalException {
        if (this._containsViewSuggestionPermission(this.getPermissionChecker(), groupId, className, classPK)) {
            return this.kbCommentLocalService.getKBComments(className, classPK, status, start, end, obc);
        }
        return Collections.emptyList();
    }

    public List<KBComment> getKBComments(long groupId, String className, long classPK, int start, int end, OrderByComparator<KBComment> obc) throws PortalException {
        if (this._containsViewSuggestionPermission(this.getPermissionChecker(), groupId, className, classPK)) {
            return this.kbCommentLocalService.getKBComments(className, classPK, start, end, obc);
        }
        return Collections.emptyList();
    }

    public int getKBCommentsCount(long groupId) throws PortalException {
        if (_portletResourcePermission.contains(this.getPermissionChecker(), groupId, "VIEW_SUGGESTIONS")) {
            return this.kbCommentPersistence.countByGroupId(groupId);
        }
        return 0;
    }

    public int getKBCommentsCount(long groupId, int status) throws PortalException {
        if (_portletResourcePermission.contains(this.getPermissionChecker(), groupId, "VIEW_SUGGESTIONS")) {
            return this.kbCommentLocalService.getKBCommentsCount(groupId, status);
        }
        return 0;
    }

    public int getKBCommentsCount(long groupId, String className, long classPK) throws PortalException {
        if (this._containsViewSuggestionPermission(this.getPermissionChecker(), groupId, className, classPK)) {
            return this.kbCommentLocalService.getKBCommentsCount(className, classPK);
        }
        return 0;
    }

    public int getKBCommentsCount(long groupId, String className, long classPK, int status) throws PortalException {
        if (this._containsViewSuggestionPermission(this.getPermissionChecker(), groupId, className, classPK)) {
            return this.kbCommentLocalService.getKBCommentsCount(className, classPK, status);
        }
        return 0;
    }

    public KBComment updateKBComment(long kbCommentId, long classNameId, long classPK, String content, int status, ServiceContext serviceContext) throws PortalException {
        _kbCommentModelResourcePermission.check(this.getPermissionChecker(), kbCommentId, "UPDATE");
        return this.kbCommentLocalService.updateKBComment(kbCommentId, classNameId, classPK, content, status, serviceContext);
    }

    public KBComment updateKBComment(long kbCommentId, long classNameId, long classPK, String content, ServiceContext serviceContext) throws PortalException {
        KBComment kbComment = this.kbCommentPersistence.findByPrimaryKey(kbCommentId);
        return this.updateKBComment(kbCommentId, classNameId, classPK, content, kbComment.getStatus(), serviceContext);
    }

    public KBComment updateStatus(long kbCommentId, int status, ServiceContext serviceContext) throws PortalException {
        _kbCommentModelResourcePermission.check(this.getPermissionChecker(), kbCommentId, "UPDATE");
        return this.kbCommentLocalService.updateStatus(this.getUserId(), kbCommentId, status, serviceContext);
    }

    private boolean _containsViewSuggestionPermission(PermissionChecker permissionChecker, long groupId, String className, long classPK) throws PortalException {
        if (!className.equals(KBArticleConstants.getClassName())) {
            throw new IllegalArgumentException("Only KB articles support suggestions");
        }
        KBArticle kbArticle = this.kbArticleLocalService.fetchKBArticle(classPK);
        kbArticle = kbArticle != null ? this.kbArticleLocalService.getLatestKBArticle(kbArticle.getResourcePrimKey(), -1) : this.kbArticleLocalService.getLatestKBArticle(classPK, -1);
        return _portletResourcePermission.contains(permissionChecker, groupId, "VIEW_SUGGESTIONS") || _kbArticleModelResourcePermission.contains(permissionChecker, (ClassedModel)kbArticle, "UPDATE");
    }
}

