/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.knowledge.base.internal.importer.util;

import com.liferay.document.library.kernel.util.DLUtil;
import com.liferay.knowledge.base.exception.KBArticleImportException;
import com.liferay.knowledge.base.internal.importer.util.KBArticleImporterUtil;
import com.liferay.knowledge.base.internal.importer.util.MarkdownConverterFactoryUtil;
import com.liferay.knowledge.base.markdown.converter.MarkdownConverter;
import com.liferay.knowledge.base.model.KBArticle;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.ModelHintsUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.zip.ZipReader;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;

public class KBArticleMarkdownConverter {
    private static final String _METADATA_BASE_SOURCE_URL = "base.source.url";
    private static final Log _log = LogFactoryUtil.getLog(KBArticleMarkdownConverter.class);
    private final String _html;
    private final String _sourceURL;
    private final String _title;
    private final String _urlTitle;

    public KBArticleMarkdownConverter(String markdown, String fileEntryName, Map<String, String> metadata) throws KBArticleImportException {
        MarkdownConverter markdownConverter = MarkdownConverterFactoryUtil.create();
        String html = null;
        try {
            html = markdownConverter.convert(markdown);
        }
        catch (IOException ioe) {
            throw new KBArticleImportException("Unable to convert Markdown to HTML: " + ioe.getLocalizedMessage(), (Throwable)ioe);
        }
        String heading = this.getHeading(html);
        if (Validator.isNull((String)heading)) {
            throw new KBArticleImportException("Unable to extract title heading from file: " + fileEntryName);
        }
        this._urlTitle = this.getUrlTitle(heading);
        if (Validator.isNull((String)this._urlTitle)) {
            throw new KBArticleImportException("Missing title heading ID in file: " + fileEntryName);
        }
        String title = HtmlUtil.unescape((String)heading);
        int x = title.indexOf("[](id=");
        if (x != -1) {
            title = title.substring(0, x);
        }
        this._title = title;
        html = this.stripIds(html);
        this._html = this.stripHeading(html);
        String baseSourceURL = metadata.get(_METADATA_BASE_SOURCE_URL);
        this._sourceURL = this.buildSourceURL(baseSourceURL, fileEntryName);
    }

    public String getSourceURL() {
        return this._sourceURL;
    }

    public String getTitle() {
        return this._title;
    }

    public String getUrlTitle() {
        return this._urlTitle;
    }

    public String processAttachmentsReferences(long userId, KBArticle kbArticle, ZipReader zipReader, Map<String, FileEntry> fileEntriesMap) throws PortalException {
        int curIndex;
        TreeSet<Integer> indexes = new TreeSet<Integer>();
        int index = 0;
        while ((index = this._html.indexOf("<img", index)) > -1) {
            indexes.add(index);
            index += 4;
        }
        if (indexes.isEmpty()) {
            return this._html;
        }
        StringBundler sb = new StringBundler();
        int previousIndex = 0;
        Iterator iterator = indexes.iterator();
        while (iterator.hasNext() && (curIndex = ((Integer)iterator.next()).intValue()) >= 0) {
            int pos;
            if (curIndex > previousIndex) {
                String text = this._html.substring(previousIndex, curIndex);
                sb.append(text);
            }
            if ((pos = this._html.indexOf(">", curIndex)) < 0) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Expected close tag for image " + this._html.substring(curIndex)));
                }
                sb.append(this._html.substring(curIndex));
                previousIndex = curIndex;
                break;
            }
            String text = this._html.substring(curIndex, pos);
            String imageFileName = KBArticleImporterUtil.extractImageFileName(text);
            FileEntry imageFileEntry = KBArticleImporterUtil.addImageFileEntry(imageFileName, userId, kbArticle, zipReader, fileEntriesMap);
            if (imageFileEntry == null) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)("Unable to find image source " + text));
                }
                sb.append("<img alt=\"missing image\" src=\"\" ");
            } else {
                String imageSrc;
                block12: {
                    imageSrc = "";
                    try {
                        imageSrc = DLUtil.getPreviewURL((FileEntry)imageFileEntry, (FileVersion)imageFileEntry.getFileVersion(), null, (String)"");
                    }
                    catch (PortalException pe) {
                        if (!_log.isWarnEnabled()) break block12;
                        _log.warn((Object)("Unable to obtain image URL from file entry " + imageFileEntry.getFileEntryId()), (Throwable)pe);
                    }
                }
                sb.append("<img alt=\"");
                sb.append(HtmlUtil.escapeAttribute((String)imageFileEntry.getTitle()));
                sb.append("\" src=\"");
                sb.append(imageSrc);
                sb.append("\" ");
            }
            previousIndex = pos;
        }
        if (previousIndex < this._html.length()) {
            sb.append(this._html.substring(previousIndex));
        }
        return sb.toString();
    }

    protected String buildSourceURL(String baseSourceURL, String fileEntryName) {
        char c;
        int pos;
        if (!Validator.isUrl((String)baseSourceURL)) {
            return null;
        }
        for (pos = baseSourceURL.length() - 1; pos >= 0 && (c = baseSourceURL.charAt(pos)) == '/'; --pos) {
        }
        StringBundler sb = new StringBundler(3);
        sb.append(baseSourceURL.substring(0, pos + 1));
        if (!fileEntryName.startsWith("/")) {
            sb.append("/");
        }
        sb.append(FileUtil.replaceSeparator((String)fileEntryName));
        return sb.toString();
    }

    protected String getHeading(String html) {
        int x = html.indexOf("<h1>");
        int y = html.indexOf("</h1>");
        if (x == -1 || y == -1 || x > y) {
            return null;
        }
        return html.substring(x + 4, y);
    }

    protected String getUrlTitle(String heading) {
        String urlTitle = null;
        int x = heading.indexOf("[](id=");
        if (x == -1) {
            return null;
        }
        int y = heading.indexOf(")", x);
        if (y > x + 1) {
            int equalsSign = heading.indexOf("=", x);
            urlTitle = heading.substring(equalsSign + 1, y);
            urlTitle = StringUtil.replace((String)urlTitle, (char)' ', (char)'-');
            urlTitle = StringUtil.toLowerCase((String)urlTitle);
        }
        if (urlTitle == null) {
            return null;
        }
        if (!urlTitle.startsWith("/")) {
            urlTitle = "/" + urlTitle;
        }
        int urlTitleMaxLength = ModelHintsUtil.getMaxLength((String)KBArticle.class.getName(), (String)"urlTitle");
        while (urlTitle.length() > urlTitleMaxLength) {
            int pos = urlTitle.lastIndexOf("-");
            if (pos == -1) {
                urlTitle = urlTitle.substring(0, urlTitleMaxLength);
                continue;
            }
            urlTitle = urlTitle.substring(0, pos);
        }
        return urlTitle;
    }

    protected String stripHeading(String html) {
        int index = html.indexOf("</h1>");
        if (index == -1) {
            return html;
        }
        return html.substring(index + 5);
    }

    protected String stripIds(String content) {
        int index = content.indexOf("[](id=");
        if (index == -1) {
            return content;
        }
        StringBundler sb = new StringBundler();
        do {
            int x;
            int y;
            if ((y = content.indexOf(")", x = content.indexOf("=", index))) != -1) {
                int z = content.indexOf("</h", y);
                if (z != y + 1) {
                    sb.append(content.substring(0, y + 1));
                } else {
                    sb.append(StringUtil.trimTrailing((String)content.substring(0, index)));
                }
            } else {
                if (!_log.isWarnEnabled()) break;
                String msg = content.substring(index);
                int spaceIndex = content.indexOf(" ");
                if (spaceIndex != -1) {
                    msg = content.substring(index, spaceIndex);
                }
                _log.warn((Object)("Missing ')' for web content containing header id " + msg));
                break;
            }
            content = content.substring(y + 1);
        } while ((index = content.indexOf("[](id=")) != -1);
        sb.append(content);
        return sb.toString();
    }
}

