/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.knowledge.base.internal.events;

import com.liferay.portal.kernel.events.Action;
import com.liferay.portal.kernel.events.LifecycleAction;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.security.auth.AuthTokenUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Http;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.Validator;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"key=servlet.service.events.pre"}, service={LifecycleAction.class})
public class KBServicePreAction
extends Action {
    private static final boolean _PORTLET_ADD_DEFAULT_RESOURCE_CHECK_ENABLED = GetterUtil.getBoolean((String)PropsUtil.get((String)"portlet.add.default.resource.check.enabled"));
    private static final Log _log = LogFactoryUtil.getLog(KBServicePreAction.class);
    @Reference
    private Http _http;
    @Reference
    private Portal _portal;

    public void run(HttpServletRequest request, HttpServletResponse response) {
        try {
            this.doRun(request, response);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
    }

    protected void doRun(HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (!_PORTLET_ADD_DEFAULT_RESOURCE_CHECK_ENABLED) {
            return;
        }
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        if (!themeDisplay.isLifecycleRender()) {
            return;
        }
        String portletId = ParamUtil.getString((HttpServletRequest)request, (String)"p_p_id");
        if (Validator.isNull((String)portletId)) {
            return;
        }
        if (!portletId.equals("com_liferay_knowledge_base_web_portlet_ArticlePortlet_INSTANCE_0000")) {
            return;
        }
        String request_p_p_auth = ParamUtil.getString((HttpServletRequest)request, (String)"p_p_auth");
        if (Validator.isNull((String)request_p_p_auth)) {
            return;
        }
        String actual_p_p_auth = AuthTokenUtil.getToken((HttpServletRequest)request, (long)themeDisplay.getPlid(), (String)portletId);
        if (request_p_p_auth.equals(actual_p_p_auth)) {
            return;
        }
        String redirect = this._portal.escapeRedirect(themeDisplay.getURLCurrent());
        if (Validator.isNull((String)redirect)) {
            return;
        }
        redirect = this._http.setParameter(redirect, "p_p_auth", actual_p_p_auth);
        response.sendRedirect(redirect);
    }
}

