/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.knowledge.base.util.comparator;

import com.liferay.knowledge.base.model.KBArticle;
import com.liferay.knowledge.base.model.KBFolder;
import com.liferay.portal.kernel.util.OrderByComparator;

public class KBObjectsViewCountComparator<T>
extends OrderByComparator<T> {
    public static final String ORDER_BY_ASC = "modelFolder DESC, viewCount ASC, title ASC";
    public static final String ORDER_BY_DESC = "modelFolder DESC, viewCount DESC, title ASC";
    public static final String[] ORDER_BY_FIELDS = new String[]{"viewCount", "title"};
    private final boolean _ascending;

    public KBObjectsViewCountComparator() {
        this(false);
    }

    public KBObjectsViewCountComparator(boolean ascending) {
        this._ascending = ascending;
    }

    public int compare(T t1, T t2) {
        int value = 0;
        double viewCount1 = this.getViewCount(t1);
        double viewCount2 = this.getViewCount(t2);
        String title1 = this.getName(t1);
        String title2 = this.getName(t1);
        value = t1 instanceof KBFolder && t2 instanceof KBFolder ? title1.compareToIgnoreCase(title2) : (t1 instanceof KBFolder ? -1 : (t2 instanceof KBFolder ? 1 : (viewCount1 < viewCount2 ? -1 : (viewCount1 > viewCount2 ? 1 : title1.compareToIgnoreCase(title2)))));
        if (this._ascending) {
            return value;
        }
        return -value;
    }

    public String getOrderBy() {
        if (this._ascending) {
            return ORDER_BY_ASC;
        }
        return ORDER_BY_DESC;
    }

    public String[] getOrderByFields() {
        return ORDER_BY_FIELDS;
    }

    public boolean isAscending() {
        return this._ascending;
    }

    protected String getName(Object object) {
        if (object instanceof KBArticle) {
            KBArticle kbArticle = (KBArticle)object;
            return kbArticle.getTitle();
        }
        KBFolder kbFolder = (KBFolder)object;
        return kbFolder.getName();
    }

    protected long getViewCount(Object object) {
        if (object instanceof KBArticle) {
            KBArticle kbArticle = (KBArticle)object;
            return kbArticle.getViewCount();
        }
        return 0L;
    }
}

