/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.item.selector.internal.provider;

import com.liferay.item.selector.provider.GroupItemSelectorProvider;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.security.auth.GuestOrUserUtil;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.GroupService;
import com.liferay.portal.kernel.service.permission.GroupPermission;
import com.liferay.portal.kernel.util.LinkedHashMapBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={GroupItemSelectorProvider.class})
public class GroupItemSelectorProviderImpl
implements GroupItemSelectorProvider {
    private static final Log _log = LogFactoryUtil.getLog(GroupItemSelectorProviderImpl.class);
    private long[] _classNameIds;
    @Reference
    private ClassNameLocalService _classNameLocalService;
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private GroupPermission _groupPermission;
    @Reference
    private GroupService _groupService;
    @Reference
    private Language _language;

    @Deprecated
    public String getEmptyResultsMessage() {
        return "no-sites-were-found";
    }

    public String getEmptyResultsMessage(Locale locale) {
        return this._language.get(locale, "no-sites-were-found");
    }

    public List<Group> getGroups(long companyId, long groupId, String keywords, int start, int end) {
        LinkedHashMap groupParams = LinkedHashMapBuilder.put((Object)"site", (Object)Boolean.TRUE).build();
        try {
            return this._filterGroups(this._groupLocalService.search(companyId, this._classNameIds, keywords, groupParams, start, end, null));
        }
        catch (PortalException portalException) {
            _log.error((Throwable)portalException);
            return Collections.emptyList();
        }
    }

    public int getGroupsCount(long companyId, long groupId, String keywords) {
        return this._groupService.searchCount(companyId, this._classNameIds, keywords, LinkedHashMapBuilder.put((Object)"actionId", (Object)"VIEW").put((Object)"site", (Object)Boolean.TRUE).build());
    }

    public String getGroupType() {
        return "site";
    }

    public String getIcon() {
        return "sites";
    }

    public String getLabel(Locale locale) {
        return this._language.get(locale, "site");
    }

    @Activate
    protected void activate() {
        this._classNameIds = new long[]{this._classNameLocalService.getClassNameId(Company.class), this._classNameLocalService.getClassNameId(Group.class), this._classNameLocalService.getClassNameId(Organization.class)};
    }

    private List<Group> _filterGroups(List<Group> groups) throws PortalException {
        ArrayList<Group> filteredGroups = new ArrayList<Group>();
        PermissionChecker permissionChecker = GuestOrUserUtil.getPermissionChecker();
        for (Group group : groups) {
            if (!group.isCompany() && !permissionChecker.isGroupAdmin(group.getGroupId()) && !this._groupPermission.contains(permissionChecker, group, "VIEW")) continue;
            filteredGroups.add(group);
        }
        return filteredGroups;
    }
}

