/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ip.geocoder.internal;

import com.liferay.ip.geocoder.IPGeocoder;
import com.liferay.ip.geocoder.IPInfo;
import com.liferay.ip.geocoder.internal.configuration.IPGeocoderConfiguration;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.Validator;
import com.maxmind.db.CHMCache;
import com.maxmind.db.NodeCache;
import com.maxmind.geoip2.DatabaseReader;
import com.maxmind.geoip2.exception.AddressNotFoundException;
import com.maxmind.geoip2.model.CountryResponse;
import com.maxmind.geoip2.record.Country;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.ip.geocoder.internal.configuration.IPGeocoderConfiguration"}, configurationPolicy=ConfigurationPolicy.OPTIONAL, name="IPGeocoder", service={IPGeocoder.class})
public class IPGeocoderImpl
implements IPGeocoder {
    private static final Log _log = LogFactoryUtil.getLog(IPGeocoderImpl.class);
    private volatile DatabaseReader _databaseReader;
    @Reference
    private Portal _portal;
    private volatile Map<String, String> _properties;

    public IPInfo getIPInfo(HttpServletRequest httpServletRequest) {
        String ipAddress = this._getIPAddress(httpServletRequest);
        return new IPInfo(this._getCountryCode(ipAddress), ipAddress);
    }

    @Modified
    public void modified(Map<String, String> properties) {
        this._databaseReader = null;
        this._properties = properties;
    }

    @Activate
    protected void activate(Map<String, String> properties) {
        this._properties = properties;
    }

    @Deactivate
    protected void deactivate(Map<String, String> properties) {
        this._databaseReader = null;
        this._properties = null;
    }

    private String _getCountryCode(String ipAddress) {
        block6: {
            try {
                InetAddress inetAddress = InetAddress.getByName(ipAddress);
                if (inetAddress.isAnyLocalAddress() || inetAddress.isLoopbackAddress()) {
                    return null;
                }
                DatabaseReader databaseReader = this._getDatabaseReader();
                CountryResponse countryResponse = databaseReader.country(inetAddress);
                if (countryResponse == null) {
                    return null;
                }
                Country country = countryResponse.getCountry();
                return country.getIsoCode();
            }
            catch (AddressNotFoundException addressNotFoundException) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Throwable)addressNotFoundException);
                }
            }
            catch (Exception exception) {
                if (!_log.isWarnEnabled()) break block6;
                _log.warn((Throwable)exception);
            }
        }
        return null;
    }

    private DatabaseReader _getDatabaseReader() {
        DatabaseReader databaseReader = this._databaseReader;
        if (databaseReader != null) {
            return databaseReader;
        }
        IPGeocoderImpl iPGeocoderImpl = this;
        synchronized (iPGeocoderImpl) {
            if (databaseReader != null) {
                return databaseReader;
            }
            try {
                this._databaseReader = databaseReader = new DatabaseReader.Builder(this._getFile()).withCache((NodeCache)new CHMCache()).build();
                return databaseReader;
            }
            catch (IOException ioException) {
                _log.error((Object)"Unable to activate IP Geocoder", (Throwable)ioException);
                throw new RuntimeException("Unable to activate IP Geocoder", ioException);
            }
        }
    }

    private File _getFile() throws IOException {
        File file;
        IPGeocoderConfiguration igGeocoderConfiguration = (IPGeocoderConfiguration)ConfigurableUtil.createConfigurable(IPGeocoderConfiguration.class, this._properties);
        if (Validator.isNotNull((String)igGeocoderConfiguration.filePath()) && (file = new File(igGeocoderConfiguration.filePath())).exists()) {
            if (_log.isInfoEnabled()) {
                _log.info((Object)("Use file " + igGeocoderConfiguration.filePath()));
            }
            return file;
        }
        Class<?> clazz = this.getClass();
        File file2 = FileUtil.createTempFile((InputStream)clazz.getResourceAsStream("/com.maxmind.geolite2.country.mmdb"));
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Use temp file " + file2));
        }
        return file2;
    }

    private String _getIPAddress(HttpServletRequest httpServletRequest) {
        HttpServletRequest originalHttpServletRequest = this._portal.getOriginalServletRequest(httpServletRequest);
        String mockIPGeocoderRemoteAddr = originalHttpServletRequest.getParameter("mockIPGeocoderRemoteAddr");
        if (mockIPGeocoderRemoteAddr != null) {
            return mockIPGeocoderRemoteAddr;
        }
        return httpServletRequest.getRemoteAddr();
    }
}

