/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.info.internal.search;

import com.liferay.info.search.InfoSearchClassMapper;
import com.liferay.info.search.InfoSearchClassMapperRegistry;
import com.liferay.osgi.service.tracker.collections.map.ServiceReferenceMapper;
import com.liferay.osgi.service.tracker.collections.map.ServiceReferenceMapperFactory;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.petra.reflect.GenericUtil;
import java.util.Collection;
import java.util.Objects;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;

@Component(service={InfoSearchClassMapperRegistry.class})
public class InfoSearchClassMapperRegistryImpl
implements InfoSearchClassMapperRegistry {
    private volatile ServiceTrackerMap<String, InfoSearchClassMapper<?>> _serviceTrackerMap;

    public String getClassName(String searchClassName) {
        Collection infoSearchClassMappers = this._serviceTrackerMap.values();
        for (InfoSearchClassMapper infoSearchClassMapper : infoSearchClassMappers) {
            if (!Objects.equals(searchClassName, infoSearchClassMapper.getSearchClassName())) continue;
            Class genericClass = GenericUtil.getGenericClass((Object)infoSearchClassMapper);
            return genericClass.getName();
        }
        return searchClassName;
    }

    public String getSearchClassName(String className) {
        InfoSearchClassMapper infoSearchClassMapper = (InfoSearchClassMapper)this._serviceTrackerMap.getService((Object)className);
        if (infoSearchClassMapper == null) {
            return className;
        }
        return infoSearchClassMapper.getSearchClassName();
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._serviceTrackerMap = ServiceTrackerMapFactory.openSingleValueMap((BundleContext)bundleContext, InfoSearchClassMapper.class, null, (ServiceReferenceMapper)ServiceReferenceMapperFactory.create((BundleContext)bundleContext, (infoSearchClassMapper, emitter) -> emitter.emit((Object)GenericUtil.getGenericClassName((Object)infoSearchClassMapper))));
    }

    @Deactivate
    protected void deactivate() {
        this._serviceTrackerMap.close();
    }
}

