/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.info.internal.request.struts;

import com.liferay.captcha.util.CaptchaUtil;
import com.liferay.fragment.contributor.FragmentCollectionContributorRegistry;
import com.liferay.fragment.model.FragmentEntry;
import com.liferay.fragment.model.FragmentEntryLink;
import com.liferay.fragment.service.FragmentEntryLinkLocalService;
import com.liferay.fragment.service.FragmentEntryLocalService;
import com.liferay.fragment.util.configuration.FragmentConfigurationField;
import com.liferay.fragment.util.configuration.FragmentEntryConfigurationParser;
import com.liferay.info.exception.InfoFormException;
import com.liferay.info.exception.InfoFormInvalidGroupException;
import com.liferay.info.exception.InfoFormInvalidLayoutModeException;
import com.liferay.info.exception.InfoFormPrincipalException;
import com.liferay.info.exception.InfoFormValidationException;
import com.liferay.info.field.InfoField;
import com.liferay.info.field.InfoFieldValue;
import com.liferay.info.field.type.DateInfoFieldType;
import com.liferay.info.field.type.RelationshipInfoFieldType;
import com.liferay.info.internal.request.helper.InfoRequestFieldValuesProviderHelper;
import com.liferay.info.item.InfoItemFieldValues;
import com.liferay.info.item.InfoItemReference;
import com.liferay.info.item.InfoItemServiceRegistry;
import com.liferay.info.item.creator.InfoItemCreator;
import com.liferay.layout.provider.LayoutStructureProvider;
import com.liferay.layout.util.structure.FragmentStyledLayoutStructureItem;
import com.liferay.layout.util.structure.LayoutStructure;
import com.liferay.layout.util.structure.LayoutStructureItem;
import com.liferay.portal.kernel.captcha.CaptchaException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONException;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.servlet.SessionMessages;
import com.liferay.portal.kernel.struts.StrutsAction;
import com.liferay.portal.kernel.upload.UploadServletRequest;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.Validator;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"path=/portal/add_info_item"}, service={StrutsAction.class})
public class AddInfoItemStrutsAction
implements StrutsAction {
    private static final Log _log = LogFactoryUtil.getLog(AddInfoItemStrutsAction.class);
    @Reference
    private FragmentCollectionContributorRegistry _fragmentCollectionContributorRegistry;
    @Reference
    private FragmentEntryConfigurationParser _fragmentEntryConfigurationParser;
    @Reference
    private FragmentEntryLinkLocalService _fragmentEntryLinkLocalService;
    @Reference
    private FragmentEntryLocalService _fragmentEntryLocalService;
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private InfoItemServiceRegistry _infoItemServiceRegistry;
    private volatile InfoRequestFieldValuesProviderHelper _infoRequestFieldValuesProviderHelper;
    @Reference
    private JSONFactory _jsonFactory;
    @Reference
    private LayoutLocalService _layoutLocalService;
    @Reference
    private LayoutStructureProvider _layoutStructureProvider;
    @Reference
    private Portal _portal;

    public String execute(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        String formItemId = ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"formItemId");
        List<InfoFieldValue<Object>> infoFieldValues = null;
        try {
            infoFieldValues = this._infoRequestFieldValuesProviderHelper.getInfoFieldValues(httpServletRequest);
        }
        catch (InfoFormException infoFormException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)infoFormException);
            }
            SessionErrors.add((HttpServletRequest)httpServletRequest, (String)formItemId, (Object)((Object)infoFormException));
            httpServletResponse.sendRedirect(httpServletRequest.getHeader("Referer"));
            return null;
        }
        String redirect = null;
        boolean success = false;
        try {
            if (!Objects.equals("view", ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"p_l_mode"))) {
                throw new InfoFormInvalidLayoutModeException();
            }
            Layout layout = this._layoutLocalService.fetchLayout(ParamUtil.getLong((HttpServletRequest)httpServletRequest, (String)"plid"));
            if (layout == null || layout.isDraftLayout()) {
                throw new InfoFormInvalidLayoutModeException();
            }
            long groupId = ParamUtil.getLong((HttpServletRequest)httpServletRequest, (String)"groupId");
            Group group = this._groupLocalService.fetchGroup(groupId);
            if (group == null || !group.isSite()) {
                throw new InfoFormInvalidGroupException();
            }
            if (this._isCaptchaLayoutStructureItem(formItemId, httpServletRequest)) {
                CaptchaUtil.check((HttpServletRequest)httpServletRequest);
            }
            this._validateRequiredFields(httpServletRequest, infoFieldValues);
            String className = this._portal.getClassName(ParamUtil.getLong((HttpServletRequest)httpServletRequest, (String)"classNameId"));
            InfoItemCreator infoItemCreator = (InfoItemCreator)this._infoItemServiceRegistry.getFirstInfoItemService(InfoItemCreator.class, className);
            if (infoItemCreator == null) {
                throw new InfoFormException();
            }
            infoItemCreator.createFromInfoItemFieldValues(groupId, InfoItemFieldValues.builder().infoFieldValues(infoFieldValues).infoItemReference(new InfoItemReference(className, 0L)).build());
            redirect = ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"redirect");
            if (Validator.isNull((String)redirect)) {
                redirect = ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"backURL");
                SessionMessages.add((HttpServletRequest)httpServletRequest, (String)formItemId);
            }
            success = true;
        }
        catch (CaptchaException captchaException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)captchaException);
            }
            SessionErrors.add((HttpServletRequest)httpServletRequest, (String)formItemId, (Object)new InfoFormValidationException.InvalidCaptcha());
        }
        catch (InfoFormValidationException infoFormValidationException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)infoFormValidationException);
            }
            SessionErrors.add((HttpServletRequest)httpServletRequest, (String)formItemId, (Object)((Object)infoFormValidationException));
            if (Validator.isNotNull((String)infoFormValidationException.getInfoFieldUniqueId())) {
                SessionErrors.add((HttpServletRequest)httpServletRequest, (String)infoFormValidationException.getInfoFieldUniqueId(), (Object)((Object)infoFormValidationException));
            }
        }
        catch (InfoFormException infoFormException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)infoFormException);
            }
            SessionErrors.add((HttpServletRequest)httpServletRequest, (String)formItemId, (Object)((Object)infoFormException));
        }
        catch (Exception exception) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)exception);
            }
            InfoFormException infoFormException = new InfoFormException();
            if (exception instanceof PrincipalException) {
                infoFormException = new InfoFormPrincipalException();
            }
            SessionErrors.add((HttpServletRequest)httpServletRequest, (String)formItemId, (Object)((Object)infoFormException));
        }
        if (!success && infoFieldValues != null) {
            HashMap<String, String> infoFormParameterMap = new HashMap<String, String>();
            for (InfoFieldValue<Object> infoFieldValue : infoFieldValues) {
                InfoField infoField = infoFieldValue.getInfoField();
                infoFormParameterMap.put(infoField.getName(), this._getValue(infoFieldValue));
                if (infoField.getInfoFieldType() != RelationshipInfoFieldType.INSTANCE) continue;
                UploadServletRequest uploadServletRequest = this._portal.getUploadServletRequest(httpServletRequest);
                String labelParameterName = infoField.getName() + "-label";
                String label = ParamUtil.getString((HttpServletRequest)uploadServletRequest, (String)labelParameterName);
                infoFormParameterMap.put(labelParameterName, label);
            }
            SessionMessages.add((HttpServletRequest)httpServletRequest, (String)("infoFormParameterMap" + formItemId), infoFormParameterMap);
        }
        if (Validator.isNull(redirect)) {
            redirect = httpServletRequest.getHeader("Referer");
        }
        httpServletResponse.sendRedirect(redirect);
        return null;
    }

    @Activate
    @Modified
    protected void activate() {
        this._infoRequestFieldValuesProviderHelper = new InfoRequestFieldValuesProviderHelper(this._infoItemServiceRegistry);
    }

    private String _getValue(InfoFieldValue<?> infoFieldValue) {
        if (infoFieldValue == null) {
            return null;
        }
        InfoField infoField = infoFieldValue.getInfoField();
        if (infoField.getInfoFieldType() == DateInfoFieldType.INSTANCE) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
            return simpleDateFormat.format(infoFieldValue.getValue());
        }
        return String.valueOf(infoFieldValue.getValue());
    }

    private boolean _hasCaptcha(List<String> childrenItemIds, LayoutStructure layoutStructure) {
        for (String childrenItemId : childrenItemIds) {
            FragmentEntryLink fragmentEntryLink;
            FragmentStyledLayoutStructureItem fragmentStyledLayoutStructureItem;
            LayoutStructureItem layoutStructureItem = layoutStructure.getLayoutStructureItem(childrenItemId);
            if (this._hasCaptcha(layoutStructureItem.getChildrenItemIds(), layoutStructure)) {
                return true;
            }
            if (!(layoutStructureItem instanceof FragmentStyledLayoutStructureItem) || (fragmentStyledLayoutStructureItem = (FragmentStyledLayoutStructureItem)layoutStructureItem).getFragmentEntryLinkId() <= 0L || (fragmentEntryLink = this._fragmentEntryLinkLocalService.fetchFragmentEntryLink(fragmentStyledLayoutStructureItem.getFragmentEntryLinkId())) == null || !fragmentEntryLink.isTypeInput() || !this._isCaptchaFragmentEntry(fragmentEntryLink.getFragmentEntryId(), fragmentEntryLink.getRendererKey())) continue;
            return true;
        }
        return false;
    }

    private boolean _isCaptchaFragmentEntry(long fragmentEntryId, String rendererKey) {
        block6: {
            FragmentEntry fragmentEntry = null;
            if (Validator.isNotNull((String)rendererKey)) {
                fragmentEntry = this._fragmentCollectionContributorRegistry.getFragmentEntry(rendererKey);
            }
            if (fragmentEntry == null && fragmentEntryId > 0L) {
                fragmentEntry = this._fragmentEntryLocalService.fetchFragmentEntry(fragmentEntryId);
            }
            if (fragmentEntry == null || Validator.isNull((String)fragmentEntry.getTypeOptions())) {
                return false;
            }
            try {
                JSONObject typeOptionsJSONObject = this._jsonFactory.createJSONObject(fragmentEntry.getTypeOptions());
                JSONArray fieldTypesJSONArray = typeOptionsJSONObject.getJSONArray("fieldTypes");
                if (fieldTypesJSONArray != null && JSONUtil.hasValue((JSONArray)fieldTypesJSONArray, (Object)"captcha")) {
                    return true;
                }
            }
            catch (JSONException jsonException) {
                if (!_log.isDebugEnabled()) break block6;
                _log.debug((Throwable)jsonException);
            }
        }
        return false;
    }

    private boolean _isCaptchaLayoutStructureItem(String formItemId, HttpServletRequest httpServletRequest) throws InfoFormException {
        LayoutStructure layoutStructure = this._layoutStructureProvider.getLayoutStructure(ParamUtil.getLong((HttpServletRequest)httpServletRequest, (String)"plid"), ParamUtil.getLong((HttpServletRequest)httpServletRequest, (String)"segmentsExperienceId"));
        if (layoutStructure == null) {
            throw new InfoFormException();
        }
        LayoutStructureItem formLayoutStructureItem = layoutStructure.getLayoutStructureItem(formItemId);
        if (formLayoutStructureItem == null) {
            throw new InfoFormException();
        }
        return this._hasCaptcha(formLayoutStructureItem.getChildrenItemIds(), layoutStructure);
    }

    private void _validateRequiredField(List<InfoFieldValue<Object>> infoFieldValues, LayoutStructureItem layoutStructureItem) throws InfoFormValidationException.RequiredInfoField {
        if (!Objects.equals("fragment", layoutStructureItem.getItemType())) {
            return;
        }
        FragmentStyledLayoutStructureItem fragmentStyledLayoutStructureItem = (FragmentStyledLayoutStructureItem)layoutStructureItem;
        FragmentEntryLink fragmentEntryLink = this._fragmentEntryLinkLocalService.fetchFragmentEntryLink(fragmentStyledLayoutStructureItem.getFragmentEntryLinkId());
        if (fragmentEntryLink == null || !GetterUtil.getBoolean((Object)this._fragmentEntryConfigurationParser.getFieldValue(fragmentEntryLink.getEditableValues(), new FragmentConfigurationField("inputRequired", "boolean", "false", false, "checkbox"), LocaleUtil.getMostRelevantLocale()))) {
            return;
        }
        String inputFieldId = GetterUtil.getString((Object)this._fragmentEntryConfigurationParser.getFieldValue(fragmentEntryLink.getEditableValues(), new FragmentConfigurationField("inputFieldId", "string", "", false, "text"), LocaleUtil.getMostRelevantLocale()));
        for (InfoFieldValue<Object> infoFieldValue : infoFieldValues) {
            InfoField infoField = infoFieldValue.getInfoField();
            if (!Objects.equals(inputFieldId, infoField.getUniqueId())) continue;
            if (!Validator.isNotNull((Object)infoFieldValue.getValue())) break;
            return;
        }
        throw new InfoFormValidationException.RequiredInfoField(inputFieldId);
    }

    private void _validateRequiredFields(HttpServletRequest httpServletRequest, List<InfoFieldValue<Object>> infoFieldValues) throws InfoFormException {
        LayoutStructure layoutStructure = this._layoutStructureProvider.getLayoutStructure(ParamUtil.getLong((HttpServletRequest)httpServletRequest, (String)"plid"), ParamUtil.getLong((HttpServletRequest)httpServletRequest, (String)"segmentsExperienceId"));
        if (layoutStructure == null) {
            throw new InfoFormException();
        }
        String formItemId = ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"formItemId");
        LayoutStructureItem formLayoutStructureItem = layoutStructure.getLayoutStructureItem(formItemId);
        if (formLayoutStructureItem == null) {
            throw new InfoFormException();
        }
        this._validateRequiredFields(infoFieldValues, formLayoutStructureItem.getChildrenItemIds(), layoutStructure);
    }

    private void _validateRequiredFields(List<InfoFieldValue<Object>> infoFieldValues, List<String> itemIds, LayoutStructure layoutStructure) throws InfoFormValidationException.RequiredInfoField {
        for (String itemId : itemIds) {
            LayoutStructureItem layoutStructureItem = layoutStructure.getLayoutStructureItem(itemId);
            this._validateRequiredField(infoFieldValues, layoutStructureItem);
            this._validateRequiredFields(infoFieldValues, layoutStructureItem.getChildrenItemIds(), layoutStructure);
        }
    }
}

