/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.info.internal.request.helper;

import com.liferay.info.exception.InfoFormFileUploadException;
import com.liferay.info.exception.NoSuchFormVariationException;
import com.liferay.info.field.InfoField;
import com.liferay.info.field.InfoFieldValue;
import com.liferay.info.field.type.BooleanInfoFieldType;
import com.liferay.info.field.type.DateInfoFieldType;
import com.liferay.info.field.type.FileInfoFieldType;
import com.liferay.info.field.type.NumberInfoFieldType;
import com.liferay.info.field.type.RelationshipInfoFieldType;
import com.liferay.info.field.type.SelectInfoFieldType;
import com.liferay.info.field.type.TextInfoFieldType;
import com.liferay.info.form.InfoForm;
import com.liferay.info.item.InfoItemServiceRegistry;
import com.liferay.info.item.provider.InfoItemFormProvider;
import com.liferay.info.localized.InfoLocalizedValue;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.upload.FileItem;
import com.liferay.portal.kernel.upload.UploadServletRequest;
import com.liferay.portal.kernel.util.DateUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.TempFileEntryUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;

public class InfoRequestFieldValuesProviderHelper {
    private static final Log _log = LogFactoryUtil.getLog(InfoRequestFieldValuesProviderHelper.class);
    private final InfoItemServiceRegistry _infoItemServiceRegistry;

    public InfoRequestFieldValuesProviderHelper(InfoItemServiceRegistry infoItemServiceRegistry) {
        this._infoItemServiceRegistry = infoItemServiceRegistry;
    }

    public List<InfoFieldValue<Object>> getInfoFieldValues(HttpServletRequest httpServletRequest) throws InfoFormFileUploadException {
        ArrayList<InfoFieldValue<Object>> infoFieldValues = new ArrayList<InfoFieldValue<Object>>();
        UploadServletRequest uploadServletRequest = PortalUtil.getUploadServletRequest((HttpServletRequest)httpServletRequest);
        ThemeDisplay themeDisplay = (ThemeDisplay)uploadServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        String className = PortalUtil.getClassName((long)ParamUtil.getLong((HttpServletRequest)uploadServletRequest, (String)"classNameId"));
        String classTypeId = ParamUtil.getString((HttpServletRequest)uploadServletRequest, (String)"classTypeId");
        long groupId = ParamUtil.getLong((HttpServletRequest)uploadServletRequest, (String)"groupId");
        Map multipartParameterMap = uploadServletRequest.getMultipartParameterMap();
        Map regularParameterMap = uploadServletRequest.getRegularParameterMap();
        for (InfoField<?> infoField : this._getInfoFields(className, classTypeId, groupId)) {
            List regularParameters;
            FileItem[] multipartParameters = (FileItem[])multipartParameterMap.get(infoField.getName());
            if (multipartParameters != null && infoField.getInfoFieldType() instanceof FileInfoFieldType) {
                for (FileItem fileItem : multipartParameters) {
                    InfoFieldValue<Object> infoFieldValue;
                    if (fileItem.getSize() < 0L || Validator.isNull((String)fileItem.getFileName()) || (infoFieldValue = this._getFileInfoFieldValue(fileItem, groupId, infoField, themeDisplay)) == null) continue;
                    infoFieldValues.add(infoFieldValue);
                }
            }
            if ((regularParameters = (List)regularParameterMap.get(infoField.getName())) == null) continue;
            for (String value : regularParameters) {
                InfoFieldValue<Object> infoFieldValue = this._getInfoFieldValue(infoField, themeDisplay.getLocale(), value);
                if (infoFieldValue == null) continue;
                infoFieldValues.add(infoFieldValue);
            }
        }
        return infoFieldValues;
    }

    private InfoFieldValue<Object> _getBooleanInfoFieldValue(InfoField<?> infoField, Locale locale, String value) {
        return this._getInfoFieldValue(infoField, locale, GetterUtil.getBoolean((String)value));
    }

    private InfoFieldValue<Object> _getDateInfoFieldValue(InfoField<?> infoField, Locale locale, String value) {
        try {
            Date date = DateUtil.parseDate((String)"yyyy-MM-dd", (String)value, (Locale)locale);
            return this._getInfoFieldValue(infoField, locale, date);
        }
        catch (ParseException parseException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)parseException);
            }
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private InfoFieldValue<Object> _getFileInfoFieldValue(FileItem fileItem, long groupId, InfoField infoField, ThemeDisplay themeDisplay) throws InfoFormFileUploadException {
        try (InputStream inputStream = fileItem.getInputStream();){
            if (inputStream == null) {
                throw new InfoFormFileUploadException(infoField.getUniqueId());
            }
            File file = FileUtil.createTempFile((InputStream)inputStream);
            if (file == null) {
                throw new InfoFormFileUploadException(infoField.getUniqueId());
            }
            FileEntry fileEntry = TempFileEntryUtil.addTempFileEntry((long)groupId, (long)themeDisplay.getUserId(), (String)InfoRequestFieldValuesProviderHelper.class.getName(), (String)TempFileEntryUtil.getTempFileName((String)fileItem.getFileName()), (File)file, (String)fileItem.getContentType());
            InfoFieldValue<Object> infoFieldValue = this._getInfoFieldValue(infoField, themeDisplay.getLocale(), String.valueOf(fileEntry.getFileEntryId()));
            return infoFieldValue;
        }
        catch (PortalException | IOException exception) {
            if (!_log.isDebugEnabled()) throw new InfoFormFileUploadException(infoField.getUniqueId());
            _log.debug(exception);
            throw new InfoFormFileUploadException(infoField.getUniqueId());
        }
    }

    private <T> List<InfoField<?>> _getInfoFields(String className, String formVariationKey, long groupId) {
        InfoItemFormProvider infoItemFormProvider = (InfoItemFormProvider)this._infoItemServiceRegistry.getFirstInfoItemService(InfoItemFormProvider.class, className);
        if (infoItemFormProvider == null) {
            return new ArrayList();
        }
        try {
            InfoForm infoForm = infoItemFormProvider.getInfoForm(formVariationKey, groupId);
            return infoForm.getAllInfoFields();
        }
        catch (NoSuchFormVariationException noSuchFormVariationException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)noSuchFormVariationException);
            }
            return new ArrayList();
        }
    }

    private InfoFieldValue<Object> _getInfoFieldValue(InfoField<?> infoField, Locale locale, Object object) {
        if (infoField.isLocalizable()) {
            return new InfoFieldValue(infoField, (Object)InfoLocalizedValue.builder().defaultLocale(locale).value(locale, object).build());
        }
        return new InfoFieldValue(infoField, object);
    }

    private InfoFieldValue<Object> _getInfoFieldValue(InfoField<?> infoField, Locale locale, String value) {
        if (Validator.isBlank((String)value)) {
            return null;
        }
        if (infoField.getInfoFieldType() instanceof BooleanInfoFieldType) {
            return this._getBooleanInfoFieldValue(infoField, locale, value);
        }
        if (infoField.getInfoFieldType() instanceof DateInfoFieldType) {
            return this._getDateInfoFieldValue(infoField, locale, value);
        }
        if (infoField.getInfoFieldType() instanceof NumberInfoFieldType) {
            return this._getNumberInfoFieldValue(infoField, locale, value);
        }
        if (infoField.getInfoFieldType() instanceof FileInfoFieldType || infoField.getInfoFieldType() instanceof RelationshipInfoFieldType || infoField.getInfoFieldType() instanceof SelectInfoFieldType || infoField.getInfoFieldType() instanceof TextInfoFieldType) {
            return this._getInfoFieldValue(infoField, locale, (Object)value);
        }
        return null;
    }

    private InfoFieldValue<Object> _getNumberInfoFieldValue(InfoField infoField, Locale locale, String value) {
        Number objectValue = null;
        Optional decimalOptional = infoField.getAttributeOptional(NumberInfoFieldType.DECIMAL);
        objectValue = decimalOptional.orElse(false) != false ? new BigDecimal(value) : Long.valueOf(GetterUtil.getLong((String)value));
        return this._getInfoFieldValue(infoField, locale, objectValue);
    }
}

