/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.info.internal.request.attributes.contributor;

import com.liferay.asset.kernel.AssetRendererFactoryRegistryUtil;
import com.liferay.asset.kernel.model.AssetRendererFactory;
import com.liferay.info.display.request.attributes.contributor.InfoDisplayRequestAttributesContributor;
import com.liferay.info.item.InfoItemDetails;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.portlet.InvokerPortlet;
import com.liferay.portal.kernel.portlet.LiferayRenderRequest;
import com.liferay.portal.kernel.portlet.PortletConfigFactoryUtil;
import com.liferay.portal.kernel.portlet.PortletInstanceFactoryUtil;
import com.liferay.portal.kernel.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portal.kernel.service.PortletLocalService;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portlet.RenderRequestFactory;
import com.liferay.portlet.RenderResponseFactory;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletMode;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.WindowState;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={InfoDisplayRequestAttributesContributor.class})
public class BasicInfoDisplayRequestAttributesContributor
implements InfoDisplayRequestAttributesContributor {
    private static final Log _log = LogFactoryUtil.getLog(BasicInfoDisplayRequestAttributesContributor.class);
    @Reference
    private Portal _portal;
    @Reference
    private PortletLocalService _portletLocalService;

    public void addAttributes(HttpServletRequest httpServletRequest) {
        AssetRendererFactory<?> assetRendererFactory = this._getAssetRendererFactory(httpServletRequest);
        PortletRequest portletRequest = (PortletRequest)httpServletRequest.getAttribute("javax.portlet.request");
        if (portletRequest == null && assetRendererFactory != null) {
            Portlet portlet = this._portletLocalService.getPortletById(assetRendererFactory.getPortletId());
            ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
            try {
                InvokerPortlet invokerPortlet = PortletInstanceFactoryUtil.create((Portlet)portlet, (ServletContext)httpServletRequest.getServletContext());
                PortletConfig portletConfig = PortletConfigFactoryUtil.create((Portlet)portlet, (ServletContext)httpServletRequest.getServletContext());
                LiferayRenderRequest liferayRenderRequest = RenderRequestFactory.create((HttpServletRequest)httpServletRequest, (Portlet)portlet, (InvokerPortlet)invokerPortlet, (PortletContext)portletConfig.getPortletContext(), (WindowState)WindowState.NORMAL, (PortletMode)PortletMode.VIEW, (PortletPreferences)PortletPreferencesFactoryUtil.fromDefaultXML((String)portlet.getDefaultPreferences()), (long)themeDisplay.getPlid());
                httpServletRequest.setAttribute("javax.portlet.request", (Object)liferayRenderRequest);
                httpServletRequest.setAttribute("javax.portlet.response", (Object)RenderResponseFactory.create((HttpServletResponse)themeDisplay.getResponse(), (RenderRequest)liferayRenderRequest));
            }
            catch (Exception exception) {
                _log.error((Throwable)exception);
            }
        }
    }

    private AssetRendererFactory<?> _getAssetRendererFactory(HttpServletRequest httpServletRequest) {
        InfoItemDetails infoItemDetails = (InfoItemDetails)httpServletRequest.getAttribute("INFO_ITEM_DETAILS");
        if (infoItemDetails == null) {
            return null;
        }
        return AssetRendererFactoryRegistryUtil.getAssetRendererFactoryByClassNameId((long)this._portal.getClassNameId(infoItemDetails.getClassName()));
    }
}

